/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.selectable.PurchasingSourceSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource PurchasingSource} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class PurchasingSourceByKeyFluentHelper
    extends
    FluentHelperByKey<PurchasingSourceByKeyFluentHelper, PurchasingSource, PurchasingSourceSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource PurchasingSource}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchasingSource}
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchasingSource}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sourceListRecord
     *            Number of Source List Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public PurchasingSourceByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String material,
        final String plant,
        final String sourceListRecord )
    {
        super(servicePath, entityCollection);
        this.key.put("Material", material);
        this.key.put("Plant", plant);
        this.key.put("SourceListRecord", sourceListRecord);
    }

    @Override
    @Nonnull
    protected Class<PurchasingSource> getEntityClass()
    {
        return PurchasingSource.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
