/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchasingSourceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService PurchasingSourceService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchasingSourceServiceBatch
    extends
    BatchFluentHelperBasic<PurchasingSourceServiceBatch, PurchasingSourceServiceBatchChangeSet>
    implements
    PurchasingSourceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchasingSourceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingSourceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchasingSourceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingSourceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingSourceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingSourceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchasingSourceServiceBatchChangeSet(this, service);
    }

}
