/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource;

/**
 * Implementation of the {@link PurchasingSourceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService PurchasingSourceService}.
 *
 */
public class DefaultPurchasingSourceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchasingSourceServiceBatch, PurchasingSourceServiceBatchChangeSet>
    implements
    PurchasingSourceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchasingSourceServiceBatchChangeSet(
        @Nonnull final DefaultPurchasingSourceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingSourceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingSourceServiceBatchChangeSet createPurchasingSource(
        @Nonnull final PurchasingSource purchasingSource )
    {
        return addRequestCreate(service::createPurchasingSource, purchasingSource);
    }

    @Nonnull
    @Override
    public PurchasingSourceServiceBatchChangeSet updatePurchasingSource(
        @Nonnull final PurchasingSource purchasingSource )
    {
        return addRequestUpdate(service::updatePurchasingSource, purchasingSource);
    }

    @Nonnull
    @Override
    public PurchasingSourceServiceBatchChangeSet deletePurchasingSource(
        @Nonnull final PurchasingSource purchasingSource )
    {
        return addRequestDelete(service::deletePurchasingSource, purchasingSource);
    }

}
