/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService PurchasingSourceService}.
 *
 */
public interface PurchasingSourceServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchasingSourceServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchasingSourceServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity and save it to the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingSourceServiceBatchChangeSet createPurchasingSource( @Nonnull final PurchasingSource purchasingSource );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity and save it to the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingSourceServiceBatchChangeSet updatePurchasingSource( @Nonnull final PurchasingSource purchasingSource );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity in the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingSourceServiceBatchChangeSet deletePurchasingSource( @Nonnull final PurchasingSource purchasingSource );

}
