/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource PurchasingSource}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.field.PurchasingSourceField
 * PurchasingSourceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.link.PurchasingSourceLink
 * PurchasingSourceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SOURCE_LIST_RECORD
 * SOURCE_LIST_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#CREATED_BY_USER_NAME
 * CREATED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SUPPLIER_IS_FIXED
 * SUPPLIER_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#PURCHASE_OUTLINE_AGREEMENT
 * PURCHASE_OUTLINE_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#PURCHASE_OUTLINE_AGREEMENT_ITEM
 * PURCHASE_OUTLINE_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SUPPLYING_PLANT
 * SUPPLYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SOURCE_OF_SUPPLY_IS_BLOCKED
 * SOURCE_OF_SUPPLY_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#MRP_SOURCING_CONTROL
 * MRP_SOURCING_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#ISSG_PLANT_IS_FIXED
 * ISSG_PLANT_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#PUR_OUTLINE_AGREEMENT_IS_FIXED
 * PUR_OUTLINE_AGREEMENT_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource#SOURCE_OF_SUPPLY_IS_FIXED
 * SOURCE_OF_SUPPLY_IS_FIXED}</li>
 * </ul>
 *
 */
public interface PurchasingSourceSelectable extends EntitySelectable<PurchasingSource>
{

}
