/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.field.QualityFirstArticleInspectionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.link.QualityFirstArticleInspectionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.selectable.QualityFirstArticleInspectionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * First Article Inspection Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>QualityFirstArticleInspectionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class QualityFirstArticleInspection extends VdmEntity<QualityFirstArticleInspection>
{

    /**
     * Selector for all available fields of QualityFirstArticleInspection.
     *
     */
    public final static QualityFirstArticleInspectionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> MATERIAL =
        new QualityFirstArticleInspectionField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtIntID</b>
     * </p>
     *
     * @return Quality Info Record in Procurement Internal ID
     */
    @Key
    @SerializedName( "QltyInProcmtIntID" )
    @JsonProperty( "QltyInProcmtIntID" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtIntID" )
    private String qltyInProcmtIntID;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtIntID</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> QLTY_IN_PROCMT_INT_ID =
        new QualityFirstArticleInspectionField<String>("QltyInProcmtIntID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmt1stArticleInsp</b>
     * </p>
     *
     * @return First Article Inspection Number in Quality Info Record
     */
    @Key
    @SerializedName( "QltyInProcmt1stArticleInsp" )
    @JsonProperty( "QltyInProcmt1stArticleInsp" )
    @Nullable
    @ODataField( odataName = "QltyInProcmt1stArticleInsp" )
    private String qltyInProcmt1stArticleInsp;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmt1stArticleInsp</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> QLTY_IN_PROCMT1ST_ARTICLE_INSP =
        new QualityFirstArticleInspectionField<String>("QltyInProcmt1stArticleInsp");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> PURCHASE_ORDER =
        new QualityFirstArticleInspectionField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> PURCHASE_ORDER_ITEM =
        new QualityFirstArticleInspectionField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionValuation</b>
     * </p>
     *
     * @return Code Valuation
     */
    @SerializedName( "InspLotUsageDecisionValuation" )
    @JsonProperty( "InspLotUsageDecisionValuation" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionValuation" )
    private String inspLotUsageDecisionValuation;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionValuation</b> field to query operations.
     *
     */
    public final static QualityFirstArticleInspectionField<String> INSP_LOT_USAGE_DECISION_VALUATION =
        new QualityFirstArticleInspectionField<String>("InspLotUsageDecisionValuation");
    /**
     * Navigation property <b>to_QltyInProcurement</b> for <b>QualityFirstArticleInspection</b> to single
     * <b>QualityInProcurement</b>.
     *
     */
    @SerializedName( "to_QltyInProcurement" )
    @JsonProperty( "to_QltyInProcurement" )
    @ODataField( odataName = "to_QltyInProcurement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private QualityInProcurement toQltyInProcurement;
    /**
     * Use with available fluent helpers to apply the <b>to_QltyInProcurement</b> navigation property to query
     * operations.
     *
     */
    public final static QualityFirstArticleInspectionOneToOneLink<QualityInProcurement> TO_QLTY_IN_PROCUREMENT =
        new QualityFirstArticleInspectionOneToOneLink<QualityInProcurement>("to_QltyInProcurement");

    @Nonnull
    @Override
    public Class<QualityFirstArticleInspection> getType()
    {
        return QualityFirstArticleInspection.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtIntID</b>
     * </p>
     *
     * @param qltyInProcmtIntID
     *            Quality Info Record in Procurement Internal ID
     */
    public void setQltyInProcmtIntID( @Nullable final String qltyInProcmtIntID )
    {
        rememberChangedField("QltyInProcmtIntID", this.qltyInProcmtIntID);
        this.qltyInProcmtIntID = qltyInProcmtIntID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmt1stArticleInsp</b>
     * </p>
     *
     * @param qltyInProcmt1stArticleInsp
     *            First Article Inspection Number in Quality Info Record
     */
    public void setQltyInProcmt1stArticleInsp( @Nullable final String qltyInProcmt1stArticleInsp )
    {
        rememberChangedField("QltyInProcmt1stArticleInsp", this.qltyInProcmt1stArticleInsp);
        this.qltyInProcmt1stArticleInsp = qltyInProcmt1stArticleInsp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionValuation</b>
     * </p>
     *
     * @param inspLotUsageDecisionValuation
     *            Code Valuation
     */
    public void setInspLotUsageDecisionValuation( @Nullable final String inspLotUsageDecisionValuation )
    {
        rememberChangedField("InspLotUsageDecisionValuation", this.inspLotUsageDecisionValuation);
        this.inspLotUsageDecisionValuation = inspLotUsageDecisionValuation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "QualityFirstArticleInspection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("QltyInProcmtIntID", getQltyInProcmtIntID());
        result.put("QltyInProcmt1stArticleInsp", getQltyInProcmt1stArticleInsp());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("QltyInProcmtIntID", getQltyInProcmtIntID());
        values.put("QltyInProcmt1stArticleInsp", getQltyInProcmt1stArticleInsp());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("InspLotUsageDecisionValuation", getInspLotUsageDecisionValuation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtIntID") ) {
                final Object value = values.remove("QltyInProcmtIntID");
                if( (value == null) || (!value.equals(getQltyInProcmtIntID())) ) {
                    setQltyInProcmtIntID(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmt1stArticleInsp") ) {
                final Object value = values.remove("QltyInProcmt1stArticleInsp");
                if( (value == null) || (!value.equals(getQltyInProcmt1stArticleInsp())) ) {
                    setQltyInProcmt1stArticleInsp(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionValuation") ) {
                final Object value = values.remove("InspLotUsageDecisionValuation");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionValuation())) ) {
                    setInspLotUsageDecisionValuation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_QltyInProcurement") ) {
                final Object value = (values).remove("to_QltyInProcurement");
                if( value instanceof Map ) {
                    if( toQltyInProcurement == null ) {
                        toQltyInProcurement = new QualityInProcurement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toQltyInProcurement.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> QualityFirstArticleInspectionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new QualityFirstArticleInspectionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> QualityFirstArticleInspectionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new QualityFirstArticleInspectionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toQltyInProcurement != null ) {
            (values).put("to_QltyInProcurement", toQltyInProcurement);
        }
        return values;
    }

    /**
     * Fetches the <b>QualityInProcurement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_QltyInProcurement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>QualityInProcurement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public QualityInProcurement fetchQltyInProcurement()
    {
        return fetchFieldAsSingle("to_QltyInProcurement", QualityInProcurement.class);
    }

    /**
     * Retrieval of associated <b>QualityInProcurement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_QltyInProcurement</b>.
     * <p>
     * If the navigation property <b>to_QltyInProcurement</b> of a queried <b>QualityFirstArticleInspection</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>QualityInProcurement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public QualityInProcurement getQltyInProcurementOrFetch()
    {
        if( toQltyInProcurement == null ) {
            toQltyInProcurement = fetchQltyInProcurement();
        }
        return toQltyInProcurement;
    }

    /**
     * Retrieval of associated <b>QualityInProcurement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_QltyInProcurement</b>.
     * <p>
     * If the navigation property for an entity <b>QualityFirstArticleInspection</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_QltyInProcurement</b> is already loaded, the result will
     *         contain the <b>QualityInProcurement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<QualityInProcurement> getQltyInProcurementIfPresent()
    {
        return Option.of(toQltyInProcurement);
    }

    /**
     * Overwrites the associated <b>QualityInProcurement</b> entity for the loaded navigation property
     * <b>to_QltyInProcurement</b>.
     *
     * @param value
     *            New <b>QualityInProcurement</b> entity.
     */
    public void setQltyInProcurement( final QualityInProcurement value )
    {
        toQltyInProcurement = value;
    }

    /**
     * Helper class to allow for fluent creation of QualityFirstArticleInspection instances.
     *
     */
    public final static class QualityFirstArticleInspectionBuilder
    {

        private QualityInProcurement toQltyInProcurement;

        private QualityFirstArticleInspection.QualityFirstArticleInspectionBuilder toQltyInProcurement(
            final QualityInProcurement value )
        {
            toQltyInProcurement = value;
            return this;
        }

        /**
         * Navigation property <b>to_QltyInProcurement</b> for <b>QualityFirstArticleInspection</b> to single
         * <b>QualityInProcurement</b>.
         *
         * @param value
         *            The QualityInProcurement to build this QualityFirstArticleInspection with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public QualityFirstArticleInspection.QualityFirstArticleInspectionBuilder qltyInProcurement(
            final QualityInProcurement value )
        {
            return toQltyInProcurement(value);
        }

    }

}
