/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.selectable.QualityFirstArticleInspectionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
 * QualityFirstArticleInspection} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class QualityFirstArticleInspectionByKeyFluentHelper
    extends
    FluentHelperByKey<QualityFirstArticleInspectionByKeyFluentHelper, QualityFirstArticleInspection, QualityFirstArticleInspectionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code QualityFirstArticleInspection}
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code QualityFirstArticleInspection}
     * @param qltyInProcmt1stArticleInsp
     *            First Article Inspection Number in Quality Info Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param qltyInProcmtIntID
     *            Quality Info Record in Procurement Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public QualityFirstArticleInspectionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String material,
        final String qltyInProcmtIntID,
        final String qltyInProcmt1stArticleInsp )
    {
        super(servicePath, entityCollection);
        this.key.put("Material", material);
        this.key.put("QltyInProcmtIntID", qltyInProcmtIntID);
        this.key.put("QltyInProcmt1stArticleInsp", qltyInProcmt1stArticleInsp);
    }

    @Override
    @Nonnull
    protected Class<QualityFirstArticleInspection> getEntityClass()
    {
        return QualityFirstArticleInspection.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
