/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.field.QualityInProcurementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.link.QualityInProcurementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.selectable.QualityInProcurementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Quality Info Record Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>QualityInProcurementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class QualityInProcurement extends VdmEntity<QualityInProcurement>
{

    /**
     * Selector for all available fields of QualityInProcurement.
     *
     */
    public final static QualityInProcurementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> MATERIAL = new QualityInProcurementField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtIntID</b>
     * </p>
     *
     * @return Quality Info Record in Procurement Internal ID
     */
    @Key
    @SerializedName( "QltyInProcmtIntID" )
    @JsonProperty( "QltyInProcmtIntID" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtIntID" )
    private String qltyInProcmtIntID;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtIntID</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QLTY_IN_PROCMT_INT_ID =
        new QualityInProcurementField<String>("QltyInProcmtIntID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> SUPPLIER = new QualityInProcurementField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PLANT = new QualityInProcurementField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @return Revision Level
     */
    @SerializedName( "MaterialRevisionLevel" )
    @JsonProperty( "MaterialRevisionLevel" )
    @Nullable
    @ODataField( odataName = "MaterialRevisionLevel" )
    private String materialRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>MaterialRevisionLevel</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> MATERIAL_REVISION_LEVEL =
        new QualityInProcurementField<String>("MaterialRevisionLevel");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtReleaseValidTo</b>
     * </p>
     *
     * @return Date Until Which the Release Is Valid
     */
    @SerializedName( "QltyInProcmtReleaseValidTo" )
    @JsonProperty( "QltyInProcmtReleaseValidTo" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QltyInProcmtReleaseValidTo",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime qltyInProcmtReleaseValidTo;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtReleaseValidTo</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<LocalDateTime> QLTY_IN_PROCMT_RELEASE_VALID_TO =
        new QualityInProcurementField<LocalDateTime>("QltyInProcmtReleaseValidTo");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for the Material
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> BASE_UNIT = new QualityInProcurementField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedQuantity</b>
     * </p>
     *
     * @return Quantity Released for the Material
     */
    @SerializedName( "ReleasedQuantity" )
    @JsonProperty( "ReleasedQuantity" )
    @Nullable
    @ODataField( odataName = "ReleasedQuantity" )
    private BigDecimal releasedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReleasedQuantity</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<BigDecimal> RELEASED_QUANTITY =
        new QualityInProcurementField<BigDecimal>("ReleasedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BlockReason</b>
     * </p>
     *
     * @return Blocking Reason
     */
    @SerializedName( "BlockReason" )
    @JsonProperty( "BlockReason" )
    @Nullable
    @ODataField( odataName = "BlockReason" )
    private String blockReason;
    /**
     * Use with available fluent helpers to apply the <b>BlockReason</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> BLOCK_REASON =
        new QualityInProcurementField<String>("BlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementBlock</b>
     * </p>
     *
     * @return Function That Will Be Blocked
     */
    @SerializedName( "ProcurementBlock" )
    @JsonProperty( "ProcurementBlock" )
    @Nullable
    @ODataField( odataName = "ProcurementBlock" )
    private String procurementBlock;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementBlock</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PROCUREMENT_BLOCK =
        new QualityInProcurementField<String>("ProcurementBlock");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtRelQtyIsActive</b>
     * </p>
     *
     * @return Release Quantity Is Active
     */
    @SerializedName( "QltyInProcmtRelQtyIsActive" )
    @JsonProperty( "QltyInProcmtRelQtyIsActive" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtRelQtyIsActive" )
    private String qltyInProcmtRelQtyIsActive;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtRelQtyIsActive</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QLTY_IN_PROCMT_REL_QTY_IS_ACTIVE =
        new QualityInProcurementField<String>("QltyInProcmtRelQtyIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtInspControl</b>
     * </p>
     *
     * @return Inspection Control in the QM Info Record
     */
    @SerializedName( "QltyInProcmtInspControl" )
    @JsonProperty( "QltyInProcmtInspControl" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtInspControl" )
    private String qltyInProcmtInspControl;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtInspControl</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QLTY_IN_PROCMT_INSP_CONTROL =
        new QualityInProcurementField<String>("QltyInProcmtInspControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnPieceApprovalIsRequired</b>
     * </p>
     *
     * @return Production Part Approval Is Required
     */
    @SerializedName( "ProdnPieceApprovalIsRequired" )
    @JsonProperty( "ProdnPieceApprovalIsRequired" )
    @Nullable
    @ODataField( odataName = "ProdnPieceApprovalIsRequired" )
    private String prodnPieceApprovalIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>ProdnPieceApprovalIsRequired</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PRODN_PIECE_APPROVAL_IS_REQUIRED =
        new QualityInProcurementField<String>("ProdnPieceApprovalIsRequired");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApproval</b>
     * </p>
     *
     * @return Production Part Approval Identifier
     */
    @SerializedName( "ProductionPieceApproval" )
    @JsonProperty( "ProductionPieceApproval" )
    @Nullable
    @ODataField( odataName = "ProductionPieceApproval" )
    private String productionPieceApproval;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPieceApproval</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PRODUCTION_PIECE_APPROVAL =
        new QualityInProcurementField<String>("ProductionPieceApproval");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApprovalLevel</b>
     * </p>
     *
     * @return Production Part Approval for Part Submission Warrant
     */
    @SerializedName( "ProductionPieceApprovalLevel" )
    @JsonProperty( "ProductionPieceApprovalLevel" )
    @Nullable
    @ODataField( odataName = "ProductionPieceApprovalLevel" )
    private String productionPieceApprovalLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPieceApprovalLevel</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PRODUCTION_PIECE_APPROVAL_LEVEL =
        new QualityInProcurementField<String>("ProductionPieceApprovalLevel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApprovalStatus</b>
     * </p>
     *
     * @return Production Part Approval Status
     */
    @SerializedName( "ProductionPieceApprovalStatus" )
    @JsonProperty( "ProductionPieceApprovalStatus" )
    @Nullable
    @ODataField( odataName = "ProductionPieceApprovalStatus" )
    private String productionPieceApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPieceApprovalStatus</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> PRODUCTION_PIECE_APPROVAL_STATUS =
        new QualityInProcurementField<String>("ProductionPieceApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Flag
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> IS_DELETED =
        new QualityInProcurementField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityManagementSystem</b>
     * </p>
     *
     * @return Supplier's QM System
     */
    @SerializedName( "QualityManagementSystem" )
    @JsonProperty( "QualityManagementSystem" )
    @Nullable
    @ODataField( odataName = "QualityManagementSystem" )
    private String qualityManagementSystem;
    /**
     * Use with available fluent helpers to apply the <b>QualityManagementSystem</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QUALITY_MANAGEMENT_SYSTEM =
        new QualityInProcurementField<String>("QualityManagementSystem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtCertfnValidTo</b>
     * </p>
     *
     * @return Validity Date of Certification
     */
    @SerializedName( "QltyInProcmtCertfnValidTo" )
    @JsonProperty( "QltyInProcmtCertfnValidTo" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QltyInProcmtCertfnValidTo",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime qltyInProcmtCertfnValidTo;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtCertfnValidTo</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<LocalDateTime> QLTY_IN_PROCMT_CERTFN_VALID_TO =
        new QualityInProcurementField<LocalDateTime>("QltyInProcmtCertfnValidTo");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @return Inspection Type for Insp. Lot Origin (Source Inspection)
     */
    @SerializedName( "InspectionLotType" )
    @JsonProperty( "InspectionLotType" )
    @Nullable
    @ODataField( odataName = "InspectionLotType" )
    private String inspectionLotType;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotType</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> INSPECTION_LOT_TYPE =
        new QualityInProcurementField<String>("InspectionLotType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtLotCrtnLeadTime</b>
     * </p>
     *
     * @return Lot Creation Lead Time (in Days) for Source Inspection
     */
    @SerializedName( "QltyInProcmtLotCrtnLeadTime" )
    @JsonProperty( "QltyInProcmtLotCrtnLeadTime" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtLotCrtnLeadTime" )
    private Short qltyInProcmtLotCrtnLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtLotCrtnLeadTime</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<Short> QLTY_IN_PROCMT_LOT_CRTN_LEAD_TIME =
        new QualityInProcurementField<Short>("QltyInProcmtLotCrtnLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtCertificateCtrl</b>
     * </p>
     *
     * @return Control of Certificate Receipt
     */
    @SerializedName( "QltyInProcmtCertificateCtrl" )
    @JsonProperty( "QltyInProcmtCertificateCtrl" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtCertificateCtrl" )
    private String qltyInProcmtCertificateCtrl;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtCertificateCtrl</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QLTY_IN_PROCMT_CERTIFICATE_CTRL =
        new QualityInProcurementField<String>("QltyInProcmtCertificateCtrl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "QltyInProcmtLongText" )
    @JsonProperty( "QltyInProcmtLongText" )
    @Nullable
    @ODataField( odataName = "QltyInProcmtLongText" )
    private String qltyInProcmtLongText;
    /**
     * Use with available fluent helpers to apply the <b>QltyInProcmtLongText</b> field to query operations.
     *
     */
    public final static QualityInProcurementField<String> QLTY_IN_PROCMT_LONG_TEXT =
        new QualityInProcurementField<String>("QltyInProcmtLongText");
    /**
     * Navigation property <b>to_QltyFirstArticleInsp</b> for <b>QualityInProcurement</b> to multiple
     * <b>QualityFirstArticleInspection</b>.
     *
     */
    @SerializedName( "to_QltyFirstArticleInsp" )
    @JsonProperty( "to_QltyFirstArticleInsp" )
    @ODataField( odataName = "to_QltyFirstArticleInsp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<QualityFirstArticleInspection> toQltyFirstArticleInsp;
    /**
     * Use with available fluent helpers to apply the <b>to_QltyFirstArticleInsp</b> navigation property to query
     * operations.
     *
     */
    public final static QualityInProcurementLink<QualityFirstArticleInspection> TO_QLTY_FIRST_ARTICLE_INSP =
        new QualityInProcurementLink<QualityFirstArticleInspection>("to_QltyFirstArticleInsp");

    @Nonnull
    @Override
    public Class<QualityInProcurement> getType()
    {
        return QualityInProcurement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtIntID</b>
     * </p>
     *
     * @param qltyInProcmtIntID
     *            Quality Info Record in Procurement Internal ID
     */
    public void setQltyInProcmtIntID( @Nullable final String qltyInProcmtIntID )
    {
        rememberChangedField("QltyInProcmtIntID", this.qltyInProcmtIntID);
        this.qltyInProcmtIntID = qltyInProcmtIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @param materialRevisionLevel
     *            Revision Level
     */
    public void setMaterialRevisionLevel( @Nullable final String materialRevisionLevel )
    {
        rememberChangedField("MaterialRevisionLevel", this.materialRevisionLevel);
        this.materialRevisionLevel = materialRevisionLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtReleaseValidTo</b>
     * </p>
     *
     * @param qltyInProcmtReleaseValidTo
     *            Date Until Which the Release Is Valid
     */
    public void setQltyInProcmtReleaseValidTo( @Nullable final LocalDateTime qltyInProcmtReleaseValidTo )
    {
        rememberChangedField("QltyInProcmtReleaseValidTo", this.qltyInProcmtReleaseValidTo);
        this.qltyInProcmtReleaseValidTo = qltyInProcmtReleaseValidTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure for the Material
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedQuantity</b>
     * </p>
     *
     * @param releasedQuantity
     *            Quantity Released for the Material
     */
    public void setReleasedQuantity( @Nullable final BigDecimal releasedQuantity )
    {
        rememberChangedField("ReleasedQuantity", this.releasedQuantity);
        this.releasedQuantity = releasedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BlockReason</b>
     * </p>
     *
     * @param blockReason
     *            Blocking Reason
     */
    public void setBlockReason( @Nullable final String blockReason )
    {
        rememberChangedField("BlockReason", this.blockReason);
        this.blockReason = blockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementBlock</b>
     * </p>
     *
     * @param procurementBlock
     *            Function That Will Be Blocked
     */
    public void setProcurementBlock( @Nullable final String procurementBlock )
    {
        rememberChangedField("ProcurementBlock", this.procurementBlock);
        this.procurementBlock = procurementBlock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtRelQtyIsActive</b>
     * </p>
     *
     * @param qltyInProcmtRelQtyIsActive
     *            Release Quantity Is Active
     */
    public void setQltyInProcmtRelQtyIsActive( @Nullable final String qltyInProcmtRelQtyIsActive )
    {
        rememberChangedField("QltyInProcmtRelQtyIsActive", this.qltyInProcmtRelQtyIsActive);
        this.qltyInProcmtRelQtyIsActive = qltyInProcmtRelQtyIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtInspControl</b>
     * </p>
     *
     * @param qltyInProcmtInspControl
     *            Inspection Control in the QM Info Record
     */
    public void setQltyInProcmtInspControl( @Nullable final String qltyInProcmtInspControl )
    {
        rememberChangedField("QltyInProcmtInspControl", this.qltyInProcmtInspControl);
        this.qltyInProcmtInspControl = qltyInProcmtInspControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnPieceApprovalIsRequired</b>
     * </p>
     *
     * @param prodnPieceApprovalIsRequired
     *            Production Part Approval Is Required
     */
    public void setProdnPieceApprovalIsRequired( @Nullable final String prodnPieceApprovalIsRequired )
    {
        rememberChangedField("ProdnPieceApprovalIsRequired", this.prodnPieceApprovalIsRequired);
        this.prodnPieceApprovalIsRequired = prodnPieceApprovalIsRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApproval</b>
     * </p>
     *
     * @param productionPieceApproval
     *            Production Part Approval Identifier
     */
    public void setProductionPieceApproval( @Nullable final String productionPieceApproval )
    {
        rememberChangedField("ProductionPieceApproval", this.productionPieceApproval);
        this.productionPieceApproval = productionPieceApproval;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApprovalLevel</b>
     * </p>
     *
     * @param productionPieceApprovalLevel
     *            Production Part Approval for Part Submission Warrant
     */
    public void setProductionPieceApprovalLevel( @Nullable final String productionPieceApprovalLevel )
    {
        rememberChangedField("ProductionPieceApprovalLevel", this.productionPieceApprovalLevel);
        this.productionPieceApprovalLevel = productionPieceApprovalLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPieceApprovalStatus</b>
     * </p>
     *
     * @param productionPieceApprovalStatus
     *            Production Part Approval Status
     */
    public void setProductionPieceApprovalStatus( @Nullable final String productionPieceApprovalStatus )
    {
        rememberChangedField("ProductionPieceApprovalStatus", this.productionPieceApprovalStatus);
        this.productionPieceApprovalStatus = productionPieceApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Flag
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityManagementSystem</b>
     * </p>
     *
     * @param qualityManagementSystem
     *            Supplier's QM System
     */
    public void setQualityManagementSystem( @Nullable final String qualityManagementSystem )
    {
        rememberChangedField("QualityManagementSystem", this.qualityManagementSystem);
        this.qualityManagementSystem = qualityManagementSystem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtCertfnValidTo</b>
     * </p>
     *
     * @param qltyInProcmtCertfnValidTo
     *            Validity Date of Certification
     */
    public void setQltyInProcmtCertfnValidTo( @Nullable final LocalDateTime qltyInProcmtCertfnValidTo )
    {
        rememberChangedField("QltyInProcmtCertfnValidTo", this.qltyInProcmtCertfnValidTo);
        this.qltyInProcmtCertfnValidTo = qltyInProcmtCertfnValidTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @param inspectionLotType
     *            Inspection Type for Insp. Lot Origin (Source Inspection)
     */
    public void setInspectionLotType( @Nullable final String inspectionLotType )
    {
        rememberChangedField("InspectionLotType", this.inspectionLotType);
        this.inspectionLotType = inspectionLotType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtLotCrtnLeadTime</b>
     * </p>
     *
     * @param qltyInProcmtLotCrtnLeadTime
     *            Lot Creation Lead Time (in Days) for Source Inspection
     */
    public void setQltyInProcmtLotCrtnLeadTime( @Nullable final Short qltyInProcmtLotCrtnLeadTime )
    {
        rememberChangedField("QltyInProcmtLotCrtnLeadTime", this.qltyInProcmtLotCrtnLeadTime);
        this.qltyInProcmtLotCrtnLeadTime = qltyInProcmtLotCrtnLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtCertificateCtrl</b>
     * </p>
     *
     * @param qltyInProcmtCertificateCtrl
     *            Control of Certificate Receipt
     */
    public void setQltyInProcmtCertificateCtrl( @Nullable final String qltyInProcmtCertificateCtrl )
    {
        rememberChangedField("QltyInProcmtCertificateCtrl", this.qltyInProcmtCertificateCtrl);
        this.qltyInProcmtCertificateCtrl = qltyInProcmtCertificateCtrl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QltyInProcmtLongText</b>
     * </p>
     *
     * @param qltyInProcmtLongText
     *            Long Text
     */
    public void setQltyInProcmtLongText( @Nullable final String qltyInProcmtLongText )
    {
        rememberChangedField("QltyInProcmtLongText", this.qltyInProcmtLongText);
        this.qltyInProcmtLongText = qltyInProcmtLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "QualityInProcurement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("QltyInProcmtIntID", getQltyInProcmtIntID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("QltyInProcmtIntID", getQltyInProcmtIntID());
        values.put("Supplier", getSupplier());
        values.put("Plant", getPlant());
        values.put("MaterialRevisionLevel", getMaterialRevisionLevel());
        values.put("QltyInProcmtReleaseValidTo", getQltyInProcmtReleaseValidTo());
        values.put("BaseUnit", getBaseUnit());
        values.put("ReleasedQuantity", getReleasedQuantity());
        values.put("BlockReason", getBlockReason());
        values.put("ProcurementBlock", getProcurementBlock());
        values.put("QltyInProcmtRelQtyIsActive", getQltyInProcmtRelQtyIsActive());
        values.put("QltyInProcmtInspControl", getQltyInProcmtInspControl());
        values.put("ProdnPieceApprovalIsRequired", getProdnPieceApprovalIsRequired());
        values.put("ProductionPieceApproval", getProductionPieceApproval());
        values.put("ProductionPieceApprovalLevel", getProductionPieceApprovalLevel());
        values.put("ProductionPieceApprovalStatus", getProductionPieceApprovalStatus());
        values.put("IsDeleted", getIsDeleted());
        values.put("QualityManagementSystem", getQualityManagementSystem());
        values.put("QltyInProcmtCertfnValidTo", getQltyInProcmtCertfnValidTo());
        values.put("InspectionLotType", getInspectionLotType());
        values.put("QltyInProcmtLotCrtnLeadTime", getQltyInProcmtLotCrtnLeadTime());
        values.put("QltyInProcmtCertificateCtrl", getQltyInProcmtCertificateCtrl());
        values.put("QltyInProcmtLongText", getQltyInProcmtLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtIntID") ) {
                final Object value = values.remove("QltyInProcmtIntID");
                if( (value == null) || (!value.equals(getQltyInProcmtIntID())) ) {
                    setQltyInProcmtIntID(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MaterialRevisionLevel") ) {
                final Object value = values.remove("MaterialRevisionLevel");
                if( (value == null) || (!value.equals(getMaterialRevisionLevel())) ) {
                    setMaterialRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtReleaseValidTo") ) {
                final Object value = values.remove("QltyInProcmtReleaseValidTo");
                if( (value == null) || (!value.equals(getQltyInProcmtReleaseValidTo())) ) {
                    setQltyInProcmtReleaseValidTo(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ReleasedQuantity") ) {
                final Object value = values.remove("ReleasedQuantity");
                if( (value == null) || (!value.equals(getReleasedQuantity())) ) {
                    setReleasedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BlockReason") ) {
                final Object value = values.remove("BlockReason");
                if( (value == null) || (!value.equals(getBlockReason())) ) {
                    setBlockReason(((String) value));
                }
            }
            if( values.containsKey("ProcurementBlock") ) {
                final Object value = values.remove("ProcurementBlock");
                if( (value == null) || (!value.equals(getProcurementBlock())) ) {
                    setProcurementBlock(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtRelQtyIsActive") ) {
                final Object value = values.remove("QltyInProcmtRelQtyIsActive");
                if( (value == null) || (!value.equals(getQltyInProcmtRelQtyIsActive())) ) {
                    setQltyInProcmtRelQtyIsActive(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtInspControl") ) {
                final Object value = values.remove("QltyInProcmtInspControl");
                if( (value == null) || (!value.equals(getQltyInProcmtInspControl())) ) {
                    setQltyInProcmtInspControl(((String) value));
                }
            }
            if( values.containsKey("ProdnPieceApprovalIsRequired") ) {
                final Object value = values.remove("ProdnPieceApprovalIsRequired");
                if( (value == null) || (!value.equals(getProdnPieceApprovalIsRequired())) ) {
                    setProdnPieceApprovalIsRequired(((String) value));
                }
            }
            if( values.containsKey("ProductionPieceApproval") ) {
                final Object value = values.remove("ProductionPieceApproval");
                if( (value == null) || (!value.equals(getProductionPieceApproval())) ) {
                    setProductionPieceApproval(((String) value));
                }
            }
            if( values.containsKey("ProductionPieceApprovalLevel") ) {
                final Object value = values.remove("ProductionPieceApprovalLevel");
                if( (value == null) || (!value.equals(getProductionPieceApprovalLevel())) ) {
                    setProductionPieceApprovalLevel(((String) value));
                }
            }
            if( values.containsKey("ProductionPieceApprovalStatus") ) {
                final Object value = values.remove("ProductionPieceApprovalStatus");
                if( (value == null) || (!value.equals(getProductionPieceApprovalStatus())) ) {
                    setProductionPieceApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("QualityManagementSystem") ) {
                final Object value = values.remove("QualityManagementSystem");
                if( (value == null) || (!value.equals(getQualityManagementSystem())) ) {
                    setQualityManagementSystem(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtCertfnValidTo") ) {
                final Object value = values.remove("QltyInProcmtCertfnValidTo");
                if( (value == null) || (!value.equals(getQltyInProcmtCertfnValidTo())) ) {
                    setQltyInProcmtCertfnValidTo(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotType") ) {
                final Object value = values.remove("InspectionLotType");
                if( (value == null) || (!value.equals(getInspectionLotType())) ) {
                    setInspectionLotType(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtLotCrtnLeadTime") ) {
                final Object value = values.remove("QltyInProcmtLotCrtnLeadTime");
                if( (value == null) || (!value.equals(getQltyInProcmtLotCrtnLeadTime())) ) {
                    setQltyInProcmtLotCrtnLeadTime(((Short) value));
                }
            }
            if( values.containsKey("QltyInProcmtCertificateCtrl") ) {
                final Object value = values.remove("QltyInProcmtCertificateCtrl");
                if( (value == null) || (!value.equals(getQltyInProcmtCertificateCtrl())) ) {
                    setQltyInProcmtCertificateCtrl(((String) value));
                }
            }
            if( values.containsKey("QltyInProcmtLongText") ) {
                final Object value = values.remove("QltyInProcmtLongText");
                if( (value == null) || (!value.equals(getQltyInProcmtLongText())) ) {
                    setQltyInProcmtLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_QltyFirstArticleInsp") ) {
                final Object value = (values).remove("to_QltyFirstArticleInsp");
                if( value instanceof Iterable ) {
                    if( toQltyFirstArticleInsp == null ) {
                        toQltyFirstArticleInsp = Lists.newArrayList();
                    } else {
                        toQltyFirstArticleInsp = Lists.newArrayList(toQltyFirstArticleInsp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        QualityFirstArticleInspection entity;
                        if( toQltyFirstArticleInsp.size() > i ) {
                            entity = toQltyFirstArticleInsp.get(i);
                        } else {
                            entity = new QualityFirstArticleInspection();
                            toQltyFirstArticleInsp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> QualityInProcurementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new QualityInProcurementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> QualityInProcurementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new QualityInProcurementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toQltyFirstArticleInsp != null ) {
            (values).put("to_QltyFirstArticleInsp", toQltyFirstArticleInsp);
        }
        return values;
    }

    /**
     * Fetches the <b>QualityFirstArticleInspection</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_QltyFirstArticleInsp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>QualityFirstArticleInspection</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<QualityFirstArticleInspection> fetchQltyFirstArticleInsp()
    {
        return fetchFieldAsList("to_QltyFirstArticleInsp", QualityFirstArticleInspection.class);
    }

    /**
     * Retrieval of associated <b>QualityFirstArticleInspection</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_QltyFirstArticleInsp</b>.
     * <p>
     * If the navigation property <b>to_QltyFirstArticleInsp</b> of a queried <b>QualityInProcurement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>QualityFirstArticleInspection</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<QualityFirstArticleInspection> getQltyFirstArticleInspOrFetch()
    {
        if( toQltyFirstArticleInsp == null ) {
            toQltyFirstArticleInsp = fetchQltyFirstArticleInsp();
        }
        return toQltyFirstArticleInsp;
    }

    /**
     * Retrieval of associated <b>QualityFirstArticleInspection</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_QltyFirstArticleInsp</b>.
     * <p>
     * If the navigation property for an entity <b>QualityInProcurement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_QltyFirstArticleInsp</b> is already loaded, the result
     *         will contain the <b>QualityFirstArticleInspection</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<QualityFirstArticleInspection>> getQltyFirstArticleInspIfPresent()
    {
        return Option.of(toQltyFirstArticleInsp);
    }

    /**
     * Overwrites the list of associated <b>QualityFirstArticleInspection</b> entities for the loaded navigation
     * property <b>to_QltyFirstArticleInsp</b>.
     * <p>
     * If the navigation property <b>to_QltyFirstArticleInsp</b> of a queried <b>QualityInProcurement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>QualityFirstArticleInspection</b> entities.
     */
    public void setQltyFirstArticleInsp( @Nonnull final List<QualityFirstArticleInspection> value )
    {
        if( toQltyFirstArticleInsp == null ) {
            toQltyFirstArticleInsp = Lists.newArrayList();
        }
        toQltyFirstArticleInsp.clear();
        toQltyFirstArticleInsp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>QualityFirstArticleInspection</b> entities. This corresponds to the
     * OData navigation property <b>to_QltyFirstArticleInsp</b>.
     * <p>
     * If the navigation property <b>to_QltyFirstArticleInsp</b> of a queried <b>QualityInProcurement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>QualityFirstArticleInspection</b> entities.
     */
    public void addQltyFirstArticleInsp( QualityFirstArticleInspection... entity )
    {
        if( toQltyFirstArticleInsp == null ) {
            toQltyFirstArticleInsp = Lists.newArrayList();
        }
        toQltyFirstArticleInsp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of QualityInProcurement instances.
     *
     */
    public final static class QualityInProcurementBuilder
    {

        private List<QualityFirstArticleInspection> toQltyFirstArticleInsp = Lists.newArrayList();

        private QualityInProcurement.QualityInProcurementBuilder toQltyFirstArticleInsp(
            final List<QualityFirstArticleInspection> value )
        {
            toQltyFirstArticleInsp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_QltyFirstArticleInsp</b> for <b>QualityInProcurement</b> to multiple
         * <b>QualityFirstArticleInspection</b>.
         *
         * @param value
         *            The QualityFirstArticleInspections to build this QualityInProcurement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public QualityInProcurement.QualityInProcurementBuilder qltyFirstArticleInsp(
            QualityFirstArticleInspection... value )
        {
            return toQltyFirstArticleInsp(Lists.newArrayList(value));
        }

    }

}
