/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link QualityInfoRecordServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService QualityInfoRecordService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultQualityInfoRecordServiceBatch
    extends
    BatchFluentHelperBasic<QualityInfoRecordServiceBatch, QualityInfoRecordServiceBatchChangeSet>
    implements
    QualityInfoRecordServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultQualityInfoRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultQualityInfoRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultQualityInfoRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultQualityInfoRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultQualityInfoRecordServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultQualityInfoRecordServiceBatchChangeSet(this, service);
    }

}
