/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement;

/**
 * Implementation of the {@link QualityInfoRecordServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService QualityInfoRecordService}.
 *
 */
public class DefaultQualityInfoRecordServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<QualityInfoRecordServiceBatch, QualityInfoRecordServiceBatchChangeSet>
    implements
    QualityInfoRecordServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService service;

    @SuppressWarnings( "deprecation" )
    DefaultQualityInfoRecordServiceBatchChangeSet(
        @Nonnull final DefaultQualityInfoRecordServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultQualityInfoRecordServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet createQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return addRequestCreate(service::createQualityFirstArticleInspection, qualityFirstArticleInspection);
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet updateQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return addRequestUpdate(service::updateQualityFirstArticleInspection, qualityFirstArticleInspection);
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet deleteQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return addRequestDelete(service::deleteQualityFirstArticleInspection, qualityFirstArticleInspection);
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet createQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return addRequestCreate(service::createQualityInProcurement, qualityInProcurement);
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet updateQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return addRequestUpdate(service::updateQualityInProcurement, qualityInProcurement);
    }

    @Nonnull
    @Override
    public QualityInfoRecordServiceBatchChangeSet deleteQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return addRequestDelete(service::deleteQualityInProcurement, qualityInProcurement);
    }

}
