/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInfoRecordService QualityInfoRecordService}.
 *
 */
public interface QualityInfoRecordServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<QualityInfoRecordServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<QualityInfoRecordServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity and save it to the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet createQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity and save it to the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet updateQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity in the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet deleteQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity and save it to the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet
        createQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity and save it to the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet
        updateQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity in the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInfoRecordServiceBatchChangeSet
        deleteQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

}
