/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
 * QualityFirstArticleInspection}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.field.QualityFirstArticleInspectionField
 * QualityFirstArticleInspectionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.link.QualityFirstArticleInspectionLink
 * QualityFirstArticleInspectionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#QLTY_IN_PROCMT_INT_ID
 * QLTY_IN_PROCMT_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#QLTY_IN_PROCMT1ST_ARTICLE_INSP
 * QLTY_IN_PROCMT1ST_ARTICLE_INSP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#INSP_LOT_USAGE_DECISION_VALUATION
 * INSP_LOT_USAGE_DECISION_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection#TO_QLTY_IN_PROCUREMENT
 * TO_QLTY_IN_PROCUREMENT}</li>
 * </ul>
 *
 */
public interface QualityFirstArticleInspectionSelectable extends EntitySelectable<QualityFirstArticleInspection>
{

}
