/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
 * QualityInProcurement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.field.QualityInProcurementField
 * QualityInProcurementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.link.QualityInProcurementLink
 * QualityInProcurementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_INT_ID
 * QLTY_IN_PROCMT_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#MATERIAL_REVISION_LEVEL
 * MATERIAL_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_RELEASE_VALID_TO
 * QLTY_IN_PROCMT_RELEASE_VALID_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#RELEASED_QUANTITY
 * RELEASED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#BLOCK_REASON
 * BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PROCUREMENT_BLOCK
 * PROCUREMENT_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_REL_QTY_IS_ACTIVE
 * QLTY_IN_PROCMT_REL_QTY_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_INSP_CONTROL
 * QLTY_IN_PROCMT_INSP_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PRODN_PIECE_APPROVAL_IS_REQUIRED
 * PRODN_PIECE_APPROVAL_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PRODUCTION_PIECE_APPROVAL
 * PRODUCTION_PIECE_APPROVAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PRODUCTION_PIECE_APPROVAL_LEVEL
 * PRODUCTION_PIECE_APPROVAL_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#PRODUCTION_PIECE_APPROVAL_STATUS
 * PRODUCTION_PIECE_APPROVAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QUALITY_MANAGEMENT_SYSTEM
 * QUALITY_MANAGEMENT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_CERTFN_VALID_TO
 * QLTY_IN_PROCMT_CERTFN_VALID_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#INSPECTION_LOT_TYPE
 * INSPECTION_LOT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_LOT_CRTN_LEAD_TIME
 * QLTY_IN_PROCMT_LOT_CRTN_LEAD_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_CERTIFICATE_CTRL
 * QLTY_IN_PROCMT_CERTIFICATE_CTRL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#QLTY_IN_PROCMT_LONG_TEXT
 * QLTY_IN_PROCMT_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement#TO_QLTY_FIRST_ARTICLE_INSP
 * TO_QLTY_FIRST_ARTICLE_INSP}</li>
 * </ul>
 *
 */
public interface QualityInProcurementSelectable extends EntitySelectable<QualityInProcurement>
{

}
