/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotMatlDocItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspLotMatlDocItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspLotMatlDocItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Stock Postings
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspLotMatlDocItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspLotMatlDocItem extends VdmEntity<InspLotMatlDocItem>
{

    /**
     * Selector for all available fields of InspLotMatlDocItem.
     *
     */
    public final static InspLotMatlDocItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSPECTION_LOT =
        new InspLotMatlDocItemField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItem</b>
     * </p>
     *
     * @return Internal Counter for DB Objects
     */
    @Key
    @SerializedName( "InspLotMatlDocItem" )
    @JsonProperty( "InspLotMatlDocItem" )
    @Nullable
    @ODataField( odataName = "InspLotMatlDocItem" )
    private String inspLotMatlDocItem;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMatlDocItem</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSP_LOT_MATL_DOC_ITEM =
        new InspLotMatlDocItemField<String>("InspLotMatlDocItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyPosted</b>
     * </p>
     *
     * @return Quantity in unit of entry
     */
    @SerializedName( "InspLotQtyPosted" )
    @JsonProperty( "InspLotQtyPosted" )
    @Nullable
    @ODataField( odataName = "InspLotQtyPosted" )
    private BigDecimal inspLotQtyPosted;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyPosted</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<BigDecimal> INSP_LOT_QTY_POSTED =
        new InspLotMatlDocItemField<BigDecimal>("InspLotQtyPosted");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItmQtyUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "InspLotMatlDocItmQtyUnit" )
    @JsonProperty( "InspLotMatlDocItmQtyUnit" )
    @Nullable
    @ODataField( odataName = "InspLotMatlDocItmQtyUnit" )
    private String inspLotMatlDocItmQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMatlDocItmQtyUnit</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSP_LOT_MATL_DOC_ITM_QTY_UNIT =
        new InspLotMatlDocItemField<String>("InspLotMatlDocItmQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UsageDecisionStockType</b>
     * </p>
     *
     * @return Posting Proposal in Usage Decision
     */
    @SerializedName( "UsageDecisionStockType" )
    @JsonProperty( "UsageDecisionStockType" )
    @Nullable
    @ODataField( odataName = "UsageDecisionStockType" )
    private String usageDecisionStockType;
    /**
     * Use with available fluent helpers to apply the <b>UsageDecisionStockType</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> USAGE_DECISION_STOCK_TYPE =
        new InspLotMatlDocItemField<String>("UsageDecisionStockType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> STORAGE_LOCATION =
        new InspLotMatlDocItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMaterialPostedTo</b>
     * </p>
     *
     * @return Transfer Material
     */
    @SerializedName( "InspLotMaterialPostedTo" )
    @JsonProperty( "InspLotMaterialPostedTo" )
    @Nullable
    @ODataField( odataName = "InspLotMaterialPostedTo" )
    private String inspLotMaterialPostedTo;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMaterialPostedTo</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSP_LOT_MATERIAL_POSTED_TO =
        new InspLotMatlDocItemField<String>("InspLotMaterialPostedTo");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotBatchTransferredTo</b>
     * </p>
     *
     * @return Transfer Batch
     */
    @SerializedName( "InspLotBatchTransferredTo" )
    @JsonProperty( "InspLotBatchTransferredTo" )
    @Nullable
    @ODataField( odataName = "InspLotBatchTransferredTo" )
    private String inspLotBatchTransferredTo;
    /**
     * Use with available fluent helpers to apply the <b>InspLotBatchTransferredTo</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSP_LOT_BATCH_TRANSFERRED_TO =
        new InspLotMatlDocItemField<String>("InspLotBatchTransferredTo");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "MaterialDocumentItemText" )
    @JsonProperty( "MaterialDocumentItemText" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItemText" )
    private String materialDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItemText</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> MATERIAL_DOCUMENT_ITEM_TEXT =
        new InspLotMatlDocItemField<String>("MaterialDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItemType</b>
     * </p>
     *
     * @return Type of Reference Between Inspection Lot and Material Doc.
     */
    @SerializedName( "InspLotMatlDocItemType" )
    @JsonProperty( "InspLotMatlDocItemType" )
    @Nullable
    @ODataField( odataName = "InspLotMatlDocItemType" )
    private String inspLotMatlDocItemType;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMatlDocItemType</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> INSP_LOT_MATL_DOC_ITEM_TYPE =
        new InspLotMatlDocItemField<String>("InspLotMatlDocItemType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> MATERIAL_DOCUMENT =
        new InspLotMatlDocItemField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> MATERIAL_DOCUMENT_YEAR =
        new InspLotMatlDocItemField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Item in Material Document
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<String> MATERIAL_DOCUMENT_ITEM =
        new InspLotMatlDocItemField<String>("MaterialDocumentItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Day On Which Accounting Document Was Entered
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<LocalDateTime> CREATION_DATE =
        new InspLotMatlDocItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItemField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspLotMatlDocItemField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> for <b>InspLotMatlDocItem</b> to multiple
     * <b>InspLotMatlDocItmSrlNmbr</b>.
     *
     */
    @SerializedName( "to_InspLotMatlDocItmSrlNmbr" )
    @JsonProperty( "to_InspLotMatlDocItmSrlNmbr" )
    @ODataField( odataName = "to_InspLotMatlDocItmSrlNmbr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InspLotMatlDocItmSrlNmbr> toInspLotMatlDocItmSrlNmbr;
    /**
     * Use with available fluent helpers to apply the <b>to_InspLotMatlDocItmSrlNmbr</b> navigation property to query
     * operations.
     *
     */
    public final static InspLotMatlDocItemLink<InspLotMatlDocItmSrlNmbr> TO_INSP_LOT_MATL_DOC_ITM_SRL_NMBR =
        new InspLotMatlDocItemLink<InspLotMatlDocItmSrlNmbr>("to_InspLotMatlDocItmSrlNmbr");

    @Nonnull
    @Override
    public Class<InspLotMatlDocItem> getType()
    {
        return InspLotMatlDocItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItem</b>
     * </p>
     *
     * @param inspLotMatlDocItem
     *            Internal Counter for DB Objects
     */
    public void setInspLotMatlDocItem( @Nullable final String inspLotMatlDocItem )
    {
        rememberChangedField("InspLotMatlDocItem", this.inspLotMatlDocItem);
        this.inspLotMatlDocItem = inspLotMatlDocItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyPosted</b>
     * </p>
     *
     * @param inspLotQtyPosted
     *            Quantity in unit of entry
     */
    public void setInspLotQtyPosted( @Nullable final BigDecimal inspLotQtyPosted )
    {
        rememberChangedField("InspLotQtyPosted", this.inspLotQtyPosted);
        this.inspLotQtyPosted = inspLotQtyPosted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItmQtyUnit</b>
     * </p>
     *
     * @param inspLotMatlDocItmQtyUnit
     *            Unit of entry
     */
    public void setInspLotMatlDocItmQtyUnit( @Nullable final String inspLotMatlDocItmQtyUnit )
    {
        rememberChangedField("InspLotMatlDocItmQtyUnit", this.inspLotMatlDocItmQtyUnit);
        this.inspLotMatlDocItmQtyUnit = inspLotMatlDocItmQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UsageDecisionStockType</b>
     * </p>
     *
     * @param usageDecisionStockType
     *            Posting Proposal in Usage Decision
     */
    public void setUsageDecisionStockType( @Nullable final String usageDecisionStockType )
    {
        rememberChangedField("UsageDecisionStockType", this.usageDecisionStockType);
        this.usageDecisionStockType = usageDecisionStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMaterialPostedTo</b>
     * </p>
     *
     * @param inspLotMaterialPostedTo
     *            Transfer Material
     */
    public void setInspLotMaterialPostedTo( @Nullable final String inspLotMaterialPostedTo )
    {
        rememberChangedField("InspLotMaterialPostedTo", this.inspLotMaterialPostedTo);
        this.inspLotMaterialPostedTo = inspLotMaterialPostedTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotBatchTransferredTo</b>
     * </p>
     *
     * @param inspLotBatchTransferredTo
     *            Transfer Batch
     */
    public void setInspLotBatchTransferredTo( @Nullable final String inspLotBatchTransferredTo )
    {
        rememberChangedField("InspLotBatchTransferredTo", this.inspLotBatchTransferredTo);
        this.inspLotBatchTransferredTo = inspLotBatchTransferredTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItemText</b>
     * </p>
     *
     * @param materialDocumentItemText
     *            Item Text
     */
    public void setMaterialDocumentItemText( @Nullable final String materialDocumentItemText )
    {
        rememberChangedField("MaterialDocumentItemText", this.materialDocumentItemText);
        this.materialDocumentItemText = materialDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItemType</b>
     * </p>
     *
     * @param inspLotMatlDocItemType
     *            Type of Reference Between Inspection Lot and Material Doc.
     */
    public void setInspLotMatlDocItemType( @Nullable final String inspLotMatlDocItemType )
    {
        rememberChangedField("InspLotMatlDocItemType", this.inspLotMatlDocItemType);
        this.inspLotMatlDocItemType = inspLotMatlDocItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Item in Material Document
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspLotMatlDocItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspLotMatlDocItem", getInspLotMatlDocItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspLotMatlDocItem", getInspLotMatlDocItem());
        values.put("InspLotQtyPosted", getInspLotQtyPosted());
        values.put("InspLotMatlDocItmQtyUnit", getInspLotMatlDocItmQtyUnit());
        values.put("UsageDecisionStockType", getUsageDecisionStockType());
        values.put("StorageLocation", getStorageLocation());
        values.put("InspLotMaterialPostedTo", getInspLotMaterialPostedTo());
        values.put("InspLotBatchTransferredTo", getInspLotBatchTransferredTo());
        values.put("MaterialDocumentItemText", getMaterialDocumentItemText());
        values.put("InspLotMatlDocItemType", getInspLotMatlDocItemType());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("CreationDate", getCreationDate());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspLotMatlDocItem") ) {
                final Object value = values.remove("InspLotMatlDocItem");
                if( (value == null) || (!value.equals(getInspLotMatlDocItem())) ) {
                    setInspLotMatlDocItem(((String) value));
                }
            }
            if( values.containsKey("InspLotQtyPosted") ) {
                final Object value = values.remove("InspLotQtyPosted");
                if( (value == null) || (!value.equals(getInspLotQtyPosted())) ) {
                    setInspLotQtyPosted(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotMatlDocItmQtyUnit") ) {
                final Object value = values.remove("InspLotMatlDocItmQtyUnit");
                if( (value == null) || (!value.equals(getInspLotMatlDocItmQtyUnit())) ) {
                    setInspLotMatlDocItmQtyUnit(((String) value));
                }
            }
            if( values.containsKey("UsageDecisionStockType") ) {
                final Object value = values.remove("UsageDecisionStockType");
                if( (value == null) || (!value.equals(getUsageDecisionStockType())) ) {
                    setUsageDecisionStockType(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("InspLotMaterialPostedTo") ) {
                final Object value = values.remove("InspLotMaterialPostedTo");
                if( (value == null) || (!value.equals(getInspLotMaterialPostedTo())) ) {
                    setInspLotMaterialPostedTo(((String) value));
                }
            }
            if( values.containsKey("InspLotBatchTransferredTo") ) {
                final Object value = values.remove("InspLotBatchTransferredTo");
                if( (value == null) || (!value.equals(getInspLotBatchTransferredTo())) ) {
                    setInspLotBatchTransferredTo(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItemText") ) {
                final Object value = values.remove("MaterialDocumentItemText");
                if( (value == null) || (!value.equals(getMaterialDocumentItemText())) ) {
                    setMaterialDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("InspLotMatlDocItemType") ) {
                final Object value = values.remove("InspLotMatlDocItemType");
                if( (value == null) || (!value.equals(getInspLotMatlDocItemType())) ) {
                    setInspLotMatlDocItemType(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InspLotMatlDocItmSrlNmbr") ) {
                final Object value = (values).remove("to_InspLotMatlDocItmSrlNmbr");
                if( value instanceof Iterable ) {
                    if( toInspLotMatlDocItmSrlNmbr == null ) {
                        toInspLotMatlDocItmSrlNmbr = Lists.newArrayList();
                    } else {
                        toInspLotMatlDocItmSrlNmbr = Lists.newArrayList(toInspLotMatlDocItmSrlNmbr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InspLotMatlDocItmSrlNmbr entity;
                        if( toInspLotMatlDocItmSrlNmbr.size() > i ) {
                            entity = toInspLotMatlDocItmSrlNmbr.get(i);
                        } else {
                            entity = new InspLotMatlDocItmSrlNmbr();
                            toInspLotMatlDocItmSrlNmbr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspLotMatlDocItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspLotMatlDocItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspLotMatlDocItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspLotMatlDocItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInspLotMatlDocItmSrlNmbr != null ) {
            (values).put("to_InspLotMatlDocItmSrlNmbr", toInspLotMatlDocItmSrlNmbr);
        }
        return values;
    }

    /**
     * Fetches the <b>InspLotMatlDocItmSrlNmbr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_InspLotMatlDocItmSrlNmbr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InspLotMatlDocItmSrlNmbr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspLotMatlDocItmSrlNmbr> fetchInspLotMatlDocItmSrlNmbr()
    {
        return fetchFieldAsList("to_InspLotMatlDocItmSrlNmbr", InspLotMatlDocItmSrlNmbr.class);
    }

    /**
     * Retrieval of associated <b>InspLotMatlDocItmSrlNmbr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InspLotMatlDocItmSrlNmbr</b>.
     * <p>
     * If the navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> of a queried <b>InspLotMatlDocItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspLotMatlDocItmSrlNmbr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspLotMatlDocItmSrlNmbr> getInspLotMatlDocItmSrlNmbrOrFetch()
    {
        if( toInspLotMatlDocItmSrlNmbr == null ) {
            toInspLotMatlDocItmSrlNmbr = fetchInspLotMatlDocItmSrlNmbr();
        }
        return toInspLotMatlDocItmSrlNmbr;
    }

    /**
     * Retrieval of associated <b>InspLotMatlDocItmSrlNmbr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InspLotMatlDocItmSrlNmbr</b>.
     * <p>
     * If the navigation property for an entity <b>InspLotMatlDocItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> is already loaded, the
     *         result will contain the <b>InspLotMatlDocItmSrlNmbr</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InspLotMatlDocItmSrlNmbr>> getInspLotMatlDocItmSrlNmbrIfPresent()
    {
        return Option.of(toInspLotMatlDocItmSrlNmbr);
    }

    /**
     * Overwrites the list of associated <b>InspLotMatlDocItmSrlNmbr</b> entities for the loaded navigation property
     * <b>to_InspLotMatlDocItmSrlNmbr</b>.
     * <p>
     * If the navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> of a queried <b>InspLotMatlDocItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InspLotMatlDocItmSrlNmbr</b> entities.
     */
    public void setInspLotMatlDocItmSrlNmbr( @Nonnull final List<InspLotMatlDocItmSrlNmbr> value )
    {
        if( toInspLotMatlDocItmSrlNmbr == null ) {
            toInspLotMatlDocItmSrlNmbr = Lists.newArrayList();
        }
        toInspLotMatlDocItmSrlNmbr.clear();
        toInspLotMatlDocItmSrlNmbr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InspLotMatlDocItmSrlNmbr</b> entities. This corresponds to the OData
     * navigation property <b>to_InspLotMatlDocItmSrlNmbr</b>.
     * <p>
     * If the navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> of a queried <b>InspLotMatlDocItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InspLotMatlDocItmSrlNmbr</b> entities.
     */
    public void addInspLotMatlDocItmSrlNmbr( InspLotMatlDocItmSrlNmbr... entity )
    {
        if( toInspLotMatlDocItmSrlNmbr == null ) {
            toInspLotMatlDocItmSrlNmbr = Lists.newArrayList();
        }
        toInspLotMatlDocItmSrlNmbr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InspLotMatlDocItem instances.
     *
     */
    public final static class InspLotMatlDocItemBuilder
    {

        private List<InspLotMatlDocItmSrlNmbr> toInspLotMatlDocItmSrlNmbr = Lists.newArrayList();

        private InspLotMatlDocItem.InspLotMatlDocItemBuilder toInspLotMatlDocItmSrlNmbr(
            final List<InspLotMatlDocItmSrlNmbr> value )
        {
            toInspLotMatlDocItmSrlNmbr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_InspLotMatlDocItmSrlNmbr</b> for <b>InspLotMatlDocItem</b> to multiple
         * <b>InspLotMatlDocItmSrlNmbr</b>.
         *
         * @param value
         *            The InspLotMatlDocItmSrlNmbrs to build this InspLotMatlDocItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspLotMatlDocItem.InspLotMatlDocItemBuilder inspLotMatlDocItmSrlNmbr(
            InspLotMatlDocItmSrlNmbr... value )
        {
            return toInspLotMatlDocItmSrlNmbr(Lists.newArrayList(value));
        }

    }

}
