/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspLotMatlDocItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
 * InspLotMatlDocItem} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class InspLotMatlDocItemByKeyFluentHelper
    extends
    FluentHelperByKey<InspLotMatlDocItemByKeyFluentHelper, InspLotMatlDocItem, InspLotMatlDocItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     * InspLotMatlDocItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspLotMatlDocItem}
     * @param inspLotMatlDocItem
     *            Internal Counter for DB Objects
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspLotMatlDocItem}
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public InspLotMatlDocItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inspectionLot,
        final String inspLotMatlDocItem )
    {
        super(servicePath, entityCollection);
        this.key.put("InspectionLot", inspectionLot);
        this.key.put("InspLotMatlDocItem", inspLotMatlDocItem);
    }

    @Override
    @Nonnull
    protected Class<InspLotMatlDocItem> getEntityClass()
    {
        return InspLotMatlDocItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
