/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotMatlDocItmSrlNmbrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspLotMatlDocItmSrlNmbrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Serial Numbers for Stock Posting
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspLotMatlDocItmSrlNmbrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspLotMatlDocItmSrlNmbr extends VdmEntity<InspLotMatlDocItmSrlNmbr>
{

    /**
     * Selector for all available fields of InspLotMatlDocItmSrlNmbr.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrField<String> INSPECTION_LOT =
        new InspLotMatlDocItmSrlNmbrField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItem</b>
     * </p>
     *
     * @return Internal Counter for DB Objects
     */
    @Key
    @SerializedName( "InspLotMatlDocItem" )
    @JsonProperty( "InspLotMatlDocItem" )
    @Nullable
    @ODataField( odataName = "InspLotMatlDocItem" )
    private String inspLotMatlDocItem;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMatlDocItem</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrField<String> INSP_LOT_MATL_DOC_ITEM =
        new InspLotMatlDocItmSrlNmbrField<String>("InspLotMatlDocItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrField<String> EQUIPMENT =
        new InspLotMatlDocItmSrlNmbrField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrField<String> SERIAL_NUMBER =
        new InspLotMatlDocItmSrlNmbrField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItemType</b>
     * </p>
     *
     * @return Type of Reference Between Inspection Lot and Material Doc.
     */
    @SerializedName( "InspLotMatlDocItemType" )
    @JsonProperty( "InspLotMatlDocItemType" )
    @Nullable
    @ODataField( odataName = "InspLotMatlDocItemType" )
    private String inspLotMatlDocItemType;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMatlDocItemType</b> field to query operations.
     *
     */
    public final static InspLotMatlDocItmSrlNmbrField<String> INSP_LOT_MATL_DOC_ITEM_TYPE =
        new InspLotMatlDocItmSrlNmbrField<String>("InspLotMatlDocItemType");

    @Nonnull
    @Override
    public Class<InspLotMatlDocItmSrlNmbr> getType()
    {
        return InspLotMatlDocItmSrlNmbr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItem</b>
     * </p>
     *
     * @param inspLotMatlDocItem
     *            Internal Counter for DB Objects
     */
    public void setInspLotMatlDocItem( @Nullable final String inspLotMatlDocItem )
    {
        rememberChangedField("InspLotMatlDocItem", this.inspLotMatlDocItem);
        this.inspLotMatlDocItem = inspLotMatlDocItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMatlDocItemType</b>
     * </p>
     *
     * @param inspLotMatlDocItemType
     *            Type of Reference Between Inspection Lot and Material Doc.
     */
    public void setInspLotMatlDocItemType( @Nullable final String inspLotMatlDocItemType )
    {
        rememberChangedField("InspLotMatlDocItemType", this.inspLotMatlDocItemType);
        this.inspLotMatlDocItemType = inspLotMatlDocItemType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspLotMatlDocItmSrlNmbr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspLotMatlDocItem", getInspLotMatlDocItem());
        result.put("Equipment", getEquipment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspLotMatlDocItem", getInspLotMatlDocItem());
        values.put("Equipment", getEquipment());
        values.put("SerialNumber", getSerialNumber());
        values.put("InspLotMatlDocItemType", getInspLotMatlDocItemType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspLotMatlDocItem") ) {
                final Object value = values.remove("InspLotMatlDocItem");
                if( (value == null) || (!value.equals(getInspLotMatlDocItem())) ) {
                    setInspLotMatlDocItem(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("InspLotMatlDocItemType") ) {
                final Object value = values.remove("InspLotMatlDocItemType");
                if( (value == null) || (!value.equals(getInspLotMatlDocItemType())) ) {
                    setInspLotMatlDocItemType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspLotMatlDocItmSrlNmbrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspLotMatlDocItmSrlNmbrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspLotMatlDocItmSrlNmbrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspLotMatlDocItmSrlNmbrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
