/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspLotSerialNumberSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
 * InspLotSerialNumber} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class InspLotSerialNumberByKeyFluentHelper
    extends
    FluentHelperByKey<InspLotSerialNumberByKeyFluentHelper, InspLotSerialNumber, InspLotSerialNumberSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
     * InspLotSerialNumber} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspLotSerialNumber}
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspLotSerialNumber}
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public InspLotSerialNumberByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inspectionLot,
        final String serialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("InspectionLot", inspectionLot);
        this.key.put("SerialNumber", serialNumber);
    }

    @Override
    @Nonnull
    protected Class<InspLotSerialNumber> getEntityClass()
    {
        return InspLotSerialNumber.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
