/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotUsageDecisionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspLotUsageDecisionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Usage Decisions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspLotUsageDecisionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspLotUsageDecision extends VdmEntity<InspLotUsageDecision>
{

    /**
     * Selector for all available fields of InspLotUsageDecision.
     *
     */
    public final static InspLotUsageDecisionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSPECTION_LOT =
        new InspLotUsageDecisionField<String>("InspectionLot");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionLevel</b>
     * </p>
     *
     * @return Inspection Lot, Partial Lot, Single Unit, Interval
     */
    @SerializedName( "InspLotUsageDecisionLevel" )
    @JsonProperty( "InspLotUsageDecisionLevel" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionLevel" )
    private String inspLotUsageDecisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionLevel</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USAGE_DECISION_LEVEL =
        new InspLotUsageDecisionField<String>("InspLotUsageDecisionLevel");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQualityScore</b>
     * </p>
     *
     * @return Quality Score
     */
    @SerializedName( "InspectionLotQualityScore" )
    @JsonProperty( "InspectionLotQualityScore" )
    @Nullable
    @ODataField( odataName = "InspectionLotQualityScore" )
    private BigDecimal inspectionLotQualityScore;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotQualityScore</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<BigDecimal> INSPECTION_LOT_QUALITY_SCORE =
        new InspLotUsageDecisionField<BigDecimal>("InspectionLotQualityScore");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionCatalog</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "InspLotUsageDecisionCatalog" )
    @JsonProperty( "InspLotUsageDecisionCatalog" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionCatalog" )
    private String inspLotUsageDecisionCatalog;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionCatalog</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USAGE_DECISION_CATALOG =
        new InspLotUsageDecisionField<String>("InspLotUsageDecisionCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> SELECTED_CODE_SET_PLANT =
        new InspLotUsageDecisionField<String>("SelectedCodeSetPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnSelectedSet</b>
     * </p>
     *
     * @return Selected Set of the Usage Decision
     */
    @SerializedName( "InspLotUsgeDcsnSelectedSet" )
    @JsonProperty( "InspLotUsgeDcsnSelectedSet" )
    @Nullable
    @ODataField( odataName = "InspLotUsgeDcsnSelectedSet" )
    private String inspLotUsgeDcsnSelectedSet;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsgeDcsnSelectedSet</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USGE_DCSN_SELECTED_SET =
        new InspLotUsageDecisionField<String>("InspLotUsgeDcsnSelectedSet");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionCodeGroup</b>
     * </p>
     *
     * @return Usage Decision Code Group
     */
    @SerializedName( "InspLotUsageDecisionCodeGroup" )
    @JsonProperty( "InspLotUsageDecisionCodeGroup" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionCodeGroup" )
    private String inspLotUsageDecisionCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionCodeGroup</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USAGE_DECISION_CODE_GROUP =
        new InspLotUsageDecisionField<String>("InspLotUsageDecisionCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecisionCode</b>
     * </p>
     *
     * @return Usage Decision Code
     */
    @SerializedName( "InspectionLotUsageDecisionCode" )
    @JsonProperty( "InspectionLotUsageDecisionCode" )
    @Nullable
    @ODataField( odataName = "InspectionLotUsageDecisionCode" )
    private String inspectionLotUsageDecisionCode;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotUsageDecisionCode</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSPECTION_LOT_USAGE_DECISION_CODE =
        new InspLotUsageDecisionField<String>("InspectionLotUsageDecisionCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnDynValuation</b>
     * </p>
     *
     * @return Dynamic Modif. Valuation According to Worst Case Principle
     */
    @SerializedName( "InspLotUsgeDcsnDynValuation" )
    @JsonProperty( "InspLotUsgeDcsnDynValuation" )
    @Nullable
    @ODataField( odataName = "InspLotUsgeDcsnDynValuation" )
    private String inspLotUsgeDcsnDynValuation;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsgeDcsnDynValuation</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USGE_DCSN_DYN_VALUATION =
        new InspLotUsageDecisionField<String>("InspLotUsgeDcsnDynValuation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionValuation</b>
     * </p>
     *
     * @return Code Valuation
     */
    @SerializedName( "InspLotUsageDecisionValuation" )
    @JsonProperty( "InspLotUsageDecisionValuation" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionValuation" )
    private String inspLotUsageDecisionValuation;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionValuation</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USAGE_DECISION_VALUATION =
        new InspLotUsageDecisionField<String>("InspLotUsageDecisionValuation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnFollowUpAction</b>
     * </p>
     *
     * @return Follow-Up Action
     */
    @SerializedName( "InspLotUsgeDcsnFollowUpAction" )
    @JsonProperty( "InspLotUsgeDcsnFollowUpAction" )
    @Nullable
    @ODataField( odataName = "InspLotUsgeDcsnFollowUpAction" )
    private String inspLotUsgeDcsnFollowUpAction;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsgeDcsnFollowUpAction</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USGE_DCSN_FOLLOW_UP_ACTION =
        new InspLotUsageDecisionField<String>("InspLotUsgeDcsnFollowUpAction");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecidedBy</b>
     * </p>
     *
     * @return Usage Decision Made By
     */
    @SerializedName( "InspectionLotUsageDecidedBy" )
    @JsonProperty( "InspectionLotUsageDecidedBy" )
    @Nullable
    @ODataField( odataName = "InspectionLotUsageDecidedBy" )
    private String inspectionLotUsageDecidedBy;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotUsageDecidedBy</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSPECTION_LOT_USAGE_DECIDED_BY =
        new InspLotUsageDecisionField<String>("InspectionLotUsageDecidedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecidedOn</b>
     * </p>
     *
     * @return Date When Usage Decision Was Made
     */
    @SerializedName( "InspectionLotUsageDecidedOn" )
    @JsonProperty( "InspectionLotUsageDecidedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotUsageDecidedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionLotUsageDecidedOn;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotUsageDecidedOn</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<LocalDateTime> INSPECTION_LOT_USAGE_DECIDED_ON =
        new InspLotUsageDecisionField<LocalDateTime>("InspectionLotUsageDecidedOn");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionTime</b>
     * </p>
     *
     * @return Time When Usage Decision Was Made
     */
    @SerializedName( "InspLotUsageDecisionTime" )
    @JsonProperty( "InspLotUsageDecisionTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspLotUsageDecisionTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspLotUsageDecisionTime;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionTime</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<LocalTime> INSP_LOT_USAGE_DECISION_TIME =
        new InspLotUsageDecisionField<LocalTime>("InspLotUsageDecisionTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionChangedBy</b>
     * </p>
     *
     * @return Usage Decision Changed By
     */
    @SerializedName( "InspLotUsageDecisionChangedBy" )
    @JsonProperty( "InspLotUsageDecisionChangedBy" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionChangedBy" )
    private String inspLotUsageDecisionChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionChangedBy</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<String> INSP_LOT_USAGE_DECISION_CHANGED_BY =
        new InspLotUsageDecisionField<String>("InspLotUsageDecisionChangedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionChangedOn</b>
     * </p>
     *
     * @return Date When Usage Decision Was Changed
     */
    @SerializedName( "InspLotUsageDecisionChangedOn" )
    @JsonProperty( "InspLotUsageDecisionChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspLotUsageDecisionChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspLotUsageDecisionChangedOn;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionChangedOn</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<LocalDateTime> INSP_LOT_USAGE_DECISION_CHANGED_ON =
        new InspLotUsageDecisionField<LocalDateTime>("InspLotUsageDecisionChangedOn");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnChangedTime</b>
     * </p>
     *
     * @return Time When Usage Decision Was Changed
     */
    @SerializedName( "InspLotUsgeDcsnChangedTime" )
    @JsonProperty( "InspLotUsgeDcsnChangedTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspLotUsgeDcsnChangedTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspLotUsgeDcsnChangedTime;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsgeDcsnChangedTime</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<LocalTime> INSP_LOT_USGE_DCSN_CHANGED_TIME =
        new InspLotUsageDecisionField<LocalTime>("InspLotUsgeDcsnChangedTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnHasLongText</b>
     * </p>
     *
     * @return Usage Decision Has Long Text
     */
    @SerializedName( "InspLotUsgeDcsnHasLongText" )
    @JsonProperty( "InspLotUsgeDcsnHasLongText" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotUsgeDcsnHasLongText" )
    private Boolean inspLotUsgeDcsnHasLongText;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsgeDcsnHasLongText</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<Boolean> INSP_LOT_USGE_DCSN_HAS_LONG_TEXT =
        new InspLotUsageDecisionField<Boolean>("InspLotUsgeDcsnHasLongText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspLotUsageDecisionField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspLotUsageDecisionField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspLotUsageDecision> getType()
    {
        return InspLotUsageDecision.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionLevel</b>
     * </p>
     *
     * @param inspLotUsageDecisionLevel
     *            Inspection Lot, Partial Lot, Single Unit, Interval
     */
    public void setInspLotUsageDecisionLevel( @Nullable final String inspLotUsageDecisionLevel )
    {
        rememberChangedField("InspLotUsageDecisionLevel", this.inspLotUsageDecisionLevel);
        this.inspLotUsageDecisionLevel = inspLotUsageDecisionLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQualityScore</b>
     * </p>
     *
     * @param inspectionLotQualityScore
     *            Quality Score
     */
    public void setInspectionLotQualityScore( @Nullable final BigDecimal inspectionLotQualityScore )
    {
        rememberChangedField("InspectionLotQualityScore", this.inspectionLotQualityScore);
        this.inspectionLotQualityScore = inspectionLotQualityScore;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionCatalog</b>
     * </p>
     *
     * @param inspLotUsageDecisionCatalog
     *            Catalog
     */
    public void setInspLotUsageDecisionCatalog( @Nullable final String inspLotUsageDecisionCatalog )
    {
        rememberChangedField("InspLotUsageDecisionCatalog", this.inspLotUsageDecisionCatalog);
        this.inspLotUsageDecisionCatalog = inspLotUsageDecisionCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnSelectedSet</b>
     * </p>
     *
     * @param inspLotUsgeDcsnSelectedSet
     *            Selected Set of the Usage Decision
     */
    public void setInspLotUsgeDcsnSelectedSet( @Nullable final String inspLotUsgeDcsnSelectedSet )
    {
        rememberChangedField("InspLotUsgeDcsnSelectedSet", this.inspLotUsgeDcsnSelectedSet);
        this.inspLotUsgeDcsnSelectedSet = inspLotUsgeDcsnSelectedSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionCodeGroup</b>
     * </p>
     *
     * @param inspLotUsageDecisionCodeGroup
     *            Usage Decision Code Group
     */
    public void setInspLotUsageDecisionCodeGroup( @Nullable final String inspLotUsageDecisionCodeGroup )
    {
        rememberChangedField("InspLotUsageDecisionCodeGroup", this.inspLotUsageDecisionCodeGroup);
        this.inspLotUsageDecisionCodeGroup = inspLotUsageDecisionCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecisionCode</b>
     * </p>
     *
     * @param inspectionLotUsageDecisionCode
     *            Usage Decision Code
     */
    public void setInspectionLotUsageDecisionCode( @Nullable final String inspectionLotUsageDecisionCode )
    {
        rememberChangedField("InspectionLotUsageDecisionCode", this.inspectionLotUsageDecisionCode);
        this.inspectionLotUsageDecisionCode = inspectionLotUsageDecisionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnDynValuation</b>
     * </p>
     *
     * @param inspLotUsgeDcsnDynValuation
     *            Dynamic Modif. Valuation According to Worst Case Principle
     */
    public void setInspLotUsgeDcsnDynValuation( @Nullable final String inspLotUsgeDcsnDynValuation )
    {
        rememberChangedField("InspLotUsgeDcsnDynValuation", this.inspLotUsgeDcsnDynValuation);
        this.inspLotUsgeDcsnDynValuation = inspLotUsgeDcsnDynValuation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionValuation</b>
     * </p>
     *
     * @param inspLotUsageDecisionValuation
     *            Code Valuation
     */
    public void setInspLotUsageDecisionValuation( @Nullable final String inspLotUsageDecisionValuation )
    {
        rememberChangedField("InspLotUsageDecisionValuation", this.inspLotUsageDecisionValuation);
        this.inspLotUsageDecisionValuation = inspLotUsageDecisionValuation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnFollowUpAction</b>
     * </p>
     *
     * @param inspLotUsgeDcsnFollowUpAction
     *            Follow-Up Action
     */
    public void setInspLotUsgeDcsnFollowUpAction( @Nullable final String inspLotUsgeDcsnFollowUpAction )
    {
        rememberChangedField("InspLotUsgeDcsnFollowUpAction", this.inspLotUsgeDcsnFollowUpAction);
        this.inspLotUsgeDcsnFollowUpAction = inspLotUsgeDcsnFollowUpAction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecidedBy</b>
     * </p>
     *
     * @param inspectionLotUsageDecidedBy
     *            Usage Decision Made By
     */
    public void setInspectionLotUsageDecidedBy( @Nullable final String inspectionLotUsageDecidedBy )
    {
        rememberChangedField("InspectionLotUsageDecidedBy", this.inspectionLotUsageDecidedBy);
        this.inspectionLotUsageDecidedBy = inspectionLotUsageDecidedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotUsageDecidedOn</b>
     * </p>
     *
     * @param inspectionLotUsageDecidedOn
     *            Date When Usage Decision Was Made
     */
    public void setInspectionLotUsageDecidedOn( @Nullable final LocalDateTime inspectionLotUsageDecidedOn )
    {
        rememberChangedField("InspectionLotUsageDecidedOn", this.inspectionLotUsageDecidedOn);
        this.inspectionLotUsageDecidedOn = inspectionLotUsageDecidedOn;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionTime</b>
     * </p>
     *
     * @param inspLotUsageDecisionTime
     *            Time When Usage Decision Was Made
     */
    public void setInspLotUsageDecisionTime( @Nullable final LocalTime inspLotUsageDecisionTime )
    {
        rememberChangedField("InspLotUsageDecisionTime", this.inspLotUsageDecisionTime);
        this.inspLotUsageDecisionTime = inspLotUsageDecisionTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionChangedBy</b>
     * </p>
     *
     * @param inspLotUsageDecisionChangedBy
     *            Usage Decision Changed By
     */
    public void setInspLotUsageDecisionChangedBy( @Nullable final String inspLotUsageDecisionChangedBy )
    {
        rememberChangedField("InspLotUsageDecisionChangedBy", this.inspLotUsageDecisionChangedBy);
        this.inspLotUsageDecisionChangedBy = inspLotUsageDecisionChangedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionChangedOn</b>
     * </p>
     *
     * @param inspLotUsageDecisionChangedOn
     *            Date When Usage Decision Was Changed
     */
    public void setInspLotUsageDecisionChangedOn( @Nullable final LocalDateTime inspLotUsageDecisionChangedOn )
    {
        rememberChangedField("InspLotUsageDecisionChangedOn", this.inspLotUsageDecisionChangedOn);
        this.inspLotUsageDecisionChangedOn = inspLotUsageDecisionChangedOn;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnChangedTime</b>
     * </p>
     *
     * @param inspLotUsgeDcsnChangedTime
     *            Time When Usage Decision Was Changed
     */
    public void setInspLotUsgeDcsnChangedTime( @Nullable final LocalTime inspLotUsgeDcsnChangedTime )
    {
        rememberChangedField("InspLotUsgeDcsnChangedTime", this.inspLotUsgeDcsnChangedTime);
        this.inspLotUsgeDcsnChangedTime = inspLotUsgeDcsnChangedTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsgeDcsnHasLongText</b>
     * </p>
     *
     * @param inspLotUsgeDcsnHasLongText
     *            Usage Decision Has Long Text
     */
    public void setInspLotUsgeDcsnHasLongText( @Nullable final Boolean inspLotUsgeDcsnHasLongText )
    {
        rememberChangedField("InspLotUsgeDcsnHasLongText", this.inspLotUsgeDcsnHasLongText);
        this.inspLotUsgeDcsnHasLongText = inspLotUsgeDcsnHasLongText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspLotUsageDecision";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspLotUsageDecisionLevel", getInspLotUsageDecisionLevel());
        values.put("InspectionLotQualityScore", getInspectionLotQualityScore());
        values.put("InspLotUsageDecisionCatalog", getInspLotUsageDecisionCatalog());
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("InspLotUsgeDcsnSelectedSet", getInspLotUsgeDcsnSelectedSet());
        values.put("InspLotUsageDecisionCodeGroup", getInspLotUsageDecisionCodeGroup());
        values.put("InspectionLotUsageDecisionCode", getInspectionLotUsageDecisionCode());
        values.put("InspLotUsgeDcsnDynValuation", getInspLotUsgeDcsnDynValuation());
        values.put("InspLotUsageDecisionValuation", getInspLotUsageDecisionValuation());
        values.put("InspLotUsgeDcsnFollowUpAction", getInspLotUsgeDcsnFollowUpAction());
        values.put("InspectionLotUsageDecidedBy", getInspectionLotUsageDecidedBy());
        values.put("InspectionLotUsageDecidedOn", getInspectionLotUsageDecidedOn());
        values.put("InspLotUsageDecisionTime", getInspLotUsageDecisionTime());
        values.put("InspLotUsageDecisionChangedBy", getInspLotUsageDecisionChangedBy());
        values.put("InspLotUsageDecisionChangedOn", getInspLotUsageDecisionChangedOn());
        values.put("InspLotUsgeDcsnChangedTime", getInspLotUsgeDcsnChangedTime());
        values.put("InspLotUsgeDcsnHasLongText", getInspLotUsgeDcsnHasLongText());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionLevel") ) {
                final Object value = values.remove("InspLotUsageDecisionLevel");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionLevel())) ) {
                    setInspLotUsageDecisionLevel(((String) value));
                }
            }
            if( values.containsKey("InspectionLotQualityScore") ) {
                final Object value = values.remove("InspectionLotQualityScore");
                if( (value == null) || (!value.equals(getInspectionLotQualityScore())) ) {
                    setInspectionLotQualityScore(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionCatalog") ) {
                final Object value = values.remove("InspLotUsageDecisionCatalog");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionCatalog())) ) {
                    setInspLotUsageDecisionCatalog(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("InspLotUsgeDcsnSelectedSet") ) {
                final Object value = values.remove("InspLotUsgeDcsnSelectedSet");
                if( (value == null) || (!value.equals(getInspLotUsgeDcsnSelectedSet())) ) {
                    setInspLotUsgeDcsnSelectedSet(((String) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionCodeGroup") ) {
                final Object value = values.remove("InspLotUsageDecisionCodeGroup");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionCodeGroup())) ) {
                    setInspLotUsageDecisionCodeGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionLotUsageDecisionCode") ) {
                final Object value = values.remove("InspectionLotUsageDecisionCode");
                if( (value == null) || (!value.equals(getInspectionLotUsageDecisionCode())) ) {
                    setInspectionLotUsageDecisionCode(((String) value));
                }
            }
            if( values.containsKey("InspLotUsgeDcsnDynValuation") ) {
                final Object value = values.remove("InspLotUsgeDcsnDynValuation");
                if( (value == null) || (!value.equals(getInspLotUsgeDcsnDynValuation())) ) {
                    setInspLotUsgeDcsnDynValuation(((String) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionValuation") ) {
                final Object value = values.remove("InspLotUsageDecisionValuation");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionValuation())) ) {
                    setInspLotUsageDecisionValuation(((String) value));
                }
            }
            if( values.containsKey("InspLotUsgeDcsnFollowUpAction") ) {
                final Object value = values.remove("InspLotUsgeDcsnFollowUpAction");
                if( (value == null) || (!value.equals(getInspLotUsgeDcsnFollowUpAction())) ) {
                    setInspLotUsgeDcsnFollowUpAction(((String) value));
                }
            }
            if( values.containsKey("InspectionLotUsageDecidedBy") ) {
                final Object value = values.remove("InspectionLotUsageDecidedBy");
                if( (value == null) || (!value.equals(getInspectionLotUsageDecidedBy())) ) {
                    setInspectionLotUsageDecidedBy(((String) value));
                }
            }
            if( values.containsKey("InspectionLotUsageDecidedOn") ) {
                final Object value = values.remove("InspectionLotUsageDecidedOn");
                if( (value == null) || (!value.equals(getInspectionLotUsageDecidedOn())) ) {
                    setInspectionLotUsageDecidedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionTime") ) {
                final Object value = values.remove("InspLotUsageDecisionTime");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionTime())) ) {
                    setInspLotUsageDecisionTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionChangedBy") ) {
                final Object value = values.remove("InspLotUsageDecisionChangedBy");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionChangedBy())) ) {
                    setInspLotUsageDecisionChangedBy(((String) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionChangedOn") ) {
                final Object value = values.remove("InspLotUsageDecisionChangedOn");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionChangedOn())) ) {
                    setInspLotUsageDecisionChangedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspLotUsgeDcsnChangedTime") ) {
                final Object value = values.remove("InspLotUsgeDcsnChangedTime");
                if( (value == null) || (!value.equals(getInspLotUsgeDcsnChangedTime())) ) {
                    setInspLotUsgeDcsnChangedTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspLotUsgeDcsnHasLongText") ) {
                final Object value = values.remove("InspLotUsgeDcsnHasLongText");
                if( (value == null) || (!value.equals(getInspLotUsgeDcsnHasLongText())) ) {
                    setInspLotUsgeDcsnHasLongText(((Boolean) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspLotUsageDecisionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspLotUsageDecisionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspLotUsageDecisionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspLotUsageDecisionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
