/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspSampleCharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspSampleCharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Characteristics of Inspection Points
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspSampleCharacteristicType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspSampleCharacteristic extends VdmEntity<InspSampleCharacteristic>
{

    /**
     * Selector for all available fields of InspSampleCharacteristic.
     *
     */
    public final static InspSampleCharacteristicSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSPECTION_LOT =
        new InspSampleCharacteristicField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspSampleCharacteristicField<String>("InspPlanOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "InspectionCharacteristic" )
    @JsonProperty( "InspectionCharacteristic" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristic" )
    private String inspectionCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristic</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSPECTION_CHARACTERISTIC =
        new InspSampleCharacteristicField<String>("InspectionCharacteristic");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @return Inspection Sample Number
     */
    @Key
    @SerializedName( "InspectionSubsetInternalID" )
    @JsonProperty( "InspectionSubsetInternalID" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetInternalID" )
    private String inspectionSubsetInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetInternalID</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSPECTION_SUBSET_INTERNAL_ID =
        new InspSampleCharacteristicField<String>("InspectionSubsetInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristicStatus</b>
     * </p>
     *
     * @return Specification Record Status
     */
    @SerializedName( "InspectionCharacteristicStatus" )
    @JsonProperty( "InspectionCharacteristicStatus" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristicStatus" )
    private String inspectionCharacteristicStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristicStatus</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSPECTION_CHARACTERISTIC_STATUS =
        new InspSampleCharacteristicField<String>("InspectionCharacteristicStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>QualityControlChart</b>
     * </p>
     *
     * @return Control Chart Number
     */
    @SerializedName( "QualityControlChart" )
    @JsonProperty( "QualityControlChart" )
    @Nullable
    @ODataField( odataName = "QualityControlChart" )
    private String qualityControlChart;
    /**
     * Use with available fluent helpers to apply the <b>QualityControlChart</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> QUALITY_CONTROL_CHART =
        new InspSampleCharacteristicField<String>("QualityControlChart");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleAcceptanceNumber</b>
     * </p>
     *
     * @return Acceptance Number
     */
    @SerializedName( "InspSampleAcceptanceNumber" )
    @JsonProperty( "InspSampleAcceptanceNumber" )
    @Nullable
    @ODataField( odataName = "InspSampleAcceptanceNumber" )
    private Short inspSampleAcceptanceNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspSampleAcceptanceNumber</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<Short> INSP_SAMPLE_ACCEPTANCE_NUMBER =
        new InspSampleCharacteristicField<Short>("InspSampleAcceptanceNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleRejectionNumber</b>
     * </p>
     *
     * @return Rejection Number
     */
    @SerializedName( "InspSampleRejectionNumber" )
    @JsonProperty( "InspSampleRejectionNumber" )
    @Nullable
    @ODataField( odataName = "InspSampleRejectionNumber" )
    private Short inspSampleRejectionNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspSampleRejectionNumber</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<Short> INSP_SAMPLE_REJECTION_NUMBER =
        new InspSampleCharacteristicField<Short>("InspSampleRejectionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleValuationRule</b>
     * </p>
     *
     * @return Valuation Rule
     */
    @SerializedName( "InspSampleValuationRule" )
    @JsonProperty( "InspSampleValuationRule" )
    @Nullable
    @ODataField( odataName = "InspSampleValuationRule" )
    private String inspSampleValuationRule;
    /**
     * Use with available fluent helpers to apply the <b>InspSampleValuationRule</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSP_SAMPLE_VALUATION_RULE =
        new InspSampleCharacteristicField<String>("InspSampleValuationRule");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSampleSize</b>
     * </p>
     *
     * @return Sample Size that Must Be Inspected
     */
    @SerializedName( "InspectionSampleSize" )
    @JsonProperty( "InspectionSampleSize" )
    @Nullable
    @ODataField( odataName = "InspectionSampleSize" )
    private Integer inspectionSampleSize;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSampleSize</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<Integer> INSPECTION_SAMPLE_SIZE =
        new InspSampleCharacteristicField<Integer>("InspectionSampleSize");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynRuleStage</b>
     * </p>
     *
     * @return Inspection Stage
     */
    @SerializedName( "InspLotDynRuleStage" )
    @JsonProperty( "InspLotDynRuleStage" )
    @Nullable
    @ODataField( odataName = "InspLotDynRuleStage" )
    private String inspLotDynRuleStage;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDynRuleStage</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSP_LOT_DYN_RULE_STAGE =
        new InspSampleCharacteristicField<String>("InspLotDynRuleStage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSeverity</b>
     * </p>
     *
     * @return Inspection Severity
     */
    @SerializedName( "InspectionSeverity" )
    @JsonProperty( "InspectionSeverity" )
    @Nullable
    @ODataField( odataName = "InspectionSeverity" )
    private String inspectionSeverity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSeverity</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<String> INSPECTION_SEVERITY =
        new InspSampleCharacteristicField<String>("InspectionSeverity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetCharcCreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "InspSubsetCharcCreationDate" )
    @JsonProperty( "InspSubsetCharcCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspSubsetCharcCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspSubsetCharcCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetCharcCreationDate</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<LocalDateTime> INSP_SUBSET_CHARC_CREATION_DATE =
        new InspSampleCharacteristicField<LocalDateTime>("InspSubsetCharcCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspSampleCharacteristicField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspSampleCharacteristicField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspSampleCharacteristic> getType()
    {
        return InspSampleCharacteristic.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     */
    public void setInspectionCharacteristic( @Nullable final String inspectionCharacteristic )
    {
        rememberChangedField("InspectionCharacteristic", this.inspectionCharacteristic);
        this.inspectionCharacteristic = inspectionCharacteristic;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @param inspectionSubsetInternalID
     *            Inspection Sample Number
     */
    public void setInspectionSubsetInternalID( @Nullable final String inspectionSubsetInternalID )
    {
        rememberChangedField("InspectionSubsetInternalID", this.inspectionSubsetInternalID);
        this.inspectionSubsetInternalID = inspectionSubsetInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristicStatus</b>
     * </p>
     *
     * @param inspectionCharacteristicStatus
     *            Specification Record Status
     */
    public void setInspectionCharacteristicStatus( @Nullable final String inspectionCharacteristicStatus )
    {
        rememberChangedField("InspectionCharacteristicStatus", this.inspectionCharacteristicStatus);
        this.inspectionCharacteristicStatus = inspectionCharacteristicStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>QualityControlChart</b>
     * </p>
     *
     * @param qualityControlChart
     *            Control Chart Number
     */
    public void setQualityControlChart( @Nullable final String qualityControlChart )
    {
        rememberChangedField("QualityControlChart", this.qualityControlChart);
        this.qualityControlChart = qualityControlChart;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleAcceptanceNumber</b>
     * </p>
     *
     * @param inspSampleAcceptanceNumber
     *            Acceptance Number
     */
    public void setInspSampleAcceptanceNumber( @Nullable final Short inspSampleAcceptanceNumber )
    {
        rememberChangedField("InspSampleAcceptanceNumber", this.inspSampleAcceptanceNumber);
        this.inspSampleAcceptanceNumber = inspSampleAcceptanceNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleRejectionNumber</b>
     * </p>
     *
     * @param inspSampleRejectionNumber
     *            Rejection Number
     */
    public void setInspSampleRejectionNumber( @Nullable final Short inspSampleRejectionNumber )
    {
        rememberChangedField("InspSampleRejectionNumber", this.inspSampleRejectionNumber);
        this.inspSampleRejectionNumber = inspSampleRejectionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleValuationRule</b>
     * </p>
     *
     * @param inspSampleValuationRule
     *            Valuation Rule
     */
    public void setInspSampleValuationRule( @Nullable final String inspSampleValuationRule )
    {
        rememberChangedField("InspSampleValuationRule", this.inspSampleValuationRule);
        this.inspSampleValuationRule = inspSampleValuationRule;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSampleSize</b>
     * </p>
     *
     * @param inspectionSampleSize
     *            Sample Size that Must Be Inspected
     */
    public void setInspectionSampleSize( @Nullable final Integer inspectionSampleSize )
    {
        rememberChangedField("InspectionSampleSize", this.inspectionSampleSize);
        this.inspectionSampleSize = inspectionSampleSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynRuleStage</b>
     * </p>
     *
     * @param inspLotDynRuleStage
     *            Inspection Stage
     */
    public void setInspLotDynRuleStage( @Nullable final String inspLotDynRuleStage )
    {
        rememberChangedField("InspLotDynRuleStage", this.inspLotDynRuleStage);
        this.inspLotDynRuleStage = inspLotDynRuleStage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSeverity</b>
     * </p>
     *
     * @param inspectionSeverity
     *            Inspection Severity
     */
    public void setInspectionSeverity( @Nullable final String inspectionSeverity )
    {
        rememberChangedField("InspectionSeverity", this.inspectionSeverity);
        this.inspectionSeverity = inspectionSeverity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetCharcCreationDate</b>
     * </p>
     *
     * @param inspSubsetCharcCreationDate
     *            System Date on Which Data Record Was Created
     */
    public void setInspSubsetCharcCreationDate( @Nullable final LocalDateTime inspSubsetCharcCreationDate )
    {
        rememberChangedField("InspSubsetCharcCreationDate", this.inspSubsetCharcCreationDate);
        this.inspSubsetCharcCreationDate = inspSubsetCharcCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspSampleCharacteristic";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        result.put("InspectionCharacteristic", getInspectionCharacteristic());
        result.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionCharacteristic", getInspectionCharacteristic());
        values.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        values.put("InspectionCharacteristicStatus", getInspectionCharacteristicStatus());
        values.put("QualityControlChart", getQualityControlChart());
        values.put("InspSampleAcceptanceNumber", getInspSampleAcceptanceNumber());
        values.put("InspSampleRejectionNumber", getInspSampleRejectionNumber());
        values.put("InspSampleValuationRule", getInspSampleValuationRule());
        values.put("InspectionSampleSize", getInspectionSampleSize());
        values.put("InspLotDynRuleStage", getInspLotDynRuleStage());
        values.put("InspectionSeverity", getInspectionSeverity());
        values.put("InspSubsetCharcCreationDate", getInspSubsetCharcCreationDate());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristic") ) {
                final Object value = values.remove("InspectionCharacteristic");
                if( (value == null) || (!value.equals(getInspectionCharacteristic())) ) {
                    setInspectionCharacteristic(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetInternalID") ) {
                final Object value = values.remove("InspectionSubsetInternalID");
                if( (value == null) || (!value.equals(getInspectionSubsetInternalID())) ) {
                    setInspectionSubsetInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristicStatus") ) {
                final Object value = values.remove("InspectionCharacteristicStatus");
                if( (value == null) || (!value.equals(getInspectionCharacteristicStatus())) ) {
                    setInspectionCharacteristicStatus(((String) value));
                }
            }
            if( values.containsKey("QualityControlChart") ) {
                final Object value = values.remove("QualityControlChart");
                if( (value == null) || (!value.equals(getQualityControlChart())) ) {
                    setQualityControlChart(((String) value));
                }
            }
            if( values.containsKey("InspSampleAcceptanceNumber") ) {
                final Object value = values.remove("InspSampleAcceptanceNumber");
                if( (value == null) || (!value.equals(getInspSampleAcceptanceNumber())) ) {
                    setInspSampleAcceptanceNumber(((Short) value));
                }
            }
            if( values.containsKey("InspSampleRejectionNumber") ) {
                final Object value = values.remove("InspSampleRejectionNumber");
                if( (value == null) || (!value.equals(getInspSampleRejectionNumber())) ) {
                    setInspSampleRejectionNumber(((Short) value));
                }
            }
            if( values.containsKey("InspSampleValuationRule") ) {
                final Object value = values.remove("InspSampleValuationRule");
                if( (value == null) || (!value.equals(getInspSampleValuationRule())) ) {
                    setInspSampleValuationRule(((String) value));
                }
            }
            if( values.containsKey("InspectionSampleSize") ) {
                final Object value = values.remove("InspectionSampleSize");
                if( (value == null) || (!value.equals(getInspectionSampleSize())) ) {
                    setInspectionSampleSize(((Integer) value));
                }
            }
            if( values.containsKey("InspLotDynRuleStage") ) {
                final Object value = values.remove("InspLotDynRuleStage");
                if( (value == null) || (!value.equals(getInspLotDynRuleStage())) ) {
                    setInspLotDynRuleStage(((String) value));
                }
            }
            if( values.containsKey("InspectionSeverity") ) {
                final Object value = values.remove("InspectionSeverity");
                if( (value == null) || (!value.equals(getInspectionSeverity())) ) {
                    setInspectionSeverity(((String) value));
                }
            }
            if( values.containsKey("InspSubsetCharcCreationDate") ) {
                final Object value = values.remove("InspSubsetCharcCreationDate");
                if( (value == null) || (!value.equals(getInspSubsetCharcCreationDate())) ) {
                    setInspSubsetCharcCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspSampleCharacteristicField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspSampleCharacteristicField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspSampleCharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspSampleCharacteristicField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
