/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionCharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionCharacteristicLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionCharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Inspection Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionCharacteristicType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionCharacteristic extends VdmEntity<InspectionCharacteristic>
{

    /**
     * Selector for all available fields of InspectionCharacteristic.
     *
     */
    public final static InspectionCharacteristicSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_LOT =
        new InspectionCharacteristicField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspectionCharacteristicField<String>("InspPlanOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "InspectionCharacteristic" )
    @JsonProperty( "InspectionCharacteristic" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristic" )
    private String inspectionCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristic</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_CHARACTERISTIC =
        new InspectionCharacteristicField<String>("InspectionCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @return Short Text for Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationText" )
    @JsonProperty( "InspectionSpecificationText" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationText" )
    private String inspectionSpecificationText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationText</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_SPECIFICATION_TEXT =
        new InspectionCharacteristicField<String>("InspectionSpecificationText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasInspCharcPrtlSmpl</b>
     * </p>
     *
     * @return Partial Samples Possible
     */
    @SerializedName( "HasInspCharcPrtlSmpl" )
    @JsonProperty( "HasInspCharcPrtlSmpl" )
    @Nullable
    @ODataField( odataName = "HasInspCharcPrtlSmpl" )
    private String hasInspCharcPrtlSmpl;
    /**
     * Use with available fluent helpers to apply the <b>HasInspCharcPrtlSmpl</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> HAS_INSP_CHARC_PRTL_SMPL =
        new InspectionCharacteristicField<String>("HasInspCharcPrtlSmpl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @return Is Quantitative Characteristic
     */
    @SerializedName( "InspSpecIsQuantitative" )
    @JsonProperty( "InspSpecIsQuantitative" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspSpecIsQuantitative" )
    private Boolean inspSpecIsQuantitative;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsQuantitative</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Boolean> INSP_SPEC_IS_QUANTITATIVE =
        new InspectionCharacteristicField<Boolean>("InspSpecIsQuantitative");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @return Measured Values Must Be Recorded
     */
    @SerializedName( "InspSpecIsMeasuredValueRqd" )
    @JsonProperty( "InspSpecIsMeasuredValueRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsMeasuredValueRqd" )
    private String inspSpecIsMeasuredValueRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsMeasuredValueRqd</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_IS_MEASURED_VALUE_RQD =
        new InspectionCharacteristicField<String>("InspSpecIsMeasuredValueRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @return Reference to Characteristic Attribute Required
     */
    @SerializedName( "InspSpecIsSelectedSetRequired" )
    @JsonProperty( "InspSpecIsSelectedSetRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSelectedSetRequired" )
    private String inspSpecIsSelectedSetRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSelectedSetRequired</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_IS_SELECTED_SET_REQUIRED =
        new InspectionCharacteristicField<String>("InspSpecIsSelectedSetRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @return Long-Term Inspection
     */
    @SerializedName( "InspSpecIsLongTermInspection" )
    @JsonProperty( "InspSpecIsLongTermInspection" )
    @Nullable
    @ODataField( odataName = "InspSpecIsLongTermInspection" )
    private String inspSpecIsLongTermInspection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsLongTermInspection</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_IS_LONG_TERM_INSPECTION =
        new InspectionCharacteristicField<String>("InspSpecIsLongTermInspection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @return Recording Type
     */
    @SerializedName( "InspSpecRecordingType" )
    @JsonProperty( "InspSpecRecordingType" )
    @Nullable
    @ODataField( odataName = "InspSpecRecordingType" )
    private String inspSpecRecordingType;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecRecordingType</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_RECORDING_TYPE =
        new InspectionCharacteristicField<String>("InspSpecRecordingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @return Documentation Required for Inspection Results
     */
    @SerializedName( "InspResultIsDocumentationRqd" )
    @JsonProperty( "InspResultIsDocumentationRqd" )
    @Nullable
    @ODataField( odataName = "InspResultIsDocumentationRqd" )
    private String inspResultIsDocumentationRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspResultIsDocumentationRqd</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_RESULT_IS_DOCUMENTATION_RQD =
        new InspectionCharacteristicField<String>("InspResultIsDocumentationRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @return Characteristic Category
     */
    @SerializedName( "InspSpecCharcCategory" )
    @JsonProperty( "InspSpecCharcCategory" )
    @Nullable
    @ODataField( odataName = "InspSpecCharcCategory" )
    private String inspSpecCharcCategory;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCharcCategory</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_CHARC_CATEGORY =
        new InspectionCharacteristicField<String>("InspSpecCharcCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @return Calculated Characteristic
     */
    @SerializedName( "InspSpecResultCalculation" )
    @JsonProperty( "InspSpecResultCalculation" )
    @Nullable
    @ODataField( odataName = "InspSpecResultCalculation" )
    private String inspSpecResultCalculation;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecResultCalculation</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_RESULT_CALCULATION =
        new InspectionCharacteristicField<String>("InspSpecResultCalculation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcIsNotPlanned</b>
     * </p>
     *
     * @return Unplanned Characteristic
     */
    @SerializedName( "InspCharcIsNotPlanned" )
    @JsonProperty( "InspCharcIsNotPlanned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspCharcIsNotPlanned" )
    private Boolean inspCharcIsNotPlanned;
    /**
     * Use with available fluent helpers to apply the <b>InspCharcIsNotPlanned</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Boolean> INSP_CHARC_IS_NOT_PLANNED =
        new InspectionCharacteristicField<Boolean>("InspCharcIsNotPlanned");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @return Inspection Method
     */
    @SerializedName( "InspectionMethod" )
    @JsonProperty( "InspectionMethod" )
    @Nullable
    @ODataField( odataName = "InspectionMethod" )
    private String inspectionMethod;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethod</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_METHOD =
        new InspectionCharacteristicField<String>("InspectionMethod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @return Plant for Inspection Method
     */
    @SerializedName( "InspectionMethodPlant" )
    @JsonProperty( "InspectionMethodPlant" )
    @Nullable
    @ODataField( odataName = "InspectionMethodPlant" )
    private String inspectionMethodPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodPlant</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_METHOD_PLANT =
        new InspectionCharacteristicField<String>("InspectionMethodPlant");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @return Version Number of Inspection Method
     */
    @SerializedName( "InspectionMethodVersion" )
    @JsonProperty( "InspectionMethodVersion" )
    @Nullable
    @ODataField( odataName = "InspectionMethodVersion" )
    private String inspectionMethodVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodVersion</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_METHOD_VERSION =
        new InspectionCharacteristicField<String>("InspectionMethodVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @return Plant for Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationPlant" )
    @JsonProperty( "InspectionSpecificationPlant" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationPlant" )
    private String inspectionSpecificationPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationPlant</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_SPECIFICATION_PLANT =
        new InspectionCharacteristicField<String>("InspectionSpecificationPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @return Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecification" )
    @JsonProperty( "InspectionSpecification" )
    @Nullable
    @ODataField( odataName = "InspectionSpecification" )
    private String inspectionSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecification</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_SPECIFICATION =
        new InspectionCharacteristicField<String>("InspectionSpecification");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @return Version Number of Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationVersion" )
    @JsonProperty( "InspectionSpecificationVersion" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationVersion" )
    private String inspectionSpecificationVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationVersion</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_SPECIFICATION_VERSION =
        new InspectionCharacteristicField<String>("InspectionSpecificationVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristicStatus</b>
     * </p>
     *
     * @return Specification Record Status
     */
    @SerializedName( "InspectionCharacteristicStatus" )
    @JsonProperty( "InspectionCharacteristicStatus" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristicStatus" )
    private String inspectionCharacteristicStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristicStatus</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_CHARACTERISTIC_STATUS =
        new InspectionCharacteristicField<String>("InspectionCharacteristicStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @return Number of Places to the Right of a Decimal Point (Accuracy)
     */
    @SerializedName( "InspSpecDecimalPlaces" )
    @JsonProperty( "InspSpecDecimalPlaces" )
    @Nullable
    @ODataField( odataName = "InspSpecDecimalPlaces" )
    private Short inspSpecDecimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDecimalPlaces</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Short> INSP_SPEC_DECIMAL_PLACES =
        new InspectionCharacteristicField<Short>("InspSpecDecimalPlaces");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @return Unit of Measurement in Which Quantitative Data Is Stored
     */
    @SerializedName( "InspectionSpecificationUnit" )
    @JsonProperty( "InspectionSpecificationUnit" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationUnit" )
    private String inspectionSpecificationUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationUnit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTION_SPECIFICATION_UNIT =
        new InspectionCharacteristicField<String>("InspectionSpecificationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleValuationRule</b>
     * </p>
     *
     * @return Valuation Rule
     */
    @SerializedName( "InspSampleValuationRule" )
    @JsonProperty( "InspSampleValuationRule" )
    @Nullable
    @ODataField( odataName = "InspSampleValuationRule" )
    private String inspSampleValuationRule;
    /**
     * Use with available fluent helpers to apply the <b>InspSampleValuationRule</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SAMPLE_VALUATION_RULE =
        new InspectionCharacteristicField<String>("InspSampleValuationRule");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Sample Unit of Measure
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> QUANTITY_UNIT =
        new InspectionCharacteristicField<String>("QuantityUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleSize</b>
     * </p>
     *
     * @return Sample Size that Has to Be Inspected for a Characteristic
     */
    @SerializedName( "InspCharacteristicSampleSize" )
    @JsonProperty( "InspCharacteristicSampleSize" )
    @Nullable
    @ODataField( odataName = "InspCharacteristicSampleSize" )
    private Integer inspCharacteristicSampleSize;
    /**
     * Use with available fluent helpers to apply the <b>InspCharacteristicSampleSize</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Integer> INSP_CHARACTERISTIC_SAMPLE_SIZE =
        new InspectionCharacteristicField<Integer>("InspCharacteristicSampleSize");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleUnit</b>
     * </p>
     *
     * @return Sample Unit of Measure
     */
    @SerializedName( "InspCharacteristicSampleUnit" )
    @JsonProperty( "InspCharacteristicSampleUnit" )
    @Nullable
    @ODataField( odataName = "InspCharacteristicSampleUnit" )
    private String inspCharacteristicSampleUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspCharacteristicSampleUnit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_CHARACTERISTIC_SAMPLE_UNIT =
        new InspectionCharacteristicField<String>("InspCharacteristicSampleUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSampleQuantityFactor</b>
     * </p>
     *
     * @return Sample Quantity Factor for Sample(Mult. Sample Unit of Msr.)
     */
    @SerializedName( "InspSpecSampleQuantityFactor" )
    @JsonProperty( "InspSpecSampleQuantityFactor" )
    @Nullable
    @ODataField( odataName = "InspSpecSampleQuantityFactor" )
    private BigDecimal inspSpecSampleQuantityFactor;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecSampleQuantityFactor</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<BigDecimal> INSP_SPEC_SAMPLE_QUANTITY_FACTOR =
        new InspectionCharacteristicField<BigDecimal>("InspSpecSampleQuantityFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @return Target Value for a Quantitative Characteristic
     */
    @SerializedName( "InspSpecTargetValue" )
    @JsonProperty( "InspSpecTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecTargetValue" )
    private Double inspSpecTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecTargetValue</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Double> INSP_SPEC_TARGET_VALUE =
        new InspectionCharacteristicField<Double>("InspSpecTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdTargetValue</b>
     * </p>
     *
     * @return Target Value for Quantitative Characteristic (Formatted)
     */
    @SerializedName( "InspSpecFrmtdTargetValue" )
    @JsonProperty( "InspSpecFrmtdTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecFrmtdTargetValue" )
    private String inspSpecFrmtdTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFrmtdTargetValue</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_FRMTD_TARGET_VALUE =
        new InspectionCharacteristicField<String>("InspSpecFrmtdTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasTargetValue" )
    @JsonProperty( "InspSpecHasTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecHasTargetValue" )
    private String inspSpecHasTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasTargetValue</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_HAS_TARGET_VALUE =
        new InspectionCharacteristicField<String>("InspSpecHasTargetValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecUpperLimit" )
    @JsonProperty( "InspSpecUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperLimit" )
    private Double inspSpecUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Double> INSP_SPEC_UPPER_LIMIT =
        new InspectionCharacteristicField<Double>("InspSpecUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdUpperLimit</b>
     * </p>
     *
     * @return Upper Specification Limit (Formatted)
     */
    @SerializedName( "InspSpecFrmtdUpperLimit" )
    @JsonProperty( "InspSpecFrmtdUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFrmtdUpperLimit" )
    private String inspSpecFrmtdUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFrmtdUpperLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_FRMTD_UPPER_LIMIT =
        new InspectionCharacteristicField<String>("InspSpecFrmtdUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUpperLimit" )
    @JsonProperty( "InspSpecHasUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUpperLimit" )
    private String inspSpecHasUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUpperLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_HAS_UPPER_LIMIT =
        new InspectionCharacteristicField<String>("InspSpecHasUpperLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecLowerLimit" )
    @JsonProperty( "InspSpecLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerLimit" )
    private Double inspSpecLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<Double> INSP_SPEC_LOWER_LIMIT =
        new InspectionCharacteristicField<Double>("InspSpecLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdLowerLimit</b>
     * </p>
     *
     * @return Lower Specification Limit (Formatted)
     */
    @SerializedName( "InspSpecFrmtdLowerLimit" )
    @JsonProperty( "InspSpecFrmtdLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFrmtdLowerLimit" )
    private String inspSpecFrmtdLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFrmtdLowerLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_FRMTD_LOWER_LIMIT =
        new InspectionCharacteristicField<String>("InspSpecFrmtdLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowerLimit" )
    @JsonProperty( "InspSpecHasLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowerLimit" )
    private String inspSpecHasLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowerLimit</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_HAS_LOWER_LIMIT =
        new InspectionCharacteristicField<String>("InspSpecHasLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @return Weighting of Characteristic
     */
    @SerializedName( "InspSpecImportanceCode" )
    @JsonProperty( "InspSpecImportanceCode" )
    @Nullable
    @ODataField( odataName = "InspSpecImportanceCode" )
    private String inspSpecImportanceCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecImportanceCode</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_IMPORTANCE_CODE =
        new InspectionCharacteristicField<String>("InspSpecImportanceCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotTestEquipInternalID</b>
     * </p>
     *
     * @return Assigned Test Equipment
     */
    @SerializedName( "InspLotTestEquipInternalID" )
    @JsonProperty( "InspLotTestEquipInternalID" )
    @Nullable
    @ODataField( odataName = "InspLotTestEquipInternalID" )
    private String inspLotTestEquipInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspLotTestEquipInternalID</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_LOT_TEST_EQUIP_INTERNAL_ID =
        new InspectionCharacteristicField<String>("InspLotTestEquipInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> SELECTED_CODE_SET =
        new InspectionCharacteristicField<String>("SelectedCodeSet");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> SELECTED_CODE_SET_PLANT =
        new InspectionCharacteristicField<String>("SelectedCodeSetPlant");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @return Inspector Qualification
     */
    @SerializedName( "InspectorQualification" )
    @JsonProperty( "InspectorQualification" )
    @Nullable
    @ODataField( odataName = "InspectorQualification" )
    private String inspectorQualification;
    /**
     * Use with available fluent helpers to apply the <b>InspectorQualification</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSPECTOR_QUALIFICATION =
        new InspectionCharacteristicField<String>("InspectorQualification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField1" )
    @JsonProperty( "InspSpecInformationField1" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField1" )
    private String inspSpecInformationField1;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField1</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD1 =
        new InspectionCharacteristicField<String>("InspSpecInformationField1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField2" )
    @JsonProperty( "InspSpecInformationField2" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField2" )
    private String inspSpecInformationField2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField2</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD2 =
        new InspectionCharacteristicField<String>("InspSpecInformationField2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField3" )
    @JsonProperty( "InspSpecInformationField3" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField3" )
    private String inspSpecInformationField3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField3</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD3 =
        new InspectionCharacteristicField<String>("InspSpecInformationField3");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @return Quantity to Be Inspected
     */
    @SerializedName( "InspectionScope" )
    @JsonProperty( "InspectionScope" )
    @Nullable
    @ODataField( odataName = "InspectionScope" )
    private BigDecimal inspectionScope;
    /**
     * Use with available fluent helpers to apply the <b>InspectionScope</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<BigDecimal> INSPECTION_SCOPE =
        new InspectionCharacteristicField<BigDecimal>("InspectionScope");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcQuantity</b>
     * </p>
     *
     * @return Quantity to Be Inspected
     */
    @SerializedName( "InspCharcQuantity" )
    @JsonProperty( "InspCharcQuantity" )
    @Nullable
    @ODataField( odataName = "InspCharcQuantity" )
    private BigDecimal inspCharcQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspCharcQuantity</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<BigDecimal> INSP_CHARC_QUANTITY =
        new InspectionCharacteristicField<BigDecimal>("InspCharcQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecControlIndicators</b>
     * </p>
     *
     * @return Cntrl Indicator String for Insp. Char./Master Insp. Char.
     */
    @SerializedName( "InspSpecControlIndicators" )
    @JsonProperty( "InspSpecControlIndicators" )
    @Nullable
    @ODataField( odataName = "InspSpecControlIndicators" )
    private String inspSpecControlIndicators;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecControlIndicators</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_SPEC_CONTROL_INDICATORS =
        new InspectionCharacteristicField<String>("InspSpecControlIndicators");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "CharacteristicAttributeCatalog" )
    @JsonProperty( "CharacteristicAttributeCatalog" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCatalog" )
    private String characteristicAttributeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCatalog</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> CHARACTERISTIC_ATTRIBUTE_CATALOG =
        new InspectionCharacteristicField<String>("CharacteristicAttributeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnplndCharcInspSubsetIntID</b>
     * </p>
     *
     * @return Unplanned Characteristic Was Created with this Sample No.
     */
    @SerializedName( "UnplndCharcInspSubsetIntID" )
    @JsonProperty( "UnplndCharcInspSubsetIntID" )
    @Nullable
    @ODataField( odataName = "UnplndCharcInspSubsetIntID" )
    private String unplndCharcInspSubsetIntID;
    /**
     * Use with available fluent helpers to apply the <b>UnplndCharcInspSubsetIntID</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> UNPLND_CHARC_INSP_SUBSET_INT_ID =
        new InspectionCharacteristicField<String>("UnplndCharcInspSubsetIntID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @return Dynamic Modification Rule
     */
    @SerializedName( "InspLotDynamicRule" )
    @JsonProperty( "InspLotDynamicRule" )
    @Nullable
    @ODataField( odataName = "InspLotDynamicRule" )
    private String inspLotDynamicRule;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDynamicRule</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_LOT_DYNAMIC_RULE =
        new InspectionCharacteristicField<String>("InspLotDynamicRule");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcConfirmationNumber</b>
     * </p>
     *
     * @return Confirmation Number for Inspection Characteristic
     */
    @SerializedName( "InspCharcConfirmationNumber" )
    @JsonProperty( "InspCharcConfirmationNumber" )
    @Nullable
    @ODataField( odataName = "InspCharcConfirmationNumber" )
    private String inspCharcConfirmationNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspCharcConfirmationNumber</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<String> INSP_CHARC_CONFIRMATION_NUMBER =
        new InspectionCharacteristicField<String>("InspCharcConfirmationNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionCharacteristicField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionCharacteristicField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_InspResultValue</b> for <b>InspectionCharacteristic</b> to multiple
     * <b>InspectionResultValue</b>.
     *
     */
    @SerializedName( "to_InspResultValue" )
    @JsonProperty( "to_InspResultValue" )
    @ODataField( odataName = "to_InspResultValue" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InspectionResultValue> toInspResultValue;
    /**
     * Navigation property <b>to_InspSmplResult</b> for <b>InspectionCharacteristic</b> to multiple
     * <b>InspSampleResult</b>.
     *
     */
    @SerializedName( "to_InspSmplResult" )
    @JsonProperty( "to_InspSmplResult" )
    @ODataField( odataName = "to_InspSmplResult" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InspSampleResult> toInspSmplResult;
    /**
     * Use with available fluent helpers to apply the <b>to_InspResultValue</b> navigation property to query operations.
     *
     */
    public final static InspectionCharacteristicLink<InspectionResultValue> TO_INSP_RESULT_VALUE =
        new InspectionCharacteristicLink<InspectionResultValue>("to_InspResultValue");
    /**
     * Use with available fluent helpers to apply the <b>to_InspSmplResult</b> navigation property to query operations.
     *
     */
    public final static InspectionCharacteristicLink<InspSampleResult> TO_INSP_SMPL_RESULT =
        new InspectionCharacteristicLink<InspSampleResult>("to_InspSmplResult");

    @Nonnull
    @Override
    public Class<InspectionCharacteristic> getType()
    {
        return InspectionCharacteristic.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     */
    public void setInspectionCharacteristic( @Nullable final String inspectionCharacteristic )
    {
        rememberChangedField("InspectionCharacteristic", this.inspectionCharacteristic);
        this.inspectionCharacteristic = inspectionCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @param inspectionSpecificationText
     *            Short Text for Inspection Characteristic
     */
    public void setInspectionSpecificationText( @Nullable final String inspectionSpecificationText )
    {
        rememberChangedField("InspectionSpecificationText", this.inspectionSpecificationText);
        this.inspectionSpecificationText = inspectionSpecificationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasInspCharcPrtlSmpl</b>
     * </p>
     *
     * @param hasInspCharcPrtlSmpl
     *            Partial Samples Possible
     */
    public void setHasInspCharcPrtlSmpl( @Nullable final String hasInspCharcPrtlSmpl )
    {
        rememberChangedField("HasInspCharcPrtlSmpl", this.hasInspCharcPrtlSmpl);
        this.hasInspCharcPrtlSmpl = hasInspCharcPrtlSmpl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @param inspSpecIsQuantitative
     *            Is Quantitative Characteristic
     */
    public void setInspSpecIsQuantitative( @Nullable final Boolean inspSpecIsQuantitative )
    {
        rememberChangedField("InspSpecIsQuantitative", this.inspSpecIsQuantitative);
        this.inspSpecIsQuantitative = inspSpecIsQuantitative;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @param inspSpecIsMeasuredValueRqd
     *            Measured Values Must Be Recorded
     */
    public void setInspSpecIsMeasuredValueRqd( @Nullable final String inspSpecIsMeasuredValueRqd )
    {
        rememberChangedField("InspSpecIsMeasuredValueRqd", this.inspSpecIsMeasuredValueRqd);
        this.inspSpecIsMeasuredValueRqd = inspSpecIsMeasuredValueRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @param inspSpecIsSelectedSetRequired
     *            Reference to Characteristic Attribute Required
     */
    public void setInspSpecIsSelectedSetRequired( @Nullable final String inspSpecIsSelectedSetRequired )
    {
        rememberChangedField("InspSpecIsSelectedSetRequired", this.inspSpecIsSelectedSetRequired);
        this.inspSpecIsSelectedSetRequired = inspSpecIsSelectedSetRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @param inspSpecIsLongTermInspection
     *            Long-Term Inspection
     */
    public void setInspSpecIsLongTermInspection( @Nullable final String inspSpecIsLongTermInspection )
    {
        rememberChangedField("InspSpecIsLongTermInspection", this.inspSpecIsLongTermInspection);
        this.inspSpecIsLongTermInspection = inspSpecIsLongTermInspection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @param inspSpecRecordingType
     *            Recording Type
     */
    public void setInspSpecRecordingType( @Nullable final String inspSpecRecordingType )
    {
        rememberChangedField("InspSpecRecordingType", this.inspSpecRecordingType);
        this.inspSpecRecordingType = inspSpecRecordingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @param inspResultIsDocumentationRqd
     *            Documentation Required for Inspection Results
     */
    public void setInspResultIsDocumentationRqd( @Nullable final String inspResultIsDocumentationRqd )
    {
        rememberChangedField("InspResultIsDocumentationRqd", this.inspResultIsDocumentationRqd);
        this.inspResultIsDocumentationRqd = inspResultIsDocumentationRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @param inspSpecCharcCategory
     *            Characteristic Category
     */
    public void setInspSpecCharcCategory( @Nullable final String inspSpecCharcCategory )
    {
        rememberChangedField("InspSpecCharcCategory", this.inspSpecCharcCategory);
        this.inspSpecCharcCategory = inspSpecCharcCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @param inspSpecResultCalculation
     *            Calculated Characteristic
     */
    public void setInspSpecResultCalculation( @Nullable final String inspSpecResultCalculation )
    {
        rememberChangedField("InspSpecResultCalculation", this.inspSpecResultCalculation);
        this.inspSpecResultCalculation = inspSpecResultCalculation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcIsNotPlanned</b>
     * </p>
     *
     * @param inspCharcIsNotPlanned
     *            Unplanned Characteristic
     */
    public void setInspCharcIsNotPlanned( @Nullable final Boolean inspCharcIsNotPlanned )
    {
        rememberChangedField("InspCharcIsNotPlanned", this.inspCharcIsNotPlanned);
        this.inspCharcIsNotPlanned = inspCharcIsNotPlanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @param inspectionMethod
     *            Inspection Method
     */
    public void setInspectionMethod( @Nullable final String inspectionMethod )
    {
        rememberChangedField("InspectionMethod", this.inspectionMethod);
        this.inspectionMethod = inspectionMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     */
    public void setInspectionMethodPlant( @Nullable final String inspectionMethodPlant )
    {
        rememberChangedField("InspectionMethodPlant", this.inspectionMethodPlant);
        this.inspectionMethodPlant = inspectionMethodPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @param inspectionMethodVersion
     *            Version Number of Inspection Method
     */
    public void setInspectionMethodVersion( @Nullable final String inspectionMethodVersion )
    {
        rememberChangedField("InspectionMethodVersion", this.inspectionMethodVersion);
        this.inspectionMethodVersion = inspectionMethodVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     */
    public void setInspectionSpecificationPlant( @Nullable final String inspectionSpecificationPlant )
    {
        rememberChangedField("InspectionSpecificationPlant", this.inspectionSpecificationPlant);
        this.inspectionSpecificationPlant = inspectionSpecificationPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     */
    public void setInspectionSpecification( @Nullable final String inspectionSpecification )
    {
        rememberChangedField("InspectionSpecification", this.inspectionSpecification);
        this.inspectionSpecification = inspectionSpecification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @param inspectionSpecificationVersion
     *            Version Number of Master Inspection Characteristic
     */
    public void setInspectionSpecificationVersion( @Nullable final String inspectionSpecificationVersion )
    {
        rememberChangedField("InspectionSpecificationVersion", this.inspectionSpecificationVersion);
        this.inspectionSpecificationVersion = inspectionSpecificationVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristicStatus</b>
     * </p>
     *
     * @param inspectionCharacteristicStatus
     *            Specification Record Status
     */
    public void setInspectionCharacteristicStatus( @Nullable final String inspectionCharacteristicStatus )
    {
        rememberChangedField("InspectionCharacteristicStatus", this.inspectionCharacteristicStatus);
        this.inspectionCharacteristicStatus = inspectionCharacteristicStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @param inspSpecDecimalPlaces
     *            Number of Places to the Right of a Decimal Point (Accuracy)
     */
    public void setInspSpecDecimalPlaces( @Nullable final Short inspSpecDecimalPlaces )
    {
        rememberChangedField("InspSpecDecimalPlaces", this.inspSpecDecimalPlaces);
        this.inspSpecDecimalPlaces = inspSpecDecimalPlaces;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @param inspectionSpecificationUnit
     *            Unit of Measurement in Which Quantitative Data Is Stored
     */
    public void setInspectionSpecificationUnit( @Nullable final String inspectionSpecificationUnit )
    {
        rememberChangedField("InspectionSpecificationUnit", this.inspectionSpecificationUnit);
        this.inspectionSpecificationUnit = inspectionSpecificationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSampleValuationRule</b>
     * </p>
     *
     * @param inspSampleValuationRule
     *            Valuation Rule
     */
    public void setInspSampleValuationRule( @Nullable final String inspSampleValuationRule )
    {
        rememberChangedField("InspSampleValuationRule", this.inspSampleValuationRule);
        this.inspSampleValuationRule = inspSampleValuationRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Sample Unit of Measure
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleSize</b>
     * </p>
     *
     * @param inspCharacteristicSampleSize
     *            Sample Size that Has to Be Inspected for a Characteristic
     */
    public void setInspCharacteristicSampleSize( @Nullable final Integer inspCharacteristicSampleSize )
    {
        rememberChangedField("InspCharacteristicSampleSize", this.inspCharacteristicSampleSize);
        this.inspCharacteristicSampleSize = inspCharacteristicSampleSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleUnit</b>
     * </p>
     *
     * @param inspCharacteristicSampleUnit
     *            Sample Unit of Measure
     */
    public void setInspCharacteristicSampleUnit( @Nullable final String inspCharacteristicSampleUnit )
    {
        rememberChangedField("InspCharacteristicSampleUnit", this.inspCharacteristicSampleUnit);
        this.inspCharacteristicSampleUnit = inspCharacteristicSampleUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSampleQuantityFactor</b>
     * </p>
     *
     * @param inspSpecSampleQuantityFactor
     *            Sample Quantity Factor for Sample(Mult. Sample Unit of Msr.)
     */
    public void setInspSpecSampleQuantityFactor( @Nullable final BigDecimal inspSpecSampleQuantityFactor )
    {
        rememberChangedField("InspSpecSampleQuantityFactor", this.inspSpecSampleQuantityFactor);
        this.inspSpecSampleQuantityFactor = inspSpecSampleQuantityFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @param inspSpecTargetValue
     *            Target Value for a Quantitative Characteristic
     */
    public void setInspSpecTargetValue( @Nullable final Double inspSpecTargetValue )
    {
        rememberChangedField("InspSpecTargetValue", this.inspSpecTargetValue);
        this.inspSpecTargetValue = inspSpecTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdTargetValue</b>
     * </p>
     *
     * @param inspSpecFrmtdTargetValue
     *            Target Value for Quantitative Characteristic (Formatted)
     */
    public void setInspSpecFrmtdTargetValue( @Nullable final String inspSpecFrmtdTargetValue )
    {
        rememberChangedField("InspSpecFrmtdTargetValue", this.inspSpecFrmtdTargetValue);
        this.inspSpecFrmtdTargetValue = inspSpecFrmtdTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @param inspSpecHasTargetValue
     *            Value Not Initial If Set
     */
    public void setInspSpecHasTargetValue( @Nullable final String inspSpecHasTargetValue )
    {
        rememberChangedField("InspSpecHasTargetValue", this.inspSpecHasTargetValue);
        this.inspSpecHasTargetValue = inspSpecHasTargetValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @param inspSpecUpperLimit
     *            Upper Specification Limit
     */
    public void setInspSpecUpperLimit( @Nullable final Double inspSpecUpperLimit )
    {
        rememberChangedField("InspSpecUpperLimit", this.inspSpecUpperLimit);
        this.inspSpecUpperLimit = inspSpecUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdUpperLimit</b>
     * </p>
     *
     * @param inspSpecFrmtdUpperLimit
     *            Upper Specification Limit (Formatted)
     */
    public void setInspSpecFrmtdUpperLimit( @Nullable final String inspSpecFrmtdUpperLimit )
    {
        rememberChangedField("InspSpecFrmtdUpperLimit", this.inspSpecFrmtdUpperLimit);
        this.inspSpecFrmtdUpperLimit = inspSpecFrmtdUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @param inspSpecHasUpperLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUpperLimit( @Nullable final String inspSpecHasUpperLimit )
    {
        rememberChangedField("InspSpecHasUpperLimit", this.inspSpecHasUpperLimit);
        this.inspSpecHasUpperLimit = inspSpecHasUpperLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @param inspSpecLowerLimit
     *            Lower Specification Limit
     */
    public void setInspSpecLowerLimit( @Nullable final Double inspSpecLowerLimit )
    {
        rememberChangedField("InspSpecLowerLimit", this.inspSpecLowerLimit);
        this.inspSpecLowerLimit = inspSpecLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFrmtdLowerLimit</b>
     * </p>
     *
     * @param inspSpecFrmtdLowerLimit
     *            Lower Specification Limit (Formatted)
     */
    public void setInspSpecFrmtdLowerLimit( @Nullable final String inspSpecFrmtdLowerLimit )
    {
        rememberChangedField("InspSpecFrmtdLowerLimit", this.inspSpecFrmtdLowerLimit);
        this.inspSpecFrmtdLowerLimit = inspSpecFrmtdLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @param inspSpecHasLowerLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowerLimit( @Nullable final String inspSpecHasLowerLimit )
    {
        rememberChangedField("InspSpecHasLowerLimit", this.inspSpecHasLowerLimit);
        this.inspSpecHasLowerLimit = inspSpecHasLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @param inspSpecImportanceCode
     *            Weighting of Characteristic
     */
    public void setInspSpecImportanceCode( @Nullable final String inspSpecImportanceCode )
    {
        rememberChangedField("InspSpecImportanceCode", this.inspSpecImportanceCode);
        this.inspSpecImportanceCode = inspSpecImportanceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspLotTestEquipInternalID</b>
     * </p>
     *
     * @param inspLotTestEquipInternalID
     *            Assigned Test Equipment
     */
    public void setInspLotTestEquipInternalID( @Nullable final String inspLotTestEquipInternalID )
    {
        rememberChangedField("InspLotTestEquipInternalID", this.inspLotTestEquipInternalID);
        this.inspLotTestEquipInternalID = inspLotTestEquipInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Assigned Code Group or Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant of the Assigned Selected Set
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @param inspectorQualification
     *            Inspector Qualification
     */
    public void setInspectorQualification( @Nullable final String inspectorQualification )
    {
        rememberChangedField("InspectorQualification", this.inspectorQualification);
        this.inspectorQualification = inspectorQualification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @param inspSpecInformationField1
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField1( @Nullable final String inspSpecInformationField1 )
    {
        rememberChangedField("InspSpecInformationField1", this.inspSpecInformationField1);
        this.inspSpecInformationField1 = inspSpecInformationField1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @param inspSpecInformationField2
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField2( @Nullable final String inspSpecInformationField2 )
    {
        rememberChangedField("InspSpecInformationField2", this.inspSpecInformationField2);
        this.inspSpecInformationField2 = inspSpecInformationField2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @param inspSpecInformationField3
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField3( @Nullable final String inspSpecInformationField3 )
    {
        rememberChangedField("InspSpecInformationField3", this.inspSpecInformationField3);
        this.inspSpecInformationField3 = inspSpecInformationField3;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @param inspectionScope
     *            Quantity to Be Inspected
     */
    public void setInspectionScope( @Nullable final BigDecimal inspectionScope )
    {
        rememberChangedField("InspectionScope", this.inspectionScope);
        this.inspectionScope = inspectionScope;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcQuantity</b>
     * </p>
     *
     * @param inspCharcQuantity
     *            Quantity to Be Inspected
     */
    public void setInspCharcQuantity( @Nullable final BigDecimal inspCharcQuantity )
    {
        rememberChangedField("InspCharcQuantity", this.inspCharcQuantity);
        this.inspCharcQuantity = inspCharcQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecControlIndicators</b>
     * </p>
     *
     * @param inspSpecControlIndicators
     *            Cntrl Indicator String for Insp. Char./Master Insp. Char.
     */
    public void setInspSpecControlIndicators( @Nullable final String inspSpecControlIndicators )
    {
        rememberChangedField("InspSpecControlIndicators", this.inspSpecControlIndicators);
        this.inspSpecControlIndicators = inspSpecControlIndicators;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @param characteristicAttributeCatalog
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setCharacteristicAttributeCatalog( @Nullable final String characteristicAttributeCatalog )
    {
        rememberChangedField("CharacteristicAttributeCatalog", this.characteristicAttributeCatalog);
        this.characteristicAttributeCatalog = characteristicAttributeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnplndCharcInspSubsetIntID</b>
     * </p>
     *
     * @param unplndCharcInspSubsetIntID
     *            Unplanned Characteristic Was Created with this Sample No.
     */
    public void setUnplndCharcInspSubsetIntID( @Nullable final String unplndCharcInspSubsetIntID )
    {
        rememberChangedField("UnplndCharcInspSubsetIntID", this.unplndCharcInspSubsetIntID);
        this.unplndCharcInspSubsetIntID = unplndCharcInspSubsetIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @param inspLotDynamicRule
     *            Dynamic Modification Rule
     */
    public void setInspLotDynamicRule( @Nullable final String inspLotDynamicRule )
    {
        rememberChangedField("InspLotDynamicRule", this.inspLotDynamicRule);
        this.inspLotDynamicRule = inspLotDynamicRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspCharcConfirmationNumber</b>
     * </p>
     *
     * @param inspCharcConfirmationNumber
     *            Confirmation Number for Inspection Characteristic
     */
    public void setInspCharcConfirmationNumber( @Nullable final String inspCharcConfirmationNumber )
    {
        rememberChangedField("InspCharcConfirmationNumber", this.inspCharcConfirmationNumber);
        this.inspCharcConfirmationNumber = inspCharcConfirmationNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionCharacteristic";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        result.put("InspectionCharacteristic", getInspectionCharacteristic());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionCharacteristic", getInspectionCharacteristic());
        values.put("InspectionSpecificationText", getInspectionSpecificationText());
        values.put("HasInspCharcPrtlSmpl", getHasInspCharcPrtlSmpl());
        values.put("InspSpecIsQuantitative", getInspSpecIsQuantitative());
        values.put("InspSpecIsMeasuredValueRqd", getInspSpecIsMeasuredValueRqd());
        values.put("InspSpecIsSelectedSetRequired", getInspSpecIsSelectedSetRequired());
        values.put("InspSpecIsLongTermInspection", getInspSpecIsLongTermInspection());
        values.put("InspSpecRecordingType", getInspSpecRecordingType());
        values.put("InspResultIsDocumentationRqd", getInspResultIsDocumentationRqd());
        values.put("InspSpecCharcCategory", getInspSpecCharcCategory());
        values.put("InspSpecResultCalculation", getInspSpecResultCalculation());
        values.put("InspCharcIsNotPlanned", getInspCharcIsNotPlanned());
        values.put("InspectionMethod", getInspectionMethod());
        values.put("InspectionMethodPlant", getInspectionMethodPlant());
        values.put("InspectionMethodVersion", getInspectionMethodVersion());
        values.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        values.put("InspectionSpecification", getInspectionSpecification());
        values.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        values.put("InspectionCharacteristicStatus", getInspectionCharacteristicStatus());
        values.put("InspSpecDecimalPlaces", getInspSpecDecimalPlaces());
        values.put("InspectionSpecificationUnit", getInspectionSpecificationUnit());
        values.put("InspSampleValuationRule", getInspSampleValuationRule());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("InspCharacteristicSampleSize", getInspCharacteristicSampleSize());
        values.put("InspCharacteristicSampleUnit", getInspCharacteristicSampleUnit());
        values.put("InspSpecSampleQuantityFactor", getInspSpecSampleQuantityFactor());
        values.put("InspSpecTargetValue", getInspSpecTargetValue());
        values.put("InspSpecFrmtdTargetValue", getInspSpecFrmtdTargetValue());
        values.put("InspSpecHasTargetValue", getInspSpecHasTargetValue());
        values.put("InspSpecUpperLimit", getInspSpecUpperLimit());
        values.put("InspSpecFrmtdUpperLimit", getInspSpecFrmtdUpperLimit());
        values.put("InspSpecHasUpperLimit", getInspSpecHasUpperLimit());
        values.put("InspSpecLowerLimit", getInspSpecLowerLimit());
        values.put("InspSpecFrmtdLowerLimit", getInspSpecFrmtdLowerLimit());
        values.put("InspSpecHasLowerLimit", getInspSpecHasLowerLimit());
        values.put("InspSpecImportanceCode", getInspSpecImportanceCode());
        values.put("InspLotTestEquipInternalID", getInspLotTestEquipInternalID());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("InspectorQualification", getInspectorQualification());
        values.put("InspSpecInformationField1", getInspSpecInformationField1());
        values.put("InspSpecInformationField2", getInspSpecInformationField2());
        values.put("InspSpecInformationField3", getInspSpecInformationField3());
        values.put("InspectionScope", getInspectionScope());
        values.put("InspCharcQuantity", getInspCharcQuantity());
        values.put("InspSpecControlIndicators", getInspSpecControlIndicators());
        values.put("CharacteristicAttributeCatalog", getCharacteristicAttributeCatalog());
        values.put("UnplndCharcInspSubsetIntID", getUnplndCharcInspSubsetIntID());
        values.put("InspLotDynamicRule", getInspLotDynamicRule());
        values.put("InspCharcConfirmationNumber", getInspCharcConfirmationNumber());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristic") ) {
                final Object value = values.remove("InspectionCharacteristic");
                if( (value == null) || (!value.equals(getInspectionCharacteristic())) ) {
                    setInspectionCharacteristic(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationText") ) {
                final Object value = values.remove("InspectionSpecificationText");
                if( (value == null) || (!value.equals(getInspectionSpecificationText())) ) {
                    setInspectionSpecificationText(((String) value));
                }
            }
            if( values.containsKey("HasInspCharcPrtlSmpl") ) {
                final Object value = values.remove("HasInspCharcPrtlSmpl");
                if( (value == null) || (!value.equals(getHasInspCharcPrtlSmpl())) ) {
                    setHasInspCharcPrtlSmpl(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsQuantitative") ) {
                final Object value = values.remove("InspSpecIsQuantitative");
                if( (value == null) || (!value.equals(getInspSpecIsQuantitative())) ) {
                    setInspSpecIsQuantitative(((Boolean) value));
                }
            }
            if( values.containsKey("InspSpecIsMeasuredValueRqd") ) {
                final Object value = values.remove("InspSpecIsMeasuredValueRqd");
                if( (value == null) || (!value.equals(getInspSpecIsMeasuredValueRqd())) ) {
                    setInspSpecIsMeasuredValueRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSelectedSetRequired") ) {
                final Object value = values.remove("InspSpecIsSelectedSetRequired");
                if( (value == null) || (!value.equals(getInspSpecIsSelectedSetRequired())) ) {
                    setInspSpecIsSelectedSetRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsLongTermInspection") ) {
                final Object value = values.remove("InspSpecIsLongTermInspection");
                if( (value == null) || (!value.equals(getInspSpecIsLongTermInspection())) ) {
                    setInspSpecIsLongTermInspection(((String) value));
                }
            }
            if( values.containsKey("InspSpecRecordingType") ) {
                final Object value = values.remove("InspSpecRecordingType");
                if( (value == null) || (!value.equals(getInspSpecRecordingType())) ) {
                    setInspSpecRecordingType(((String) value));
                }
            }
            if( values.containsKey("InspResultIsDocumentationRqd") ) {
                final Object value = values.remove("InspResultIsDocumentationRqd");
                if( (value == null) || (!value.equals(getInspResultIsDocumentationRqd())) ) {
                    setInspResultIsDocumentationRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecCharcCategory") ) {
                final Object value = values.remove("InspSpecCharcCategory");
                if( (value == null) || (!value.equals(getInspSpecCharcCategory())) ) {
                    setInspSpecCharcCategory(((String) value));
                }
            }
            if( values.containsKey("InspSpecResultCalculation") ) {
                final Object value = values.remove("InspSpecResultCalculation");
                if( (value == null) || (!value.equals(getInspSpecResultCalculation())) ) {
                    setInspSpecResultCalculation(((String) value));
                }
            }
            if( values.containsKey("InspCharcIsNotPlanned") ) {
                final Object value = values.remove("InspCharcIsNotPlanned");
                if( (value == null) || (!value.equals(getInspCharcIsNotPlanned())) ) {
                    setInspCharcIsNotPlanned(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionMethod") ) {
                final Object value = values.remove("InspectionMethod");
                if( (value == null) || (!value.equals(getInspectionMethod())) ) {
                    setInspectionMethod(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodPlant") ) {
                final Object value = values.remove("InspectionMethodPlant");
                if( (value == null) || (!value.equals(getInspectionMethodPlant())) ) {
                    setInspectionMethodPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodVersion") ) {
                final Object value = values.remove("InspectionMethodVersion");
                if( (value == null) || (!value.equals(getInspectionMethodVersion())) ) {
                    setInspectionMethodVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationPlant") ) {
                final Object value = values.remove("InspectionSpecificationPlant");
                if( (value == null) || (!value.equals(getInspectionSpecificationPlant())) ) {
                    setInspectionSpecificationPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecification") ) {
                final Object value = values.remove("InspectionSpecification");
                if( (value == null) || (!value.equals(getInspectionSpecification())) ) {
                    setInspectionSpecification(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationVersion") ) {
                final Object value = values.remove("InspectionSpecificationVersion");
                if( (value == null) || (!value.equals(getInspectionSpecificationVersion())) ) {
                    setInspectionSpecificationVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristicStatus") ) {
                final Object value = values.remove("InspectionCharacteristicStatus");
                if( (value == null) || (!value.equals(getInspectionCharacteristicStatus())) ) {
                    setInspectionCharacteristicStatus(((String) value));
                }
            }
            if( values.containsKey("InspSpecDecimalPlaces") ) {
                final Object value = values.remove("InspSpecDecimalPlaces");
                if( (value == null) || (!value.equals(getInspSpecDecimalPlaces())) ) {
                    setInspSpecDecimalPlaces(((Short) value));
                }
            }
            if( values.containsKey("InspectionSpecificationUnit") ) {
                final Object value = values.remove("InspectionSpecificationUnit");
                if( (value == null) || (!value.equals(getInspectionSpecificationUnit())) ) {
                    setInspectionSpecificationUnit(((String) value));
                }
            }
            if( values.containsKey("InspSampleValuationRule") ) {
                final Object value = values.remove("InspSampleValuationRule");
                if( (value == null) || (!value.equals(getInspSampleValuationRule())) ) {
                    setInspSampleValuationRule(((String) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("InspCharacteristicSampleSize") ) {
                final Object value = values.remove("InspCharacteristicSampleSize");
                if( (value == null) || (!value.equals(getInspCharacteristicSampleSize())) ) {
                    setInspCharacteristicSampleSize(((Integer) value));
                }
            }
            if( values.containsKey("InspCharacteristicSampleUnit") ) {
                final Object value = values.remove("InspCharacteristicSampleUnit");
                if( (value == null) || (!value.equals(getInspCharacteristicSampleUnit())) ) {
                    setInspCharacteristicSampleUnit(((String) value));
                }
            }
            if( values.containsKey("InspSpecSampleQuantityFactor") ) {
                final Object value = values.remove("InspSpecSampleQuantityFactor");
                if( (value == null) || (!value.equals(getInspSpecSampleQuantityFactor())) ) {
                    setInspSpecSampleQuantityFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspSpecTargetValue") ) {
                final Object value = values.remove("InspSpecTargetValue");
                if( (value == null) || (!value.equals(getInspSpecTargetValue())) ) {
                    setInspSpecTargetValue(((Double) value));
                }
            }
            if( values.containsKey("InspSpecFrmtdTargetValue") ) {
                final Object value = values.remove("InspSpecFrmtdTargetValue");
                if( (value == null) || (!value.equals(getInspSpecFrmtdTargetValue())) ) {
                    setInspSpecFrmtdTargetValue(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasTargetValue") ) {
                final Object value = values.remove("InspSpecHasTargetValue");
                if( (value == null) || (!value.equals(getInspSpecHasTargetValue())) ) {
                    setInspSpecHasTargetValue(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperLimit") ) {
                final Object value = values.remove("InspSpecUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecUpperLimit())) ) {
                    setInspSpecUpperLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecFrmtdUpperLimit") ) {
                final Object value = values.remove("InspSpecFrmtdUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecFrmtdUpperLimit())) ) {
                    setInspSpecFrmtdUpperLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasUpperLimit") ) {
                final Object value = values.remove("InspSpecHasUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecHasUpperLimit())) ) {
                    setInspSpecHasUpperLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecLowerLimit") ) {
                final Object value = values.remove("InspSpecLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecLowerLimit())) ) {
                    setInspSpecLowerLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecFrmtdLowerLimit") ) {
                final Object value = values.remove("InspSpecFrmtdLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecFrmtdLowerLimit())) ) {
                    setInspSpecFrmtdLowerLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasLowerLimit") ) {
                final Object value = values.remove("InspSpecHasLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecHasLowerLimit())) ) {
                    setInspSpecHasLowerLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecImportanceCode") ) {
                final Object value = values.remove("InspSpecImportanceCode");
                if( (value == null) || (!value.equals(getInspSpecImportanceCode())) ) {
                    setInspSpecImportanceCode(((String) value));
                }
            }
            if( values.containsKey("InspLotTestEquipInternalID") ) {
                final Object value = values.remove("InspLotTestEquipInternalID");
                if( (value == null) || (!value.equals(getInspLotTestEquipInternalID())) ) {
                    setInspLotTestEquipInternalID(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("InspectorQualification") ) {
                final Object value = values.remove("InspectorQualification");
                if( (value == null) || (!value.equals(getInspectorQualification())) ) {
                    setInspectorQualification(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField1") ) {
                final Object value = values.remove("InspSpecInformationField1");
                if( (value == null) || (!value.equals(getInspSpecInformationField1())) ) {
                    setInspSpecInformationField1(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField2") ) {
                final Object value = values.remove("InspSpecInformationField2");
                if( (value == null) || (!value.equals(getInspSpecInformationField2())) ) {
                    setInspSpecInformationField2(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField3") ) {
                final Object value = values.remove("InspSpecInformationField3");
                if( (value == null) || (!value.equals(getInspSpecInformationField3())) ) {
                    setInspSpecInformationField3(((String) value));
                }
            }
            if( values.containsKey("InspectionScope") ) {
                final Object value = values.remove("InspectionScope");
                if( (value == null) || (!value.equals(getInspectionScope())) ) {
                    setInspectionScope(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspCharcQuantity") ) {
                final Object value = values.remove("InspCharcQuantity");
                if( (value == null) || (!value.equals(getInspCharcQuantity())) ) {
                    setInspCharcQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspSpecControlIndicators") ) {
                final Object value = values.remove("InspSpecControlIndicators");
                if( (value == null) || (!value.equals(getInspSpecControlIndicators())) ) {
                    setInspSpecControlIndicators(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCatalog") ) {
                final Object value = values.remove("CharacteristicAttributeCatalog");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCatalog())) ) {
                    setCharacteristicAttributeCatalog(((String) value));
                }
            }
            if( values.containsKey("UnplndCharcInspSubsetIntID") ) {
                final Object value = values.remove("UnplndCharcInspSubsetIntID");
                if( (value == null) || (!value.equals(getUnplndCharcInspSubsetIntID())) ) {
                    setUnplndCharcInspSubsetIntID(((String) value));
                }
            }
            if( values.containsKey("InspLotDynamicRule") ) {
                final Object value = values.remove("InspLotDynamicRule");
                if( (value == null) || (!value.equals(getInspLotDynamicRule())) ) {
                    setInspLotDynamicRule(((String) value));
                }
            }
            if( values.containsKey("InspCharcConfirmationNumber") ) {
                final Object value = values.remove("InspCharcConfirmationNumber");
                if( (value == null) || (!value.equals(getInspCharcConfirmationNumber())) ) {
                    setInspCharcConfirmationNumber(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InspResultValue") ) {
                final Object value = (values).remove("to_InspResultValue");
                if( value instanceof Iterable ) {
                    if( toInspResultValue == null ) {
                        toInspResultValue = Lists.newArrayList();
                    } else {
                        toInspResultValue = Lists.newArrayList(toInspResultValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InspectionResultValue entity;
                        if( toInspResultValue.size() > i ) {
                            entity = toInspResultValue.get(i);
                        } else {
                            entity = new InspectionResultValue();
                            toInspResultValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_InspSmplResult") ) {
                final Object value = (values).remove("to_InspSmplResult");
                if( value instanceof Iterable ) {
                    if( toInspSmplResult == null ) {
                        toInspSmplResult = Lists.newArrayList();
                    } else {
                        toInspSmplResult = Lists.newArrayList(toInspSmplResult);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InspSampleResult entity;
                        if( toInspSmplResult.size() > i ) {
                            entity = toInspSmplResult.get(i);
                        } else {
                            entity = new InspSampleResult();
                            toInspSmplResult.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionCharacteristicField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionCharacteristicField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionCharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionCharacteristicField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInspResultValue != null ) {
            (values).put("to_InspResultValue", toInspResultValue);
        }
        if( toInspSmplResult != null ) {
            (values).put("to_InspSmplResult", toInspSmplResult);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionResultValue</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_InspResultValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InspectionResultValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionResultValue> fetchInspResultValue()
    {
        return fetchFieldAsList("to_InspResultValue", InspectionResultValue.class);
    }

    /**
     * Retrieval of associated <b>InspectionResultValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InspResultValue</b>.
     * <p>
     * If the navigation property <b>to_InspResultValue</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionResultValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionResultValue> getInspResultValueOrFetch()
    {
        if( toInspResultValue == null ) {
            toInspResultValue = fetchInspResultValue();
        }
        return toInspResultValue;
    }

    /**
     * Retrieval of associated <b>InspectionResultValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InspResultValue</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionCharacteristic</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspResultValue</b> is already loaded, the result will
     *         contain the <b>InspectionResultValue</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InspectionResultValue>> getInspResultValueIfPresent()
    {
        return Option.of(toInspResultValue);
    }

    /**
     * Overwrites the list of associated <b>InspectionResultValue</b> entities for the loaded navigation property
     * <b>to_InspResultValue</b>.
     * <p>
     * If the navigation property <b>to_InspResultValue</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InspectionResultValue</b> entities.
     */
    public void setInspResultValue( @Nonnull final List<InspectionResultValue> value )
    {
        if( toInspResultValue == null ) {
            toInspResultValue = Lists.newArrayList();
        }
        toInspResultValue.clear();
        toInspResultValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InspectionResultValue</b> entities. This corresponds to the OData
     * navigation property <b>to_InspResultValue</b>.
     * <p>
     * If the navigation property <b>to_InspResultValue</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InspectionResultValue</b> entities.
     */
    public void addInspResultValue( InspectionResultValue... entity )
    {
        if( toInspResultValue == null ) {
            toInspResultValue = Lists.newArrayList();
        }
        toInspResultValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>InspSampleResult</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_InspSmplResult</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InspSampleResult</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspSampleResult> fetchInspSmplResult()
    {
        return fetchFieldAsList("to_InspSmplResult", InspSampleResult.class);
    }

    /**
     * Retrieval of associated <b>InspSampleResult</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_InspSmplResult</b>.
     * <p>
     * If the navigation property <b>to_InspSmplResult</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspSampleResult</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspSampleResult> getInspSmplResultOrFetch()
    {
        if( toInspSmplResult == null ) {
            toInspSmplResult = fetchInspSmplResult();
        }
        return toInspSmplResult;
    }

    /**
     * Retrieval of associated <b>InspSampleResult</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_InspSmplResult</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionCharacteristic</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspSmplResult</b> is already loaded, the result will
     *         contain the <b>InspSampleResult</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InspSampleResult>> getInspSmplResultIfPresent()
    {
        return Option.of(toInspSmplResult);
    }

    /**
     * Overwrites the list of associated <b>InspSampleResult</b> entities for the loaded navigation property
     * <b>to_InspSmplResult</b>.
     * <p>
     * If the navigation property <b>to_InspSmplResult</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InspSampleResult</b> entities.
     */
    public void setInspSmplResult( @Nonnull final List<InspSampleResult> value )
    {
        if( toInspSmplResult == null ) {
            toInspSmplResult = Lists.newArrayList();
        }
        toInspSmplResult.clear();
        toInspSmplResult.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InspSampleResult</b> entities. This corresponds to the OData
     * navigation property <b>to_InspSmplResult</b>.
     * <p>
     * If the navigation property <b>to_InspSmplResult</b> of a queried <b>InspectionCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InspSampleResult</b> entities.
     */
    public void addInspSmplResult( InspSampleResult... entity )
    {
        if( toInspSmplResult == null ) {
            toInspSmplResult = Lists.newArrayList();
        }
        toInspSmplResult.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InspectionCharacteristic instances.
     *
     */
    public final static class InspectionCharacteristicBuilder
    {

        private List<InspectionResultValue> toInspResultValue = Lists.newArrayList();
        private List<InspSampleResult> toInspSmplResult = Lists.newArrayList();

        private InspectionCharacteristic.InspectionCharacteristicBuilder toInspResultValue(
            final List<InspectionResultValue> value )
        {
            toInspResultValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_InspResultValue</b> for <b>InspectionCharacteristic</b> to multiple
         * <b>InspectionResultValue</b>.
         *
         * @param value
         *            The InspectionResultValues to build this InspectionCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionCharacteristic.InspectionCharacteristicBuilder inspResultValue(
            InspectionResultValue... value )
        {
            return toInspResultValue(Lists.newArrayList(value));
        }

        private InspectionCharacteristic.InspectionCharacteristicBuilder toInspSmplResult(
            final List<InspSampleResult> value )
        {
            toInspSmplResult.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_InspSmplResult</b> for <b>InspectionCharacteristic</b> to multiple
         * <b>InspSampleResult</b>.
         *
         * @param value
         *            The InspSampleResults to build this InspectionCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionCharacteristic.InspectionCharacteristicBuilder inspSmplResult( InspSampleResult... value )
        {
            return toInspSmplResult(Lists.newArrayList(value));
        }

    }

}
