/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionLotField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionLotOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionLotSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Inspection Lot Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionLotType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionLot extends VdmEntity<InspectionLot>
{

    /**
     * Selector for all available fields of InspectionLot.
     *
     */
    public final static InspectionLotSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT = new InspectionLotField<String>("InspectionLot");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL = new InspectionLotField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BATCH = new InspectionLotField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PLANT = new InspectionLotField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotOrigin</b>
     * </p>
     *
     * @return Inspection Lot Origin
     */
    @SerializedName( "InspectionLotOrigin" )
    @JsonProperty( "InspectionLotOrigin" )
    @Nullable
    @ODataField( odataName = "InspectionLotOrigin" )
    private String inspectionLotOrigin;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotOrigin</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_ORIGIN =
        new InspectionLotField<String>("InspectionLotOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new InspectionLotField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Order Number (Production Order)
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MANUFACTURING_ORDER =
        new InspectionLotField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotText</b>
     * </p>
     *
     * @return Inspection Lot Text
     */
    @SerializedName( "InspectionLotText" )
    @JsonProperty( "InspectionLotText" )
    @Nullable
    @ODataField( odataName = "InspectionLotText" )
    private String inspectionLotText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotText</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_TEXT =
        new InspectionLotField<String>("InspectionLotText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @return Inspection Type
     */
    @SerializedName( "InspectionLotType" )
    @JsonProperty( "InspectionLotType" )
    @Nullable
    @ODataField( odataName = "InspectionLotType" )
    private String inspectionLotType;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_TYPE =
        new InspectionLotField<String>("InspectionLotType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQuantity</b>
     * </p>
     *
     * @return Inspection Lot Quantity
     */
    @SerializedName( "InspectionLotQuantity" )
    @JsonProperty( "InspectionLotQuantity" )
    @Nullable
    @ODataField( odataName = "InspectionLotQuantity" )
    private BigDecimal inspectionLotQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotQuantity</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSPECTION_LOT_QUANTITY =
        new InspectionLotField<BigDecimal>("InspectionLotQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotActualQuantity</b>
     * </p>
     *
     * @return Actual Lot Quantity
     */
    @SerializedName( "InspectionLotActualQuantity" )
    @JsonProperty( "InspectionLotActualQuantity" )
    @Nullable
    @ODataField( odataName = "InspectionLotActualQuantity" )
    private BigDecimal inspectionLotActualQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotActualQuantity</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSPECTION_LOT_ACTUAL_QUANTITY =
        new InspectionLotField<BigDecimal>("InspectionLotActualQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDefectiveQuantity</b>
     * </p>
     *
     * @return Defective Quantity
     */
    @SerializedName( "InspectionLotDefectiveQuantity" )
    @JsonProperty( "InspectionLotDefectiveQuantity" )
    @Nullable
    @ODataField( odataName = "InspectionLotDefectiveQuantity" )
    private BigDecimal inspectionLotDefectiveQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotDefectiveQuantity</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSPECTION_LOT_DEFECTIVE_QUANTITY =
        new InspectionLotField<BigDecimal>("InspectionLotDefectiveQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for Inspection Lot Quantity
     */
    @SerializedName( "InspectionLotQuantityUnit" )
    @JsonProperty( "InspectionLotQuantityUnit" )
    @Nullable
    @ODataField( odataName = "InspectionLotQuantityUnit" )
    private String inspectionLotQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotQuantityUnit</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_QUANTITY_UNIT =
        new InspectionLotField<String>("InspectionLotQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCreatedOnLocalDate</b>
     * </p>
     *
     * @return Date in Time Zone Where Lot Created
     */
    @SerializedName( "InspLotCreatedOnLocalDate" )
    @JsonProperty( "InspLotCreatedOnLocalDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspLotCreatedOnLocalDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspLotCreatedOnLocalDate;
    /**
     * Use with available fluent helpers to apply the <b>InspLotCreatedOnLocalDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSP_LOT_CREATED_ON_LOCAL_DATE =
        new InspectionLotField<LocalDateTime>("InspLotCreatedOnLocalDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetFieldCombination</b>
     * </p>
     *
     * @return Identifier for Inspection Point Field Combination
     */
    @SerializedName( "InspSubsetFieldCombination" )
    @JsonProperty( "InspSubsetFieldCombination" )
    @Nullable
    @ODataField( odataName = "InspSubsetFieldCombination" )
    private String inspSubsetFieldCombination;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetFieldCombination</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_SUBSET_FIELD_COMBINATION =
        new InspectionLotField<String>("InspSubsetFieldCombination");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrOpenLongTermCharc</b>
     * </p>
     *
     * @return Open Long-Term Characteristics
     */
    @SerializedName( "InspLotNmbrOpenLongTermCharc" )
    @JsonProperty( "InspLotNmbrOpenLongTermCharc" )
    @Nullable
    @ODataField( odataName = "InspLotNmbrOpenLongTermCharc" )
    private Short inspLotNmbrOpenLongTermCharc;
    /**
     * Use with available fluent helpers to apply the <b>InspLotNmbrOpenLongTermCharc</b> field to query operations.
     *
     */
    public final static InspectionLotField<Short> INSP_LOT_NMBR_OPEN_LONG_TERM_CHARC =
        new InspectionLotField<Short>("InspLotNmbrOpenLongTermCharc");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>StatusObject</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "StatusObject" )
    @JsonProperty( "StatusObject" )
    @Nullable
    @ODataField( odataName = "StatusObject" )
    private String statusObject;
    /**
     * Use with available fluent helpers to apply the <b>StatusObject</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> STATUS_OBJECT = new InspectionLotField<String>("StatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StatusObjectCategory</b>
     * </p>
     *
     * @return Object Category
     */
    @SerializedName( "StatusObjectCategory" )
    @JsonProperty( "StatusObjectCategory" )
    @Nullable
    @ODataField( odataName = "StatusObjectCategory" )
    private String statusObjectCategory;
    /**
     * Use with available fluent helpers to apply the <b>StatusObjectCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> STATUS_OBJECT_CATEGORY =
        new InspectionLotField<String>("StatusObjectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotObjectText</b>
     * </p>
     *
     * @return Short Text for Inspection Object
     */
    @SerializedName( "InspectionLotObjectText" )
    @JsonProperty( "InspectionLotObjectText" )
    @Nullable
    @ODataField( odataName = "InspectionLotObjectText" )
    private String inspectionLotObjectText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotObjectText</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_OBJECT_TEXT =
        new InspectionLotField<String>("InspectionLotObjectText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StatusProfile</b>
     * </p>
     *
     * @return Status Profile
     */
    @SerializedName( "StatusProfile" )
    @JsonProperty( "StatusProfile" )
    @Nullable
    @ODataField( odataName = "StatusProfile" )
    private String statusProfile;
    /**
     * Use with available fluent helpers to apply the <b>StatusProfile</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> STATUS_PROFILE = new InspectionLotField<String>("StatusProfile");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MatlQualityAuthorizationGroup</b>
     * </p>
     *
     * @return Material Authorization Group for Activities in QM
     */
    @SerializedName( "MatlQualityAuthorizationGroup" )
    @JsonProperty( "MatlQualityAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "MatlQualityAuthorizationGroup" )
    private String matlQualityAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlQualityAuthorizationGroup</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATL_QUALITY_AUTHORIZATION_GROUP =
        new InspectionLotField<String>("MatlQualityAuthorizationGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasQuantity</b>
     * </p>
     *
     * @return Posted to Inspection Stock
     */
    @SerializedName( "InspectionLotHasQuantity" )
    @JsonProperty( "InspectionLotHasQuantity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotHasQuantity" )
    private Boolean inspectionLotHasQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotHasQuantity</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_HAS_QUANTITY =
        new InspectionLotField<Boolean>("InspectionLotHasQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsCreatedAutomatically</b>
     * </p>
     *
     * @return Inspection Lot Is Created Automatically
     */
    @SerializedName( "InspLotIsCreatedAutomatically" )
    @JsonProperty( "InspLotIsCreatedAutomatically" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsCreatedAutomatically" )
    private Boolean inspLotIsCreatedAutomatically;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsCreatedAutomatically</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_CREATED_AUTOMATICALLY =
        new InspectionLotField<Boolean>("InspLotIsCreatedAutomatically");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasPartialLots</b>
     * </p>
     *
     * @return Partial Lots Exist
     */
    @SerializedName( "InspectionLotHasPartialLots" )
    @JsonProperty( "InspectionLotHasPartialLots" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotHasPartialLots" )
    private Boolean inspectionLotHasPartialLots;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotHasPartialLots</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_HAS_PARTIAL_LOTS =
        new InspectionLotField<Boolean>("InspectionLotHasPartialLots");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasAppraisalCosts</b>
     * </p>
     *
     * @return Record Appraisal Costs in Individual QM Order
     */
    @SerializedName( "InspectionLotHasAppraisalCosts" )
    @JsonProperty( "InspectionLotHasAppraisalCosts" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotHasAppraisalCosts" )
    private Boolean inspectionLotHasAppraisalCosts;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotHasAppraisalCosts</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_HAS_APPRAISAL_COSTS =
        new InspectionLotField<Boolean>("InspectionLotHasAppraisalCosts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasSubsets</b>
     * </p>
     *
     * @return Inspection with Inspection Points
     */
    @SerializedName( "InspLotHasSubsets" )
    @JsonProperty( "InspLotHasSubsets" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotHasSubsets" )
    private Boolean inspLotHasSubsets;
    /**
     * Use with available fluent helpers to apply the <b>InspLotHasSubsets</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_HAS_SUBSETS =
        new InspectionLotField<Boolean>("InspLotHasSubsets");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsAutomUsgeDcsnPossible</b>
     * </p>
     *
     * @return Automatic Usage Decision Planned
     */
    @SerializedName( "InspLotIsAutomUsgeDcsnPossible" )
    @JsonProperty( "InspLotIsAutomUsgeDcsnPossible" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsAutomUsgeDcsnPossible" )
    private Boolean inspLotIsAutomUsgeDcsnPossible;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsAutomUsgeDcsnPossible</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_AUTOM_USGE_DCSN_POSSIBLE =
        new InspectionLotField<Boolean>("InspLotIsAutomUsgeDcsnPossible");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Source Inspection
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PURCHASING_DOCUMENT_CATEGORY =
        new InspectionLotField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasConfignSpecification</b>
     * </p>
     *
     * @return Inspection Specifications from Configuration
     */
    @SerializedName( "InspLotHasConfignSpecification" )
    @JsonProperty( "InspLotHasConfignSpecification" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotHasConfignSpecification" )
    private Boolean inspLotHasConfignSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspLotHasConfignSpecification</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_HAS_CONFIGN_SPECIFICATION =
        new InspectionLotField<Boolean>("InspLotHasConfignSpecification");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsMovedToBlkdStock</b>
     * </p>
     *
     * @return GR Blocked Stock
     */
    @SerializedName( "GoodsReceiptIsMovedToBlkdStock" )
    @JsonProperty( "GoodsReceiptIsMovedToBlkdStock" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptIsMovedToBlkdStock" )
    private String goodsReceiptIsMovedToBlkdStock;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsMovedToBlkdStock</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> GOODS_RECEIPT_IS_MOVED_TO_BLKD_STOCK =
        new InspectionLotField<String>("GoodsReceiptIsMovedToBlkdStock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsDocumentationRequired</b>
     * </p>
     *
     * @return Documentation Required
     */
    @SerializedName( "InspLotIsDocumentationRequired" )
    @JsonProperty( "InspLotIsDocumentationRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsDocumentationRequired" )
    private Boolean inspLotIsDocumentationRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsDocumentationRequired</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_DOCUMENTATION_REQUIRED =
        new InspectionLotField<Boolean>("InspLotIsDocumentationRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsTaskListRequired</b>
     * </p>
     *
     * @return Inspection Plan Required
     */
    @SerializedName( "InspLotIsTaskListRequired" )
    @JsonProperty( "InspLotIsTaskListRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsTaskListRequired" )
    private Boolean inspLotIsTaskListRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsTaskListRequired</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_TASK_LIST_REQUIRED =
        new InspectionLotField<Boolean>("InspLotIsTaskListRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasManualSampleSize</b>
     * </p>
     *
     * @return Enter Sample Manually
     */
    @SerializedName( "InspLotHasManualSampleSize" )
    @JsonProperty( "InspLotHasManualSampleSize" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotHasManualSampleSize" )
    private Boolean inspLotHasManualSampleSize;
    /**
     * Use with available fluent helpers to apply the <b>InspLotHasManualSampleSize</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_HAS_MANUAL_SAMPLE_SIZE =
        new InspectionLotField<Boolean>("InspLotHasManualSampleSize");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasMaterialSpec</b>
     * </p>
     *
     * @return Inspect with Material Specification
     */
    @SerializedName( "InspLotHasMaterialSpec" )
    @JsonProperty( "InspLotHasMaterialSpec" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotHasMaterialSpec" )
    private Boolean inspLotHasMaterialSpec;
    /**
     * Use with available fluent helpers to apply the <b>InspLotHasMaterialSpec</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_HAS_MATERIAL_SPEC =
        new InspectionLotField<Boolean>("InspLotHasMaterialSpec");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotApproval</b>
     * </p>
     *
     * @return Inspection Lot Approval
     */
    @SerializedName( "InspectionLotApproval" )
    @JsonProperty( "InspectionLotApproval" )
    @Nullable
    @ODataField( odataName = "InspectionLotApproval" )
    private String inspectionLotApproval;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotApproval</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_APPROVAL =
        new InspectionLotField<String>("InspectionLotApproval");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDigitalSgntrResultsRecg</b>
     * </p>
     *
     * @return Digital Signature for Insp. Lot in Results Recording
     */
    @SerializedName( "InspLotDigitalSgntrResultsRecg" )
    @JsonProperty( "InspLotDigitalSgntrResultsRecg" )
    @Nullable
    @ODataField( odataName = "InspLotDigitalSgntrResultsRecg" )
    private String inspLotDigitalSgntrResultsRecg;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDigitalSgntrResultsRecg</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_DIGITAL_SGNTR_RESULTS_RECG =
        new InspectionLotField<String>("InspLotDigitalSgntrResultsRecg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDigitalSgntrInUsgeDcsn</b>
     * </p>
     *
     * @return Digital Signature Usage Decision
     */
    @SerializedName( "InspLotDigitalSgntrInUsgeDcsn" )
    @JsonProperty( "InspLotDigitalSgntrInUsgeDcsn" )
    @Nullable
    @ODataField( odataName = "InspLotDigitalSgntrInUsgeDcsn" )
    private String inspLotDigitalSgntrInUsgeDcsn;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDigitalSgntrInUsgeDcsn</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_DIGITAL_SGNTR_IN_USGE_DCSN =
        new InspectionLotField<String>("InspLotDigitalSgntrInUsgeDcsn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsBatchRequired</b>
     * </p>
     *
     * @return Approved Batch Record Required
     */
    @SerializedName( "InspLotIsBatchRequired" )
    @JsonProperty( "InspLotIsBatchRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsBatchRequired" )
    private Boolean inspLotIsBatchRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsBatchRequired</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_BATCH_REQUIRED =
        new InspectionLotField<Boolean>("InspLotIsBatchRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageInStabilityStudy</b>
     * </p>
     *
     * @return Inspection Lot for Stability Study
     */
    @SerializedName( "InspLotUsageInStabilityStudy" )
    @JsonProperty( "InspLotUsageInStabilityStudy" )
    @Nullable
    @ODataField( odataName = "InspLotUsageInStabilityStudy" )
    private String inspLotUsageInStabilityStudy;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageInStabilityStudy</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_USAGE_IN_STABILITY_STUDY =
        new InspectionLotField<String>("InspLotUsageInStabilityStudy");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsStockPostingCompleted</b>
     * </p>
     *
     * @return Stock Postings Completed
     */
    @SerializedName( "InspLotIsStockPostingCompleted" )
    @JsonProperty( "InspLotIsStockPostingCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsStockPostingCompleted" )
    private Boolean inspLotIsStockPostingCompleted;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsStockPostingCompleted</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_STOCK_POSTING_COMPLETED =
        new InspectionLotField<Boolean>("InspLotIsStockPostingCompleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasUsageDecision</b>
     * </p>
     *
     * @return Usage Decision Made
     */
    @SerializedName( "InspectionLotHasUsageDecision" )
    @JsonProperty( "InspectionLotHasUsageDecision" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotHasUsageDecision" )
    private Boolean inspectionLotHasUsageDecision;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotHasUsageDecision</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_HAS_USAGE_DECISION =
        new InspectionLotField<Boolean>("InspectionLotHasUsageDecision");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfSerialNumbers</b>
     * </p>
     *
     * @return Number of serial numbers
     */
    @SerializedName( "NumberOfSerialNumbers" )
    @JsonProperty( "NumberOfSerialNumbers" )
    @Nullable
    @ODataField( odataName = "NumberOfSerialNumbers" )
    private Integer numberOfSerialNumbers;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfSerialNumbers</b> field to query operations.
     *
     */
    public final static InspectionLotField<Integer> NUMBER_OF_SERIAL_NUMBERS =
        new InspectionLotField<Integer>("NumberOfSerialNumbers");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsSerialNmbrPossible</b>
     * </p>
     *
     * @return Serial Numbers Possible
     */
    @SerializedName( "InspLotIsSerialNmbrPossible" )
    @JsonProperty( "InspLotIsSerialNmbrPossible" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotIsSerialNmbrPossible" )
    private Boolean inspLotIsSerialNmbrPossible;
    /**
     * Use with available fluent helpers to apply the <b>InspLotIsSerialNmbrPossible</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSP_LOT_IS_SERIAL_NMBR_POSSIBLE =
        new InspectionLotField<Boolean>("InspLotIsSerialNmbrPossible");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotIsSkipped</b>
     * </p>
     *
     * @return Skip Lot
     */
    @SerializedName( "InspectionLotIsSkipped" )
    @JsonProperty( "InspectionLotIsSkipped" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotIsSkipped" )
    private Boolean inspectionLotIsSkipped;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotIsSkipped</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_IS_SKIPPED =
        new InspectionLotField<Boolean>("InspectionLotIsSkipped");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotIsFullInspection</b>
     * </p>
     *
     * @return 100% Inspection
     */
    @SerializedName( "InspectionLotIsFullInspection" )
    @JsonProperty( "InspectionLotIsFullInspection" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspectionLotIsFullInspection" )
    private Boolean inspectionLotIsFullInspection;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotIsFullInspection</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> INSPECTION_LOT_IS_FULL_INSPECTION =
        new InspectionLotField<Boolean>("InspectionLotIsFullInspection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDynamicLevel</b>
     * </p>
     *
     * @return Level at Which Dynamic Modification Parameters Are Defined
     */
    @SerializedName( "InspectionLotDynamicLevel" )
    @JsonProperty( "InspectionLotDynamicLevel" )
    @Nullable
    @ODataField( odataName = "InspectionLotDynamicLevel" )
    private String inspectionLotDynamicLevel;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotDynamicLevel</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_DYNAMIC_LEVEL =
        new InspectionLotField<String>("InspectionLotDynamicLevel");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SamplingProcedure</b>
     * </p>
     *
     * @return Sampling Procedure
     */
    @SerializedName( "SamplingProcedure" )
    @JsonProperty( "SamplingProcedure" )
    @Nullable
    @ODataField( odataName = "SamplingProcedure" )
    private String samplingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SamplingProcedure</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SAMPLING_PROCEDURE =
        new InspectionLotField<String>("SamplingProcedure");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCreatedOnLocalTime</b>
     * </p>
     *
     * @return Time in Time Zone Where Lot Created
     */
    @SerializedName( "InspLotCreatedOnLocalTime" )
    @JsonProperty( "InspLotCreatedOnLocalTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspLotCreatedOnLocalTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspLotCreatedOnLocalTime;
    /**
     * Use with available fluent helpers to apply the <b>InspLotCreatedOnLocalTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalTime> INSP_LOT_CREATED_ON_LOCAL_TIME =
        new InspectionLotField<LocalTime>("InspLotCreatedOnLocalTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedBy</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "InspectionLotCreatedBy" )
    @JsonProperty( "InspectionLotCreatedBy" )
    @Nullable
    @ODataField( odataName = "InspectionLotCreatedBy" )
    private String inspectionLotCreatedBy;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotCreatedBy</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_CREATED_BY =
        new InspectionLotField<String>("InspectionLotCreatedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedOn</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "InspectionLotCreatedOn" )
    @JsonProperty( "InspectionLotCreatedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotCreatedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionLotCreatedOn;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotCreatedOn</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSPECTION_LOT_CREATED_ON =
        new InspectionLotField<LocalDateTime>("InspectionLotCreatedOn");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedOnTime</b>
     * </p>
     *
     * @return System Time of Creation
     */
    @SerializedName( "InspectionLotCreatedOnTime" )
    @JsonProperty( "InspectionLotCreatedOnTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotCreatedOnTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionLotCreatedOnTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotCreatedOnTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalTime> INSPECTION_LOT_CREATED_ON_TIME =
        new InspectionLotField<LocalTime>("InspectionLotCreatedOnTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangedBy</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "InspectionLotChangedBy" )
    @JsonProperty( "InspectionLotChangedBy" )
    @Nullable
    @ODataField( odataName = "InspectionLotChangedBy" )
    private String inspectionLotChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotChangedBy</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_CHANGED_BY =
        new InspectionLotField<String>("InspectionLotChangedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "InspectionLotChangeDate" )
    @JsonProperty( "InspectionLotChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionLotChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotChangeDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSPECTION_LOT_CHANGE_DATE =
        new InspectionLotField<LocalDateTime>("InspectionLotChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangeTime</b>
     * </p>
     *
     * @return System Time of Change
     */
    @SerializedName( "InspectionLotChangeTime" )
    @JsonProperty( "InspectionLotChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionLotChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotChangeTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalTime> INSPECTION_LOT_CHANGE_TIME =
        new InspectionLotField<LocalTime>("InspectionLotChangeTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionLotField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStartDate</b>
     * </p>
     *
     * @return Start Date of Inspection in Local Time Zone
     */
    @SerializedName( "InspectionLotStartDate" )
    @JsonProperty( "InspectionLotStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionLotStartDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStartDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSPECTION_LOT_START_DATE =
        new InspectionLotField<LocalDateTime>("InspectionLotStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStartTime</b>
     * </p>
     *
     * @return Inspection Started At
     */
    @SerializedName( "InspectionLotStartTime" )
    @JsonProperty( "InspectionLotStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionLotStartTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStartTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalTime> INSPECTION_LOT_START_TIME =
        new InspectionLotField<LocalTime>("InspectionLotStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotEndDate</b>
     * </p>
     *
     * @return End Date of Inspection in Local Time Zone
     */
    @SerializedName( "InspectionLotEndDate" )
    @JsonProperty( "InspectionLotEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionLotEndDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotEndDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSPECTION_LOT_END_DATE =
        new InspectionLotField<LocalDateTime>("InspectionLotEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotEndTime</b>
     * </p>
     *
     * @return Inspection Ended At
     */
    @SerializedName( "InspectionLotEndTime" )
    @JsonProperty( "InspectionLotEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionLotEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionLotEndTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotEndTime</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalTime> INSPECTION_LOT_END_TIME =
        new InspectionLotField<LocalTime>("InspectionLotEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @return Bill of Operations Type
     */
    @SerializedName( "BillOfOperationsType" )
    @JsonProperty( "BillOfOperationsType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsType" )
    private String billOfOperationsType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_OF_OPERATIONS_TYPE =
        new InspectionLotField<String>("BillOfOperationsType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @return Bill of Operations Group
     */
    @SerializedName( "BillOfOperationsGroup" )
    @JsonProperty( "BillOfOperationsGroup" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsGroup" )
    private String billOfOperationsGroup;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsGroup</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_OF_OPERATIONS_GROUP =
        new InspectionLotField<String>("BillOfOperationsGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @return Bill of Operations Usage
     */
    @SerializedName( "BillOfOperationsUsage" )
    @JsonProperty( "BillOfOperationsUsage" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUsage" )
    private String billOfOperationsUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUsage</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_OF_OPERATIONS_USAGE =
        new InspectionLotField<String>("BillOfOperationsUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @return Bill of Operations Group Counter
     */
    @SerializedName( "BillOfOperationsVariant" )
    @JsonProperty( "BillOfOperationsVariant" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVariant" )
    private String billOfOperationsVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVariant</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_OF_OPERATIONS_VARIANT =
        new InspectionLotField<String>("BillOfOperationsVariant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsChangeStateID</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "BillOfOperationsChangeStateID" )
    @JsonProperty( "BillOfOperationsChangeStateID" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsChangeStateID" )
    private String billOfOperationsChangeStateID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsChangeStateID</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_OF_OPERATIONS_CHANGE_STATE_ID =
        new InspectionLotField<String>("BillOfOperationsChangeStateID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetType</b>
     * </p>
     *
     * @return Inspection Point Type
     */
    @SerializedName( "InspectionSubsetType" )
    @JsonProperty( "InspectionSubsetType" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetType" )
    private String inspectionSubsetType;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_SUBSET_TYPE =
        new InspectionLotField<String>("InspectionSubsetType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedure</b>
     * </p>
     *
     * @return Sample-Drawing Procedure
     */
    @SerializedName( "SmplDrawingProcedure" )
    @JsonProperty( "SmplDrawingProcedure" )
    @Nullable
    @ODataField( odataName = "SmplDrawingProcedure" )
    private String smplDrawingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SmplDrawingProcedure</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SMPL_DRAWING_PROCEDURE =
        new InspectionLotField<String>("SmplDrawingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedureVersion</b>
     * </p>
     *
     * @return Version No. of the Sample-Drawing Procedure
     */
    @SerializedName( "SmplDrawingProcedureVersion" )
    @JsonProperty( "SmplDrawingProcedureVersion" )
    @Nullable
    @ODataField( odataName = "SmplDrawingProcedureVersion" )
    private String smplDrawingProcedureVersion;
    /**
     * Use with available fluent helpers to apply the <b>SmplDrawingProcedureVersion</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SMPL_DRAWING_PROCEDURE_VERSION =
        new InspectionLotField<String>("SmplDrawingProcedureVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrwgProcedIsConfRequired</b>
     * </p>
     *
     * @return Confirmation Required for Sample Drawing
     */
    @SerializedName( "SmplDrwgProcedIsConfRequired" )
    @JsonProperty( "SmplDrwgProcedIsConfRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SmplDrwgProcedIsConfRequired" )
    private Boolean smplDrwgProcedIsConfRequired;
    /**
     * Use with available fluent helpers to apply the <b>SmplDrwgProcedIsConfRequired</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> SMPL_DRWG_PROCED_IS_CONF_REQUIRED =
        new InspectionLotField<Boolean>("SmplDrwgProcedIsConfRequired");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionMaterial</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "InspLotSelectionMaterial" )
    @JsonProperty( "InspLotSelectionMaterial" )
    @Nullable
    @ODataField( odataName = "InspLotSelectionMaterial" )
    private String inspLotSelectionMaterial;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionMaterial</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SELECTION_MATERIAL =
        new InspectionLotField<String>("InspLotSelectionMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelMatlRevisionLvl</b>
     * </p>
     *
     * @return Revision Level
     */
    @SerializedName( "InspLotSelMatlRevisionLvl" )
    @JsonProperty( "InspLotSelMatlRevisionLvl" )
    @Nullable
    @ODataField( odataName = "InspLotSelMatlRevisionLvl" )
    private String inspLotSelMatlRevisionLvl;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelMatlRevisionLvl</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SEL_MATL_REVISION_LVL =
        new InspectionLotField<String>("InspLotSelMatlRevisionLvl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "InspLotSelectionPlant" )
    @JsonProperty( "InspLotSelectionPlant" )
    @Nullable
    @ODataField( odataName = "InspLotSelectionPlant" )
    private String inspLotSelectionPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionPlant</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SELECTION_PLANT =
        new InspectionLotField<String>("InspLotSelectionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionSupplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "InspLotSelectionSupplier" )
    @JsonProperty( "InspLotSelectionSupplier" )
    @Nullable
    @ODataField( odataName = "InspLotSelectionSupplier" )
    private String inspLotSelectionSupplier;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionSupplier</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SELECTION_SUPPLIER =
        new InspectionLotField<String>("InspLotSelectionSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionManufacturer</b>
     * </p>
     *
     * @return Number of Manufacturer
     */
    @SerializedName( "InspLotSelectionManufacturer" )
    @JsonProperty( "InspLotSelectionManufacturer" )
    @Nullable
    @ODataField( odataName = "InspLotSelectionManufacturer" )
    private String inspLotSelectionManufacturer;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionManufacturer</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SELECTION_MANUFACTURER =
        new InspectionLotField<String>("InspLotSelectionManufacturer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionCustomer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "InspLotSelectionCustomer" )
    @JsonProperty( "InspLotSelectionCustomer" )
    @Nullable
    @ODataField( odataName = "InspLotSelectionCustomer" )
    private String inspLotSelectionCustomer;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionCustomer</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SELECTION_CUSTOMER =
        new InspectionLotField<String>("InspLotSelectionCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelBillOfOperationsUsge</b>
     * </p>
     *
     * @return Task List Usage
     */
    @SerializedName( "InspLotSelBillOfOperationsUsge" )
    @JsonProperty( "InspLotSelBillOfOperationsUsge" )
    @Nullable
    @ODataField( odataName = "InspLotSelBillOfOperationsUsge" )
    private String inspLotSelBillOfOperationsUsge;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelBillOfOperationsUsge</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_SEL_BILL_OF_OPERATIONS_USGE =
        new InspectionLotField<String>("InspLotSelBillOfOperationsUsge");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionValidFromDate</b>
     * </p>
     *
     * @return Key Date for Selecting Records or Changing Task Lists
     */
    @SerializedName( "InspLotSelectionValidFromDate" )
    @JsonProperty( "InspLotSelectionValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspLotSelectionValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspLotSelectionValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSelectionValidFromDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> INSP_LOT_SELECTION_VALID_FROM_DATE =
        new InspectionLotField<LocalDateTime>("InspLotSelectionValidFromDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PRODUCTION_VERSION =
        new InspectionLotField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SalesOperationsPlanningOrder</b>
     * </p>
     *
     * @return Run Schedule Header
     */
    @SerializedName( "SalesOperationsPlanningOrder" )
    @JsonProperty( "SalesOperationsPlanningOrder" )
    @Nullable
    @ODataField( odataName = "SalesOperationsPlanningOrder" )
    private String salesOperationsPlanningOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOperationsPlanningOrder</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SALES_OPERATIONS_PLANNING_ORDER =
        new InspectionLotField<String>("SalesOperationsPlanningOrder");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @return Business Purpose Completed Flag
     */
    @SerializedName( "IsBusinessPurposeCompleted" )
    @JsonProperty( "IsBusinessPurposeCompleted" )
    @Nullable
    @ODataField( odataName = "IsBusinessPurposeCompleted" )
    private String isBusinessPurposeCompleted;
    /**
     * Use with available fluent helpers to apply the <b>IsBusinessPurposeCompleted</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> IS_BUSINESS_PURPOSE_COMPLETED =
        new InspectionLotField<String>("IsBusinessPurposeCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer (Ship-To Party)
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> CUSTOMER = new InspectionLotField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SUPPLIER = new InspectionLotField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @return Supplier Batch Number
     */
    @SerializedName( "BatchBySupplier" )
    @JsonProperty( "BatchBySupplier" )
    @Nullable
    @ODataField( odataName = "BatchBySupplier" )
    private String batchBySupplier;
    /**
     * Use with available fluent helpers to apply the <b>BatchBySupplier</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BATCH_BY_SUPPLIER =
        new InspectionLotField<String>("BatchBySupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @return Number of Manufacturer
     */
    @SerializedName( "Manufacturer" )
    @JsonProperty( "Manufacturer" )
    @Nullable
    @ODataField( odataName = "Manufacturer" )
    private String manufacturer;
    /**
     * Use with available fluent helpers to apply the <b>Manufacturer</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MANUFACTURER = new InspectionLotField<String>("Manufacturer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @return Manufacturer Material
     */
    @SerializedName( "ManufacturerPartNmbr" )
    @JsonProperty( "ManufacturerPartNmbr" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartNmbr" )
    private String manufacturerPartNmbr;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartNmbr</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MANUFACTURER_PART_NMBR =
        new InspectionLotField<String>("ManufacturerPartNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @return Revision Level
     */
    @SerializedName( "MaterialRevisionLevel" )
    @JsonProperty( "MaterialRevisionLevel" )
    @Nullable
    @ODataField( odataName = "MaterialRevisionLevel" )
    private String materialRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>MaterialRevisionLevel</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_REVISION_LEVEL =
        new InspectionLotField<String>("MaterialRevisionLevel");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsBatchManaged</b>
     * </p>
     *
     * @return Batch Required
     */
    @SerializedName( "MaterialIsBatchManaged" )
    @JsonProperty( "MaterialIsBatchManaged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsBatchManaged" )
    private Boolean materialIsBatchManaged;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsBatchManaged</b> field to query operations.
     *
     */
    public final static InspectionLotField<Boolean> MATERIAL_IS_BATCH_MANAGED =
        new InspectionLotField<Boolean>("MaterialIsBatchManaged");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchStorageLocation</b>
     * </p>
     *
     * @return Storage Location for Batch
     */
    @SerializedName( "BatchStorageLocation" )
    @JsonProperty( "BatchStorageLocation" )
    @Nullable
    @ODataField( odataName = "BatchStorageLocation" )
    private String batchStorageLocation;
    /**
     * Use with available fluent helpers to apply the <b>BatchStorageLocation</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BATCH_STORAGE_LOCATION =
        new InspectionLotField<String>("BatchStorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsSpecialStock</b>
     * </p>
     *
     * @return Special Stock Indicator
     */
    @SerializedName( "MaterialCompIsSpecialStock" )
    @JsonProperty( "MaterialCompIsSpecialStock" )
    @Nullable
    @ODataField( odataName = "MaterialCompIsSpecialStock" )
    private String materialCompIsSpecialStock;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompIsSpecialStock</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_COMP_IS_SPECIAL_STOCK =
        new InspectionLotField<String>("MaterialCompIsSpecialStock");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PURCHASING_ORGANIZATION =
        new InspectionLotField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PURCHASING_DOCUMENT =
        new InspectionLotField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PURCHASING_DOCUMENT_ITEM =
        new InspectionLotField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Delivery Schedule Line Counter
     */
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SCHEDULE_LINE = new InspectionLotField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> ACCOUNTING_DOCUMENT_TYPE =
        new InspectionLotField<String>("AccountingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_DOCUMENT_YEAR =
        new InspectionLotField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_DOCUMENT =
        new InspectionLotField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_DOCUMENT_ITEM =
        new InspectionLotField<String>("MaterialDocumentItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlDocLatestPostgDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "MatlDocLatestPostgDate" )
    @JsonProperty( "MatlDocLatestPostgDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlDocLatestPostgDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlDocLatestPostgDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlDocLatestPostgDate</b> field to query operations.
     *
     */
    public final static InspectionLotField<LocalDateTime> MATL_DOC_LATEST_POSTG_DATE =
        new InspectionLotField<LocalDateTime>("MatlDocLatestPostgDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> GOODS_MOVEMENT_TYPE =
        new InspectionLotField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotPlant</b>
     * </p>
     *
     * @return Plant for Inspection Lot
     */
    @SerializedName( "InspectionLotPlant" )
    @JsonProperty( "InspectionLotPlant" )
    @Nullable
    @ODataField( odataName = "InspectionLotPlant" )
    private String inspectionLotPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotPlant</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_PLANT =
        new InspectionLotField<String>("InspectionLotPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStorageLocation</b>
     * </p>
     *
     * @return Storage Location for Inspection Lot Stock
     */
    @SerializedName( "InspectionLotStorageLocation" )
    @JsonProperty( "InspectionLotStorageLocation" )
    @Nullable
    @ODataField( odataName = "InspectionLotStorageLocation" )
    private String inspectionLotStorageLocation;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStorageLocation</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_STORAGE_LOCATION =
        new InspectionLotField<String>("InspectionLotStorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number / Warehouse Complex
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> WAREHOUSE = new InspectionLotField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> STORAGE_TYPE = new InspectionLotField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> STORAGE_BIN = new InspectionLotField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SALES_ORDER = new InspectionLotField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SALES_ORDER_ITEM = new InspectionLotField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery Document
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> DELIVERY_DOCUMENT =
        new InspectionLotField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @return Delivery Document Item
     */
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> DELIVERY_DOCUMENT_ITEM =
        new InspectionLotField<String>("DeliveryDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @return Delivery Category
     */
    @SerializedName( "DeliveryCategory" )
    @JsonProperty( "DeliveryCategory" )
    @Nullable
    @ODataField( odataName = "DeliveryCategory" )
    private String deliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> DELIVERY_CATEGORY =
        new InspectionLotField<String>("DeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionDeliveryCategory</b>
     * </p>
     *
     * @return Delivery Category
     */
    @SerializedName( "InspectionDeliveryCategory" )
    @JsonProperty( "InspectionDeliveryCategory" )
    @Nullable
    @ODataField( odataName = "InspectionDeliveryCategory" )
    private String inspectionDeliveryCategory;
    /**
     * Use with available fluent helpers to apply the <b>InspectionDeliveryCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_DELIVERY_CATEGORY =
        new InspectionLotField<String>("InspectionDeliveryCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Route</b>
     * </p>
     *
     * @return Route
     */
    @SerializedName( "Route" )
    @JsonProperty( "Route" )
    @Nullable
    @ODataField( odataName = "Route" )
    private String route;
    /**
     * Use with available fluent helpers to apply the <b>Route</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> ROUTE = new InspectionLotField<String>("Route");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyCountry</b>
     * </p>
     *
     * @return Destination Country/Region
     */
    @SerializedName( "BillToPartyCountry" )
    @JsonProperty( "BillToPartyCountry" )
    @Nullable
    @ODataField( odataName = "BillToPartyCountry" )
    private String billToPartyCountry;
    /**
     * Use with available fluent helpers to apply the <b>BillToPartyCountry</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BILL_TO_PARTY_COUNTRY =
        new InspectionLotField<String>("BillToPartyCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Customer (Sold-To Party)
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SOLD_TO_PARTY = new InspectionLotField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SALES_ORGANIZATION =
        new InspectionLotField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Customer Material
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MATERIAL_BY_CUSTOMER =
        new InspectionLotField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> LANGUAGE = new InspectionLotField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrAddlRecordedCharc</b>
     * </p>
     *
     * @return Number of Characteristics Recorded Additionally
     */
    @SerializedName( "InspLotNmbrAddlRecordedCharc" )
    @JsonProperty( "InspLotNmbrAddlRecordedCharc" )
    @Nullable
    @ODataField( odataName = "InspLotNmbrAddlRecordedCharc" )
    private Short inspLotNmbrAddlRecordedCharc;
    /**
     * Use with available fluent helpers to apply the <b>InspLotNmbrAddlRecordedCharc</b> field to query operations.
     *
     */
    public final static InspectionLotField<Short> INSP_LOT_NMBR_ADDL_RECORDED_CHARC =
        new InspectionLotField<Short>("InspLotNmbrAddlRecordedCharc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrOpenShortTermCharc</b>
     * </p>
     *
     * @return Number of Outstanding Short-Term Chars That Require Confirm.
     */
    @SerializedName( "InspLotNmbrOpenShortTermCharc" )
    @JsonProperty( "InspLotNmbrOpenShortTermCharc" )
    @Nullable
    @ODataField( odataName = "InspLotNmbrOpenShortTermCharc" )
    private Short inspLotNmbrOpenShortTermCharc;
    /**
     * Use with available fluent helpers to apply the <b>InspLotNmbrOpenShortTermCharc</b> field to query operations.
     *
     */
    public final static InspectionLotField<Short> INSP_LOT_NMBR_OPEN_SHORT_TERM_CHARC =
        new InspectionLotField<Short>("InspLotNmbrOpenShortTermCharc");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotContainer</b>
     * </p>
     *
     * @return QM - No. of Containers
     */
    @SerializedName( "InspectionLotContainer" )
    @JsonProperty( "InspectionLotContainer" )
    @Nullable
    @ODataField( odataName = "InspectionLotContainer" )
    private BigDecimal inspectionLotContainer;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotContainer</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSPECTION_LOT_CONTAINER =
        new InspectionLotField<BigDecimal>("InspectionLotContainer");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotContainerUnit</b>
     * </p>
     *
     * @return Lot Container
     */
    @SerializedName( "InspectionLotContainerUnit" )
    @JsonProperty( "InspectionLotContainerUnit" )
    @Nullable
    @ODataField( odataName = "InspectionLotContainerUnit" )
    private String inspectionLotContainerUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotContainerUnit</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_CONTAINER_UNIT =
        new InspectionLotField<String>("InspectionLotContainerUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotSampleQuantity</b>
     * </p>
     *
     * @return Inspection Sample Size
     */
    @SerializedName( "InspectionLotSampleQuantity" )
    @JsonProperty( "InspectionLotSampleQuantity" )
    @Nullable
    @ODataField( odataName = "InspectionLotSampleQuantity" )
    private BigDecimal inspectionLotSampleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotSampleQuantity</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSPECTION_LOT_SAMPLE_QUANTITY =
        new InspectionLotField<BigDecimal>("InspectionLotSampleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotSampleUnit</b>
     * </p>
     *
     * @return Sample Unit of Measure
     */
    @SerializedName( "InspectionLotSampleUnit" )
    @JsonProperty( "InspectionLotSampleUnit" )
    @Nullable
    @ODataField( odataName = "InspectionLotSampleUnit" )
    private String inspectionLotSampleUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotSampleUnit</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_LOT_SAMPLE_UNIT =
        new InspectionLotField<String>("InspectionLotSampleUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @return Dynamic Modification Rule
     */
    @SerializedName( "InspLotDynamicRule" )
    @JsonProperty( "InspLotDynamicRule" )
    @Nullable
    @ODataField( odataName = "InspLotDynamicRule" )
    private String inspLotDynamicRule;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDynamicRule</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_DYNAMIC_RULE =
        new InspectionLotField<String>("InspLotDynamicRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicTrggrPoint</b>
     * </p>
     *
     * @return Time of Dynamic Modification in Inspection Lot
     */
    @SerializedName( "InspLotDynamicTrggrPoint" )
    @JsonProperty( "InspLotDynamicTrggrPoint" )
    @Nullable
    @ODataField( odataName = "InspLotDynamicTrggrPoint" )
    private String inspLotDynamicTrggrPoint;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDynamicTrggrPoint</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_DYNAMIC_TRGGR_POINT =
        new InspectionLotField<String>("InspLotDynamicTrggrPoint");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionDynamicStage</b>
     * </p>
     *
     * @return Inspection Stage
     */
    @SerializedName( "InspectionDynamicStage" )
    @JsonProperty( "InspectionDynamicStage" )
    @Nullable
    @ODataField( odataName = "InspectionDynamicStage" )
    private String inspectionDynamicStage;
    /**
     * Use with available fluent helpers to apply the <b>InspectionDynamicStage</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_DYNAMIC_STAGE =
        new InspectionLotField<String>("InspectionDynamicStage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSeverity</b>
     * </p>
     *
     * @return Inspection Severity
     */
    @SerializedName( "InspectionSeverity" )
    @JsonProperty( "InspectionSeverity" )
    @Nullable
    @ODataField( odataName = "InspectionSeverity" )
    private String inspectionSeverity;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSeverity</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSPECTION_SEVERITY =
        new InspectionLotField<String>("InspectionSeverity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToFree</b>
     * </p>
     *
     * @return Unrestricted-Use Stock
     */
    @SerializedName( "InspLotQtyToFree" )
    @JsonProperty( "InspLotQtyToFree" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToFree" )
    private BigDecimal inspLotQtyToFree;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToFree</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_FREE =
        new InspectionLotField<BigDecimal>("InspLotQtyToFree");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToScrap</b>
     * </p>
     *
     * @return Scrap Quantity
     */
    @SerializedName( "InspLotQtyToScrap" )
    @JsonProperty( "InspLotQtyToScrap" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToScrap" )
    private BigDecimal inspLotQtyToScrap;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToScrap</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_SCRAP =
        new InspectionLotField<BigDecimal>("InspLotQtyToScrap");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToSample</b>
     * </p>
     *
     * @return Quantity Posted to Sample
     */
    @SerializedName( "InspLotQtyToSample" )
    @JsonProperty( "InspLotQtyToSample" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToSample" )
    private BigDecimal inspLotQtyToSample;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToSample</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_SAMPLE =
        new InspectionLotField<BigDecimal>("InspLotQtyToSample");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToBlocked</b>
     * </p>
     *
     * @return Blocked Stock
     */
    @SerializedName( "InspLotQtyToBlocked" )
    @JsonProperty( "InspLotQtyToBlocked" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToBlocked" )
    private BigDecimal inspLotQtyToBlocked;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToBlocked</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_BLOCKED =
        new InspectionLotField<BigDecimal>("InspLotQtyToBlocked");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToReserves</b>
     * </p>
     *
     * @return Quantity Posted to Reserves
     */
    @SerializedName( "InspLotQtyToReserves" )
    @JsonProperty( "InspLotQtyToReserves" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToReserves" )
    private BigDecimal inspLotQtyToReserves;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToReserves</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_RESERVES =
        new InspectionLotField<BigDecimal>("InspLotQtyToReserves");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToAnotherMaterial</b>
     * </p>
     *
     * @return New Material
     */
    @SerializedName( "InspLotQtyToAnotherMaterial" )
    @JsonProperty( "InspLotQtyToAnotherMaterial" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToAnotherMaterial" )
    private BigDecimal inspLotQtyToAnotherMaterial;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToAnotherMaterial</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_ANOTHER_MATERIAL =
        new InspectionLotField<BigDecimal>("InspLotQtyToAnotherMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMaterialPostedTo</b>
     * </p>
     *
     * @return Material Posted To
     */
    @SerializedName( "InspLotMaterialPostedTo" )
    @JsonProperty( "InspLotMaterialPostedTo" )
    @Nullable
    @ODataField( odataName = "InspLotMaterialPostedTo" )
    private String inspLotMaterialPostedTo;
    /**
     * Use with available fluent helpers to apply the <b>InspLotMaterialPostedTo</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_MATERIAL_POSTED_TO =
        new InspectionLotField<String>("InspLotMaterialPostedTo");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotBatchTransferredTo</b>
     * </p>
     *
     * @return Batch Transferred To
     */
    @SerializedName( "InspLotBatchTransferredTo" )
    @JsonProperty( "InspLotBatchTransferredTo" )
    @Nullable
    @ODataField( odataName = "InspLotBatchTransferredTo" )
    private String inspLotBatchTransferredTo;
    /**
     * Use with available fluent helpers to apply the <b>InspLotBatchTransferredTo</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_BATCH_TRANSFERRED_TO =
        new InspectionLotField<String>("InspLotBatchTransferredTo");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyReturnedToSupplier</b>
     * </p>
     *
     * @return Return to Supplier
     */
    @SerializedName( "InspLotQtyReturnedToSupplier" )
    @JsonProperty( "InspLotQtyReturnedToSupplier" )
    @Nullable
    @ODataField( odataName = "InspLotQtyReturnedToSupplier" )
    private BigDecimal inspLotQtyReturnedToSupplier;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyReturnedToSupplier</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_RETURNED_TO_SUPPLIER =
        new InspectionLotField<BigDecimal>("InspLotQtyReturnedToSupplier");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToSpecialStock</b>
     * </p>
     *
     * @return Other Quantity
     */
    @SerializedName( "InspLotQtyToSpecialStock" )
    @JsonProperty( "InspLotQtyToSpecialStock" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToSpecialStock" )
    private BigDecimal inspLotQtyToSpecialStock;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToSpecialStock</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_SPECIAL_STOCK =
        new InspectionLotField<BigDecimal>("InspLotQtyToSpecialStock");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToOtherStock</b>
     * </p>
     *
     * @return Other Quantity 2
     */
    @SerializedName( "InspLotQtyToOtherStock" )
    @JsonProperty( "InspLotQtyToOtherStock" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToOtherStock" )
    private BigDecimal inspLotQtyToOtherStock;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToOtherStock</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_OTHER_STOCK =
        new InspectionLotField<BigDecimal>("InspLotQtyToOtherStock");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToBePosted</b>
     * </p>
     *
     * @return Quantity to Be Posted
     */
    @SerializedName( "InspLotQtyToBePosted" )
    @JsonProperty( "InspLotQtyToBePosted" )
    @Nullable
    @ODataField( odataName = "InspLotQtyToBePosted" )
    private BigDecimal inspLotQtyToBePosted;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyToBePosted</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_TO_BE_POSTED =
        new InspectionLotField<BigDecimal>("InspLotQtyToBePosted");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSmplQtyForLongTermChar</b>
     * </p>
     *
     * @return Long-Term Sample Quantity
     */
    @SerializedName( "InspLotSmplQtyForLongTermChar" )
    @JsonProperty( "InspLotSmplQtyForLongTermChar" )
    @Nullable
    @ODataField( odataName = "InspLotSmplQtyForLongTermChar" )
    private BigDecimal inspLotSmplQtyForLongTermChar;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSmplQtyForLongTermChar</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_SMPL_QTY_FOR_LONG_TERM_CHAR =
        new InspectionLotField<BigDecimal>("InspLotSmplQtyForLongTermChar");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyInspected</b>
     * </p>
     *
     * @return Inspected Quantity
     */
    @SerializedName( "InspLotQtyInspected" )
    @JsonProperty( "InspLotQtyInspected" )
    @Nullable
    @ODataField( odataName = "InspLotQtyInspected" )
    private BigDecimal inspLotQtyInspected;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyInspected</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_INSPECTED =
        new InspectionLotField<BigDecimal>("InspLotQtyInspected");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyDestroyed</b>
     * </p>
     *
     * @return Destroyed Quantity
     */
    @SerializedName( "InspLotQtyDestroyed" )
    @JsonProperty( "InspLotQtyDestroyed" )
    @Nullable
    @ODataField( odataName = "InspLotQtyDestroyed" )
    private BigDecimal inspLotQtyDestroyed;
    /**
     * Use with available fluent helpers to apply the <b>InspLotQtyDestroyed</b> field to query operations.
     *
     */
    public final static InspectionLotField<BigDecimal> INSP_LOT_QTY_DESTROYED =
        new InspectionLotField<BigDecimal>("InspLotQtyDestroyed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotScrapRatio</b>
     * </p>
     *
     * @return Share of Scrap in Inspection Lot
     */
    @SerializedName( "InspectionLotScrapRatio" )
    @JsonProperty( "InspectionLotScrapRatio" )
    @Nullable
    @ODataField( odataName = "InspectionLotScrapRatio" )
    private Double inspectionLotScrapRatio;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotScrapRatio</b> field to query operations.
     *
     */
    public final static InspectionLotField<Double> INSPECTION_LOT_SCRAP_RATIO =
        new InspectionLotField<Double>("InspectionLotScrapRatio");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionTool</b>
     * </p>
     *
     * @return Usage Decision Mode (UD Origin)
     */
    @SerializedName( "InspLotUsageDecisionTool" )
    @JsonProperty( "InspLotUsageDecisionTool" )
    @Nullable
    @ODataField( odataName = "InspLotUsageDecisionTool" )
    private String inspLotUsageDecisionTool;
    /**
     * Use with available fluent helpers to apply the <b>InspLotUsageDecisionTool</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_USAGE_DECISION_TOOL =
        new InspectionLotField<String>("InspLotUsageDecisionTool");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotAllowedScrapRatio</b>
     * </p>
     *
     * @return Allowed Share of Scrap
     */
    @SerializedName( "InspectionLotAllowedScrapRatio" )
    @JsonProperty( "InspectionLotAllowedScrapRatio" )
    @Nullable
    @ODataField( odataName = "InspectionLotAllowedScrapRatio" )
    private Double inspectionLotAllowedScrapRatio;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotAllowedScrapRatio</b> field to query operations.
     *
     */
    public final static InspectionLotField<Double> INSPECTION_LOT_ALLOWED_SCRAP_RATIO =
        new InspectionLotField<Double>("InspectionLotAllowedScrapRatio");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>QualityCostCollector</b>
     * </p>
     *
     * @return Order Number for Recording Appraisal Costs
     */
    @SerializedName( "QualityCostCollector" )
    @JsonProperty( "QualityCostCollector" )
    @Nullable
    @ODataField( odataName = "QualityCostCollector" )
    private String qualityCostCollector;
    /**
     * Use with available fluent helpers to apply the <b>QualityCostCollector</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> QUALITY_COST_COLLECTOR =
        new InspectionLotField<String>("QualityCostCollector");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @return Consumption posting
     */
    @SerializedName( "ConsumptionPosting" )
    @JsonProperty( "ConsumptionPosting" )
    @Nullable
    @ODataField( odataName = "ConsumptionPosting" )
    private String consumptionPosting;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionPosting</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> CONSUMPTION_POSTING =
        new InspectionLotField<String>("ConsumptionPosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new InspectionLotField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new InspectionLotField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotAcctAssgmtKey</b>
     * </p>
     *
     * @return Account Assignment Key: Inspection Lot
     */
    @SerializedName( "InspLotAcctAssgmtKey" )
    @JsonProperty( "InspLotAcctAssgmtKey" )
    @Nullable
    @ODataField( odataName = "InspLotAcctAssgmtKey" )
    private String inspLotAcctAssgmtKey;
    /**
     * Use with available fluent helpers to apply the <b>InspLotAcctAssgmtKey</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_ACCT_ASSGMT_KEY =
        new InspectionLotField<String>("InspLotAcctAssgmtKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> COST_CENTER = new InspectionLotField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation / Dependent Requirements
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> RESERVATION_ITEM = new InspectionLotField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MASTER_FIXED_ASSET =
        new InspectionLotField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> FIXED_ASSET = new InspectionLotField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrdStockWBSElement</b>
     * </p>
     *
     * @return Valuated Sales Order Stock WBS Element
     */
    @SerializedName( "SalesOrdStockWBSElement" )
    @JsonProperty( "SalesOrdStockWBSElement" )
    @Nullable
    @ODataField( odataName = "SalesOrdStockWBSElement" )
    private String salesOrdStockWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrdStockWBSElement</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SALES_ORD_STOCK_WBS_ELEMENT =
        new InspectionLotField<String>("SalesOrdStockWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PROJECT_NETWORK = new InspectionLotField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "NetworkActivityInternalID" )
    @JsonProperty( "NetworkActivityInternalID" )
    @Nullable
    @ODataField( odataName = "NetworkActivityInternalID" )
    private String networkActivityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivityInternalID</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> NETWORK_ACTIVITY_INTERNAL_ID =
        new InspectionLotField<String>("NetworkActivityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document
     */
    @SerializedName( "InventorySpclStkSalesDocument" )
    @JsonProperty( "InventorySpclStkSalesDocument" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocument" )
    private String inventorySpclStkSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocument</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INVENTORY_SPCL_STK_SALES_DOCUMENT =
        new InspectionLotField<String>("InventorySpclStkSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @return Sales Order Item of Valuated Sales Order Stock
     */
    @SerializedName( "InventorySpclStkSalesDocItm" )
    @JsonProperty( "InventorySpclStkSalesDocItm" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItm" )
    private String inventorySpclStkSalesDocItm;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItm</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM =
        new InspectionLotField<String>("InventorySpclStkSalesDocItm");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Deprecated: Profitability Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PROFITABILITY_SEGMENT =
        new InspectionLotField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> PROFIT_CENTER = new InspectionLotField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> BUSINESS_AREA = new InspectionLotField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> GL_ACCOUNT = new InspectionLotField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> CONTROLLING_AREA = new InspectionLotField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> COMPANY_CODE = new InspectionLotField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @return Serial Number Profile
     */
    @SerializedName( "SerialNumberProfile" )
    @JsonProperty( "SerialNumberProfile" )
    @Nullable
    @ODataField( odataName = "SerialNumberProfile" )
    private String serialNumberProfile;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberProfile</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> SERIAL_NUMBER_PROFILE =
        new InspectionLotField<String>("SerialNumberProfile");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorSalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "InspLotCostCollectorSalesOrder" )
    @JsonProperty( "InspLotCostCollectorSalesOrder" )
    @Nullable
    @ODataField( odataName = "InspLotCostCollectorSalesOrder" )
    private String inspLotCostCollectorSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>InspLotCostCollectorSalesOrder</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_COST_COLLECTOR_SALES_ORDER =
        new InspectionLotField<String>("InspLotCostCollectorSalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorSlsOrdItem</b>
     * </p>
     *
     * @return Item Number in Sales Order
     */
    @SerializedName( "InspLotCostCollectorSlsOrdItem" )
    @JsonProperty( "InspLotCostCollectorSlsOrdItem" )
    @Nullable
    @ODataField( odataName = "InspLotCostCollectorSlsOrdItem" )
    private String inspLotCostCollectorSlsOrdItem;
    /**
     * Use with available fluent helpers to apply the <b>InspLotCostCollectorSlsOrdItem</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_COST_COLLECTOR_SLS_ORD_ITEM =
        new InspectionLotField<String>("InspLotCostCollectorSlsOrdItem");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorWBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "InspLotCostCollectorWBSElement" )
    @JsonProperty( "InspLotCostCollectorWBSElement" )
    @Nullable
    @ODataField( odataName = "InspLotCostCollectorWBSElement" )
    private String inspLotCostCollectorWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>InspLotCostCollectorWBSElement</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_COST_COLLECTOR_WBS_ELEMENT =
        new InspectionLotField<String>("InspLotCostCollectorWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspLotExternalNumber</b>
     * </p>
     *
     * @return Inspection Document Number
     */
    @SerializedName( "InspLotExternalNumber" )
    @JsonProperty( "InspLotExternalNumber" )
    @Nullable
    @ODataField( odataName = "InspLotExternalNumber" )
    private String inspLotExternalNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspLotExternalNumber</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> INSP_LOT_EXTERNAL_NUMBER =
        new InspectionLotField<String>("InspLotExternalNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotPriorityPoints</b>
     * </p>
     *
     * @return Priority Points
     */
    @SerializedName( "InspectionLotPriorityPoints" )
    @JsonProperty( "InspectionLotPriorityPoints" )
    @Nullable
    @ODataField( odataName = "InspectionLotPriorityPoints" )
    private Integer inspectionLotPriorityPoints;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotPriorityPoints</b> field to query operations.
     *
     */
    public final static InspectionLotField<Integer> INSPECTION_LOT_PRIORITY_POINTS =
        new InspectionLotField<Integer>("InspectionLotPriorityPoints");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MAINTENANCE_PLAN = new InspectionLotField<String>("MaintenancePlan");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanItemIntID</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @SerializedName( "MaintenancePlanItemIntID" )
    @JsonProperty( "MaintenancePlanItemIntID" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanItemIntID" )
    private String maintenancePlanItemIntID;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanItemIntID</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MAINTENANCE_PLAN_ITEM_INT_ID =
        new InspectionLotField<String>("MaintenancePlanItemIntID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @return Maintenance Strategy
     */
    @SerializedName( "MaintenanceStrategy" )
    @JsonProperty( "MaintenanceStrategy" )
    @Nullable
    @ODataField( odataName = "MaintenanceStrategy" )
    private String maintenanceStrategy;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStrategy</b> field to query operations.
     *
     */
    public final static InspectionLotField<String> MAINTENANCE_STRATEGY =
        new InspectionLotField<String>("MaintenanceStrategy");
    /**
     * Navigation property <b>to_InspectionLotWithStatus</b> for <b>InspectionLot</b> to single
     * <b>InspectionLotWithStatus</b>.
     *
     */
    @SerializedName( "to_InspectionLotWithStatus" )
    @JsonProperty( "to_InspectionLotWithStatus" )
    @ODataField( odataName = "to_InspectionLotWithStatus" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InspectionLotWithStatus toInspectionLotWithStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_InspectionLotWithStatus</b> navigation property to query
     * operations.
     *
     */
    public final static InspectionLotOneToOneLink<InspectionLotWithStatus> TO_INSPECTION_LOT_WITH_STATUS =
        new InspectionLotOneToOneLink<InspectionLotWithStatus>("to_InspectionLotWithStatus");

    @Nonnull
    @Override
    public Class<InspectionLot> getType()
    {
        return InspectionLot.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotOrigin</b>
     * </p>
     *
     * @param inspectionLotOrigin
     *            Inspection Lot Origin
     */
    public void setInspectionLotOrigin( @Nullable final String inspectionLotOrigin )
    {
        rememberChangedField("InspectionLotOrigin", this.inspectionLotOrigin);
        this.inspectionLotOrigin = inspectionLotOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Routing number of operations in the order
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Order Number (Production Order)
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotText</b>
     * </p>
     *
     * @param inspectionLotText
     *            Inspection Lot Text
     */
    public void setInspectionLotText( @Nullable final String inspectionLotText )
    {
        rememberChangedField("InspectionLotText", this.inspectionLotText);
        this.inspectionLotText = inspectionLotText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotType</b>
     * </p>
     *
     * @param inspectionLotType
     *            Inspection Type
     */
    public void setInspectionLotType( @Nullable final String inspectionLotType )
    {
        rememberChangedField("InspectionLotType", this.inspectionLotType);
        this.inspectionLotType = inspectionLotType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQuantity</b>
     * </p>
     *
     * @param inspectionLotQuantity
     *            Inspection Lot Quantity
     */
    public void setInspectionLotQuantity( @Nullable final BigDecimal inspectionLotQuantity )
    {
        rememberChangedField("InspectionLotQuantity", this.inspectionLotQuantity);
        this.inspectionLotQuantity = inspectionLotQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotActualQuantity</b>
     * </p>
     *
     * @param inspectionLotActualQuantity
     *            Actual Lot Quantity
     */
    public void setInspectionLotActualQuantity( @Nullable final BigDecimal inspectionLotActualQuantity )
    {
        rememberChangedField("InspectionLotActualQuantity", this.inspectionLotActualQuantity);
        this.inspectionLotActualQuantity = inspectionLotActualQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDefectiveQuantity</b>
     * </p>
     *
     * @param inspectionLotDefectiveQuantity
     *            Defective Quantity
     */
    public void setInspectionLotDefectiveQuantity( @Nullable final BigDecimal inspectionLotDefectiveQuantity )
    {
        rememberChangedField("InspectionLotDefectiveQuantity", this.inspectionLotDefectiveQuantity);
        this.inspectionLotDefectiveQuantity = inspectionLotDefectiveQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQuantityUnit</b>
     * </p>
     *
     * @param inspectionLotQuantityUnit
     *            Base Unit of Measure for Inspection Lot Quantity
     */
    public void setInspectionLotQuantityUnit( @Nullable final String inspectionLotQuantityUnit )
    {
        rememberChangedField("InspectionLotQuantityUnit", this.inspectionLotQuantityUnit);
        this.inspectionLotQuantityUnit = inspectionLotQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCreatedOnLocalDate</b>
     * </p>
     *
     * @param inspLotCreatedOnLocalDate
     *            Date in Time Zone Where Lot Created
     */
    public void setInspLotCreatedOnLocalDate( @Nullable final LocalDateTime inspLotCreatedOnLocalDate )
    {
        rememberChangedField("InspLotCreatedOnLocalDate", this.inspLotCreatedOnLocalDate);
        this.inspLotCreatedOnLocalDate = inspLotCreatedOnLocalDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetFieldCombination</b>
     * </p>
     *
     * @param inspSubsetFieldCombination
     *            Identifier for Inspection Point Field Combination
     */
    public void setInspSubsetFieldCombination( @Nullable final String inspSubsetFieldCombination )
    {
        rememberChangedField("InspSubsetFieldCombination", this.inspSubsetFieldCombination);
        this.inspSubsetFieldCombination = inspSubsetFieldCombination;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrOpenLongTermCharc</b>
     * </p>
     *
     * @param inspLotNmbrOpenLongTermCharc
     *            Open Long-Term Characteristics
     */
    public void setInspLotNmbrOpenLongTermCharc( @Nullable final Short inspLotNmbrOpenLongTermCharc )
    {
        rememberChangedField("InspLotNmbrOpenLongTermCharc", this.inspLotNmbrOpenLongTermCharc);
        this.inspLotNmbrOpenLongTermCharc = inspLotNmbrOpenLongTermCharc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>StatusObject</b>
     * </p>
     *
     * @param statusObject
     *            Object Number
     */
    public void setStatusObject( @Nullable final String statusObject )
    {
        rememberChangedField("StatusObject", this.statusObject);
        this.statusObject = statusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StatusObjectCategory</b>
     * </p>
     *
     * @param statusObjectCategory
     *            Object Category
     */
    public void setStatusObjectCategory( @Nullable final String statusObjectCategory )
    {
        rememberChangedField("StatusObjectCategory", this.statusObjectCategory);
        this.statusObjectCategory = statusObjectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotObjectText</b>
     * </p>
     *
     * @param inspectionLotObjectText
     *            Short Text for Inspection Object
     */
    public void setInspectionLotObjectText( @Nullable final String inspectionLotObjectText )
    {
        rememberChangedField("InspectionLotObjectText", this.inspectionLotObjectText);
        this.inspectionLotObjectText = inspectionLotObjectText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StatusProfile</b>
     * </p>
     *
     * @param statusProfile
     *            Status Profile
     */
    public void setStatusProfile( @Nullable final String statusProfile )
    {
        rememberChangedField("StatusProfile", this.statusProfile);
        this.statusProfile = statusProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MatlQualityAuthorizationGroup</b>
     * </p>
     *
     * @param matlQualityAuthorizationGroup
     *            Material Authorization Group for Activities in QM
     */
    public void setMatlQualityAuthorizationGroup( @Nullable final String matlQualityAuthorizationGroup )
    {
        rememberChangedField("MatlQualityAuthorizationGroup", this.matlQualityAuthorizationGroup);
        this.matlQualityAuthorizationGroup = matlQualityAuthorizationGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasQuantity</b>
     * </p>
     *
     * @param inspectionLotHasQuantity
     *            Posted to Inspection Stock
     */
    public void setInspectionLotHasQuantity( @Nullable final Boolean inspectionLotHasQuantity )
    {
        rememberChangedField("InspectionLotHasQuantity", this.inspectionLotHasQuantity);
        this.inspectionLotHasQuantity = inspectionLotHasQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsCreatedAutomatically</b>
     * </p>
     *
     * @param inspLotIsCreatedAutomatically
     *            Inspection Lot Is Created Automatically
     */
    public void setInspLotIsCreatedAutomatically( @Nullable final Boolean inspLotIsCreatedAutomatically )
    {
        rememberChangedField("InspLotIsCreatedAutomatically", this.inspLotIsCreatedAutomatically);
        this.inspLotIsCreatedAutomatically = inspLotIsCreatedAutomatically;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasPartialLots</b>
     * </p>
     *
     * @param inspectionLotHasPartialLots
     *            Partial Lots Exist
     */
    public void setInspectionLotHasPartialLots( @Nullable final Boolean inspectionLotHasPartialLots )
    {
        rememberChangedField("InspectionLotHasPartialLots", this.inspectionLotHasPartialLots);
        this.inspectionLotHasPartialLots = inspectionLotHasPartialLots;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasAppraisalCosts</b>
     * </p>
     *
     * @param inspectionLotHasAppraisalCosts
     *            Record Appraisal Costs in Individual QM Order
     */
    public void setInspectionLotHasAppraisalCosts( @Nullable final Boolean inspectionLotHasAppraisalCosts )
    {
        rememberChangedField("InspectionLotHasAppraisalCosts", this.inspectionLotHasAppraisalCosts);
        this.inspectionLotHasAppraisalCosts = inspectionLotHasAppraisalCosts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasSubsets</b>
     * </p>
     *
     * @param inspLotHasSubsets
     *            Inspection with Inspection Points
     */
    public void setInspLotHasSubsets( @Nullable final Boolean inspLotHasSubsets )
    {
        rememberChangedField("InspLotHasSubsets", this.inspLotHasSubsets);
        this.inspLotHasSubsets = inspLotHasSubsets;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsAutomUsgeDcsnPossible</b>
     * </p>
     *
     * @param inspLotIsAutomUsgeDcsnPossible
     *            Automatic Usage Decision Planned
     */
    public void setInspLotIsAutomUsgeDcsnPossible( @Nullable final Boolean inspLotIsAutomUsgeDcsnPossible )
    {
        rememberChangedField("InspLotIsAutomUsgeDcsnPossible", this.inspLotIsAutomUsgeDcsnPossible);
        this.inspLotIsAutomUsgeDcsnPossible = inspLotIsAutomUsgeDcsnPossible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Source Inspection
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasConfignSpecification</b>
     * </p>
     *
     * @param inspLotHasConfignSpecification
     *            Inspection Specifications from Configuration
     */
    public void setInspLotHasConfignSpecification( @Nullable final Boolean inspLotHasConfignSpecification )
    {
        rememberChangedField("InspLotHasConfignSpecification", this.inspLotHasConfignSpecification);
        this.inspLotHasConfignSpecification = inspLotHasConfignSpecification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsMovedToBlkdStock</b>
     * </p>
     *
     * @param goodsReceiptIsMovedToBlkdStock
     *            GR Blocked Stock
     */
    public void setGoodsReceiptIsMovedToBlkdStock( @Nullable final String goodsReceiptIsMovedToBlkdStock )
    {
        rememberChangedField("GoodsReceiptIsMovedToBlkdStock", this.goodsReceiptIsMovedToBlkdStock);
        this.goodsReceiptIsMovedToBlkdStock = goodsReceiptIsMovedToBlkdStock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsDocumentationRequired</b>
     * </p>
     *
     * @param inspLotIsDocumentationRequired
     *            Documentation Required
     */
    public void setInspLotIsDocumentationRequired( @Nullable final Boolean inspLotIsDocumentationRequired )
    {
        rememberChangedField("InspLotIsDocumentationRequired", this.inspLotIsDocumentationRequired);
        this.inspLotIsDocumentationRequired = inspLotIsDocumentationRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsTaskListRequired</b>
     * </p>
     *
     * @param inspLotIsTaskListRequired
     *            Inspection Plan Required
     */
    public void setInspLotIsTaskListRequired( @Nullable final Boolean inspLotIsTaskListRequired )
    {
        rememberChangedField("InspLotIsTaskListRequired", this.inspLotIsTaskListRequired);
        this.inspLotIsTaskListRequired = inspLotIsTaskListRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasManualSampleSize</b>
     * </p>
     *
     * @param inspLotHasManualSampleSize
     *            Enter Sample Manually
     */
    public void setInspLotHasManualSampleSize( @Nullable final Boolean inspLotHasManualSampleSize )
    {
        rememberChangedField("InspLotHasManualSampleSize", this.inspLotHasManualSampleSize);
        this.inspLotHasManualSampleSize = inspLotHasManualSampleSize;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotHasMaterialSpec</b>
     * </p>
     *
     * @param inspLotHasMaterialSpec
     *            Inspect with Material Specification
     */
    public void setInspLotHasMaterialSpec( @Nullable final Boolean inspLotHasMaterialSpec )
    {
        rememberChangedField("InspLotHasMaterialSpec", this.inspLotHasMaterialSpec);
        this.inspLotHasMaterialSpec = inspLotHasMaterialSpec;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotApproval</b>
     * </p>
     *
     * @param inspectionLotApproval
     *            Inspection Lot Approval
     */
    public void setInspectionLotApproval( @Nullable final String inspectionLotApproval )
    {
        rememberChangedField("InspectionLotApproval", this.inspectionLotApproval);
        this.inspectionLotApproval = inspectionLotApproval;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDigitalSgntrResultsRecg</b>
     * </p>
     *
     * @param inspLotDigitalSgntrResultsRecg
     *            Digital Signature for Insp. Lot in Results Recording
     */
    public void setInspLotDigitalSgntrResultsRecg( @Nullable final String inspLotDigitalSgntrResultsRecg )
    {
        rememberChangedField("InspLotDigitalSgntrResultsRecg", this.inspLotDigitalSgntrResultsRecg);
        this.inspLotDigitalSgntrResultsRecg = inspLotDigitalSgntrResultsRecg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDigitalSgntrInUsgeDcsn</b>
     * </p>
     *
     * @param inspLotDigitalSgntrInUsgeDcsn
     *            Digital Signature Usage Decision
     */
    public void setInspLotDigitalSgntrInUsgeDcsn( @Nullable final String inspLotDigitalSgntrInUsgeDcsn )
    {
        rememberChangedField("InspLotDigitalSgntrInUsgeDcsn", this.inspLotDigitalSgntrInUsgeDcsn);
        this.inspLotDigitalSgntrInUsgeDcsn = inspLotDigitalSgntrInUsgeDcsn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsBatchRequired</b>
     * </p>
     *
     * @param inspLotIsBatchRequired
     *            Approved Batch Record Required
     */
    public void setInspLotIsBatchRequired( @Nullable final Boolean inspLotIsBatchRequired )
    {
        rememberChangedField("InspLotIsBatchRequired", this.inspLotIsBatchRequired);
        this.inspLotIsBatchRequired = inspLotIsBatchRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageInStabilityStudy</b>
     * </p>
     *
     * @param inspLotUsageInStabilityStudy
     *            Inspection Lot for Stability Study
     */
    public void setInspLotUsageInStabilityStudy( @Nullable final String inspLotUsageInStabilityStudy )
    {
        rememberChangedField("InspLotUsageInStabilityStudy", this.inspLotUsageInStabilityStudy);
        this.inspLotUsageInStabilityStudy = inspLotUsageInStabilityStudy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsStockPostingCompleted</b>
     * </p>
     *
     * @param inspLotIsStockPostingCompleted
     *            Stock Postings Completed
     */
    public void setInspLotIsStockPostingCompleted( @Nullable final Boolean inspLotIsStockPostingCompleted )
    {
        rememberChangedField("InspLotIsStockPostingCompleted", this.inspLotIsStockPostingCompleted);
        this.inspLotIsStockPostingCompleted = inspLotIsStockPostingCompleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotHasUsageDecision</b>
     * </p>
     *
     * @param inspectionLotHasUsageDecision
     *            Usage Decision Made
     */
    public void setInspectionLotHasUsageDecision( @Nullable final Boolean inspectionLotHasUsageDecision )
    {
        rememberChangedField("InspectionLotHasUsageDecision", this.inspectionLotHasUsageDecision);
        this.inspectionLotHasUsageDecision = inspectionLotHasUsageDecision;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfSerialNumbers</b>
     * </p>
     *
     * @param numberOfSerialNumbers
     *            Number of serial numbers
     */
    public void setNumberOfSerialNumbers( @Nullable final Integer numberOfSerialNumbers )
    {
        rememberChangedField("NumberOfSerialNumbers", this.numberOfSerialNumbers);
        this.numberOfSerialNumbers = numberOfSerialNumbers;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotIsSerialNmbrPossible</b>
     * </p>
     *
     * @param inspLotIsSerialNmbrPossible
     *            Serial Numbers Possible
     */
    public void setInspLotIsSerialNmbrPossible( @Nullable final Boolean inspLotIsSerialNmbrPossible )
    {
        rememberChangedField("InspLotIsSerialNmbrPossible", this.inspLotIsSerialNmbrPossible);
        this.inspLotIsSerialNmbrPossible = inspLotIsSerialNmbrPossible;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotIsSkipped</b>
     * </p>
     *
     * @param inspectionLotIsSkipped
     *            Skip Lot
     */
    public void setInspectionLotIsSkipped( @Nullable final Boolean inspectionLotIsSkipped )
    {
        rememberChangedField("InspectionLotIsSkipped", this.inspectionLotIsSkipped);
        this.inspectionLotIsSkipped = inspectionLotIsSkipped;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotIsFullInspection</b>
     * </p>
     *
     * @param inspectionLotIsFullInspection
     *            100% Inspection
     */
    public void setInspectionLotIsFullInspection( @Nullable final Boolean inspectionLotIsFullInspection )
    {
        rememberChangedField("InspectionLotIsFullInspection", this.inspectionLotIsFullInspection);
        this.inspectionLotIsFullInspection = inspectionLotIsFullInspection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDynamicLevel</b>
     * </p>
     *
     * @param inspectionLotDynamicLevel
     *            Level at Which Dynamic Modification Parameters Are Defined
     */
    public void setInspectionLotDynamicLevel( @Nullable final String inspectionLotDynamicLevel )
    {
        rememberChangedField("InspectionLotDynamicLevel", this.inspectionLotDynamicLevel);
        this.inspectionLotDynamicLevel = inspectionLotDynamicLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SamplingProcedure</b>
     * </p>
     *
     * @param samplingProcedure
     *            Sampling Procedure
     */
    public void setSamplingProcedure( @Nullable final String samplingProcedure )
    {
        rememberChangedField("SamplingProcedure", this.samplingProcedure);
        this.samplingProcedure = samplingProcedure;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCreatedOnLocalTime</b>
     * </p>
     *
     * @param inspLotCreatedOnLocalTime
     *            Time in Time Zone Where Lot Created
     */
    public void setInspLotCreatedOnLocalTime( @Nullable final LocalTime inspLotCreatedOnLocalTime )
    {
        rememberChangedField("InspLotCreatedOnLocalTime", this.inspLotCreatedOnLocalTime);
        this.inspLotCreatedOnLocalTime = inspLotCreatedOnLocalTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedBy</b>
     * </p>
     *
     * @param inspectionLotCreatedBy
     *            Name of User Who Created the Data Record
     */
    public void setInspectionLotCreatedBy( @Nullable final String inspectionLotCreatedBy )
    {
        rememberChangedField("InspectionLotCreatedBy", this.inspectionLotCreatedBy);
        this.inspectionLotCreatedBy = inspectionLotCreatedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedOn</b>
     * </p>
     *
     * @param inspectionLotCreatedOn
     *            System Date on Which Data Record Was Created
     */
    public void setInspectionLotCreatedOn( @Nullable final LocalDateTime inspectionLotCreatedOn )
    {
        rememberChangedField("InspectionLotCreatedOn", this.inspectionLotCreatedOn);
        this.inspectionLotCreatedOn = inspectionLotCreatedOn;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotCreatedOnTime</b>
     * </p>
     *
     * @param inspectionLotCreatedOnTime
     *            System Time of Creation
     */
    public void setInspectionLotCreatedOnTime( @Nullable final LocalTime inspectionLotCreatedOnTime )
    {
        rememberChangedField("InspectionLotCreatedOnTime", this.inspectionLotCreatedOnTime);
        this.inspectionLotCreatedOnTime = inspectionLotCreatedOnTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangedBy</b>
     * </p>
     *
     * @param inspectionLotChangedBy
     *            Name of User Who Last Changed Data Record
     */
    public void setInspectionLotChangedBy( @Nullable final String inspectionLotChangedBy )
    {
        rememberChangedField("InspectionLotChangedBy", this.inspectionLotChangedBy);
        this.inspectionLotChangedBy = inspectionLotChangedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangeDate</b>
     * </p>
     *
     * @param inspectionLotChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setInspectionLotChangeDate( @Nullable final LocalDateTime inspectionLotChangeDate )
    {
        rememberChangedField("InspectionLotChangeDate", this.inspectionLotChangeDate);
        this.inspectionLotChangeDate = inspectionLotChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotChangeTime</b>
     * </p>
     *
     * @param inspectionLotChangeTime
     *            System Time of Change
     */
    public void setInspectionLotChangeTime( @Nullable final LocalTime inspectionLotChangeTime )
    {
        rememberChangedField("InspectionLotChangeTime", this.inspectionLotChangeTime);
        this.inspectionLotChangeTime = inspectionLotChangeTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStartDate</b>
     * </p>
     *
     * @param inspectionLotStartDate
     *            Start Date of Inspection in Local Time Zone
     */
    public void setInspectionLotStartDate( @Nullable final LocalDateTime inspectionLotStartDate )
    {
        rememberChangedField("InspectionLotStartDate", this.inspectionLotStartDate);
        this.inspectionLotStartDate = inspectionLotStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStartTime</b>
     * </p>
     *
     * @param inspectionLotStartTime
     *            Inspection Started At
     */
    public void setInspectionLotStartTime( @Nullable final LocalTime inspectionLotStartTime )
    {
        rememberChangedField("InspectionLotStartTime", this.inspectionLotStartTime);
        this.inspectionLotStartTime = inspectionLotStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotEndDate</b>
     * </p>
     *
     * @param inspectionLotEndDate
     *            End Date of Inspection in Local Time Zone
     */
    public void setInspectionLotEndDate( @Nullable final LocalDateTime inspectionLotEndDate )
    {
        rememberChangedField("InspectionLotEndDate", this.inspectionLotEndDate);
        this.inspectionLotEndDate = inspectionLotEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotEndTime</b>
     * </p>
     *
     * @param inspectionLotEndTime
     *            Inspection Ended At
     */
    public void setInspectionLotEndTime( @Nullable final LocalTime inspectionLotEndTime )
    {
        rememberChangedField("InspectionLotEndTime", this.inspectionLotEndTime);
        this.inspectionLotEndTime = inspectionLotEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @param billOfOperationsType
     *            Bill of Operations Type
     */
    public void setBillOfOperationsType( @Nullable final String billOfOperationsType )
    {
        rememberChangedField("BillOfOperationsType", this.billOfOperationsType);
        this.billOfOperationsType = billOfOperationsType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @param billOfOperationsGroup
     *            Bill of Operations Group
     */
    public void setBillOfOperationsGroup( @Nullable final String billOfOperationsGroup )
    {
        rememberChangedField("BillOfOperationsGroup", this.billOfOperationsGroup);
        this.billOfOperationsGroup = billOfOperationsGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @param billOfOperationsUsage
     *            Bill of Operations Usage
     */
    public void setBillOfOperationsUsage( @Nullable final String billOfOperationsUsage )
    {
        rememberChangedField("BillOfOperationsUsage", this.billOfOperationsUsage);
        this.billOfOperationsUsage = billOfOperationsUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVariant</b>
     * </p>
     *
     * @param billOfOperationsVariant
     *            Bill of Operations Group Counter
     */
    public void setBillOfOperationsVariant( @Nullable final String billOfOperationsVariant )
    {
        rememberChangedField("BillOfOperationsVariant", this.billOfOperationsVariant);
        this.billOfOperationsVariant = billOfOperationsVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsChangeStateID</b>
     * </p>
     *
     * @param billOfOperationsChangeStateID
     *            Internal counter
     */
    public void setBillOfOperationsChangeStateID( @Nullable final String billOfOperationsChangeStateID )
    {
        rememberChangedField("BillOfOperationsChangeStateID", this.billOfOperationsChangeStateID);
        this.billOfOperationsChangeStateID = billOfOperationsChangeStateID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetType</b>
     * </p>
     *
     * @param inspectionSubsetType
     *            Inspection Point Type
     */
    public void setInspectionSubsetType( @Nullable final String inspectionSubsetType )
    {
        rememberChangedField("InspectionSubsetType", this.inspectionSubsetType);
        this.inspectionSubsetType = inspectionSubsetType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedure</b>
     * </p>
     *
     * @param smplDrawingProcedure
     *            Sample-Drawing Procedure
     */
    public void setSmplDrawingProcedure( @Nullable final String smplDrawingProcedure )
    {
        rememberChangedField("SmplDrawingProcedure", this.smplDrawingProcedure);
        this.smplDrawingProcedure = smplDrawingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedureVersion</b>
     * </p>
     *
     * @param smplDrawingProcedureVersion
     *            Version No. of the Sample-Drawing Procedure
     */
    public void setSmplDrawingProcedureVersion( @Nullable final String smplDrawingProcedureVersion )
    {
        rememberChangedField("SmplDrawingProcedureVersion", this.smplDrawingProcedureVersion);
        this.smplDrawingProcedureVersion = smplDrawingProcedureVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrwgProcedIsConfRequired</b>
     * </p>
     *
     * @param smplDrwgProcedIsConfRequired
     *            Confirmation Required for Sample Drawing
     */
    public void setSmplDrwgProcedIsConfRequired( @Nullable final Boolean smplDrwgProcedIsConfRequired )
    {
        rememberChangedField("SmplDrwgProcedIsConfRequired", this.smplDrwgProcedIsConfRequired);
        this.smplDrwgProcedIsConfRequired = smplDrwgProcedIsConfRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionMaterial</b>
     * </p>
     *
     * @param inspLotSelectionMaterial
     *            Material Number
     */
    public void setInspLotSelectionMaterial( @Nullable final String inspLotSelectionMaterial )
    {
        rememberChangedField("InspLotSelectionMaterial", this.inspLotSelectionMaterial);
        this.inspLotSelectionMaterial = inspLotSelectionMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelMatlRevisionLvl</b>
     * </p>
     *
     * @param inspLotSelMatlRevisionLvl
     *            Revision Level
     */
    public void setInspLotSelMatlRevisionLvl( @Nullable final String inspLotSelMatlRevisionLvl )
    {
        rememberChangedField("InspLotSelMatlRevisionLvl", this.inspLotSelMatlRevisionLvl);
        this.inspLotSelMatlRevisionLvl = inspLotSelMatlRevisionLvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionPlant</b>
     * </p>
     *
     * @param inspLotSelectionPlant
     *            Plant
     */
    public void setInspLotSelectionPlant( @Nullable final String inspLotSelectionPlant )
    {
        rememberChangedField("InspLotSelectionPlant", this.inspLotSelectionPlant);
        this.inspLotSelectionPlant = inspLotSelectionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionSupplier</b>
     * </p>
     *
     * @param inspLotSelectionSupplier
     *            Supplier's Account Number
     */
    public void setInspLotSelectionSupplier( @Nullable final String inspLotSelectionSupplier )
    {
        rememberChangedField("InspLotSelectionSupplier", this.inspLotSelectionSupplier);
        this.inspLotSelectionSupplier = inspLotSelectionSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionManufacturer</b>
     * </p>
     *
     * @param inspLotSelectionManufacturer
     *            Number of Manufacturer
     */
    public void setInspLotSelectionManufacturer( @Nullable final String inspLotSelectionManufacturer )
    {
        rememberChangedField("InspLotSelectionManufacturer", this.inspLotSelectionManufacturer);
        this.inspLotSelectionManufacturer = inspLotSelectionManufacturer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionCustomer</b>
     * </p>
     *
     * @param inspLotSelectionCustomer
     *            Account number of customer
     */
    public void setInspLotSelectionCustomer( @Nullable final String inspLotSelectionCustomer )
    {
        rememberChangedField("InspLotSelectionCustomer", this.inspLotSelectionCustomer);
        this.inspLotSelectionCustomer = inspLotSelectionCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelBillOfOperationsUsge</b>
     * </p>
     *
     * @param inspLotSelBillOfOperationsUsge
     *            Task List Usage
     */
    public void setInspLotSelBillOfOperationsUsge( @Nullable final String inspLotSelBillOfOperationsUsge )
    {
        rememberChangedField("InspLotSelBillOfOperationsUsge", this.inspLotSelBillOfOperationsUsge);
        this.inspLotSelBillOfOperationsUsge = inspLotSelBillOfOperationsUsge;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSelectionValidFromDate</b>
     * </p>
     *
     * @param inspLotSelectionValidFromDate
     *            Key Date for Selecting Records or Changing Task Lists
     */
    public void setInspLotSelectionValidFromDate( @Nullable final LocalDateTime inspLotSelectionValidFromDate )
    {
        rememberChangedField("InspLotSelectionValidFromDate", this.inspLotSelectionValidFromDate);
        this.inspLotSelectionValidFromDate = inspLotSelectionValidFromDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SalesOperationsPlanningOrder</b>
     * </p>
     *
     * @param salesOperationsPlanningOrder
     *            Run Schedule Header
     */
    public void setSalesOperationsPlanningOrder( @Nullable final String salesOperationsPlanningOrder )
    {
        rememberChangedField("SalesOperationsPlanningOrder", this.salesOperationsPlanningOrder);
        this.salesOperationsPlanningOrder = salesOperationsPlanningOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @param isBusinessPurposeCompleted
     *            Business Purpose Completed Flag
     */
    public void setIsBusinessPurposeCompleted( @Nullable final String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer (Ship-To Party)
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BatchBySupplier</b>
     * </p>
     *
     * @param batchBySupplier
     *            Supplier Batch Number
     */
    public void setBatchBySupplier( @Nullable final String batchBySupplier )
    {
        rememberChangedField("BatchBySupplier", this.batchBySupplier);
        this.batchBySupplier = batchBySupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @param manufacturer
     *            Number of Manufacturer
     */
    public void setManufacturer( @Nullable final String manufacturer )
    {
        rememberChangedField("Manufacturer", this.manufacturer);
        this.manufacturer = manufacturer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @param manufacturerPartNmbr
     *            Manufacturer Material
     */
    public void setManufacturerPartNmbr( @Nullable final String manufacturerPartNmbr )
    {
        rememberChangedField("ManufacturerPartNmbr", this.manufacturerPartNmbr);
        this.manufacturerPartNmbr = manufacturerPartNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @param materialRevisionLevel
     *            Revision Level
     */
    public void setMaterialRevisionLevel( @Nullable final String materialRevisionLevel )
    {
        rememberChangedField("MaterialRevisionLevel", this.materialRevisionLevel);
        this.materialRevisionLevel = materialRevisionLevel;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsBatchManaged</b>
     * </p>
     *
     * @param materialIsBatchManaged
     *            Batch Required
     */
    public void setMaterialIsBatchManaged( @Nullable final Boolean materialIsBatchManaged )
    {
        rememberChangedField("MaterialIsBatchManaged", this.materialIsBatchManaged);
        this.materialIsBatchManaged = materialIsBatchManaged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BatchStorageLocation</b>
     * </p>
     *
     * @param batchStorageLocation
     *            Storage Location for Batch
     */
    public void setBatchStorageLocation( @Nullable final String batchStorageLocation )
    {
        rememberChangedField("BatchStorageLocation", this.batchStorageLocation);
        this.batchStorageLocation = batchStorageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsSpecialStock</b>
     * </p>
     *
     * @param materialCompIsSpecialStock
     *            Special Stock Indicator
     */
    public void setMaterialCompIsSpecialStock( @Nullable final String materialCompIsSpecialStock )
    {
        rememberChangedField("MaterialCompIsSpecialStock", this.materialCompIsSpecialStock);
        this.materialCompIsSpecialStock = materialCompIsSpecialStock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Document Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlDocLatestPostgDate</b>
     * </p>
     *
     * @param matlDocLatestPostgDate
     *            Posting Date in the Document
     */
    public void setMatlDocLatestPostgDate( @Nullable final LocalDateTime matlDocLatestPostgDate )
    {
        rememberChangedField("MatlDocLatestPostgDate", this.matlDocLatestPostgDate);
        this.matlDocLatestPostgDate = matlDocLatestPostgDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotPlant</b>
     * </p>
     *
     * @param inspectionLotPlant
     *            Plant for Inspection Lot
     */
    public void setInspectionLotPlant( @Nullable final String inspectionLotPlant )
    {
        rememberChangedField("InspectionLotPlant", this.inspectionLotPlant);
        this.inspectionLotPlant = inspectionLotPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStorageLocation</b>
     * </p>
     *
     * @param inspectionLotStorageLocation
     *            Storage Location for Inspection Lot Stock
     */
    public void setInspectionLotStorageLocation( @Nullable final String inspectionLotStorageLocation )
    {
        rememberChangedField("InspectionLotStorageLocation", this.inspectionLotStorageLocation);
        this.inspectionLotStorageLocation = inspectionLotStorageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number / Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery Document
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            Delivery Document Item
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCategory</b>
     * </p>
     *
     * @param deliveryCategory
     *            Delivery Category
     */
    public void setDeliveryCategory( @Nullable final String deliveryCategory )
    {
        rememberChangedField("DeliveryCategory", this.deliveryCategory);
        this.deliveryCategory = deliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionDeliveryCategory</b>
     * </p>
     *
     * @param inspectionDeliveryCategory
     *            Delivery Category
     */
    public void setInspectionDeliveryCategory( @Nullable final String inspectionDeliveryCategory )
    {
        rememberChangedField("InspectionDeliveryCategory", this.inspectionDeliveryCategory);
        this.inspectionDeliveryCategory = inspectionDeliveryCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Route</b>
     * </p>
     *
     * @param route
     *            Route
     */
    public void setRoute( @Nullable final String route )
    {
        rememberChangedField("Route", this.route);
        this.route = route;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyCountry</b>
     * </p>
     *
     * @param billToPartyCountry
     *            Destination Country/Region
     */
    public void setBillToPartyCountry( @Nullable final String billToPartyCountry )
    {
        rememberChangedField("BillToPartyCountry", this.billToPartyCountry);
        this.billToPartyCountry = billToPartyCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Customer (Sold-To Party)
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Customer Material
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrAddlRecordedCharc</b>
     * </p>
     *
     * @param inspLotNmbrAddlRecordedCharc
     *            Number of Characteristics Recorded Additionally
     */
    public void setInspLotNmbrAddlRecordedCharc( @Nullable final Short inspLotNmbrAddlRecordedCharc )
    {
        rememberChangedField("InspLotNmbrAddlRecordedCharc", this.inspLotNmbrAddlRecordedCharc);
        this.inspLotNmbrAddlRecordedCharc = inspLotNmbrAddlRecordedCharc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotNmbrOpenShortTermCharc</b>
     * </p>
     *
     * @param inspLotNmbrOpenShortTermCharc
     *            Number of Outstanding Short-Term Chars That Require Confirm.
     */
    public void setInspLotNmbrOpenShortTermCharc( @Nullable final Short inspLotNmbrOpenShortTermCharc )
    {
        rememberChangedField("InspLotNmbrOpenShortTermCharc", this.inspLotNmbrOpenShortTermCharc);
        this.inspLotNmbrOpenShortTermCharc = inspLotNmbrOpenShortTermCharc;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotContainer</b>
     * </p>
     *
     * @param inspectionLotContainer
     *            QM - No. of Containers
     */
    public void setInspectionLotContainer( @Nullable final BigDecimal inspectionLotContainer )
    {
        rememberChangedField("InspectionLotContainer", this.inspectionLotContainer);
        this.inspectionLotContainer = inspectionLotContainer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotContainerUnit</b>
     * </p>
     *
     * @param inspectionLotContainerUnit
     *            Lot Container
     */
    public void setInspectionLotContainerUnit( @Nullable final String inspectionLotContainerUnit )
    {
        rememberChangedField("InspectionLotContainerUnit", this.inspectionLotContainerUnit);
        this.inspectionLotContainerUnit = inspectionLotContainerUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotSampleQuantity</b>
     * </p>
     *
     * @param inspectionLotSampleQuantity
     *            Inspection Sample Size
     */
    public void setInspectionLotSampleQuantity( @Nullable final BigDecimal inspectionLotSampleQuantity )
    {
        rememberChangedField("InspectionLotSampleQuantity", this.inspectionLotSampleQuantity);
        this.inspectionLotSampleQuantity = inspectionLotSampleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotSampleUnit</b>
     * </p>
     *
     * @param inspectionLotSampleUnit
     *            Sample Unit of Measure
     */
    public void setInspectionLotSampleUnit( @Nullable final String inspectionLotSampleUnit )
    {
        rememberChangedField("InspectionLotSampleUnit", this.inspectionLotSampleUnit);
        this.inspectionLotSampleUnit = inspectionLotSampleUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @param inspLotDynamicRule
     *            Dynamic Modification Rule
     */
    public void setInspLotDynamicRule( @Nullable final String inspLotDynamicRule )
    {
        rememberChangedField("InspLotDynamicRule", this.inspLotDynamicRule);
        this.inspLotDynamicRule = inspLotDynamicRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicTrggrPoint</b>
     * </p>
     *
     * @param inspLotDynamicTrggrPoint
     *            Time of Dynamic Modification in Inspection Lot
     */
    public void setInspLotDynamicTrggrPoint( @Nullable final String inspLotDynamicTrggrPoint )
    {
        rememberChangedField("InspLotDynamicTrggrPoint", this.inspLotDynamicTrggrPoint);
        this.inspLotDynamicTrggrPoint = inspLotDynamicTrggrPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionDynamicStage</b>
     * </p>
     *
     * @param inspectionDynamicStage
     *            Inspection Stage
     */
    public void setInspectionDynamicStage( @Nullable final String inspectionDynamicStage )
    {
        rememberChangedField("InspectionDynamicStage", this.inspectionDynamicStage);
        this.inspectionDynamicStage = inspectionDynamicStage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSeverity</b>
     * </p>
     *
     * @param inspectionSeverity
     *            Inspection Severity
     */
    public void setInspectionSeverity( @Nullable final String inspectionSeverity )
    {
        rememberChangedField("InspectionSeverity", this.inspectionSeverity);
        this.inspectionSeverity = inspectionSeverity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToFree</b>
     * </p>
     *
     * @param inspLotQtyToFree
     *            Unrestricted-Use Stock
     */
    public void setInspLotQtyToFree( @Nullable final BigDecimal inspLotQtyToFree )
    {
        rememberChangedField("InspLotQtyToFree", this.inspLotQtyToFree);
        this.inspLotQtyToFree = inspLotQtyToFree;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToScrap</b>
     * </p>
     *
     * @param inspLotQtyToScrap
     *            Scrap Quantity
     */
    public void setInspLotQtyToScrap( @Nullable final BigDecimal inspLotQtyToScrap )
    {
        rememberChangedField("InspLotQtyToScrap", this.inspLotQtyToScrap);
        this.inspLotQtyToScrap = inspLotQtyToScrap;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToSample</b>
     * </p>
     *
     * @param inspLotQtyToSample
     *            Quantity Posted to Sample
     */
    public void setInspLotQtyToSample( @Nullable final BigDecimal inspLotQtyToSample )
    {
        rememberChangedField("InspLotQtyToSample", this.inspLotQtyToSample);
        this.inspLotQtyToSample = inspLotQtyToSample;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToBlocked</b>
     * </p>
     *
     * @param inspLotQtyToBlocked
     *            Blocked Stock
     */
    public void setInspLotQtyToBlocked( @Nullable final BigDecimal inspLotQtyToBlocked )
    {
        rememberChangedField("InspLotQtyToBlocked", this.inspLotQtyToBlocked);
        this.inspLotQtyToBlocked = inspLotQtyToBlocked;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToReserves</b>
     * </p>
     *
     * @param inspLotQtyToReserves
     *            Quantity Posted to Reserves
     */
    public void setInspLotQtyToReserves( @Nullable final BigDecimal inspLotQtyToReserves )
    {
        rememberChangedField("InspLotQtyToReserves", this.inspLotQtyToReserves);
        this.inspLotQtyToReserves = inspLotQtyToReserves;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToAnotherMaterial</b>
     * </p>
     *
     * @param inspLotQtyToAnotherMaterial
     *            New Material
     */
    public void setInspLotQtyToAnotherMaterial( @Nullable final BigDecimal inspLotQtyToAnotherMaterial )
    {
        rememberChangedField("InspLotQtyToAnotherMaterial", this.inspLotQtyToAnotherMaterial);
        this.inspLotQtyToAnotherMaterial = inspLotQtyToAnotherMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspLotMaterialPostedTo</b>
     * </p>
     *
     * @param inspLotMaterialPostedTo
     *            Material Posted To
     */
    public void setInspLotMaterialPostedTo( @Nullable final String inspLotMaterialPostedTo )
    {
        rememberChangedField("InspLotMaterialPostedTo", this.inspLotMaterialPostedTo);
        this.inspLotMaterialPostedTo = inspLotMaterialPostedTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotBatchTransferredTo</b>
     * </p>
     *
     * @param inspLotBatchTransferredTo
     *            Batch Transferred To
     */
    public void setInspLotBatchTransferredTo( @Nullable final String inspLotBatchTransferredTo )
    {
        rememberChangedField("InspLotBatchTransferredTo", this.inspLotBatchTransferredTo);
        this.inspLotBatchTransferredTo = inspLotBatchTransferredTo;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyReturnedToSupplier</b>
     * </p>
     *
     * @param inspLotQtyReturnedToSupplier
     *            Return to Supplier
     */
    public void setInspLotQtyReturnedToSupplier( @Nullable final BigDecimal inspLotQtyReturnedToSupplier )
    {
        rememberChangedField("InspLotQtyReturnedToSupplier", this.inspLotQtyReturnedToSupplier);
        this.inspLotQtyReturnedToSupplier = inspLotQtyReturnedToSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToSpecialStock</b>
     * </p>
     *
     * @param inspLotQtyToSpecialStock
     *            Other Quantity
     */
    public void setInspLotQtyToSpecialStock( @Nullable final BigDecimal inspLotQtyToSpecialStock )
    {
        rememberChangedField("InspLotQtyToSpecialStock", this.inspLotQtyToSpecialStock);
        this.inspLotQtyToSpecialStock = inspLotQtyToSpecialStock;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToOtherStock</b>
     * </p>
     *
     * @param inspLotQtyToOtherStock
     *            Other Quantity 2
     */
    public void setInspLotQtyToOtherStock( @Nullable final BigDecimal inspLotQtyToOtherStock )
    {
        rememberChangedField("InspLotQtyToOtherStock", this.inspLotQtyToOtherStock);
        this.inspLotQtyToOtherStock = inspLotQtyToOtherStock;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyToBePosted</b>
     * </p>
     *
     * @param inspLotQtyToBePosted
     *            Quantity to Be Posted
     */
    public void setInspLotQtyToBePosted( @Nullable final BigDecimal inspLotQtyToBePosted )
    {
        rememberChangedField("InspLotQtyToBePosted", this.inspLotQtyToBePosted);
        this.inspLotQtyToBePosted = inspLotQtyToBePosted;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSmplQtyForLongTermChar</b>
     * </p>
     *
     * @param inspLotSmplQtyForLongTermChar
     *            Long-Term Sample Quantity
     */
    public void setInspLotSmplQtyForLongTermChar( @Nullable final BigDecimal inspLotSmplQtyForLongTermChar )
    {
        rememberChangedField("InspLotSmplQtyForLongTermChar", this.inspLotSmplQtyForLongTermChar);
        this.inspLotSmplQtyForLongTermChar = inspLotSmplQtyForLongTermChar;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyInspected</b>
     * </p>
     *
     * @param inspLotQtyInspected
     *            Inspected Quantity
     */
    public void setInspLotQtyInspected( @Nullable final BigDecimal inspLotQtyInspected )
    {
        rememberChangedField("InspLotQtyInspected", this.inspLotQtyInspected);
        this.inspLotQtyInspected = inspLotQtyInspected;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotQtyDestroyed</b>
     * </p>
     *
     * @param inspLotQtyDestroyed
     *            Destroyed Quantity
     */
    public void setInspLotQtyDestroyed( @Nullable final BigDecimal inspLotQtyDestroyed )
    {
        rememberChangedField("InspLotQtyDestroyed", this.inspLotQtyDestroyed);
        this.inspLotQtyDestroyed = inspLotQtyDestroyed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotScrapRatio</b>
     * </p>
     *
     * @param inspectionLotScrapRatio
     *            Share of Scrap in Inspection Lot
     */
    public void setInspectionLotScrapRatio( @Nullable final Double inspectionLotScrapRatio )
    {
        rememberChangedField("InspectionLotScrapRatio", this.inspectionLotScrapRatio);
        this.inspectionLotScrapRatio = inspectionLotScrapRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotUsageDecisionTool</b>
     * </p>
     *
     * @param inspLotUsageDecisionTool
     *            Usage Decision Mode (UD Origin)
     */
    public void setInspLotUsageDecisionTool( @Nullable final String inspLotUsageDecisionTool )
    {
        rememberChangedField("InspLotUsageDecisionTool", this.inspLotUsageDecisionTool);
        this.inspLotUsageDecisionTool = inspLotUsageDecisionTool;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotAllowedScrapRatio</b>
     * </p>
     *
     * @param inspectionLotAllowedScrapRatio
     *            Allowed Share of Scrap
     */
    public void setInspectionLotAllowedScrapRatio( @Nullable final Double inspectionLotAllowedScrapRatio )
    {
        rememberChangedField("InspectionLotAllowedScrapRatio", this.inspectionLotAllowedScrapRatio);
        this.inspectionLotAllowedScrapRatio = inspectionLotAllowedScrapRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>QualityCostCollector</b>
     * </p>
     *
     * @param qualityCostCollector
     *            Order Number for Recording Appraisal Costs
     */
    public void setQualityCostCollector( @Nullable final String qualityCostCollector )
    {
        rememberChangedField("QualityCostCollector", this.qualityCostCollector);
        this.qualityCostCollector = qualityCostCollector;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @param consumptionPosting
     *            Consumption posting
     */
    public void setConsumptionPosting( @Nullable final String consumptionPosting )
    {
        rememberChangedField("ConsumptionPosting", this.consumptionPosting);
        this.consumptionPosting = consumptionPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotAcctAssgmtKey</b>
     * </p>
     *
     * @param inspLotAcctAssgmtKey
     *            Account Assignment Key: Inspection Lot
     */
    public void setInspLotAcctAssgmtKey( @Nullable final String inspLotAcctAssgmtKey )
    {
        rememberChangedField("InspLotAcctAssgmtKey", this.inspLotAcctAssgmtKey);
        this.inspLotAcctAssgmtKey = inspLotAcctAssgmtKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrdStockWBSElement</b>
     * </p>
     *
     * @param salesOrdStockWBSElement
     *            Valuated Sales Order Stock WBS Element
     */
    public void setSalesOrdStockWBSElement( @Nullable final String salesOrdStockWBSElement )
    {
        rememberChangedField("SalesOrdStockWBSElement", this.salesOrdStockWBSElement);
        this.salesOrdStockWBSElement = salesOrdStockWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @param networkActivityInternalID
     *            Internal counter
     */
    public void setNetworkActivityInternalID( @Nullable final String networkActivityInternalID )
    {
        rememberChangedField("NetworkActivityInternalID", this.networkActivityInternalID);
        this.networkActivityInternalID = networkActivityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Special Stock Sales Document
     */
    public void setInventorySpclStkSalesDocument( @Nullable final String inventorySpclStkSalesDocument )
    {
        rememberChangedField("InventorySpclStkSalesDocument", this.inventorySpclStkSalesDocument);
        this.inventorySpclStkSalesDocument = inventorySpclStkSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItm
     *            Sales Order Item of Valuated Sales Order Stock
     */
    public void setInventorySpclStkSalesDocItm( @Nullable final String inventorySpclStkSalesDocItm )
    {
        rememberChangedField("InventorySpclStkSalesDocItm", this.inventorySpclStkSalesDocItm);
        this.inventorySpclStkSalesDocItm = inventorySpclStkSalesDocItm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Deprecated: Profitability Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @param serialNumberProfile
     *            Serial Number Profile
     */
    public void setSerialNumberProfile( @Nullable final String serialNumberProfile )
    {
        rememberChangedField("SerialNumberProfile", this.serialNumberProfile);
        this.serialNumberProfile = serialNumberProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorSalesOrder</b>
     * </p>
     *
     * @param inspLotCostCollectorSalesOrder
     *            Sales Order Number
     */
    public void setInspLotCostCollectorSalesOrder( @Nullable final String inspLotCostCollectorSalesOrder )
    {
        rememberChangedField("InspLotCostCollectorSalesOrder", this.inspLotCostCollectorSalesOrder);
        this.inspLotCostCollectorSalesOrder = inspLotCostCollectorSalesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorSlsOrdItem</b>
     * </p>
     *
     * @param inspLotCostCollectorSlsOrdItem
     *            Item Number in Sales Order
     */
    public void setInspLotCostCollectorSlsOrdItem( @Nullable final String inspLotCostCollectorSlsOrdItem )
    {
        rememberChangedField("InspLotCostCollectorSlsOrdItem", this.inspLotCostCollectorSlsOrdItem);
        this.inspLotCostCollectorSlsOrdItem = inspLotCostCollectorSlsOrdItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InspLotCostCollectorWBSElement</b>
     * </p>
     *
     * @param inspLotCostCollectorWBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setInspLotCostCollectorWBSElement( @Nullable final String inspLotCostCollectorWBSElement )
    {
        rememberChangedField("InspLotCostCollectorWBSElement", this.inspLotCostCollectorWBSElement);
        this.inspLotCostCollectorWBSElement = inspLotCostCollectorWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspLotExternalNumber</b>
     * </p>
     *
     * @param inspLotExternalNumber
     *            Inspection Document Number
     */
    public void setInspLotExternalNumber( @Nullable final String inspLotExternalNumber )
    {
        rememberChangedField("InspLotExternalNumber", this.inspLotExternalNumber);
        this.inspLotExternalNumber = inspLotExternalNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotPriorityPoints</b>
     * </p>
     *
     * @param inspectionLotPriorityPoints
     *            Priority Points
     */
    public void setInspectionLotPriorityPoints( @Nullable final Integer inspectionLotPriorityPoints )
    {
        rememberChangedField("InspectionLotPriorityPoints", this.inspectionLotPriorityPoints);
        this.inspectionLotPriorityPoints = inspectionLotPriorityPoints;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanItemIntID</b>
     * </p>
     *
     * @param maintenancePlanItemIntID
     *            Maintenance Item
     */
    public void setMaintenancePlanItemIntID( @Nullable final String maintenancePlanItemIntID )
    {
        rememberChangedField("MaintenancePlanItemIntID", this.maintenancePlanItemIntID);
        this.maintenancePlanItemIntID = maintenancePlanItemIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionLot";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("Material", getMaterial());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("InspectionLotOrigin", getInspectionLotOrigin());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("InspectionLotText", getInspectionLotText());
        values.put("InspectionLotType", getInspectionLotType());
        values.put("InspectionLotQuantity", getInspectionLotQuantity());
        values.put("InspectionLotActualQuantity", getInspectionLotActualQuantity());
        values.put("InspectionLotDefectiveQuantity", getInspectionLotDefectiveQuantity());
        values.put("InspectionLotQuantityUnit", getInspectionLotQuantityUnit());
        values.put("InspLotCreatedOnLocalDate", getInspLotCreatedOnLocalDate());
        values.put("InspSubsetFieldCombination", getInspSubsetFieldCombination());
        values.put("InspLotNmbrOpenLongTermCharc", getInspLotNmbrOpenLongTermCharc());
        values.put("StatusObject", getStatusObject());
        values.put("StatusObjectCategory", getStatusObjectCategory());
        values.put("InspectionLotObjectText", getInspectionLotObjectText());
        values.put("StatusProfile", getStatusProfile());
        values.put("MatlQualityAuthorizationGroup", getMatlQualityAuthorizationGroup());
        values.put("InspectionLotHasQuantity", getInspectionLotHasQuantity());
        values.put("InspLotIsCreatedAutomatically", getInspLotIsCreatedAutomatically());
        values.put("InspectionLotHasPartialLots", getInspectionLotHasPartialLots());
        values.put("InspectionLotHasAppraisalCosts", getInspectionLotHasAppraisalCosts());
        values.put("InspLotHasSubsets", getInspLotHasSubsets());
        values.put("InspLotIsAutomUsgeDcsnPossible", getInspLotIsAutomUsgeDcsnPossible());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("InspLotHasConfignSpecification", getInspLotHasConfignSpecification());
        values.put("GoodsReceiptIsMovedToBlkdStock", getGoodsReceiptIsMovedToBlkdStock());
        values.put("InspLotIsDocumentationRequired", getInspLotIsDocumentationRequired());
        values.put("InspLotIsTaskListRequired", getInspLotIsTaskListRequired());
        values.put("InspLotHasManualSampleSize", getInspLotHasManualSampleSize());
        values.put("InspLotHasMaterialSpec", getInspLotHasMaterialSpec());
        values.put("InspectionLotApproval", getInspectionLotApproval());
        values.put("InspLotDigitalSgntrResultsRecg", getInspLotDigitalSgntrResultsRecg());
        values.put("InspLotDigitalSgntrInUsgeDcsn", getInspLotDigitalSgntrInUsgeDcsn());
        values.put("InspLotIsBatchRequired", getInspLotIsBatchRequired());
        values.put("InspLotUsageInStabilityStudy", getInspLotUsageInStabilityStudy());
        values.put("InspLotIsStockPostingCompleted", getInspLotIsStockPostingCompleted());
        values.put("InspectionLotHasUsageDecision", getInspectionLotHasUsageDecision());
        values.put("NumberOfSerialNumbers", getNumberOfSerialNumbers());
        values.put("InspLotIsSerialNmbrPossible", getInspLotIsSerialNmbrPossible());
        values.put("InspectionLotIsSkipped", getInspectionLotIsSkipped());
        values.put("InspectionLotIsFullInspection", getInspectionLotIsFullInspection());
        values.put("InspectionLotDynamicLevel", getInspectionLotDynamicLevel());
        values.put("SamplingProcedure", getSamplingProcedure());
        values.put("InspLotCreatedOnLocalTime", getInspLotCreatedOnLocalTime());
        values.put("InspectionLotCreatedBy", getInspectionLotCreatedBy());
        values.put("InspectionLotCreatedOn", getInspectionLotCreatedOn());
        values.put("InspectionLotCreatedOnTime", getInspectionLotCreatedOnTime());
        values.put("InspectionLotChangedBy", getInspectionLotChangedBy());
        values.put("InspectionLotChangeDate", getInspectionLotChangeDate());
        values.put("InspectionLotChangeTime", getInspectionLotChangeTime());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("InspectionLotStartDate", getInspectionLotStartDate());
        values.put("InspectionLotStartTime", getInspectionLotStartTime());
        values.put("InspectionLotEndDate", getInspectionLotEndDate());
        values.put("InspectionLotEndTime", getInspectionLotEndTime());
        values.put("BillOfOperationsType", getBillOfOperationsType());
        values.put("BillOfOperationsGroup", getBillOfOperationsGroup());
        values.put("BillOfOperationsUsage", getBillOfOperationsUsage());
        values.put("BillOfOperationsVariant", getBillOfOperationsVariant());
        values.put("BillOfOperationsChangeStateID", getBillOfOperationsChangeStateID());
        values.put("InspectionSubsetType", getInspectionSubsetType());
        values.put("SmplDrawingProcedure", getSmplDrawingProcedure());
        values.put("SmplDrawingProcedureVersion", getSmplDrawingProcedureVersion());
        values.put("SmplDrwgProcedIsConfRequired", getSmplDrwgProcedIsConfRequired());
        values.put("InspLotSelectionMaterial", getInspLotSelectionMaterial());
        values.put("InspLotSelMatlRevisionLvl", getInspLotSelMatlRevisionLvl());
        values.put("InspLotSelectionPlant", getInspLotSelectionPlant());
        values.put("InspLotSelectionSupplier", getInspLotSelectionSupplier());
        values.put("InspLotSelectionManufacturer", getInspLotSelectionManufacturer());
        values.put("InspLotSelectionCustomer", getInspLotSelectionCustomer());
        values.put("InspLotSelBillOfOperationsUsge", getInspLotSelBillOfOperationsUsge());
        values.put("InspLotSelectionValidFromDate", getInspLotSelectionValidFromDate());
        values.put("ProductionVersion", getProductionVersion());
        values.put("SalesOperationsPlanningOrder", getSalesOperationsPlanningOrder());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("BatchBySupplier", getBatchBySupplier());
        values.put("Manufacturer", getManufacturer());
        values.put("ManufacturerPartNmbr", getManufacturerPartNmbr());
        values.put("MaterialRevisionLevel", getMaterialRevisionLevel());
        values.put("MaterialIsBatchManaged", getMaterialIsBatchManaged());
        values.put("BatchStorageLocation", getBatchStorageLocation());
        values.put("MaterialCompIsSpecialStock", getMaterialCompIsSpecialStock());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("MatlDocLatestPostgDate", getMatlDocLatestPostgDate());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("InspectionLotPlant", getInspectionLotPlant());
        values.put("InspectionLotStorageLocation", getInspectionLotStorageLocation());
        values.put("Warehouse", getWarehouse());
        values.put("StorageType", getStorageType());
        values.put("StorageBin", getStorageBin());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        values.put("DeliveryCategory", getDeliveryCategory());
        values.put("InspectionDeliveryCategory", getInspectionDeliveryCategory());
        values.put("Route", getRoute());
        values.put("BillToPartyCountry", getBillToPartyCountry());
        values.put("SoldToParty", getSoldToParty());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("Language", getLanguage());
        values.put("InspLotNmbrAddlRecordedCharc", getInspLotNmbrAddlRecordedCharc());
        values.put("InspLotNmbrOpenShortTermCharc", getInspLotNmbrOpenShortTermCharc());
        values.put("InspectionLotContainer", getInspectionLotContainer());
        values.put("InspectionLotContainerUnit", getInspectionLotContainerUnit());
        values.put("InspectionLotSampleQuantity", getInspectionLotSampleQuantity());
        values.put("InspectionLotSampleUnit", getInspectionLotSampleUnit());
        values.put("InspLotDynamicRule", getInspLotDynamicRule());
        values.put("InspLotDynamicTrggrPoint", getInspLotDynamicTrggrPoint());
        values.put("InspectionDynamicStage", getInspectionDynamicStage());
        values.put("InspectionSeverity", getInspectionSeverity());
        values.put("InspLotQtyToFree", getInspLotQtyToFree());
        values.put("InspLotQtyToScrap", getInspLotQtyToScrap());
        values.put("InspLotQtyToSample", getInspLotQtyToSample());
        values.put("InspLotQtyToBlocked", getInspLotQtyToBlocked());
        values.put("InspLotQtyToReserves", getInspLotQtyToReserves());
        values.put("InspLotQtyToAnotherMaterial", getInspLotQtyToAnotherMaterial());
        values.put("InspLotMaterialPostedTo", getInspLotMaterialPostedTo());
        values.put("InspLotBatchTransferredTo", getInspLotBatchTransferredTo());
        values.put("InspLotQtyReturnedToSupplier", getInspLotQtyReturnedToSupplier());
        values.put("InspLotQtyToSpecialStock", getInspLotQtyToSpecialStock());
        values.put("InspLotQtyToOtherStock", getInspLotQtyToOtherStock());
        values.put("InspLotQtyToBePosted", getInspLotQtyToBePosted());
        values.put("InspLotSmplQtyForLongTermChar", getInspLotSmplQtyForLongTermChar());
        values.put("InspLotQtyInspected", getInspLotQtyInspected());
        values.put("InspLotQtyDestroyed", getInspLotQtyDestroyed());
        values.put("InspectionLotScrapRatio", getInspectionLotScrapRatio());
        values.put("InspLotUsageDecisionTool", getInspLotUsageDecisionTool());
        values.put("InspectionLotAllowedScrapRatio", getInspectionLotAllowedScrapRatio());
        values.put("QualityCostCollector", getQualityCostCollector());
        values.put("ConsumptionPosting", getConsumptionPosting());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("InspLotAcctAssgmtKey", getInspLotAcctAssgmtKey());
        values.put("CostCenter", getCostCenter());
        values.put("ReservationItem", getReservationItem());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("SalesOrdStockWBSElement", getSalesOrdStockWBSElement());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("NetworkActivityInternalID", getNetworkActivityInternalID());
        values.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        values.put("InventorySpclStkSalesDocItm", getInventorySpclStkSalesDocItm());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("BusinessArea", getBusinessArea());
        values.put("GLAccount", getGLAccount());
        values.put("ControllingArea", getControllingArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("SerialNumberProfile", getSerialNumberProfile());
        values.put("InspLotCostCollectorSalesOrder", getInspLotCostCollectorSalesOrder());
        values.put("InspLotCostCollectorSlsOrdItem", getInspLotCostCollectorSlsOrdItem());
        values.put("InspLotCostCollectorWBSElement", getInspLotCostCollectorWBSElement());
        values.put("InspLotExternalNumber", getInspLotExternalNumber());
        values.put("InspectionLotPriorityPoints", getInspectionLotPriorityPoints());
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanItemIntID", getMaintenancePlanItemIntID());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionLotOrigin") ) {
                final Object value = values.remove("InspectionLotOrigin");
                if( (value == null) || (!value.equals(getInspectionLotOrigin())) ) {
                    setInspectionLotOrigin(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("InspectionLotText") ) {
                final Object value = values.remove("InspectionLotText");
                if( (value == null) || (!value.equals(getInspectionLotText())) ) {
                    setInspectionLotText(((String) value));
                }
            }
            if( values.containsKey("InspectionLotType") ) {
                final Object value = values.remove("InspectionLotType");
                if( (value == null) || (!value.equals(getInspectionLotType())) ) {
                    setInspectionLotType(((String) value));
                }
            }
            if( values.containsKey("InspectionLotQuantity") ) {
                final Object value = values.remove("InspectionLotQuantity");
                if( (value == null) || (!value.equals(getInspectionLotQuantity())) ) {
                    setInspectionLotQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotActualQuantity") ) {
                final Object value = values.remove("InspectionLotActualQuantity");
                if( (value == null) || (!value.equals(getInspectionLotActualQuantity())) ) {
                    setInspectionLotActualQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotDefectiveQuantity") ) {
                final Object value = values.remove("InspectionLotDefectiveQuantity");
                if( (value == null) || (!value.equals(getInspectionLotDefectiveQuantity())) ) {
                    setInspectionLotDefectiveQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotQuantityUnit") ) {
                final Object value = values.remove("InspectionLotQuantityUnit");
                if( (value == null) || (!value.equals(getInspectionLotQuantityUnit())) ) {
                    setInspectionLotQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("InspLotCreatedOnLocalDate") ) {
                final Object value = values.remove("InspLotCreatedOnLocalDate");
                if( (value == null) || (!value.equals(getInspLotCreatedOnLocalDate())) ) {
                    setInspLotCreatedOnLocalDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSubsetFieldCombination") ) {
                final Object value = values.remove("InspSubsetFieldCombination");
                if( (value == null) || (!value.equals(getInspSubsetFieldCombination())) ) {
                    setInspSubsetFieldCombination(((String) value));
                }
            }
            if( values.containsKey("InspLotNmbrOpenLongTermCharc") ) {
                final Object value = values.remove("InspLotNmbrOpenLongTermCharc");
                if( (value == null) || (!value.equals(getInspLotNmbrOpenLongTermCharc())) ) {
                    setInspLotNmbrOpenLongTermCharc(((Short) value));
                }
            }
            if( values.containsKey("StatusObject") ) {
                final Object value = values.remove("StatusObject");
                if( (value == null) || (!value.equals(getStatusObject())) ) {
                    setStatusObject(((String) value));
                }
            }
            if( values.containsKey("StatusObjectCategory") ) {
                final Object value = values.remove("StatusObjectCategory");
                if( (value == null) || (!value.equals(getStatusObjectCategory())) ) {
                    setStatusObjectCategory(((String) value));
                }
            }
            if( values.containsKey("InspectionLotObjectText") ) {
                final Object value = values.remove("InspectionLotObjectText");
                if( (value == null) || (!value.equals(getInspectionLotObjectText())) ) {
                    setInspectionLotObjectText(((String) value));
                }
            }
            if( values.containsKey("StatusProfile") ) {
                final Object value = values.remove("StatusProfile");
                if( (value == null) || (!value.equals(getStatusProfile())) ) {
                    setStatusProfile(((String) value));
                }
            }
            if( values.containsKey("MatlQualityAuthorizationGroup") ) {
                final Object value = values.remove("MatlQualityAuthorizationGroup");
                if( (value == null) || (!value.equals(getMatlQualityAuthorizationGroup())) ) {
                    setMatlQualityAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionLotHasQuantity") ) {
                final Object value = values.remove("InspectionLotHasQuantity");
                if( (value == null) || (!value.equals(getInspectionLotHasQuantity())) ) {
                    setInspectionLotHasQuantity(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotIsCreatedAutomatically") ) {
                final Object value = values.remove("InspLotIsCreatedAutomatically");
                if( (value == null) || (!value.equals(getInspLotIsCreatedAutomatically())) ) {
                    setInspLotIsCreatedAutomatically(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotHasPartialLots") ) {
                final Object value = values.remove("InspectionLotHasPartialLots");
                if( (value == null) || (!value.equals(getInspectionLotHasPartialLots())) ) {
                    setInspectionLotHasPartialLots(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotHasAppraisalCosts") ) {
                final Object value = values.remove("InspectionLotHasAppraisalCosts");
                if( (value == null) || (!value.equals(getInspectionLotHasAppraisalCosts())) ) {
                    setInspectionLotHasAppraisalCosts(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotHasSubsets") ) {
                final Object value = values.remove("InspLotHasSubsets");
                if( (value == null) || (!value.equals(getInspLotHasSubsets())) ) {
                    setInspLotHasSubsets(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotIsAutomUsgeDcsnPossible") ) {
                final Object value = values.remove("InspLotIsAutomUsgeDcsnPossible");
                if( (value == null) || (!value.equals(getInspLotIsAutomUsgeDcsnPossible())) ) {
                    setInspLotIsAutomUsgeDcsnPossible(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("InspLotHasConfignSpecification") ) {
                final Object value = values.remove("InspLotHasConfignSpecification");
                if( (value == null) || (!value.equals(getInspLotHasConfignSpecification())) ) {
                    setInspLotHasConfignSpecification(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsMovedToBlkdStock") ) {
                final Object value = values.remove("GoodsReceiptIsMovedToBlkdStock");
                if( (value == null) || (!value.equals(getGoodsReceiptIsMovedToBlkdStock())) ) {
                    setGoodsReceiptIsMovedToBlkdStock(((String) value));
                }
            }
            if( values.containsKey("InspLotIsDocumentationRequired") ) {
                final Object value = values.remove("InspLotIsDocumentationRequired");
                if( (value == null) || (!value.equals(getInspLotIsDocumentationRequired())) ) {
                    setInspLotIsDocumentationRequired(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotIsTaskListRequired") ) {
                final Object value = values.remove("InspLotIsTaskListRequired");
                if( (value == null) || (!value.equals(getInspLotIsTaskListRequired())) ) {
                    setInspLotIsTaskListRequired(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotHasManualSampleSize") ) {
                final Object value = values.remove("InspLotHasManualSampleSize");
                if( (value == null) || (!value.equals(getInspLotHasManualSampleSize())) ) {
                    setInspLotHasManualSampleSize(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotHasMaterialSpec") ) {
                final Object value = values.remove("InspLotHasMaterialSpec");
                if( (value == null) || (!value.equals(getInspLotHasMaterialSpec())) ) {
                    setInspLotHasMaterialSpec(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotApproval") ) {
                final Object value = values.remove("InspectionLotApproval");
                if( (value == null) || (!value.equals(getInspectionLotApproval())) ) {
                    setInspectionLotApproval(((String) value));
                }
            }
            if( values.containsKey("InspLotDigitalSgntrResultsRecg") ) {
                final Object value = values.remove("InspLotDigitalSgntrResultsRecg");
                if( (value == null) || (!value.equals(getInspLotDigitalSgntrResultsRecg())) ) {
                    setInspLotDigitalSgntrResultsRecg(((String) value));
                }
            }
            if( values.containsKey("InspLotDigitalSgntrInUsgeDcsn") ) {
                final Object value = values.remove("InspLotDigitalSgntrInUsgeDcsn");
                if( (value == null) || (!value.equals(getInspLotDigitalSgntrInUsgeDcsn())) ) {
                    setInspLotDigitalSgntrInUsgeDcsn(((String) value));
                }
            }
            if( values.containsKey("InspLotIsBatchRequired") ) {
                final Object value = values.remove("InspLotIsBatchRequired");
                if( (value == null) || (!value.equals(getInspLotIsBatchRequired())) ) {
                    setInspLotIsBatchRequired(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotUsageInStabilityStudy") ) {
                final Object value = values.remove("InspLotUsageInStabilityStudy");
                if( (value == null) || (!value.equals(getInspLotUsageInStabilityStudy())) ) {
                    setInspLotUsageInStabilityStudy(((String) value));
                }
            }
            if( values.containsKey("InspLotIsStockPostingCompleted") ) {
                final Object value = values.remove("InspLotIsStockPostingCompleted");
                if( (value == null) || (!value.equals(getInspLotIsStockPostingCompleted())) ) {
                    setInspLotIsStockPostingCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotHasUsageDecision") ) {
                final Object value = values.remove("InspectionLotHasUsageDecision");
                if( (value == null) || (!value.equals(getInspectionLotHasUsageDecision())) ) {
                    setInspectionLotHasUsageDecision(((Boolean) value));
                }
            }
            if( values.containsKey("NumberOfSerialNumbers") ) {
                final Object value = values.remove("NumberOfSerialNumbers");
                if( (value == null) || (!value.equals(getNumberOfSerialNumbers())) ) {
                    setNumberOfSerialNumbers(((Integer) value));
                }
            }
            if( values.containsKey("InspLotIsSerialNmbrPossible") ) {
                final Object value = values.remove("InspLotIsSerialNmbrPossible");
                if( (value == null) || (!value.equals(getInspLotIsSerialNmbrPossible())) ) {
                    setInspLotIsSerialNmbrPossible(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotIsSkipped") ) {
                final Object value = values.remove("InspectionLotIsSkipped");
                if( (value == null) || (!value.equals(getInspectionLotIsSkipped())) ) {
                    setInspectionLotIsSkipped(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotIsFullInspection") ) {
                final Object value = values.remove("InspectionLotIsFullInspection");
                if( (value == null) || (!value.equals(getInspectionLotIsFullInspection())) ) {
                    setInspectionLotIsFullInspection(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLotDynamicLevel") ) {
                final Object value = values.remove("InspectionLotDynamicLevel");
                if( (value == null) || (!value.equals(getInspectionLotDynamicLevel())) ) {
                    setInspectionLotDynamicLevel(((String) value));
                }
            }
            if( values.containsKey("SamplingProcedure") ) {
                final Object value = values.remove("SamplingProcedure");
                if( (value == null) || (!value.equals(getSamplingProcedure())) ) {
                    setSamplingProcedure(((String) value));
                }
            }
            if( values.containsKey("InspLotCreatedOnLocalTime") ) {
                final Object value = values.remove("InspLotCreatedOnLocalTime");
                if( (value == null) || (!value.equals(getInspLotCreatedOnLocalTime())) ) {
                    setInspLotCreatedOnLocalTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionLotCreatedBy") ) {
                final Object value = values.remove("InspectionLotCreatedBy");
                if( (value == null) || (!value.equals(getInspectionLotCreatedBy())) ) {
                    setInspectionLotCreatedBy(((String) value));
                }
            }
            if( values.containsKey("InspectionLotCreatedOn") ) {
                final Object value = values.remove("InspectionLotCreatedOn");
                if( (value == null) || (!value.equals(getInspectionLotCreatedOn())) ) {
                    setInspectionLotCreatedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotCreatedOnTime") ) {
                final Object value = values.remove("InspectionLotCreatedOnTime");
                if( (value == null) || (!value.equals(getInspectionLotCreatedOnTime())) ) {
                    setInspectionLotCreatedOnTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionLotChangedBy") ) {
                final Object value = values.remove("InspectionLotChangedBy");
                if( (value == null) || (!value.equals(getInspectionLotChangedBy())) ) {
                    setInspectionLotChangedBy(((String) value));
                }
            }
            if( values.containsKey("InspectionLotChangeDate") ) {
                final Object value = values.remove("InspectionLotChangeDate");
                if( (value == null) || (!value.equals(getInspectionLotChangeDate())) ) {
                    setInspectionLotChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotChangeTime") ) {
                final Object value = values.remove("InspectionLotChangeTime");
                if( (value == null) || (!value.equals(getInspectionLotChangeTime())) ) {
                    setInspectionLotChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotStartDate") ) {
                final Object value = values.remove("InspectionLotStartDate");
                if( (value == null) || (!value.equals(getInspectionLotStartDate())) ) {
                    setInspectionLotStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotStartTime") ) {
                final Object value = values.remove("InspectionLotStartTime");
                if( (value == null) || (!value.equals(getInspectionLotStartTime())) ) {
                    setInspectionLotStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionLotEndDate") ) {
                final Object value = values.remove("InspectionLotEndDate");
                if( (value == null) || (!value.equals(getInspectionLotEndDate())) ) {
                    setInspectionLotEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionLotEndTime") ) {
                final Object value = values.remove("InspectionLotEndTime");
                if( (value == null) || (!value.equals(getInspectionLotEndTime())) ) {
                    setInspectionLotEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("BillOfOperationsType") ) {
                final Object value = values.remove("BillOfOperationsType");
                if( (value == null) || (!value.equals(getBillOfOperationsType())) ) {
                    setBillOfOperationsType(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsGroup") ) {
                final Object value = values.remove("BillOfOperationsGroup");
                if( (value == null) || (!value.equals(getBillOfOperationsGroup())) ) {
                    setBillOfOperationsGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsUsage") ) {
                final Object value = values.remove("BillOfOperationsUsage");
                if( (value == null) || (!value.equals(getBillOfOperationsUsage())) ) {
                    setBillOfOperationsUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsVariant") ) {
                final Object value = values.remove("BillOfOperationsVariant");
                if( (value == null) || (!value.equals(getBillOfOperationsVariant())) ) {
                    setBillOfOperationsVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsChangeStateID") ) {
                final Object value = values.remove("BillOfOperationsChangeStateID");
                if( (value == null) || (!value.equals(getBillOfOperationsChangeStateID())) ) {
                    setBillOfOperationsChangeStateID(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetType") ) {
                final Object value = values.remove("InspectionSubsetType");
                if( (value == null) || (!value.equals(getInspectionSubsetType())) ) {
                    setInspectionSubsetType(((String) value));
                }
            }
            if( values.containsKey("SmplDrawingProcedure") ) {
                final Object value = values.remove("SmplDrawingProcedure");
                if( (value == null) || (!value.equals(getSmplDrawingProcedure())) ) {
                    setSmplDrawingProcedure(((String) value));
                }
            }
            if( values.containsKey("SmplDrawingProcedureVersion") ) {
                final Object value = values.remove("SmplDrawingProcedureVersion");
                if( (value == null) || (!value.equals(getSmplDrawingProcedureVersion())) ) {
                    setSmplDrawingProcedureVersion(((String) value));
                }
            }
            if( values.containsKey("SmplDrwgProcedIsConfRequired") ) {
                final Object value = values.remove("SmplDrwgProcedIsConfRequired");
                if( (value == null) || (!value.equals(getSmplDrwgProcedIsConfRequired())) ) {
                    setSmplDrwgProcedIsConfRequired(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotSelectionMaterial") ) {
                final Object value = values.remove("InspLotSelectionMaterial");
                if( (value == null) || (!value.equals(getInspLotSelectionMaterial())) ) {
                    setInspLotSelectionMaterial(((String) value));
                }
            }
            if( values.containsKey("InspLotSelMatlRevisionLvl") ) {
                final Object value = values.remove("InspLotSelMatlRevisionLvl");
                if( (value == null) || (!value.equals(getInspLotSelMatlRevisionLvl())) ) {
                    setInspLotSelMatlRevisionLvl(((String) value));
                }
            }
            if( values.containsKey("InspLotSelectionPlant") ) {
                final Object value = values.remove("InspLotSelectionPlant");
                if( (value == null) || (!value.equals(getInspLotSelectionPlant())) ) {
                    setInspLotSelectionPlant(((String) value));
                }
            }
            if( values.containsKey("InspLotSelectionSupplier") ) {
                final Object value = values.remove("InspLotSelectionSupplier");
                if( (value == null) || (!value.equals(getInspLotSelectionSupplier())) ) {
                    setInspLotSelectionSupplier(((String) value));
                }
            }
            if( values.containsKey("InspLotSelectionManufacturer") ) {
                final Object value = values.remove("InspLotSelectionManufacturer");
                if( (value == null) || (!value.equals(getInspLotSelectionManufacturer())) ) {
                    setInspLotSelectionManufacturer(((String) value));
                }
            }
            if( values.containsKey("InspLotSelectionCustomer") ) {
                final Object value = values.remove("InspLotSelectionCustomer");
                if( (value == null) || (!value.equals(getInspLotSelectionCustomer())) ) {
                    setInspLotSelectionCustomer(((String) value));
                }
            }
            if( values.containsKey("InspLotSelBillOfOperationsUsge") ) {
                final Object value = values.remove("InspLotSelBillOfOperationsUsge");
                if( (value == null) || (!value.equals(getInspLotSelBillOfOperationsUsge())) ) {
                    setInspLotSelBillOfOperationsUsge(((String) value));
                }
            }
            if( values.containsKey("InspLotSelectionValidFromDate") ) {
                final Object value = values.remove("InspLotSelectionValidFromDate");
                if( (value == null) || (!value.equals(getInspLotSelectionValidFromDate())) ) {
                    setInspLotSelectionValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("SalesOperationsPlanningOrder") ) {
                final Object value = values.remove("SalesOperationsPlanningOrder");
                if( (value == null) || (!value.equals(getSalesOperationsPlanningOrder())) ) {
                    setSalesOperationsPlanningOrder(((String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("BatchBySupplier") ) {
                final Object value = values.remove("BatchBySupplier");
                if( (value == null) || (!value.equals(getBatchBySupplier())) ) {
                    setBatchBySupplier(((String) value));
                }
            }
            if( values.containsKey("Manufacturer") ) {
                final Object value = values.remove("Manufacturer");
                if( (value == null) || (!value.equals(getManufacturer())) ) {
                    setManufacturer(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartNmbr") ) {
                final Object value = values.remove("ManufacturerPartNmbr");
                if( (value == null) || (!value.equals(getManufacturerPartNmbr())) ) {
                    setManufacturerPartNmbr(((String) value));
                }
            }
            if( values.containsKey("MaterialRevisionLevel") ) {
                final Object value = values.remove("MaterialRevisionLevel");
                if( (value == null) || (!value.equals(getMaterialRevisionLevel())) ) {
                    setMaterialRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("MaterialIsBatchManaged") ) {
                final Object value = values.remove("MaterialIsBatchManaged");
                if( (value == null) || (!value.equals(getMaterialIsBatchManaged())) ) {
                    setMaterialIsBatchManaged(((Boolean) value));
                }
            }
            if( values.containsKey("BatchStorageLocation") ) {
                final Object value = values.remove("BatchStorageLocation");
                if( (value == null) || (!value.equals(getBatchStorageLocation())) ) {
                    setBatchStorageLocation(((String) value));
                }
            }
            if( values.containsKey("MaterialCompIsSpecialStock") ) {
                final Object value = values.remove("MaterialCompIsSpecialStock");
                if( (value == null) || (!value.equals(getMaterialCompIsSpecialStock())) ) {
                    setMaterialCompIsSpecialStock(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MatlDocLatestPostgDate") ) {
                final Object value = values.remove("MatlDocLatestPostgDate");
                if( (value == null) || (!value.equals(getMatlDocLatestPostgDate())) ) {
                    setMatlDocLatestPostgDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("InspectionLotPlant") ) {
                final Object value = values.remove("InspectionLotPlant");
                if( (value == null) || (!value.equals(getInspectionLotPlant())) ) {
                    setInspectionLotPlant(((String) value));
                }
            }
            if( values.containsKey("InspectionLotStorageLocation") ) {
                final Object value = values.remove("InspectionLotStorageLocation");
                if( (value == null) || (!value.equals(getInspectionLotStorageLocation())) ) {
                    setInspectionLotStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("DeliveryCategory") ) {
                final Object value = values.remove("DeliveryCategory");
                if( (value == null) || (!value.equals(getDeliveryCategory())) ) {
                    setDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("InspectionDeliveryCategory") ) {
                final Object value = values.remove("InspectionDeliveryCategory");
                if( (value == null) || (!value.equals(getInspectionDeliveryCategory())) ) {
                    setInspectionDeliveryCategory(((String) value));
                }
            }
            if( values.containsKey("Route") ) {
                final Object value = values.remove("Route");
                if( (value == null) || (!value.equals(getRoute())) ) {
                    setRoute(((String) value));
                }
            }
            if( values.containsKey("BillToPartyCountry") ) {
                final Object value = values.remove("BillToPartyCountry");
                if( (value == null) || (!value.equals(getBillToPartyCountry())) ) {
                    setBillToPartyCountry(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InspLotNmbrAddlRecordedCharc") ) {
                final Object value = values.remove("InspLotNmbrAddlRecordedCharc");
                if( (value == null) || (!value.equals(getInspLotNmbrAddlRecordedCharc())) ) {
                    setInspLotNmbrAddlRecordedCharc(((Short) value));
                }
            }
            if( values.containsKey("InspLotNmbrOpenShortTermCharc") ) {
                final Object value = values.remove("InspLotNmbrOpenShortTermCharc");
                if( (value == null) || (!value.equals(getInspLotNmbrOpenShortTermCharc())) ) {
                    setInspLotNmbrOpenShortTermCharc(((Short) value));
                }
            }
            if( values.containsKey("InspectionLotContainer") ) {
                final Object value = values.remove("InspectionLotContainer");
                if( (value == null) || (!value.equals(getInspectionLotContainer())) ) {
                    setInspectionLotContainer(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotContainerUnit") ) {
                final Object value = values.remove("InspectionLotContainerUnit");
                if( (value == null) || (!value.equals(getInspectionLotContainerUnit())) ) {
                    setInspectionLotContainerUnit(((String) value));
                }
            }
            if( values.containsKey("InspectionLotSampleQuantity") ) {
                final Object value = values.remove("InspectionLotSampleQuantity");
                if( (value == null) || (!value.equals(getInspectionLotSampleQuantity())) ) {
                    setInspectionLotSampleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotSampleUnit") ) {
                final Object value = values.remove("InspectionLotSampleUnit");
                if( (value == null) || (!value.equals(getInspectionLotSampleUnit())) ) {
                    setInspectionLotSampleUnit(((String) value));
                }
            }
            if( values.containsKey("InspLotDynamicRule") ) {
                final Object value = values.remove("InspLotDynamicRule");
                if( (value == null) || (!value.equals(getInspLotDynamicRule())) ) {
                    setInspLotDynamicRule(((String) value));
                }
            }
            if( values.containsKey("InspLotDynamicTrggrPoint") ) {
                final Object value = values.remove("InspLotDynamicTrggrPoint");
                if( (value == null) || (!value.equals(getInspLotDynamicTrggrPoint())) ) {
                    setInspLotDynamicTrggrPoint(((String) value));
                }
            }
            if( values.containsKey("InspectionDynamicStage") ) {
                final Object value = values.remove("InspectionDynamicStage");
                if( (value == null) || (!value.equals(getInspectionDynamicStage())) ) {
                    setInspectionDynamicStage(((String) value));
                }
            }
            if( values.containsKey("InspectionSeverity") ) {
                final Object value = values.remove("InspectionSeverity");
                if( (value == null) || (!value.equals(getInspectionSeverity())) ) {
                    setInspectionSeverity(((String) value));
                }
            }
            if( values.containsKey("InspLotQtyToFree") ) {
                final Object value = values.remove("InspLotQtyToFree");
                if( (value == null) || (!value.equals(getInspLotQtyToFree())) ) {
                    setInspLotQtyToFree(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToScrap") ) {
                final Object value = values.remove("InspLotQtyToScrap");
                if( (value == null) || (!value.equals(getInspLotQtyToScrap())) ) {
                    setInspLotQtyToScrap(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToSample") ) {
                final Object value = values.remove("InspLotQtyToSample");
                if( (value == null) || (!value.equals(getInspLotQtyToSample())) ) {
                    setInspLotQtyToSample(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToBlocked") ) {
                final Object value = values.remove("InspLotQtyToBlocked");
                if( (value == null) || (!value.equals(getInspLotQtyToBlocked())) ) {
                    setInspLotQtyToBlocked(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToReserves") ) {
                final Object value = values.remove("InspLotQtyToReserves");
                if( (value == null) || (!value.equals(getInspLotQtyToReserves())) ) {
                    setInspLotQtyToReserves(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToAnotherMaterial") ) {
                final Object value = values.remove("InspLotQtyToAnotherMaterial");
                if( (value == null) || (!value.equals(getInspLotQtyToAnotherMaterial())) ) {
                    setInspLotQtyToAnotherMaterial(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotMaterialPostedTo") ) {
                final Object value = values.remove("InspLotMaterialPostedTo");
                if( (value == null) || (!value.equals(getInspLotMaterialPostedTo())) ) {
                    setInspLotMaterialPostedTo(((String) value));
                }
            }
            if( values.containsKey("InspLotBatchTransferredTo") ) {
                final Object value = values.remove("InspLotBatchTransferredTo");
                if( (value == null) || (!value.equals(getInspLotBatchTransferredTo())) ) {
                    setInspLotBatchTransferredTo(((String) value));
                }
            }
            if( values.containsKey("InspLotQtyReturnedToSupplier") ) {
                final Object value = values.remove("InspLotQtyReturnedToSupplier");
                if( (value == null) || (!value.equals(getInspLotQtyReturnedToSupplier())) ) {
                    setInspLotQtyReturnedToSupplier(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToSpecialStock") ) {
                final Object value = values.remove("InspLotQtyToSpecialStock");
                if( (value == null) || (!value.equals(getInspLotQtyToSpecialStock())) ) {
                    setInspLotQtyToSpecialStock(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToOtherStock") ) {
                final Object value = values.remove("InspLotQtyToOtherStock");
                if( (value == null) || (!value.equals(getInspLotQtyToOtherStock())) ) {
                    setInspLotQtyToOtherStock(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyToBePosted") ) {
                final Object value = values.remove("InspLotQtyToBePosted");
                if( (value == null) || (!value.equals(getInspLotQtyToBePosted())) ) {
                    setInspLotQtyToBePosted(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotSmplQtyForLongTermChar") ) {
                final Object value = values.remove("InspLotSmplQtyForLongTermChar");
                if( (value == null) || (!value.equals(getInspLotSmplQtyForLongTermChar())) ) {
                    setInspLotSmplQtyForLongTermChar(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyInspected") ) {
                final Object value = values.remove("InspLotQtyInspected");
                if( (value == null) || (!value.equals(getInspLotQtyInspected())) ) {
                    setInspLotQtyInspected(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspLotQtyDestroyed") ) {
                final Object value = values.remove("InspLotQtyDestroyed");
                if( (value == null) || (!value.equals(getInspLotQtyDestroyed())) ) {
                    setInspLotQtyDestroyed(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionLotScrapRatio") ) {
                final Object value = values.remove("InspectionLotScrapRatio");
                if( (value == null) || (!value.equals(getInspectionLotScrapRatio())) ) {
                    setInspectionLotScrapRatio(((Double) value));
                }
            }
            if( values.containsKey("InspLotUsageDecisionTool") ) {
                final Object value = values.remove("InspLotUsageDecisionTool");
                if( (value == null) || (!value.equals(getInspLotUsageDecisionTool())) ) {
                    setInspLotUsageDecisionTool(((String) value));
                }
            }
            if( values.containsKey("InspectionLotAllowedScrapRatio") ) {
                final Object value = values.remove("InspectionLotAllowedScrapRatio");
                if( (value == null) || (!value.equals(getInspectionLotAllowedScrapRatio())) ) {
                    setInspectionLotAllowedScrapRatio(((Double) value));
                }
            }
            if( values.containsKey("QualityCostCollector") ) {
                final Object value = values.remove("QualityCostCollector");
                if( (value == null) || (!value.equals(getQualityCostCollector())) ) {
                    setQualityCostCollector(((String) value));
                }
            }
            if( values.containsKey("ConsumptionPosting") ) {
                final Object value = values.remove("ConsumptionPosting");
                if( (value == null) || (!value.equals(getConsumptionPosting())) ) {
                    setConsumptionPosting(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("InspLotAcctAssgmtKey") ) {
                final Object value = values.remove("InspLotAcctAssgmtKey");
                if( (value == null) || (!value.equals(getInspLotAcctAssgmtKey())) ) {
                    setInspLotAcctAssgmtKey(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("SalesOrdStockWBSElement") ) {
                final Object value = values.remove("SalesOrdStockWBSElement");
                if( (value == null) || (!value.equals(getSalesOrdStockWBSElement())) ) {
                    setSalesOrdStockWBSElement(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("NetworkActivityInternalID") ) {
                final Object value = values.remove("NetworkActivityInternalID");
                if( (value == null) || (!value.equals(getNetworkActivityInternalID())) ) {
                    setNetworkActivityInternalID(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocument") ) {
                final Object value = values.remove("InventorySpclStkSalesDocument");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocument())) ) {
                    setInventorySpclStkSalesDocument(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocItm") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItm");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItm())) ) {
                    setInventorySpclStkSalesDocItm(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("SerialNumberProfile") ) {
                final Object value = values.remove("SerialNumberProfile");
                if( (value == null) || (!value.equals(getSerialNumberProfile())) ) {
                    setSerialNumberProfile(((String) value));
                }
            }
            if( values.containsKey("InspLotCostCollectorSalesOrder") ) {
                final Object value = values.remove("InspLotCostCollectorSalesOrder");
                if( (value == null) || (!value.equals(getInspLotCostCollectorSalesOrder())) ) {
                    setInspLotCostCollectorSalesOrder(((String) value));
                }
            }
            if( values.containsKey("InspLotCostCollectorSlsOrdItem") ) {
                final Object value = values.remove("InspLotCostCollectorSlsOrdItem");
                if( (value == null) || (!value.equals(getInspLotCostCollectorSlsOrdItem())) ) {
                    setInspLotCostCollectorSlsOrdItem(((String) value));
                }
            }
            if( values.containsKey("InspLotCostCollectorWBSElement") ) {
                final Object value = values.remove("InspLotCostCollectorWBSElement");
                if( (value == null) || (!value.equals(getInspLotCostCollectorWBSElement())) ) {
                    setInspLotCostCollectorWBSElement(((String) value));
                }
            }
            if( values.containsKey("InspLotExternalNumber") ) {
                final Object value = values.remove("InspLotExternalNumber");
                if( (value == null) || (!value.equals(getInspLotExternalNumber())) ) {
                    setInspLotExternalNumber(((String) value));
                }
            }
            if( values.containsKey("InspectionLotPriorityPoints") ) {
                final Object value = values.remove("InspectionLotPriorityPoints");
                if( (value == null) || (!value.equals(getInspectionLotPriorityPoints())) ) {
                    setInspectionLotPriorityPoints(((Integer) value));
                }
            }
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanItemIntID") ) {
                final Object value = values.remove("MaintenancePlanItemIntID");
                if( (value == null) || (!value.equals(getMaintenancePlanItemIntID())) ) {
                    setMaintenancePlanItemIntID(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InspectionLotWithStatus") ) {
                final Object value = (values).remove("to_InspectionLotWithStatus");
                if( value instanceof Map ) {
                    if( toInspectionLotWithStatus == null ) {
                        toInspectionLotWithStatus = new InspectionLotWithStatus();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toInspectionLotWithStatus.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InspectionLotField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionLotField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionLotField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionLotField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInspectionLotWithStatus != null ) {
            (values).put("to_InspectionLotWithStatus", toInspectionLotWithStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionLotWithStatus</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_InspectionLotWithStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>InspectionLotWithStatus</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionLotWithStatus fetchInspectionLotWithStatus()
    {
        return fetchFieldAsSingle("to_InspectionLotWithStatus", InspectionLotWithStatus.class);
    }

    /**
     * Retrieval of associated <b>InspectionLotWithStatus</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_InspectionLotWithStatus</b>.
     * <p>
     * If the navigation property <b>to_InspectionLotWithStatus</b> of a queried <b>InspectionLot</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionLotWithStatus</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InspectionLotWithStatus getInspectionLotWithStatusOrFetch()
    {
        if( toInspectionLotWithStatus == null ) {
            toInspectionLotWithStatus = fetchInspectionLotWithStatus();
        }
        return toInspectionLotWithStatus;
    }

    /**
     * Retrieval of associated <b>InspectionLotWithStatus</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_InspectionLotWithStatus</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionLot</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InspectionLotWithStatus</b> is already loaded, the
     *         result will contain the <b>InspectionLotWithStatus</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InspectionLotWithStatus> getInspectionLotWithStatusIfPresent()
    {
        return Option.of(toInspectionLotWithStatus);
    }

    /**
     * Overwrites the associated <b>InspectionLotWithStatus</b> entity for the loaded navigation property
     * <b>to_InspectionLotWithStatus</b>.
     *
     * @param value
     *            New <b>InspectionLotWithStatus</b> entity.
     */
    public void setInspectionLotWithStatus( final InspectionLotWithStatus value )
    {
        toInspectionLotWithStatus = value;
    }

    /**
     * Helper class to allow for fluent creation of InspectionLot instances.
     *
     */
    public final static class InspectionLotBuilder
    {

        private InspectionLotWithStatus toInspectionLotWithStatus;

        private InspectionLot.InspectionLotBuilder toInspectionLotWithStatus( final InspectionLotWithStatus value )
        {
            toInspectionLotWithStatus = value;
            return this;
        }

        /**
         * Navigation property <b>to_InspectionLotWithStatus</b> for <b>InspectionLot</b> to single
         * <b>InspectionLotWithStatus</b>.
         *
         * @param value
         *            The InspectionLotWithStatus to build this InspectionLot with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionLot.InspectionLotBuilder inspectionLotWithStatus( final InspectionLotWithStatus value )
        {
            return toInspectionLotWithStatus(value);
        }

    }

}
