/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionLotWithStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionLotWithStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Lot Statuses
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionLotWithStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionLotWithStatus extends VdmEntity<InspectionLotWithStatus>
{

    /**
     * Selector for all available fields of InspectionLotWithStatus.
     *
     */
    public final static InspectionLotWithStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSPECTION_LOT =
        new InspectionLotWithStatusField<String>("InspectionLot");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusCreated</b>
     * </p>
     *
     * @return The inspectionLotStatusCreated contained in this entity.
     */
    @SerializedName( "InspectionLotStatusCreated" )
    @JsonProperty( "InspectionLotStatusCreated" )
    @Nullable
    @ODataField( odataName = "InspectionLotStatusCreated" )
    private String inspectionLotStatusCreated;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStatusCreated</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSPECTION_LOT_STATUS_CREATED =
        new InspectionLotWithStatusField<String>("InspectionLotStatusCreated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusReleased</b>
     * </p>
     *
     * @return The inspectionLotStatusReleased contained in this entity.
     */
    @SerializedName( "InspectionLotStatusReleased" )
    @JsonProperty( "InspectionLotStatusReleased" )
    @Nullable
    @ODataField( odataName = "InspectionLotStatusReleased" )
    private String inspectionLotStatusReleased;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStatusReleased</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSPECTION_LOT_STATUS_RELEASED =
        new InspectionLotWithStatusField<String>("InspectionLotStatusReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusSkip</b>
     * </p>
     *
     * @return The inspectionLotStatusSkip contained in this entity.
     */
    @SerializedName( "InspectionLotStatusSkip" )
    @JsonProperty( "InspectionLotStatusSkip" )
    @Nullable
    @ODataField( odataName = "InspectionLotStatusSkip" )
    private String inspectionLotStatusSkip;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotStatusSkip</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSPECTION_LOT_STATUS_SKIP =
        new InspectionLotWithStatusField<String>("InspectionLotStatusSkip");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusRsltsConfirmed</b>
     * </p>
     *
     * @return The inspLotStatusRsltsConfirmed contained in this entity.
     */
    @SerializedName( "InspLotStatusRsltsConfirmed" )
    @JsonProperty( "InspLotStatusRsltsConfirmed" )
    @Nullable
    @ODataField( odataName = "InspLotStatusRsltsConfirmed" )
    private String inspLotStatusRsltsConfirmed;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStatusRsltsConfirmed</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STATUS_RSLTS_CONFIRMED =
        new InspectionLotWithStatusField<String>("InspLotStatusRsltsConfirmed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStsDefectsRecorded</b>
     * </p>
     *
     * @return The inspLotStsDefectsRecorded contained in this entity.
     */
    @SerializedName( "InspLotStsDefectsRecorded" )
    @JsonProperty( "InspLotStsDefectsRecorded" )
    @Nullable
    @ODataField( odataName = "InspLotStsDefectsRecorded" )
    private String inspLotStsDefectsRecorded;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStsDefectsRecorded</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STS_DEFECTS_RECORDED =
        new InspectionLotWithStatusField<String>("InspLotStsDefectsRecorded");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStsShrtTrmInspCmpltd</b>
     * </p>
     *
     * @return The inspLotStsShrtTrmInspCmpltd contained in this entity.
     */
    @SerializedName( "InspLotStsShrtTrmInspCmpltd" )
    @JsonProperty( "InspLotStsShrtTrmInspCmpltd" )
    @Nullable
    @ODataField( odataName = "InspLotStsShrtTrmInspCmpltd" )
    private String inspLotStsShrtTrmInspCmpltd;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStsShrtTrmInspCmpltd</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STS_SHRT_TRM_INSP_CMPLTD =
        new InspectionLotWithStatusField<String>("InspLotStsShrtTrmInspCmpltd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusInspCompleted</b>
     * </p>
     *
     * @return The inspLotStatusInspCompleted contained in this entity.
     */
    @SerializedName( "InspLotStatusInspCompleted" )
    @JsonProperty( "InspLotStatusInspCompleted" )
    @Nullable
    @ODataField( odataName = "InspLotStatusInspCompleted" )
    private String inspLotStatusInspCompleted;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStatusInspCompleted</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STATUS_INSP_COMPLETED =
        new InspectionLotWithStatusField<String>("InspLotStatusInspCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusCanceled</b>
     * </p>
     *
     * @return The inspLotStatusCanceled contained in this entity.
     */
    @SerializedName( "InspLotStatusCanceled" )
    @JsonProperty( "InspLotStatusCanceled" )
    @Nullable
    @ODataField( odataName = "InspLotStatusCanceled" )
    private String inspLotStatusCanceled;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStatusCanceled</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STATUS_CANCELED =
        new InspectionLotWithStatusField<String>("InspLotStatusCanceled");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusRepair</b>
     * </p>
     *
     * @return The inspLotStatusRepair contained in this entity.
     */
    @SerializedName( "InspLotStatusRepair" )
    @JsonProperty( "InspLotStatusRepair" )
    @Nullable
    @ODataField( odataName = "InspLotStatusRepair" )
    private String inspLotStatusRepair;
    /**
     * Use with available fluent helpers to apply the <b>InspLotStatusRepair</b> field to query operations.
     *
     */
    public final static InspectionLotWithStatusField<String> INSP_LOT_STATUS_REPAIR =
        new InspectionLotWithStatusField<String>("InspLotStatusRepair");

    @Nonnull
    @Override
    public Class<InspectionLotWithStatus> getType()
    {
        return InspectionLotWithStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusCreated</b>
     * </p>
     *
     * @param inspectionLotStatusCreated
     *            The inspectionLotStatusCreated to set.
     */
    public void setInspectionLotStatusCreated( @Nullable final String inspectionLotStatusCreated )
    {
        rememberChangedField("InspectionLotStatusCreated", this.inspectionLotStatusCreated);
        this.inspectionLotStatusCreated = inspectionLotStatusCreated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusReleased</b>
     * </p>
     *
     * @param inspectionLotStatusReleased
     *            The inspectionLotStatusReleased to set.
     */
    public void setInspectionLotStatusReleased( @Nullable final String inspectionLotStatusReleased )
    {
        rememberChangedField("InspectionLotStatusReleased", this.inspectionLotStatusReleased);
        this.inspectionLotStatusReleased = inspectionLotStatusReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotStatusSkip</b>
     * </p>
     *
     * @param inspectionLotStatusSkip
     *            The inspectionLotStatusSkip to set.
     */
    public void setInspectionLotStatusSkip( @Nullable final String inspectionLotStatusSkip )
    {
        rememberChangedField("InspectionLotStatusSkip", this.inspectionLotStatusSkip);
        this.inspectionLotStatusSkip = inspectionLotStatusSkip;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusRsltsConfirmed</b>
     * </p>
     *
     * @param inspLotStatusRsltsConfirmed
     *            The inspLotStatusRsltsConfirmed to set.
     */
    public void setInspLotStatusRsltsConfirmed( @Nullable final String inspLotStatusRsltsConfirmed )
    {
        rememberChangedField("InspLotStatusRsltsConfirmed", this.inspLotStatusRsltsConfirmed);
        this.inspLotStatusRsltsConfirmed = inspLotStatusRsltsConfirmed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStsDefectsRecorded</b>
     * </p>
     *
     * @param inspLotStsDefectsRecorded
     *            The inspLotStsDefectsRecorded to set.
     */
    public void setInspLotStsDefectsRecorded( @Nullable final String inspLotStsDefectsRecorded )
    {
        rememberChangedField("InspLotStsDefectsRecorded", this.inspLotStsDefectsRecorded);
        this.inspLotStsDefectsRecorded = inspLotStsDefectsRecorded;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStsShrtTrmInspCmpltd</b>
     * </p>
     *
     * @param inspLotStsShrtTrmInspCmpltd
     *            The inspLotStsShrtTrmInspCmpltd to set.
     */
    public void setInspLotStsShrtTrmInspCmpltd( @Nullable final String inspLotStsShrtTrmInspCmpltd )
    {
        rememberChangedField("InspLotStsShrtTrmInspCmpltd", this.inspLotStsShrtTrmInspCmpltd);
        this.inspLotStsShrtTrmInspCmpltd = inspLotStsShrtTrmInspCmpltd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusInspCompleted</b>
     * </p>
     *
     * @param inspLotStatusInspCompleted
     *            The inspLotStatusInspCompleted to set.
     */
    public void setInspLotStatusInspCompleted( @Nullable final String inspLotStatusInspCompleted )
    {
        rememberChangedField("InspLotStatusInspCompleted", this.inspLotStatusInspCompleted);
        this.inspLotStatusInspCompleted = inspLotStatusInspCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusCanceled</b>
     * </p>
     *
     * @param inspLotStatusCanceled
     *            The inspLotStatusCanceled to set.
     */
    public void setInspLotStatusCanceled( @Nullable final String inspLotStatusCanceled )
    {
        rememberChangedField("InspLotStatusCanceled", this.inspLotStatusCanceled);
        this.inspLotStatusCanceled = inspLotStatusCanceled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspLotStatusRepair</b>
     * </p>
     *
     * @param inspLotStatusRepair
     *            The inspLotStatusRepair to set.
     */
    public void setInspLotStatusRepair( @Nullable final String inspLotStatusRepair )
    {
        rememberChangedField("InspLotStatusRepair", this.inspLotStatusRepair);
        this.inspLotStatusRepair = inspLotStatusRepair;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionLotWithStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspectionLotStatusCreated", getInspectionLotStatusCreated());
        values.put("InspectionLotStatusReleased", getInspectionLotStatusReleased());
        values.put("InspectionLotStatusSkip", getInspectionLotStatusSkip());
        values.put("InspLotStatusRsltsConfirmed", getInspLotStatusRsltsConfirmed());
        values.put("InspLotStsDefectsRecorded", getInspLotStsDefectsRecorded());
        values.put("InspLotStsShrtTrmInspCmpltd", getInspLotStsShrtTrmInspCmpltd());
        values.put("InspLotStatusInspCompleted", getInspLotStatusInspCompleted());
        values.put("InspLotStatusCanceled", getInspLotStatusCanceled());
        values.put("InspLotStatusRepair", getInspLotStatusRepair());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspectionLotStatusCreated") ) {
                final Object value = values.remove("InspectionLotStatusCreated");
                if( (value == null) || (!value.equals(getInspectionLotStatusCreated())) ) {
                    setInspectionLotStatusCreated(((String) value));
                }
            }
            if( values.containsKey("InspectionLotStatusReleased") ) {
                final Object value = values.remove("InspectionLotStatusReleased");
                if( (value == null) || (!value.equals(getInspectionLotStatusReleased())) ) {
                    setInspectionLotStatusReleased(((String) value));
                }
            }
            if( values.containsKey("InspectionLotStatusSkip") ) {
                final Object value = values.remove("InspectionLotStatusSkip");
                if( (value == null) || (!value.equals(getInspectionLotStatusSkip())) ) {
                    setInspectionLotStatusSkip(((String) value));
                }
            }
            if( values.containsKey("InspLotStatusRsltsConfirmed") ) {
                final Object value = values.remove("InspLotStatusRsltsConfirmed");
                if( (value == null) || (!value.equals(getInspLotStatusRsltsConfirmed())) ) {
                    setInspLotStatusRsltsConfirmed(((String) value));
                }
            }
            if( values.containsKey("InspLotStsDefectsRecorded") ) {
                final Object value = values.remove("InspLotStsDefectsRecorded");
                if( (value == null) || (!value.equals(getInspLotStsDefectsRecorded())) ) {
                    setInspLotStsDefectsRecorded(((String) value));
                }
            }
            if( values.containsKey("InspLotStsShrtTrmInspCmpltd") ) {
                final Object value = values.remove("InspLotStsShrtTrmInspCmpltd");
                if( (value == null) || (!value.equals(getInspLotStsShrtTrmInspCmpltd())) ) {
                    setInspLotStsShrtTrmInspCmpltd(((String) value));
                }
            }
            if( values.containsKey("InspLotStatusInspCompleted") ) {
                final Object value = values.remove("InspLotStatusInspCompleted");
                if( (value == null) || (!value.equals(getInspLotStatusInspCompleted())) ) {
                    setInspLotStatusInspCompleted(((String) value));
                }
            }
            if( values.containsKey("InspLotStatusCanceled") ) {
                final Object value = values.remove("InspLotStatusCanceled");
                if( (value == null) || (!value.equals(getInspLotStatusCanceled())) ) {
                    setInspLotStatusCanceled(((String) value));
                }
            }
            if( values.containsKey("InspLotStatusRepair") ) {
                final Object value = values.remove("InspLotStatusRepair");
                if( (value == null) || (!value.equals(getInspLotStatusRepair())) ) {
                    setInspLotStatusRepair(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionLotWithStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionLotWithStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionLotWithStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionLotWithStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
