/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionOperation extends VdmEntity<InspectionOperation>
{

    /**
     * Selector for all available fields of InspectionOperation.
     *
     */
    public final static InspectionOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> INSPECTION_LOT =
        new InspectionOperationField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspectionOperationField<String>("InspPlanOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new InspectionOperationField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionOperation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "InspectionOperation" )
    @JsonProperty( "InspectionOperation" )
    @Nullable
    @ODataField( odataName = "InspectionOperation" )
    private String inspectionOperation;
    /**
     * Use with available fluent helpers to apply the <b>InspectionOperation</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> INSPECTION_OPERATION =
        new InspectionOperationField<String>("InspectionOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionOperationPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "InspectionOperationPlant" )
    @JsonProperty( "InspectionOperationPlant" )
    @Nullable
    @ODataField( odataName = "InspectionOperationPlant" )
    private String inspectionOperationPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionOperationPlant</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> INSPECTION_OPERATION_PLANT =
        new InspectionOperationField<String>("InspectionOperationPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "BillOfOperationsType" )
    @JsonProperty( "BillOfOperationsType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsType" )
    private String billOfOperationsType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsType</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> BILL_OF_OPERATIONS_TYPE =
        new InspectionOperationField<String>("BillOfOperationsType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @SerializedName( "BOOOperationInternalID" )
    @JsonProperty( "BOOOperationInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationInternalID" )
    private String bOOOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> BOO_OPERATION_INTERNAL_ID =
        new InspectionOperationField<String>("BOOOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> WORK_CENTER_INTERNAL_ID =
        new InspectionOperationField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>StatusObject</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "StatusObject" )
    @JsonProperty( "StatusObject" )
    @Nullable
    @ODataField( odataName = "StatusObject" )
    private String statusObject;
    /**
     * Use with available fluent helpers to apply the <b>StatusObject</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> STATUS_OBJECT =
        new InspectionOperationField<String>("StatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> OPERATION_CONTROL_PROFILE =
        new InspectionOperationField<String>("OperationControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmation</b>
     * </p>
     *
     * @return Completion confirmation number for the operation
     */
    @SerializedName( "OperationConfirmation" )
    @JsonProperty( "OperationConfirmation" )
    @Nullable
    @ODataField( odataName = "OperationConfirmation" )
    private String operationConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>OperationConfirmation</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> OPERATION_CONFIRMATION =
        new InspectionOperationField<String>("OperationConfirmation");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubSystem</b>
     * </p>
     *
     * @return Subsystem Identifier for QM Subsystem Interface
     */
    @SerializedName( "InspectionSubSystem" )
    @JsonProperty( "InspectionSubSystem" )
    @Nullable
    @ODataField( odataName = "InspectionSubSystem" )
    private String inspectionSubSystem;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubSystem</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> INSPECTION_SUB_SYSTEM =
        new InspectionOperationField<String>("InspectionSubSystem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationText" )
    @JsonProperty( "OperationText" )
    @Nullable
    @ODataField( odataName = "OperationText" )
    private String operationText;
    /**
     * Use with available fluent helpers to apply the <b>OperationText</b> field to query operations.
     *
     */
    public final static InspectionOperationField<String> OPERATION_TEXT =
        new InspectionOperationField<String>("OperationText");

    @Nonnull
    @Override
    public Class<InspectionOperation> getType()
    {
        return InspectionOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Routing number of operations in the order
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionOperation</b>
     * </p>
     *
     * @param inspectionOperation
     *            Operation/Activity Number
     */
    public void setInspectionOperation( @Nullable final String inspectionOperation )
    {
        rememberChangedField("InspectionOperation", this.inspectionOperation);
        this.inspectionOperation = inspectionOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionOperationPlant</b>
     * </p>
     *
     * @param inspectionOperationPlant
     *            Plant
     */
    public void setInspectionOperationPlant( @Nullable final String inspectionOperationPlant )
    {
        rememberChangedField("InspectionOperationPlant", this.inspectionOperationPlant);
        this.inspectionOperationPlant = inspectionOperationPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @param billOfOperationsType
     *            Task List Type
     */
    public void setBillOfOperationsType( @Nullable final String billOfOperationsType )
    {
        rememberChangedField("BillOfOperationsType", this.billOfOperationsType);
        this.billOfOperationsType = billOfOperationsType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     */
    public void setBOOOperationInternalID( @Nullable final String bOOOperationInternalID )
    {
        rememberChangedField("BOOOperationInternalID", this.bOOOperationInternalID);
        this.bOOOperationInternalID = bOOOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>StatusObject</b>
     * </p>
     *
     * @param statusObject
     *            Object Number
     */
    public void setStatusObject( @Nullable final String statusObject )
    {
        rememberChangedField("StatusObject", this.statusObject);
        this.statusObject = statusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmation</b>
     * </p>
     *
     * @param operationConfirmation
     *            Completion confirmation number for the operation
     */
    public void setOperationConfirmation( @Nullable final String operationConfirmation )
    {
        rememberChangedField("OperationConfirmation", this.operationConfirmation);
        this.operationConfirmation = operationConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubSystem</b>
     * </p>
     *
     * @param inspectionSubSystem
     *            Subsystem Identifier for QM Subsystem Interface
     */
    public void setInspectionSubSystem( @Nullable final String inspectionSubSystem )
    {
        rememberChangedField("InspectionSubSystem", this.inspectionSubSystem);
        this.inspectionSubSystem = inspectionSubSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("InspectionOperation", getInspectionOperation());
        values.put("InspectionOperationPlant", getInspectionOperationPlant());
        values.put("BillOfOperationsType", getBillOfOperationsType());
        values.put("BOOOperationInternalID", getBOOOperationInternalID());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("StatusObject", getStatusObject());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("OperationConfirmation", getOperationConfirmation());
        values.put("InspectionSubSystem", getInspectionSubSystem());
        values.put("OperationText", getOperationText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("InspectionOperation") ) {
                final Object value = values.remove("InspectionOperation");
                if( (value == null) || (!value.equals(getInspectionOperation())) ) {
                    setInspectionOperation(((String) value));
                }
            }
            if( values.containsKey("InspectionOperationPlant") ) {
                final Object value = values.remove("InspectionOperationPlant");
                if( (value == null) || (!value.equals(getInspectionOperationPlant())) ) {
                    setInspectionOperationPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsType") ) {
                final Object value = values.remove("BillOfOperationsType");
                if( (value == null) || (!value.equals(getBillOfOperationsType())) ) {
                    setBillOfOperationsType(((String) value));
                }
            }
            if( values.containsKey("BOOOperationInternalID") ) {
                final Object value = values.remove("BOOOperationInternalID");
                if( (value == null) || (!value.equals(getBOOOperationInternalID())) ) {
                    setBOOOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("StatusObject") ) {
                final Object value = values.remove("StatusObject");
                if( (value == null) || (!value.equals(getStatusObject())) ) {
                    setStatusObject(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("OperationConfirmation") ) {
                final Object value = values.remove("OperationConfirmation");
                if( (value == null) || (!value.equals(getOperationConfirmation())) ) {
                    setOperationConfirmation(((String) value));
                }
            }
            if( values.containsKey("InspectionSubSystem") ) {
                final Object value = values.remove("InspectionSubSystem");
                if( (value == null) || (!value.equals(getInspectionSubSystem())) ) {
                    setInspectionSubSystem(((String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
