/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Summarized Inspection Results
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionResultType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionResult extends VdmEntity<InspectionResult>
{

    /**
     * Selector for all available fields of InspectionResult.
     *
     */
    public final static InspectionResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_LOT =
        new InspectionResultField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspectionResultField<String>("InspPlanOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "InspectionCharacteristic" )
    @JsonProperty( "InspectionCharacteristic" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristic" )
    private String inspectionCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristic</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_CHARACTERISTIC =
        new InspectionResultField<String>("InspectionCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultStatus</b>
     * </p>
     *
     * @return Results Record Status
     */
    @SerializedName( "InspectionResultStatus" )
    @JsonProperty( "InspectionResultStatus" )
    @Nullable
    @ODataField( odataName = "InspectionResultStatus" )
    private String inspectionResultStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultStatus</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_STATUS =
        new InspectionResultField<String>("InspectionResultStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultAttribute</b>
     * </p>
     *
     * @return Attribute of Results Record (Valid, Invalid,...)
     */
    @SerializedName( "InspectionResultAttribute" )
    @JsonProperty( "InspectionResultAttribute" )
    @Nullable
    @ODataField( odataName = "InspectionResultAttribute" )
    private String inspectionResultAttribute;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultAttribute</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_ATTRIBUTE =
        new InspectionResultField<String>("InspectionResultAttribute");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOrigin</b>
     * </p>
     *
     * @return Origin of Results Data
     */
    @SerializedName( "InspectionResultOrigin" )
    @JsonProperty( "InspectionResultOrigin" )
    @Nullable
    @ODataField( odataName = "InspectionResultOrigin" )
    private String inspectionResultOrigin;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultOrigin</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_ORIGIN =
        new InspectionResultField<String>("InspectionResultOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @return Name of Inspector
     */
    @SerializedName( "Inspector" )
    @JsonProperty( "Inspector" )
    @Nullable
    @ODataField( odataName = "Inspector" )
    private String inspector;
    /**
     * Use with available fluent helpers to apply the <b>Inspector</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTOR = new InspectionResultField<String>("Inspector");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionValuationResult</b>
     * </p>
     *
     * @return Inspection Result Valuation
     */
    @SerializedName( "InspectionValuationResult" )
    @JsonProperty( "InspectionValuationResult" )
    @Nullable
    @ODataField( odataName = "InspectionValuationResult" )
    private String inspectionValuationResult;
    /**
     * Use with available fluent helpers to apply the <b>InspectionValuationResult</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_VALUATION_RESULT =
        new InspectionResultField<String>("InspectionValuationResult");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMeanValue</b>
     * </p>
     *
     * @return Arithmetic Mean of Valid Measured Values
     */
    @SerializedName( "InspectionResultMeanValue" )
    @JsonProperty( "InspectionResultMeanValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultMeanValue" )
    private Double inspectionResultMeanValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultMeanValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSPECTION_RESULT_MEAN_VALUE =
        new InspectionResultField<Double>("InspectionResultMeanValue");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMeanValue</b>
     * </p>
     *
     * @return Arithmetic Mean of Valid Measured Values (Formatted)
     */
    @SerializedName( "InspResultFrmtdMeanValue" )
    @JsonProperty( "InspResultFrmtdMeanValue" )
    @Nullable
    @ODataField( odataName = "InspResultFrmtdMeanValue" )
    private String inspResultFrmtdMeanValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultFrmtdMeanValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_FRMTD_MEAN_VALUE =
        new InspectionResultField<String>("InspResultFrmtdMeanValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultHasMeanValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspectionResultHasMeanValue" )
    @JsonProperty( "InspectionResultHasMeanValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultHasMeanValue" )
    private String inspectionResultHasMeanValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultHasMeanValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_HAS_MEAN_VALUE =
        new InspectionResultField<String>("InspectionResultHasMeanValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMaximumValue</b>
     * </p>
     *
     * @return Maximum Value of Valid Measured Values
     */
    @SerializedName( "InspectionResultMaximumValue" )
    @JsonProperty( "InspectionResultMaximumValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultMaximumValue" )
    private Double inspectionResultMaximumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultMaximumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSPECTION_RESULT_MAXIMUM_VALUE =
        new InspectionResultField<Double>("InspectionResultMaximumValue");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMaximumValue</b>
     * </p>
     *
     * @return Maximum Value of Valid Measured Values - formatted
     */
    @SerializedName( "InspResultFrmtdMaximumValue" )
    @JsonProperty( "InspResultFrmtdMaximumValue" )
    @Nullable
    @ODataField( odataName = "InspResultFrmtdMaximumValue" )
    private String inspResultFrmtdMaximumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultFrmtdMaximumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_FRMTD_MAXIMUM_VALUE =
        new InspectionResultField<String>("InspResultFrmtdMaximumValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMaximumValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspResultHasMaximumValue" )
    @JsonProperty( "InspResultHasMaximumValue" )
    @Nullable
    @ODataField( odataName = "InspResultHasMaximumValue" )
    private String inspResultHasMaximumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultHasMaximumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_HAS_MAXIMUM_VALUE =
        new InspectionResultField<String>("InspResultHasMaximumValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMinimumValue</b>
     * </p>
     *
     * @return Minimum Value of Valid Measured Values
     */
    @SerializedName( "InspectionResultMinimumValue" )
    @JsonProperty( "InspectionResultMinimumValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultMinimumValue" )
    private Double inspectionResultMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultMinimumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSPECTION_RESULT_MINIMUM_VALUE =
        new InspectionResultField<Double>("InspectionResultMinimumValue");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMinimumValue</b>
     * </p>
     *
     * @return Minimum Value of Valid Measured Values (Formatted)
     */
    @SerializedName( "InspResultFrmtdMinimumValue" )
    @JsonProperty( "InspResultFrmtdMinimumValue" )
    @Nullable
    @ODataField( odataName = "InspResultFrmtdMinimumValue" )
    private String inspResultFrmtdMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultFrmtdMinimumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_FRMTD_MINIMUM_VALUE =
        new InspectionResultField<String>("InspResultFrmtdMinimumValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMinimumValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspResultHasMinimumValue" )
    @JsonProperty( "InspResultHasMinimumValue" )
    @Nullable
    @ODataField( odataName = "InspResultHasMinimumValue" )
    private String inspResultHasMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultHasMinimumValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_HAS_MINIMUM_VALUE =
        new InspectionResultField<String>("InspResultHasMinimumValue");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOriginalValue</b>
     * </p>
     *
     * @return Original Value Before Input Processing
     */
    @SerializedName( "InspectionResultOriginalValue" )
    @JsonProperty( "InspectionResultOriginalValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultOriginalValue" )
    private String inspectionResultOriginalValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultOriginalValue</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_ORIGINAL_VALUE =
        new InspectionResultField<String>("InspectionResultOriginalValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspResultValidValuesNumber</b>
     * </p>
     *
     * @return Number of Inspected Sample Units
     */
    @SerializedName( "InspResultValidValuesNumber" )
    @JsonProperty( "InspResultValidValuesNumber" )
    @Nullable
    @ODataField( odataName = "InspResultValidValuesNumber" )
    private Integer inspResultValidValuesNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspResultValidValuesNumber</b> field to query operations.
     *
     */
    public final static InspectionResultField<Integer> INSP_RESULT_VALID_VALUES_NUMBER =
        new InspectionResultField<Integer>("InspResultValidValuesNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultText</b>
     * </p>
     *
     * @return Inspection Description for Summarized Result
     */
    @SerializedName( "InspectionResultText" )
    @JsonProperty( "InspectionResultText" )
    @Nullable
    @ODataField( odataName = "InspectionResultText" )
    private String inspectionResultText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultText</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_TEXT =
        new InspectionResultField<String>("InspectionResultText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultHasLongText</b>
     * </p>
     *
     * @return Inspection Characteristic Long Text Exists
     */
    @SerializedName( "InspectionResultHasLongText" )
    @JsonProperty( "InspectionResultHasLongText" )
    @Nullable
    @ODataField( odataName = "InspectionResultHasLongText" )
    private String inspectionResultHasLongText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultHasLongText</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_HAS_LONG_TEXT =
        new InspectionResultField<String>("InspectionResultHasLongText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "CharacteristicAttributeCatalog" )
    @JsonProperty( "CharacteristicAttributeCatalog" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCatalog" )
    private String characteristicAttributeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCatalog</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> CHARACTERISTIC_ATTRIBUTE_CATALOG =
        new InspectionResultField<String>("CharacteristicAttributeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "CharacteristicAttributeCodeGrp" )
    @JsonProperty( "CharacteristicAttributeCodeGrp" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCodeGrp" )
    private String characteristicAttributeCodeGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCodeGrp</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> CHARACTERISTIC_ATTRIBUTE_CODE_GRP =
        new InspectionResultField<String>("CharacteristicAttributeCodeGrp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "CharacteristicAttributeCode" )
    @JsonProperty( "CharacteristicAttributeCode" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCode" )
    private String characteristicAttributeCode;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCode</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> CHARACTERISTIC_ATTRIBUTE_CODE =
        new InspectionResultField<String>("CharacteristicAttributeCode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFreeDefinedTestEquip</b>
     * </p>
     *
     * @return General Information
     */
    @SerializedName( "InspRsltFreeDefinedTestEquip" )
    @JsonProperty( "InspRsltFreeDefinedTestEquip" )
    @Nullable
    @ODataField( odataName = "InspRsltFreeDefinedTestEquip" )
    private String inspRsltFreeDefinedTestEquip;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltFreeDefinedTestEquip</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RSLT_FREE_DEFINED_TEST_EQUIP =
        new InspectionResultField<String>("InspRsltFreeDefinedTestEquip");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltBelowToleranceValsNmbr</b>
     * </p>
     *
     * @return Number of Measured Values Below Tolerance Range
     */
    @SerializedName( "InspRsltBelowToleranceValsNmbr" )
    @JsonProperty( "InspRsltBelowToleranceValsNmbr" )
    @Nullable
    @ODataField( odataName = "InspRsltBelowToleranceValsNmbr" )
    private Integer inspRsltBelowToleranceValsNmbr;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltBelowToleranceValsNmbr</b> field to query operations.
     *
     */
    public final static InspectionResultField<Integer> INSP_RSLT_BELOW_TOLERANCE_VALS_NMBR =
        new InspectionResultField<Integer>("InspRsltBelowToleranceValsNmbr");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltAboveToleranceValsNmbr</b>
     * </p>
     *
     * @return Number of Measured Values Above Tolerance Range
     */
    @SerializedName( "InspRsltAboveToleranceValsNmbr" )
    @JsonProperty( "InspRsltAboveToleranceValsNmbr" )
    @Nullable
    @ODataField( odataName = "InspRsltAboveToleranceValsNmbr" )
    private Integer inspRsltAboveToleranceValsNmbr;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltAboveToleranceValsNmbr</b> field to query operations.
     *
     */
    public final static InspectionResultField<Integer> INSP_RSLT_ABOVE_TOLERANCE_VALS_NMBR =
        new InspectionResultField<Integer>("InspRsltAboveToleranceValsNmbr");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltNonconformingValsNmbr</b>
     * </p>
     *
     * @return Number of Nonconforming Sample Units
     */
    @SerializedName( "InspRsltNonconformingValsNmbr" )
    @JsonProperty( "InspRsltNonconformingValsNmbr" )
    @Nullable
    @ODataField( odataName = "InspRsltNonconformingValsNmbr" )
    private Integer inspRsltNonconformingValsNmbr;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltNonconformingValsNmbr</b> field to query operations.
     *
     */
    public final static InspectionResultField<Integer> INSP_RSLT_NONCONFORMING_VALS_NMBR =
        new InspectionResultField<Integer>("InspRsltNonconformingValsNmbr");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionNumberOfDefects</b>
     * </p>
     *
     * @return Number of Defects Found
     */
    @SerializedName( "InspectionNumberOfDefects" )
    @JsonProperty( "InspectionNumberOfDefects" )
    @Nullable
    @ODataField( odataName = "InspectionNumberOfDefects" )
    private Integer inspectionNumberOfDefects;
    /**
     * Use with available fluent helpers to apply the <b>InspectionNumberOfDefects</b> field to query operations.
     *
     */
    public final static InspectionResultField<Integer> INSPECTION_NUMBER_OF_DEFECTS =
        new InspectionResultField<Integer>("InspectionNumberOfDefects");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @return Defect Class
     */
    @SerializedName( "DefectClass" )
    @JsonProperty( "DefectClass" )
    @Nullable
    @ODataField( odataName = "DefectClass" )
    private String defectClass;
    /**
     * Use with available fluent helpers to apply the <b>DefectClass</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> DEFECT_CLASS = new InspectionResultField<String>("DefectClass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltAboveToleranceFraction</b>
     * </p>
     *
     * @return Estimated Fraction Above Tolerance Range
     */
    @SerializedName( "InspRsltAboveToleranceFraction" )
    @JsonProperty( "InspRsltAboveToleranceFraction" )
    @Nullable
    @ODataField( odataName = "InspRsltAboveToleranceFraction" )
    private Double inspRsltAboveToleranceFraction;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltAboveToleranceFraction</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSP_RSLT_ABOVE_TOLERANCE_FRACTION =
        new InspectionResultField<Double>("InspRsltAboveToleranceFraction");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFrmtdAbvTolFraction</b>
     * </p>
     *
     * @return Estimated Fraction Above Tolerance Range (Formatted)
     */
    @SerializedName( "InspRsltFrmtdAbvTolFraction" )
    @JsonProperty( "InspRsltFrmtdAbvTolFraction" )
    @Nullable
    @ODataField( odataName = "InspRsltFrmtdAbvTolFraction" )
    private String inspRsltFrmtdAbvTolFraction;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltFrmtdAbvTolFraction</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RSLT_FRMTD_ABV_TOL_FRACTION =
        new InspectionResultField<String>("InspRsltFrmtdAbvTolFraction");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltBelowToleranceFraction</b>
     * </p>
     *
     * @return Estimated Fraction Below Tolerance Range
     */
    @SerializedName( "InspRsltBelowToleranceFraction" )
    @JsonProperty( "InspRsltBelowToleranceFraction" )
    @Nullable
    @ODataField( odataName = "InspRsltBelowToleranceFraction" )
    private Double inspRsltBelowToleranceFraction;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltBelowToleranceFraction</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSP_RSLT_BELOW_TOLERANCE_FRACTION =
        new InspectionResultField<Double>("InspRsltBelowToleranceFraction");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFrmtdBelowTolFraction</b>
     * </p>
     *
     * @return Estimated Fraction Below Tolerance Range (Formatted)
     */
    @SerializedName( "InspRsltFrmtdBelowTolFraction" )
    @JsonProperty( "InspRsltFrmtdBelowTolFraction" )
    @Nullable
    @ODataField( odataName = "InspRsltFrmtdBelowTolFraction" )
    private String inspRsltFrmtdBelowTolFraction;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltFrmtdBelowTolFraction</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RSLT_FRMTD_BELOW_TOL_FRACTION =
        new InspectionResultField<String>("InspRsltFrmtdBelowTolFraction");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspResultVariance</b>
     * </p>
     *
     * @return Dispersion (Variance) of Valid Measured Values
     */
    @SerializedName( "InspResultVariance" )
    @JsonProperty( "InspResultVariance" )
    @Nullable
    @ODataField( odataName = "InspResultVariance" )
    private Double inspResultVariance;
    /**
     * Use with available fluent helpers to apply the <b>InspResultVariance</b> field to query operations.
     *
     */
    public final static InspectionResultField<Double> INSP_RESULT_VARIANCE =
        new InspectionResultField<Double>("InspResultVariance");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdVariance</b>
     * </p>
     *
     * @return Dispersion (Variance) of Valid Measured Values (Formatted)
     */
    @SerializedName( "InspResultFrmtdVariance" )
    @JsonProperty( "InspResultFrmtdVariance" )
    @Nullable
    @ODataField( odataName = "InspResultFrmtdVariance" )
    private String inspResultFrmtdVariance;
    /**
     * Use with available fluent helpers to apply the <b>InspResultFrmtdVariance</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSP_RESULT_FRMTD_VARIANCE =
        new InspectionResultField<String>("InspResultFrmtdVariance");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog2</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspectionResultCatalog2" )
    @JsonProperty( "InspectionResultCatalog2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog2" )
    private String inspectionResultCatalog2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog2</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CATALOG2 =
        new InspectionResultField<String>("InspectionResultCatalog2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog3</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspectionResultCatalog3" )
    @JsonProperty( "InspectionResultCatalog3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog3" )
    private String inspectionResultCatalog3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog3</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CATALOG3 =
        new InspectionResultField<String>("InspectionResultCatalog3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog4</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspectionResultCatalog4" )
    @JsonProperty( "InspectionResultCatalog4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog4" )
    private String inspectionResultCatalog4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog4</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CATALOG4 =
        new InspectionResultField<String>("InspectionResultCatalog4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog5</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspectionResultCatalog5" )
    @JsonProperty( "InspectionResultCatalog5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog5" )
    private String inspectionResultCatalog5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog5</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CATALOG5 =
        new InspectionResultField<String>("InspectionResultCatalog5");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode2</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode2" )
    @JsonProperty( "InspectionResultCode2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode2" )
    private String inspectionResultCode2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode2</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE2 =
        new InspectionResultField<String>("InspectionResultCode2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode3</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode3" )
    @JsonProperty( "InspectionResultCode3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode3" )
    private String inspectionResultCode3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode3</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE3 =
        new InspectionResultField<String>("InspectionResultCode3");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode4</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode4" )
    @JsonProperty( "InspectionResultCode4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode4" )
    private String inspectionResultCode4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode4</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE4 =
        new InspectionResultField<String>("InspectionResultCode4");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode5</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode5" )
    @JsonProperty( "InspectionResultCode5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode5" )
    private String inspectionResultCode5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode5</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE5 =
        new InspectionResultField<String>("InspectionResultCode5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup2</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup2" )
    @JsonProperty( "InspectionResultCodeGroup2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup2" )
    private String inspectionResultCodeGroup2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup2</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE_GROUP2 =
        new InspectionResultField<String>("InspectionResultCodeGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup3</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup3" )
    @JsonProperty( "InspectionResultCodeGroup3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup3" )
    private String inspectionResultCodeGroup3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup3</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE_GROUP3 =
        new InspectionResultField<String>("InspectionResultCodeGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup4</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup4" )
    @JsonProperty( "InspectionResultCodeGroup4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup4" )
    private String inspectionResultCodeGroup4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup4</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE_GROUP4 =
        new InspectionResultField<String>("InspectionResultCodeGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup5</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup5" )
    @JsonProperty( "InspectionResultCodeGroup5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup5" )
    private String inspectionResultCodeGroup5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup5</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> INSPECTION_RESULT_CODE_GROUP5 =
        new InspectionResultField<String>("InspectionResultCodeGroup5");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialSampleSize</b>
     * </p>
     *
     * @return Number of Partial Samples for Characteristic
     */
    @SerializedName( "InspectionPartialSampleSize" )
    @JsonProperty( "InspectionPartialSampleSize" )
    @Nullable
    @ODataField( odataName = "InspectionPartialSampleSize" )
    private Short inspectionPartialSampleSize;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPartialSampleSize</b> field to query operations.
     *
     */
    public final static InspectionResultField<Short> INSPECTION_PARTIAL_SAMPLE_SIZE =
        new InspectionResultField<Short>("InspectionPartialSampleSize");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartDate</b>
     * </p>
     *
     * @return Start Date in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionStartDate" )
    @JsonProperty( "InspectionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionStartDate</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalDateTime> INSPECTION_START_DATE =
        new InspectionResultField<LocalDateTime>("InspectionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartTime</b>
     * </p>
     *
     * @return Start Time in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionStartTime" )
    @JsonProperty( "InspectionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionStartTime</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalTime> INSPECTION_START_TIME =
        new InspectionResultField<LocalTime>("InspectionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndDate</b>
     * </p>
     *
     * @return Inspection End Date
     */
    @SerializedName( "InspectionEndDate" )
    @JsonProperty( "InspectionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionEndDate</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalDateTime> INSPECTION_END_DATE =
        new InspectionResultField<LocalDateTime>("InspectionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndTime</b>
     * </p>
     *
     * @return End Time in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionEndTime" )
    @JsonProperty( "InspectionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionEndTime</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalTime> INSPECTION_END_TIME =
        new InspectionResultField<LocalTime>("InspectionEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> CREATED_BY_USER =
        new InspectionResultField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalDateTime> CREATION_DATE =
        new InspectionResultField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionResultField<String> LAST_CHANGED_BY_USER =
        new InspectionResultField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspectionResultField<LocalDateTime> LAST_CHANGE_DATE =
        new InspectionResultField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionResultField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionResultField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspectionResult> getType()
    {
        return InspectionResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     */
    public void setInspectionCharacteristic( @Nullable final String inspectionCharacteristic )
    {
        rememberChangedField("InspectionCharacteristic", this.inspectionCharacteristic);
        this.inspectionCharacteristic = inspectionCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultStatus</b>
     * </p>
     *
     * @param inspectionResultStatus
     *            Results Record Status
     */
    public void setInspectionResultStatus( @Nullable final String inspectionResultStatus )
    {
        rememberChangedField("InspectionResultStatus", this.inspectionResultStatus);
        this.inspectionResultStatus = inspectionResultStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultAttribute</b>
     * </p>
     *
     * @param inspectionResultAttribute
     *            Attribute of Results Record (Valid, Invalid,...)
     */
    public void setInspectionResultAttribute( @Nullable final String inspectionResultAttribute )
    {
        rememberChangedField("InspectionResultAttribute", this.inspectionResultAttribute);
        this.inspectionResultAttribute = inspectionResultAttribute;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOrigin</b>
     * </p>
     *
     * @param inspectionResultOrigin
     *            Origin of Results Data
     */
    public void setInspectionResultOrigin( @Nullable final String inspectionResultOrigin )
    {
        rememberChangedField("InspectionResultOrigin", this.inspectionResultOrigin);
        this.inspectionResultOrigin = inspectionResultOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @param inspector
     *            Name of Inspector
     */
    public void setInspector( @Nullable final String inspector )
    {
        rememberChangedField("Inspector", this.inspector);
        this.inspector = inspector;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionValuationResult</b>
     * </p>
     *
     * @param inspectionValuationResult
     *            Inspection Result Valuation
     */
    public void setInspectionValuationResult( @Nullable final String inspectionValuationResult )
    {
        rememberChangedField("InspectionValuationResult", this.inspectionValuationResult);
        this.inspectionValuationResult = inspectionValuationResult;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMeanValue</b>
     * </p>
     *
     * @param inspectionResultMeanValue
     *            Arithmetic Mean of Valid Measured Values
     */
    public void setInspectionResultMeanValue( @Nullable final Double inspectionResultMeanValue )
    {
        rememberChangedField("InspectionResultMeanValue", this.inspectionResultMeanValue);
        this.inspectionResultMeanValue = inspectionResultMeanValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMeanValue</b>
     * </p>
     *
     * @param inspResultFrmtdMeanValue
     *            Arithmetic Mean of Valid Measured Values (Formatted)
     */
    public void setInspResultFrmtdMeanValue( @Nullable final String inspResultFrmtdMeanValue )
    {
        rememberChangedField("InspResultFrmtdMeanValue", this.inspResultFrmtdMeanValue);
        this.inspResultFrmtdMeanValue = inspResultFrmtdMeanValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultHasMeanValue</b>
     * </p>
     *
     * @param inspectionResultHasMeanValue
     *            Value Not Initial If Set
     */
    public void setInspectionResultHasMeanValue( @Nullable final String inspectionResultHasMeanValue )
    {
        rememberChangedField("InspectionResultHasMeanValue", this.inspectionResultHasMeanValue);
        this.inspectionResultHasMeanValue = inspectionResultHasMeanValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMaximumValue</b>
     * </p>
     *
     * @param inspectionResultMaximumValue
     *            Maximum Value of Valid Measured Values
     */
    public void setInspectionResultMaximumValue( @Nullable final Double inspectionResultMaximumValue )
    {
        rememberChangedField("InspectionResultMaximumValue", this.inspectionResultMaximumValue);
        this.inspectionResultMaximumValue = inspectionResultMaximumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMaximumValue</b>
     * </p>
     *
     * @param inspResultFrmtdMaximumValue
     *            Maximum Value of Valid Measured Values - formatted
     */
    public void setInspResultFrmtdMaximumValue( @Nullable final String inspResultFrmtdMaximumValue )
    {
        rememberChangedField("InspResultFrmtdMaximumValue", this.inspResultFrmtdMaximumValue);
        this.inspResultFrmtdMaximumValue = inspResultFrmtdMaximumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMaximumValue</b>
     * </p>
     *
     * @param inspResultHasMaximumValue
     *            Value Not Initial If Set
     */
    public void setInspResultHasMaximumValue( @Nullable final String inspResultHasMaximumValue )
    {
        rememberChangedField("InspResultHasMaximumValue", this.inspResultHasMaximumValue);
        this.inspResultHasMaximumValue = inspResultHasMaximumValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMinimumValue</b>
     * </p>
     *
     * @param inspectionResultMinimumValue
     *            Minimum Value of Valid Measured Values
     */
    public void setInspectionResultMinimumValue( @Nullable final Double inspectionResultMinimumValue )
    {
        rememberChangedField("InspectionResultMinimumValue", this.inspectionResultMinimumValue);
        this.inspectionResultMinimumValue = inspectionResultMinimumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMinimumValue</b>
     * </p>
     *
     * @param inspResultFrmtdMinimumValue
     *            Minimum Value of Valid Measured Values (Formatted)
     */
    public void setInspResultFrmtdMinimumValue( @Nullable final String inspResultFrmtdMinimumValue )
    {
        rememberChangedField("InspResultFrmtdMinimumValue", this.inspResultFrmtdMinimumValue);
        this.inspResultFrmtdMinimumValue = inspResultFrmtdMinimumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMinimumValue</b>
     * </p>
     *
     * @param inspResultHasMinimumValue
     *            Value Not Initial If Set
     */
    public void setInspResultHasMinimumValue( @Nullable final String inspResultHasMinimumValue )
    {
        rememberChangedField("InspResultHasMinimumValue", this.inspResultHasMinimumValue);
        this.inspResultHasMinimumValue = inspResultHasMinimumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOriginalValue</b>
     * </p>
     *
     * @param inspectionResultOriginalValue
     *            Original Value Before Input Processing
     */
    public void setInspectionResultOriginalValue( @Nullable final String inspectionResultOriginalValue )
    {
        rememberChangedField("InspectionResultOriginalValue", this.inspectionResultOriginalValue);
        this.inspectionResultOriginalValue = inspectionResultOriginalValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspResultValidValuesNumber</b>
     * </p>
     *
     * @param inspResultValidValuesNumber
     *            Number of Inspected Sample Units
     */
    public void setInspResultValidValuesNumber( @Nullable final Integer inspResultValidValuesNumber )
    {
        rememberChangedField("InspResultValidValuesNumber", this.inspResultValidValuesNumber);
        this.inspResultValidValuesNumber = inspResultValidValuesNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultText</b>
     * </p>
     *
     * @param inspectionResultText
     *            Inspection Description for Summarized Result
     */
    public void setInspectionResultText( @Nullable final String inspectionResultText )
    {
        rememberChangedField("InspectionResultText", this.inspectionResultText);
        this.inspectionResultText = inspectionResultText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultHasLongText</b>
     * </p>
     *
     * @param inspectionResultHasLongText
     *            Inspection Characteristic Long Text Exists
     */
    public void setInspectionResultHasLongText( @Nullable final String inspectionResultHasLongText )
    {
        rememberChangedField("InspectionResultHasLongText", this.inspectionResultHasLongText);
        this.inspectionResultHasLongText = inspectionResultHasLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @param characteristicAttributeCatalog
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setCharacteristicAttributeCatalog( @Nullable final String characteristicAttributeCatalog )
    {
        rememberChangedField("CharacteristicAttributeCatalog", this.characteristicAttributeCatalog);
        this.characteristicAttributeCatalog = characteristicAttributeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @param characteristicAttributeCodeGrp
     *            Code Group
     */
    public void setCharacteristicAttributeCodeGrp( @Nullable final String characteristicAttributeCodeGrp )
    {
        rememberChangedField("CharacteristicAttributeCodeGrp", this.characteristicAttributeCodeGrp);
        this.characteristicAttributeCodeGrp = characteristicAttributeCodeGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @param characteristicAttributeCode
     *            Code
     */
    public void setCharacteristicAttributeCode( @Nullable final String characteristicAttributeCode )
    {
        rememberChangedField("CharacteristicAttributeCode", this.characteristicAttributeCode);
        this.characteristicAttributeCode = characteristicAttributeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFreeDefinedTestEquip</b>
     * </p>
     *
     * @param inspRsltFreeDefinedTestEquip
     *            General Information
     */
    public void setInspRsltFreeDefinedTestEquip( @Nullable final String inspRsltFreeDefinedTestEquip )
    {
        rememberChangedField("InspRsltFreeDefinedTestEquip", this.inspRsltFreeDefinedTestEquip);
        this.inspRsltFreeDefinedTestEquip = inspRsltFreeDefinedTestEquip;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltBelowToleranceValsNmbr</b>
     * </p>
     *
     * @param inspRsltBelowToleranceValsNmbr
     *            Number of Measured Values Below Tolerance Range
     */
    public void setInspRsltBelowToleranceValsNmbr( @Nullable final Integer inspRsltBelowToleranceValsNmbr )
    {
        rememberChangedField("InspRsltBelowToleranceValsNmbr", this.inspRsltBelowToleranceValsNmbr);
        this.inspRsltBelowToleranceValsNmbr = inspRsltBelowToleranceValsNmbr;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltAboveToleranceValsNmbr</b>
     * </p>
     *
     * @param inspRsltAboveToleranceValsNmbr
     *            Number of Measured Values Above Tolerance Range
     */
    public void setInspRsltAboveToleranceValsNmbr( @Nullable final Integer inspRsltAboveToleranceValsNmbr )
    {
        rememberChangedField("InspRsltAboveToleranceValsNmbr", this.inspRsltAboveToleranceValsNmbr);
        this.inspRsltAboveToleranceValsNmbr = inspRsltAboveToleranceValsNmbr;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltNonconformingValsNmbr</b>
     * </p>
     *
     * @param inspRsltNonconformingValsNmbr
     *            Number of Nonconforming Sample Units
     */
    public void setInspRsltNonconformingValsNmbr( @Nullable final Integer inspRsltNonconformingValsNmbr )
    {
        rememberChangedField("InspRsltNonconformingValsNmbr", this.inspRsltNonconformingValsNmbr);
        this.inspRsltNonconformingValsNmbr = inspRsltNonconformingValsNmbr;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionNumberOfDefects</b>
     * </p>
     *
     * @param inspectionNumberOfDefects
     *            Number of Defects Found
     */
    public void setInspectionNumberOfDefects( @Nullable final Integer inspectionNumberOfDefects )
    {
        rememberChangedField("InspectionNumberOfDefects", this.inspectionNumberOfDefects);
        this.inspectionNumberOfDefects = inspectionNumberOfDefects;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @param defectClass
     *            Defect Class
     */
    public void setDefectClass( @Nullable final String defectClass )
    {
        rememberChangedField("DefectClass", this.defectClass);
        this.defectClass = defectClass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltAboveToleranceFraction</b>
     * </p>
     *
     * @param inspRsltAboveToleranceFraction
     *            Estimated Fraction Above Tolerance Range
     */
    public void setInspRsltAboveToleranceFraction( @Nullable final Double inspRsltAboveToleranceFraction )
    {
        rememberChangedField("InspRsltAboveToleranceFraction", this.inspRsltAboveToleranceFraction);
        this.inspRsltAboveToleranceFraction = inspRsltAboveToleranceFraction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFrmtdAbvTolFraction</b>
     * </p>
     *
     * @param inspRsltFrmtdAbvTolFraction
     *            Estimated Fraction Above Tolerance Range (Formatted)
     */
    public void setInspRsltFrmtdAbvTolFraction( @Nullable final String inspRsltFrmtdAbvTolFraction )
    {
        rememberChangedField("InspRsltFrmtdAbvTolFraction", this.inspRsltFrmtdAbvTolFraction);
        this.inspRsltFrmtdAbvTolFraction = inspRsltFrmtdAbvTolFraction;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltBelowToleranceFraction</b>
     * </p>
     *
     * @param inspRsltBelowToleranceFraction
     *            Estimated Fraction Below Tolerance Range
     */
    public void setInspRsltBelowToleranceFraction( @Nullable final Double inspRsltBelowToleranceFraction )
    {
        rememberChangedField("InspRsltBelowToleranceFraction", this.inspRsltBelowToleranceFraction);
        this.inspRsltBelowToleranceFraction = inspRsltBelowToleranceFraction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFrmtdBelowTolFraction</b>
     * </p>
     *
     * @param inspRsltFrmtdBelowTolFraction
     *            Estimated Fraction Below Tolerance Range (Formatted)
     */
    public void setInspRsltFrmtdBelowTolFraction( @Nullable final String inspRsltFrmtdBelowTolFraction )
    {
        rememberChangedField("InspRsltFrmtdBelowTolFraction", this.inspRsltFrmtdBelowTolFraction);
        this.inspRsltFrmtdBelowTolFraction = inspRsltFrmtdBelowTolFraction;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspResultVariance</b>
     * </p>
     *
     * @param inspResultVariance
     *            Dispersion (Variance) of Valid Measured Values
     */
    public void setInspResultVariance( @Nullable final Double inspResultVariance )
    {
        rememberChangedField("InspResultVariance", this.inspResultVariance);
        this.inspResultVariance = inspResultVariance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdVariance</b>
     * </p>
     *
     * @param inspResultFrmtdVariance
     *            Dispersion (Variance) of Valid Measured Values (Formatted)
     */
    public void setInspResultFrmtdVariance( @Nullable final String inspResultFrmtdVariance )
    {
        rememberChangedField("InspResultFrmtdVariance", this.inspResultFrmtdVariance);
        this.inspResultFrmtdVariance = inspResultFrmtdVariance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog2</b>
     * </p>
     *
     * @param inspectionResultCatalog2
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspectionResultCatalog2( @Nullable final String inspectionResultCatalog2 )
    {
        rememberChangedField("InspectionResultCatalog2", this.inspectionResultCatalog2);
        this.inspectionResultCatalog2 = inspectionResultCatalog2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog3</b>
     * </p>
     *
     * @param inspectionResultCatalog3
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspectionResultCatalog3( @Nullable final String inspectionResultCatalog3 )
    {
        rememberChangedField("InspectionResultCatalog3", this.inspectionResultCatalog3);
        this.inspectionResultCatalog3 = inspectionResultCatalog3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog4</b>
     * </p>
     *
     * @param inspectionResultCatalog4
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspectionResultCatalog4( @Nullable final String inspectionResultCatalog4 )
    {
        rememberChangedField("InspectionResultCatalog4", this.inspectionResultCatalog4);
        this.inspectionResultCatalog4 = inspectionResultCatalog4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog5</b>
     * </p>
     *
     * @param inspectionResultCatalog5
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspectionResultCatalog5( @Nullable final String inspectionResultCatalog5 )
    {
        rememberChangedField("InspectionResultCatalog5", this.inspectionResultCatalog5);
        this.inspectionResultCatalog5 = inspectionResultCatalog5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode2</b>
     * </p>
     *
     * @param inspectionResultCode2
     *            Code
     */
    public void setInspectionResultCode2( @Nullable final String inspectionResultCode2 )
    {
        rememberChangedField("InspectionResultCode2", this.inspectionResultCode2);
        this.inspectionResultCode2 = inspectionResultCode2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode3</b>
     * </p>
     *
     * @param inspectionResultCode3
     *            Code
     */
    public void setInspectionResultCode3( @Nullable final String inspectionResultCode3 )
    {
        rememberChangedField("InspectionResultCode3", this.inspectionResultCode3);
        this.inspectionResultCode3 = inspectionResultCode3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode4</b>
     * </p>
     *
     * @param inspectionResultCode4
     *            Code
     */
    public void setInspectionResultCode4( @Nullable final String inspectionResultCode4 )
    {
        rememberChangedField("InspectionResultCode4", this.inspectionResultCode4);
        this.inspectionResultCode4 = inspectionResultCode4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode5</b>
     * </p>
     *
     * @param inspectionResultCode5
     *            Code
     */
    public void setInspectionResultCode5( @Nullable final String inspectionResultCode5 )
    {
        rememberChangedField("InspectionResultCode5", this.inspectionResultCode5);
        this.inspectionResultCode5 = inspectionResultCode5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup2</b>
     * </p>
     *
     * @param inspectionResultCodeGroup2
     *            Code Group
     */
    public void setInspectionResultCodeGroup2( @Nullable final String inspectionResultCodeGroup2 )
    {
        rememberChangedField("InspectionResultCodeGroup2", this.inspectionResultCodeGroup2);
        this.inspectionResultCodeGroup2 = inspectionResultCodeGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup3</b>
     * </p>
     *
     * @param inspectionResultCodeGroup3
     *            Code Group
     */
    public void setInspectionResultCodeGroup3( @Nullable final String inspectionResultCodeGroup3 )
    {
        rememberChangedField("InspectionResultCodeGroup3", this.inspectionResultCodeGroup3);
        this.inspectionResultCodeGroup3 = inspectionResultCodeGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup4</b>
     * </p>
     *
     * @param inspectionResultCodeGroup4
     *            Code Group
     */
    public void setInspectionResultCodeGroup4( @Nullable final String inspectionResultCodeGroup4 )
    {
        rememberChangedField("InspectionResultCodeGroup4", this.inspectionResultCodeGroup4);
        this.inspectionResultCodeGroup4 = inspectionResultCodeGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup5</b>
     * </p>
     *
     * @param inspectionResultCodeGroup5
     *            Code Group
     */
    public void setInspectionResultCodeGroup5( @Nullable final String inspectionResultCodeGroup5 )
    {
        rememberChangedField("InspectionResultCodeGroup5", this.inspectionResultCodeGroup5);
        this.inspectionResultCodeGroup5 = inspectionResultCodeGroup5;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialSampleSize</b>
     * </p>
     *
     * @param inspectionPartialSampleSize
     *            Number of Partial Samples for Characteristic
     */
    public void setInspectionPartialSampleSize( @Nullable final Short inspectionPartialSampleSize )
    {
        rememberChangedField("InspectionPartialSampleSize", this.inspectionPartialSampleSize);
        this.inspectionPartialSampleSize = inspectionPartialSampleSize;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartDate</b>
     * </p>
     *
     * @param inspectionStartDate
     *            Start Date in Local Time Zone of Inspection
     */
    public void setInspectionStartDate( @Nullable final LocalDateTime inspectionStartDate )
    {
        rememberChangedField("InspectionStartDate", this.inspectionStartDate);
        this.inspectionStartDate = inspectionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartTime</b>
     * </p>
     *
     * @param inspectionStartTime
     *            Start Time in Local Time Zone of Inspection
     */
    public void setInspectionStartTime( @Nullable final LocalTime inspectionStartTime )
    {
        rememberChangedField("InspectionStartTime", this.inspectionStartTime);
        this.inspectionStartTime = inspectionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndDate</b>
     * </p>
     *
     * @param inspectionEndDate
     *            Inspection End Date
     */
    public void setInspectionEndDate( @Nullable final LocalDateTime inspectionEndDate )
    {
        rememberChangedField("InspectionEndDate", this.inspectionEndDate);
        this.inspectionEndDate = inspectionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndTime</b>
     * </p>
     *
     * @param inspectionEndTime
     *            End Time in Local Time Zone of Inspection
     */
    public void setInspectionEndTime( @Nullable final LocalTime inspectionEndTime )
    {
        rememberChangedField("InspectionEndTime", this.inspectionEndTime);
        this.inspectionEndTime = inspectionEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of User Who Created the Data Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionResult";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        result.put("InspectionCharacteristic", getInspectionCharacteristic());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionCharacteristic", getInspectionCharacteristic());
        values.put("InspectionResultStatus", getInspectionResultStatus());
        values.put("InspectionResultAttribute", getInspectionResultAttribute());
        values.put("InspectionResultOrigin", getInspectionResultOrigin());
        values.put("Inspector", getInspector());
        values.put("InspectionValuationResult", getInspectionValuationResult());
        values.put("InspectionResultMeanValue", getInspectionResultMeanValue());
        values.put("InspResultFrmtdMeanValue", getInspResultFrmtdMeanValue());
        values.put("InspectionResultHasMeanValue", getInspectionResultHasMeanValue());
        values.put("InspectionResultMaximumValue", getInspectionResultMaximumValue());
        values.put("InspResultFrmtdMaximumValue", getInspResultFrmtdMaximumValue());
        values.put("InspResultHasMaximumValue", getInspResultHasMaximumValue());
        values.put("InspectionResultMinimumValue", getInspectionResultMinimumValue());
        values.put("InspResultFrmtdMinimumValue", getInspResultFrmtdMinimumValue());
        values.put("InspResultHasMinimumValue", getInspResultHasMinimumValue());
        values.put("InspectionResultOriginalValue", getInspectionResultOriginalValue());
        values.put("InspResultValidValuesNumber", getInspResultValidValuesNumber());
        values.put("InspectionResultText", getInspectionResultText());
        values.put("InspectionResultHasLongText", getInspectionResultHasLongText());
        values.put("CharacteristicAttributeCatalog", getCharacteristicAttributeCatalog());
        values.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        values.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        values.put("InspRsltFreeDefinedTestEquip", getInspRsltFreeDefinedTestEquip());
        values.put("InspRsltBelowToleranceValsNmbr", getInspRsltBelowToleranceValsNmbr());
        values.put("InspRsltAboveToleranceValsNmbr", getInspRsltAboveToleranceValsNmbr());
        values.put("InspRsltNonconformingValsNmbr", getInspRsltNonconformingValsNmbr());
        values.put("InspectionNumberOfDefects", getInspectionNumberOfDefects());
        values.put("DefectClass", getDefectClass());
        values.put("InspRsltAboveToleranceFraction", getInspRsltAboveToleranceFraction());
        values.put("InspRsltFrmtdAbvTolFraction", getInspRsltFrmtdAbvTolFraction());
        values.put("InspRsltBelowToleranceFraction", getInspRsltBelowToleranceFraction());
        values.put("InspRsltFrmtdBelowTolFraction", getInspRsltFrmtdBelowTolFraction());
        values.put("InspResultVariance", getInspResultVariance());
        values.put("InspResultFrmtdVariance", getInspResultFrmtdVariance());
        values.put("InspectionResultCatalog2", getInspectionResultCatalog2());
        values.put("InspectionResultCatalog3", getInspectionResultCatalog3());
        values.put("InspectionResultCatalog4", getInspectionResultCatalog4());
        values.put("InspectionResultCatalog5", getInspectionResultCatalog5());
        values.put("InspectionResultCode2", getInspectionResultCode2());
        values.put("InspectionResultCode3", getInspectionResultCode3());
        values.put("InspectionResultCode4", getInspectionResultCode4());
        values.put("InspectionResultCode5", getInspectionResultCode5());
        values.put("InspectionResultCodeGroup2", getInspectionResultCodeGroup2());
        values.put("InspectionResultCodeGroup3", getInspectionResultCodeGroup3());
        values.put("InspectionResultCodeGroup4", getInspectionResultCodeGroup4());
        values.put("InspectionResultCodeGroup5", getInspectionResultCodeGroup5());
        values.put("InspectionPartialSampleSize", getInspectionPartialSampleSize());
        values.put("InspectionStartDate", getInspectionStartDate());
        values.put("InspectionStartTime", getInspectionStartTime());
        values.put("InspectionEndDate", getInspectionEndDate());
        values.put("InspectionEndTime", getInspectionEndTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristic") ) {
                final Object value = values.remove("InspectionCharacteristic");
                if( (value == null) || (!value.equals(getInspectionCharacteristic())) ) {
                    setInspectionCharacteristic(((String) value));
                }
            }
            if( values.containsKey("InspectionResultStatus") ) {
                final Object value = values.remove("InspectionResultStatus");
                if( (value == null) || (!value.equals(getInspectionResultStatus())) ) {
                    setInspectionResultStatus(((String) value));
                }
            }
            if( values.containsKey("InspectionResultAttribute") ) {
                final Object value = values.remove("InspectionResultAttribute");
                if( (value == null) || (!value.equals(getInspectionResultAttribute())) ) {
                    setInspectionResultAttribute(((String) value));
                }
            }
            if( values.containsKey("InspectionResultOrigin") ) {
                final Object value = values.remove("InspectionResultOrigin");
                if( (value == null) || (!value.equals(getInspectionResultOrigin())) ) {
                    setInspectionResultOrigin(((String) value));
                }
            }
            if( values.containsKey("Inspector") ) {
                final Object value = values.remove("Inspector");
                if( (value == null) || (!value.equals(getInspector())) ) {
                    setInspector(((String) value));
                }
            }
            if( values.containsKey("InspectionValuationResult") ) {
                final Object value = values.remove("InspectionValuationResult");
                if( (value == null) || (!value.equals(getInspectionValuationResult())) ) {
                    setInspectionValuationResult(((String) value));
                }
            }
            if( values.containsKey("InspectionResultMeanValue") ) {
                final Object value = values.remove("InspectionResultMeanValue");
                if( (value == null) || (!value.equals(getInspectionResultMeanValue())) ) {
                    setInspectionResultMeanValue(((Double) value));
                }
            }
            if( values.containsKey("InspResultFrmtdMeanValue") ) {
                final Object value = values.remove("InspResultFrmtdMeanValue");
                if( (value == null) || (!value.equals(getInspResultFrmtdMeanValue())) ) {
                    setInspResultFrmtdMeanValue(((String) value));
                }
            }
            if( values.containsKey("InspectionResultHasMeanValue") ) {
                final Object value = values.remove("InspectionResultHasMeanValue");
                if( (value == null) || (!value.equals(getInspectionResultHasMeanValue())) ) {
                    setInspectionResultHasMeanValue(((String) value));
                }
            }
            if( values.containsKey("InspectionResultMaximumValue") ) {
                final Object value = values.remove("InspectionResultMaximumValue");
                if( (value == null) || (!value.equals(getInspectionResultMaximumValue())) ) {
                    setInspectionResultMaximumValue(((Double) value));
                }
            }
            if( values.containsKey("InspResultFrmtdMaximumValue") ) {
                final Object value = values.remove("InspResultFrmtdMaximumValue");
                if( (value == null) || (!value.equals(getInspResultFrmtdMaximumValue())) ) {
                    setInspResultFrmtdMaximumValue(((String) value));
                }
            }
            if( values.containsKey("InspResultHasMaximumValue") ) {
                final Object value = values.remove("InspResultHasMaximumValue");
                if( (value == null) || (!value.equals(getInspResultHasMaximumValue())) ) {
                    setInspResultHasMaximumValue(((String) value));
                }
            }
            if( values.containsKey("InspectionResultMinimumValue") ) {
                final Object value = values.remove("InspectionResultMinimumValue");
                if( (value == null) || (!value.equals(getInspectionResultMinimumValue())) ) {
                    setInspectionResultMinimumValue(((Double) value));
                }
            }
            if( values.containsKey("InspResultFrmtdMinimumValue") ) {
                final Object value = values.remove("InspResultFrmtdMinimumValue");
                if( (value == null) || (!value.equals(getInspResultFrmtdMinimumValue())) ) {
                    setInspResultFrmtdMinimumValue(((String) value));
                }
            }
            if( values.containsKey("InspResultHasMinimumValue") ) {
                final Object value = values.remove("InspResultHasMinimumValue");
                if( (value == null) || (!value.equals(getInspResultHasMinimumValue())) ) {
                    setInspResultHasMinimumValue(((String) value));
                }
            }
            if( values.containsKey("InspectionResultOriginalValue") ) {
                final Object value = values.remove("InspectionResultOriginalValue");
                if( (value == null) || (!value.equals(getInspectionResultOriginalValue())) ) {
                    setInspectionResultOriginalValue(((String) value));
                }
            }
            if( values.containsKey("InspResultValidValuesNumber") ) {
                final Object value = values.remove("InspResultValidValuesNumber");
                if( (value == null) || (!value.equals(getInspResultValidValuesNumber())) ) {
                    setInspResultValidValuesNumber(((Integer) value));
                }
            }
            if( values.containsKey("InspectionResultText") ) {
                final Object value = values.remove("InspectionResultText");
                if( (value == null) || (!value.equals(getInspectionResultText())) ) {
                    setInspectionResultText(((String) value));
                }
            }
            if( values.containsKey("InspectionResultHasLongText") ) {
                final Object value = values.remove("InspectionResultHasLongText");
                if( (value == null) || (!value.equals(getInspectionResultHasLongText())) ) {
                    setInspectionResultHasLongText(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCatalog") ) {
                final Object value = values.remove("CharacteristicAttributeCatalog");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCatalog())) ) {
                    setCharacteristicAttributeCatalog(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCodeGrp") ) {
                final Object value = values.remove("CharacteristicAttributeCodeGrp");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCodeGrp())) ) {
                    setCharacteristicAttributeCodeGrp(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCode") ) {
                final Object value = values.remove("CharacteristicAttributeCode");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCode())) ) {
                    setCharacteristicAttributeCode(((String) value));
                }
            }
            if( values.containsKey("InspRsltFreeDefinedTestEquip") ) {
                final Object value = values.remove("InspRsltFreeDefinedTestEquip");
                if( (value == null) || (!value.equals(getInspRsltFreeDefinedTestEquip())) ) {
                    setInspRsltFreeDefinedTestEquip(((String) value));
                }
            }
            if( values.containsKey("InspRsltBelowToleranceValsNmbr") ) {
                final Object value = values.remove("InspRsltBelowToleranceValsNmbr");
                if( (value == null) || (!value.equals(getInspRsltBelowToleranceValsNmbr())) ) {
                    setInspRsltBelowToleranceValsNmbr(((Integer) value));
                }
            }
            if( values.containsKey("InspRsltAboveToleranceValsNmbr") ) {
                final Object value = values.remove("InspRsltAboveToleranceValsNmbr");
                if( (value == null) || (!value.equals(getInspRsltAboveToleranceValsNmbr())) ) {
                    setInspRsltAboveToleranceValsNmbr(((Integer) value));
                }
            }
            if( values.containsKey("InspRsltNonconformingValsNmbr") ) {
                final Object value = values.remove("InspRsltNonconformingValsNmbr");
                if( (value == null) || (!value.equals(getInspRsltNonconformingValsNmbr())) ) {
                    setInspRsltNonconformingValsNmbr(((Integer) value));
                }
            }
            if( values.containsKey("InspectionNumberOfDefects") ) {
                final Object value = values.remove("InspectionNumberOfDefects");
                if( (value == null) || (!value.equals(getInspectionNumberOfDefects())) ) {
                    setInspectionNumberOfDefects(((Integer) value));
                }
            }
            if( values.containsKey("DefectClass") ) {
                final Object value = values.remove("DefectClass");
                if( (value == null) || (!value.equals(getDefectClass())) ) {
                    setDefectClass(((String) value));
                }
            }
            if( values.containsKey("InspRsltAboveToleranceFraction") ) {
                final Object value = values.remove("InspRsltAboveToleranceFraction");
                if( (value == null) || (!value.equals(getInspRsltAboveToleranceFraction())) ) {
                    setInspRsltAboveToleranceFraction(((Double) value));
                }
            }
            if( values.containsKey("InspRsltFrmtdAbvTolFraction") ) {
                final Object value = values.remove("InspRsltFrmtdAbvTolFraction");
                if( (value == null) || (!value.equals(getInspRsltFrmtdAbvTolFraction())) ) {
                    setInspRsltFrmtdAbvTolFraction(((String) value));
                }
            }
            if( values.containsKey("InspRsltBelowToleranceFraction") ) {
                final Object value = values.remove("InspRsltBelowToleranceFraction");
                if( (value == null) || (!value.equals(getInspRsltBelowToleranceFraction())) ) {
                    setInspRsltBelowToleranceFraction(((Double) value));
                }
            }
            if( values.containsKey("InspRsltFrmtdBelowTolFraction") ) {
                final Object value = values.remove("InspRsltFrmtdBelowTolFraction");
                if( (value == null) || (!value.equals(getInspRsltFrmtdBelowTolFraction())) ) {
                    setInspRsltFrmtdBelowTolFraction(((String) value));
                }
            }
            if( values.containsKey("InspResultVariance") ) {
                final Object value = values.remove("InspResultVariance");
                if( (value == null) || (!value.equals(getInspResultVariance())) ) {
                    setInspResultVariance(((Double) value));
                }
            }
            if( values.containsKey("InspResultFrmtdVariance") ) {
                final Object value = values.remove("InspResultFrmtdVariance");
                if( (value == null) || (!value.equals(getInspResultFrmtdVariance())) ) {
                    setInspResultFrmtdVariance(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog2") ) {
                final Object value = values.remove("InspectionResultCatalog2");
                if( (value == null) || (!value.equals(getInspectionResultCatalog2())) ) {
                    setInspectionResultCatalog2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog3") ) {
                final Object value = values.remove("InspectionResultCatalog3");
                if( (value == null) || (!value.equals(getInspectionResultCatalog3())) ) {
                    setInspectionResultCatalog3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog4") ) {
                final Object value = values.remove("InspectionResultCatalog4");
                if( (value == null) || (!value.equals(getInspectionResultCatalog4())) ) {
                    setInspectionResultCatalog4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog5") ) {
                final Object value = values.remove("InspectionResultCatalog5");
                if( (value == null) || (!value.equals(getInspectionResultCatalog5())) ) {
                    setInspectionResultCatalog5(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode2") ) {
                final Object value = values.remove("InspectionResultCode2");
                if( (value == null) || (!value.equals(getInspectionResultCode2())) ) {
                    setInspectionResultCode2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode3") ) {
                final Object value = values.remove("InspectionResultCode3");
                if( (value == null) || (!value.equals(getInspectionResultCode3())) ) {
                    setInspectionResultCode3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode4") ) {
                final Object value = values.remove("InspectionResultCode4");
                if( (value == null) || (!value.equals(getInspectionResultCode4())) ) {
                    setInspectionResultCode4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode5") ) {
                final Object value = values.remove("InspectionResultCode5");
                if( (value == null) || (!value.equals(getInspectionResultCode5())) ) {
                    setInspectionResultCode5(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup2") ) {
                final Object value = values.remove("InspectionResultCodeGroup2");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup2())) ) {
                    setInspectionResultCodeGroup2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup3") ) {
                final Object value = values.remove("InspectionResultCodeGroup3");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup3())) ) {
                    setInspectionResultCodeGroup3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup4") ) {
                final Object value = values.remove("InspectionResultCodeGroup4");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup4())) ) {
                    setInspectionResultCodeGroup4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup5") ) {
                final Object value = values.remove("InspectionResultCodeGroup5");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup5())) ) {
                    setInspectionResultCodeGroup5(((String) value));
                }
            }
            if( values.containsKey("InspectionPartialSampleSize") ) {
                final Object value = values.remove("InspectionPartialSampleSize");
                if( (value == null) || (!value.equals(getInspectionPartialSampleSize())) ) {
                    setInspectionPartialSampleSize(((Short) value));
                }
            }
            if( values.containsKey("InspectionStartDate") ) {
                final Object value = values.remove("InspectionStartDate");
                if( (value == null) || (!value.equals(getInspectionStartDate())) ) {
                    setInspectionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionStartTime") ) {
                final Object value = values.remove("InspectionStartTime");
                if( (value == null) || (!value.equals(getInspectionStartTime())) ) {
                    setInspectionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionEndDate") ) {
                final Object value = values.remove("InspectionEndDate");
                if( (value == null) || (!value.equals(getInspectionEndDate())) ) {
                    setInspectionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionEndTime") ) {
                final Object value = values.remove("InspectionEndTime");
                if( (value == null) || (!value.equals(getInspectionEndTime())) ) {
                    setInspectionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
