/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionResultValueField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionResultValueSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Single Inspection Results
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionResultValueType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionResultValue extends VdmEntity<InspectionResultValue>
{

    /**
     * Selector for all available fields of InspectionResultValue.
     *
     */
    public final static InspectionResultValueSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_LOT =
        new InspectionResultValueField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspectionResultValueField<String>("InspPlanOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "InspectionCharacteristic" )
    @JsonProperty( "InspectionCharacteristic" )
    @Nullable
    @ODataField( odataName = "InspectionCharacteristic" )
    private String inspectionCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>InspectionCharacteristic</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_CHARACTERISTIC =
        new InspectionResultValueField<String>("InspectionCharacteristic");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspResultValueInternalID</b>
     * </p>
     *
     * @return Number of Individual Result
     */
    @Key
    @SerializedName( "InspResultValueInternalID" )
    @JsonProperty( "InspResultValueInternalID" )
    @Nullable
    @ODataField( odataName = "InspResultValueInternalID" )
    private String inspResultValueInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspResultValueInternalID</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_RESULT_VALUE_INTERNAL_ID =
        new InspectionResultValueField<String>("InspResultValueInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultAttribute</b>
     * </p>
     *
     * @return Attribute of Results Record (Valid, Invalid,...)
     */
    @SerializedName( "InspectionResultAttribute" )
    @JsonProperty( "InspectionResultAttribute" )
    @Nullable
    @ODataField( odataName = "InspectionResultAttribute" )
    private String inspectionResultAttribute;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultAttribute</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_ATTRIBUTE =
        new InspectionResultValueField<String>("InspectionResultAttribute");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspResultItemInternalID</b>
     * </p>
     *
     * @return Counter for Inspection Unit Number
     */
    @SerializedName( "InspResultItemInternalID" )
    @JsonProperty( "InspResultItemInternalID" )
    @Nullable
    @ODataField( odataName = "InspResultItemInternalID" )
    private String inspResultItemInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspResultItemInternalID</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_RESULT_ITEM_INTERNAL_ID =
        new InspectionResultValueField<String>("InspResultItemInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @return Inspection Sample Number
     */
    @SerializedName( "InspectionSubsetInternalID" )
    @JsonProperty( "InspectionSubsetInternalID" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetInternalID" )
    private String inspectionSubsetInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetInternalID</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_SUBSET_INTERNAL_ID =
        new InspectionResultValueField<String>("InspectionSubsetInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMeasuredValue</b>
     * </p>
     *
     * @return Measured Value for a Sample Unit
     */
    @SerializedName( "InspectionResultMeasuredValue" )
    @JsonProperty( "InspectionResultMeasuredValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultMeasuredValue" )
    private Double inspectionResultMeasuredValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultMeasuredValue</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<Double> INSPECTION_RESULT_MEASURED_VALUE =
        new InspectionResultValueField<Double>("InspectionResultMeasuredValue");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMeasuredValue</b>
     * </p>
     *
     * @return Measured Value for a Sample Unit - formatted
     */
    @SerializedName( "InspResultFrmtdMeasuredValue" )
    @JsonProperty( "InspResultFrmtdMeasuredValue" )
    @Nullable
    @ODataField( odataName = "InspResultFrmtdMeasuredValue" )
    private String inspResultFrmtdMeasuredValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultFrmtdMeasuredValue</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_RESULT_FRMTD_MEASURED_VALUE =
        new InspectionResultValueField<String>("InspResultFrmtdMeasuredValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMeasuredValue</b>
     * </p>
     *
     * @return Measured Value Is Not Initial
     */
    @SerializedName( "InspResultHasMeasuredValue" )
    @JsonProperty( "InspResultHasMeasuredValue" )
    @Nullable
    @ODataField( odataName = "InspResultHasMeasuredValue" )
    private String inspResultHasMeasuredValue;
    /**
     * Use with available fluent helpers to apply the <b>InspResultHasMeasuredValue</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_RESULT_HAS_MEASURED_VALUE =
        new InspectionResultValueField<String>("InspResultHasMeasuredValue");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOriginalValue</b>
     * </p>
     *
     * @return Original Value Before Input Processing
     */
    @SerializedName( "InspectionResultOriginalValue" )
    @JsonProperty( "InspectionResultOriginalValue" )
    @Nullable
    @ODataField( odataName = "InspectionResultOriginalValue" )
    private String inspectionResultOriginalValue;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultOriginalValue</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_ORIGINAL_VALUE =
        new InspectionResultValueField<String>("InspectionResultOriginalValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionNumberOfDefects</b>
     * </p>
     *
     * @return Number of Defects Found
     */
    @SerializedName( "InspectionNumberOfDefects" )
    @JsonProperty( "InspectionNumberOfDefects" )
    @Nullable
    @ODataField( odataName = "InspectionNumberOfDefects" )
    private Short inspectionNumberOfDefects;
    /**
     * Use with available fluent helpers to apply the <b>InspectionNumberOfDefects</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<Short> INSPECTION_NUMBER_OF_DEFECTS =
        new InspectionResultValueField<Short>("InspectionNumberOfDefects");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @return Defect Class
     */
    @SerializedName( "DefectClass" )
    @JsonProperty( "DefectClass" )
    @Nullable
    @ODataField( odataName = "DefectClass" )
    private String defectClass;
    /**
     * Use with available fluent helpers to apply the <b>DefectClass</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> DEFECT_CLASS =
        new InspectionResultValueField<String>("DefectClass");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultText</b>
     * </p>
     *
     * @return Inspection Description for Single Value
     */
    @SerializedName( "InspectionResultText" )
    @JsonProperty( "InspectionResultText" )
    @Nullable
    @ODataField( odataName = "InspectionResultText" )
    private String inspectionResultText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultText</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_TEXT =
        new InspectionResultValueField<String>("InspectionResultText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSingleUnitNumber</b>
     * </p>
     *
     * @return Number of Single Unit in Inspection Lot
     */
    @SerializedName( "InspLotSingleUnitNumber" )
    @JsonProperty( "InspLotSingleUnitNumber" )
    @Nullable
    @ODataField( odataName = "InspLotSingleUnitNumber" )
    private String inspLotSingleUnitNumber;
    /**
     * Use with available fluent helpers to apply the <b>InspLotSingleUnitNumber</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_LOT_SINGLE_UNIT_NUMBER =
        new InspectionResultValueField<String>("InspLotSingleUnitNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultItem</b>
     * </p>
     *
     * @return Single-Unit Number for the Unit to Be Inspected
     */
    @SerializedName( "InspectionResultItem" )
    @JsonProperty( "InspectionResultItem" )
    @Nullable
    @ODataField( odataName = "InspectionResultItem" )
    private String inspectionResultItem;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultItem</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_ITEM =
        new InspectionResultValueField<String>("InspectionResultItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFreeDefinedTestEquip</b>
     * </p>
     *
     * @return General Information
     */
    @SerializedName( "InspRsltFreeDefinedTestEquip" )
    @JsonProperty( "InspRsltFreeDefinedTestEquip" )
    @Nullable
    @ODataField( odataName = "InspRsltFreeDefinedTestEquip" )
    private String inspRsltFreeDefinedTestEquip;
    /**
     * Use with available fluent helpers to apply the <b>InspRsltFreeDefinedTestEquip</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSP_RSLT_FREE_DEFINED_TEST_EQUIP =
        new InspectionResultValueField<String>("InspRsltFreeDefinedTestEquip");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionValuationResult</b>
     * </p>
     *
     * @return Inspection Result Valuation
     */
    @SerializedName( "InspectionValuationResult" )
    @JsonProperty( "InspectionValuationResult" )
    @Nullable
    @ODataField( odataName = "InspectionValuationResult" )
    private String inspectionValuationResult;
    /**
     * Use with available fluent helpers to apply the <b>InspectionValuationResult</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_VALUATION_RESULT =
        new InspectionResultValueField<String>("InspectionValuationResult");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "CharacteristicAttributeCodeGrp" )
    @JsonProperty( "CharacteristicAttributeCodeGrp" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCodeGrp" )
    private String characteristicAttributeCodeGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCodeGrp</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> CHARACTERISTIC_ATTRIBUTE_CODE_GRP =
        new InspectionResultValueField<String>("CharacteristicAttributeCodeGrp");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup2</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup2" )
    @JsonProperty( "InspectionResultCodeGroup2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup2" )
    private String inspectionResultCodeGroup2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup2</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE_GROUP2 =
        new InspectionResultValueField<String>("InspectionResultCodeGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup3</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup3" )
    @JsonProperty( "InspectionResultCodeGroup3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup3" )
    private String inspectionResultCodeGroup3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup3</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE_GROUP3 =
        new InspectionResultValueField<String>("InspectionResultCodeGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup4</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup4" )
    @JsonProperty( "InspectionResultCodeGroup4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup4" )
    private String inspectionResultCodeGroup4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup4</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE_GROUP4 =
        new InspectionResultValueField<String>("InspectionResultCodeGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup5</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "InspectionResultCodeGroup5" )
    @JsonProperty( "InspectionResultCodeGroup5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCodeGroup5" )
    private String inspectionResultCodeGroup5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCodeGroup5</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE_GROUP5 =
        new InspectionResultValueField<String>("InspectionResultCodeGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "CharacteristicAttributeCode" )
    @JsonProperty( "CharacteristicAttributeCode" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCode" )
    private String characteristicAttributeCode;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCode</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> CHARACTERISTIC_ATTRIBUTE_CODE =
        new InspectionResultValueField<String>("CharacteristicAttributeCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode2</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode2" )
    @JsonProperty( "InspectionResultCode2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode2" )
    private String inspectionResultCode2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode2</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE2 =
        new InspectionResultValueField<String>("InspectionResultCode2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode3</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode3" )
    @JsonProperty( "InspectionResultCode3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode3" )
    private String inspectionResultCode3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode3</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE3 =
        new InspectionResultValueField<String>("InspectionResultCode3");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode4</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode4" )
    @JsonProperty( "InspectionResultCode4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode4" )
    private String inspectionResultCode4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode4</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE4 =
        new InspectionResultValueField<String>("InspectionResultCode4");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode5</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "InspectionResultCode5" )
    @JsonProperty( "InspectionResultCode5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCode5" )
    private String inspectionResultCode5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCode5</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CODE5 =
        new InspectionResultValueField<String>("InspectionResultCode5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "CharacteristicAttributeCatalog" )
    @JsonProperty( "CharacteristicAttributeCatalog" )
    @Nullable
    @ODataField( odataName = "CharacteristicAttributeCatalog" )
    private String characteristicAttributeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAttributeCatalog</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> CHARACTERISTIC_ATTRIBUTE_CATALOG =
        new InspectionResultValueField<String>("CharacteristicAttributeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog2</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "InspectionResultCatalog2" )
    @JsonProperty( "InspectionResultCatalog2" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog2" )
    private String inspectionResultCatalog2;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog2</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CATALOG2 =
        new InspectionResultValueField<String>("InspectionResultCatalog2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog3</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "InspectionResultCatalog3" )
    @JsonProperty( "InspectionResultCatalog3" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog3" )
    private String inspectionResultCatalog3;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog3</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CATALOG3 =
        new InspectionResultValueField<String>("InspectionResultCatalog3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog4</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "InspectionResultCatalog4" )
    @JsonProperty( "InspectionResultCatalog4" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog4" )
    private String inspectionResultCatalog4;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog4</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CATALOG4 =
        new InspectionResultValueField<String>("InspectionResultCatalog4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog5</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "InspectionResultCatalog5" )
    @JsonProperty( "InspectionResultCatalog5" )
    @Nullable
    @ODataField( odataName = "InspectionResultCatalog5" )
    private String inspectionResultCatalog5;
    /**
     * Use with available fluent helpers to apply the <b>InspectionResultCatalog5</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTION_RESULT_CATALOG5 =
        new InspectionResultValueField<String>("InspectionResultCatalog5");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @return Name of Inspector
     */
    @SerializedName( "Inspector" )
    @JsonProperty( "Inspector" )
    @Nullable
    @ODataField( odataName = "Inspector" )
    private String inspector;
    /**
     * Use with available fluent helpers to apply the <b>Inspector</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> INSPECTOR =
        new InspectionResultValueField<String>("Inspector");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartDate</b>
     * </p>
     *
     * @return Start Date in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionStartDate" )
    @JsonProperty( "InspectionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionStartDate</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalDateTime> INSPECTION_START_DATE =
        new InspectionResultValueField<LocalDateTime>("InspectionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartTime</b>
     * </p>
     *
     * @return Start Time in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionStartTime" )
    @JsonProperty( "InspectionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionStartTime</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalTime> INSPECTION_START_TIME =
        new InspectionResultValueField<LocalTime>("InspectionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndDate</b>
     * </p>
     *
     * @return End Date in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionEndDate" )
    @JsonProperty( "InspectionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionEndDate</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalDateTime> INSPECTION_END_DATE =
        new InspectionResultValueField<LocalDateTime>("InspectionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndTime</b>
     * </p>
     *
     * @return End Time in Local Time Zone of Inspection
     */
    @SerializedName( "InspectionEndTime" )
    @JsonProperty( "InspectionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionEndTime</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalTime> INSPECTION_END_TIME =
        new InspectionResultValueField<LocalTime>("InspectionEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalDateTime> CREATION_DATE =
        new InspectionResultValueField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return System Time at Which Data Record Was Created
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalTime> CREATION_TIME =
        new InspectionResultValueField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> CREATED_BY_USER =
        new InspectionResultValueField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalDateTime> LAST_CHANGE_DATE =
        new InspectionResultValueField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedTime</b>
     * </p>
     *
     * @return System Time at Which Data Record Was Changed
     */
    @SerializedName( "ChangedTime" )
    @JsonProperty( "ChangedTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ChangedTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime changedTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedTime</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<LocalTime> CHANGED_TIME =
        new InspectionResultValueField<LocalTime>("ChangedTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<String> LAST_CHANGED_BY_USER =
        new InspectionResultValueField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionResultValueField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionResultValueField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspectionResultValue> getType()
    {
        return InspectionResultValue.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionCharacteristic</b>
     * </p>
     *
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     */
    public void setInspectionCharacteristic( @Nullable final String inspectionCharacteristic )
    {
        rememberChangedField("InspectionCharacteristic", this.inspectionCharacteristic);
        this.inspectionCharacteristic = inspectionCharacteristic;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspResultValueInternalID</b>
     * </p>
     *
     * @param inspResultValueInternalID
     *            Number of Individual Result
     */
    public void setInspResultValueInternalID( @Nullable final String inspResultValueInternalID )
    {
        rememberChangedField("InspResultValueInternalID", this.inspResultValueInternalID);
        this.inspResultValueInternalID = inspResultValueInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultAttribute</b>
     * </p>
     *
     * @param inspectionResultAttribute
     *            Attribute of Results Record (Valid, Invalid,...)
     */
    public void setInspectionResultAttribute( @Nullable final String inspectionResultAttribute )
    {
        rememberChangedField("InspectionResultAttribute", this.inspectionResultAttribute);
        this.inspectionResultAttribute = inspectionResultAttribute;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspResultItemInternalID</b>
     * </p>
     *
     * @param inspResultItemInternalID
     *            Counter for Inspection Unit Number
     */
    public void setInspResultItemInternalID( @Nullable final String inspResultItemInternalID )
    {
        rememberChangedField("InspResultItemInternalID", this.inspResultItemInternalID);
        this.inspResultItemInternalID = inspResultItemInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @param inspectionSubsetInternalID
     *            Inspection Sample Number
     */
    public void setInspectionSubsetInternalID( @Nullable final String inspectionSubsetInternalID )
    {
        rememberChangedField("InspectionSubsetInternalID", this.inspectionSubsetInternalID);
        this.inspectionSubsetInternalID = inspectionSubsetInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultMeasuredValue</b>
     * </p>
     *
     * @param inspectionResultMeasuredValue
     *            Measured Value for a Sample Unit
     */
    public void setInspectionResultMeasuredValue( @Nullable final Double inspectionResultMeasuredValue )
    {
        rememberChangedField("InspectionResultMeasuredValue", this.inspectionResultMeasuredValue);
        this.inspectionResultMeasuredValue = inspectionResultMeasuredValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>InspResultFrmtdMeasuredValue</b>
     * </p>
     *
     * @param inspResultFrmtdMeasuredValue
     *            Measured Value for a Sample Unit - formatted
     */
    public void setInspResultFrmtdMeasuredValue( @Nullable final String inspResultFrmtdMeasuredValue )
    {
        rememberChangedField("InspResultFrmtdMeasuredValue", this.inspResultFrmtdMeasuredValue);
        this.inspResultFrmtdMeasuredValue = inspResultFrmtdMeasuredValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultHasMeasuredValue</b>
     * </p>
     *
     * @param inspResultHasMeasuredValue
     *            Measured Value Is Not Initial
     */
    public void setInspResultHasMeasuredValue( @Nullable final String inspResultHasMeasuredValue )
    {
        rememberChangedField("InspResultHasMeasuredValue", this.inspResultHasMeasuredValue);
        this.inspResultHasMeasuredValue = inspResultHasMeasuredValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultOriginalValue</b>
     * </p>
     *
     * @param inspectionResultOriginalValue
     *            Original Value Before Input Processing
     */
    public void setInspectionResultOriginalValue( @Nullable final String inspectionResultOriginalValue )
    {
        rememberChangedField("InspectionResultOriginalValue", this.inspectionResultOriginalValue);
        this.inspectionResultOriginalValue = inspectionResultOriginalValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionNumberOfDefects</b>
     * </p>
     *
     * @param inspectionNumberOfDefects
     *            Number of Defects Found
     */
    public void setInspectionNumberOfDefects( @Nullable final Short inspectionNumberOfDefects )
    {
        rememberChangedField("InspectionNumberOfDefects", this.inspectionNumberOfDefects);
        this.inspectionNumberOfDefects = inspectionNumberOfDefects;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectClass</b>
     * </p>
     *
     * @param defectClass
     *            Defect Class
     */
    public void setDefectClass( @Nullable final String defectClass )
    {
        rememberChangedField("DefectClass", this.defectClass);
        this.defectClass = defectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultText</b>
     * </p>
     *
     * @param inspectionResultText
     *            Inspection Description for Single Value
     */
    public void setInspectionResultText( @Nullable final String inspectionResultText )
    {
        rememberChangedField("InspectionResultText", this.inspectionResultText);
        this.inspectionResultText = inspectionResultText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspLotSingleUnitNumber</b>
     * </p>
     *
     * @param inspLotSingleUnitNumber
     *            Number of Single Unit in Inspection Lot
     */
    public void setInspLotSingleUnitNumber( @Nullable final String inspLotSingleUnitNumber )
    {
        rememberChangedField("InspLotSingleUnitNumber", this.inspLotSingleUnitNumber);
        this.inspLotSingleUnitNumber = inspLotSingleUnitNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultItem</b>
     * </p>
     *
     * @param inspectionResultItem
     *            Single-Unit Number for the Unit to Be Inspected
     */
    public void setInspectionResultItem( @Nullable final String inspectionResultItem )
    {
        rememberChangedField("InspectionResultItem", this.inspectionResultItem);
        this.inspectionResultItem = inspectionResultItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspRsltFreeDefinedTestEquip</b>
     * </p>
     *
     * @param inspRsltFreeDefinedTestEquip
     *            General Information
     */
    public void setInspRsltFreeDefinedTestEquip( @Nullable final String inspRsltFreeDefinedTestEquip )
    {
        rememberChangedField("InspRsltFreeDefinedTestEquip", this.inspRsltFreeDefinedTestEquip);
        this.inspRsltFreeDefinedTestEquip = inspRsltFreeDefinedTestEquip;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionValuationResult</b>
     * </p>
     *
     * @param inspectionValuationResult
     *            Inspection Result Valuation
     */
    public void setInspectionValuationResult( @Nullable final String inspectionValuationResult )
    {
        rememberChangedField("InspectionValuationResult", this.inspectionValuationResult);
        this.inspectionValuationResult = inspectionValuationResult;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCodeGrp</b>
     * </p>
     *
     * @param characteristicAttributeCodeGrp
     *            Code Group
     */
    public void setCharacteristicAttributeCodeGrp( @Nullable final String characteristicAttributeCodeGrp )
    {
        rememberChangedField("CharacteristicAttributeCodeGrp", this.characteristicAttributeCodeGrp);
        this.characteristicAttributeCodeGrp = characteristicAttributeCodeGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup2</b>
     * </p>
     *
     * @param inspectionResultCodeGroup2
     *            Code Group
     */
    public void setInspectionResultCodeGroup2( @Nullable final String inspectionResultCodeGroup2 )
    {
        rememberChangedField("InspectionResultCodeGroup2", this.inspectionResultCodeGroup2);
        this.inspectionResultCodeGroup2 = inspectionResultCodeGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup3</b>
     * </p>
     *
     * @param inspectionResultCodeGroup3
     *            Code Group
     */
    public void setInspectionResultCodeGroup3( @Nullable final String inspectionResultCodeGroup3 )
    {
        rememberChangedField("InspectionResultCodeGroup3", this.inspectionResultCodeGroup3);
        this.inspectionResultCodeGroup3 = inspectionResultCodeGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup4</b>
     * </p>
     *
     * @param inspectionResultCodeGroup4
     *            Code Group
     */
    public void setInspectionResultCodeGroup4( @Nullable final String inspectionResultCodeGroup4 )
    {
        rememberChangedField("InspectionResultCodeGroup4", this.inspectionResultCodeGroup4);
        this.inspectionResultCodeGroup4 = inspectionResultCodeGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCodeGroup5</b>
     * </p>
     *
     * @param inspectionResultCodeGroup5
     *            Code Group
     */
    public void setInspectionResultCodeGroup5( @Nullable final String inspectionResultCodeGroup5 )
    {
        rememberChangedField("InspectionResultCodeGroup5", this.inspectionResultCodeGroup5);
        this.inspectionResultCodeGroup5 = inspectionResultCodeGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCode</b>
     * </p>
     *
     * @param characteristicAttributeCode
     *            Code
     */
    public void setCharacteristicAttributeCode( @Nullable final String characteristicAttributeCode )
    {
        rememberChangedField("CharacteristicAttributeCode", this.characteristicAttributeCode);
        this.characteristicAttributeCode = characteristicAttributeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode2</b>
     * </p>
     *
     * @param inspectionResultCode2
     *            Code
     */
    public void setInspectionResultCode2( @Nullable final String inspectionResultCode2 )
    {
        rememberChangedField("InspectionResultCode2", this.inspectionResultCode2);
        this.inspectionResultCode2 = inspectionResultCode2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode3</b>
     * </p>
     *
     * @param inspectionResultCode3
     *            Code
     */
    public void setInspectionResultCode3( @Nullable final String inspectionResultCode3 )
    {
        rememberChangedField("InspectionResultCode3", this.inspectionResultCode3);
        this.inspectionResultCode3 = inspectionResultCode3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode4</b>
     * </p>
     *
     * @param inspectionResultCode4
     *            Code
     */
    public void setInspectionResultCode4( @Nullable final String inspectionResultCode4 )
    {
        rememberChangedField("InspectionResultCode4", this.inspectionResultCode4);
        this.inspectionResultCode4 = inspectionResultCode4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCode5</b>
     * </p>
     *
     * @param inspectionResultCode5
     *            Code
     */
    public void setInspectionResultCode5( @Nullable final String inspectionResultCode5 )
    {
        rememberChangedField("InspectionResultCode5", this.inspectionResultCode5);
        this.inspectionResultCode5 = inspectionResultCode5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAttributeCatalog</b>
     * </p>
     *
     * @param characteristicAttributeCatalog
     *            Catalog
     */
    public void setCharacteristicAttributeCatalog( @Nullable final String characteristicAttributeCatalog )
    {
        rememberChangedField("CharacteristicAttributeCatalog", this.characteristicAttributeCatalog);
        this.characteristicAttributeCatalog = characteristicAttributeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog2</b>
     * </p>
     *
     * @param inspectionResultCatalog2
     *            Catalog
     */
    public void setInspectionResultCatalog2( @Nullable final String inspectionResultCatalog2 )
    {
        rememberChangedField("InspectionResultCatalog2", this.inspectionResultCatalog2);
        this.inspectionResultCatalog2 = inspectionResultCatalog2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog3</b>
     * </p>
     *
     * @param inspectionResultCatalog3
     *            Catalog
     */
    public void setInspectionResultCatalog3( @Nullable final String inspectionResultCatalog3 )
    {
        rememberChangedField("InspectionResultCatalog3", this.inspectionResultCatalog3);
        this.inspectionResultCatalog3 = inspectionResultCatalog3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog4</b>
     * </p>
     *
     * @param inspectionResultCatalog4
     *            Catalog
     */
    public void setInspectionResultCatalog4( @Nullable final String inspectionResultCatalog4 )
    {
        rememberChangedField("InspectionResultCatalog4", this.inspectionResultCatalog4);
        this.inspectionResultCatalog4 = inspectionResultCatalog4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionResultCatalog5</b>
     * </p>
     *
     * @param inspectionResultCatalog5
     *            Catalog
     */
    public void setInspectionResultCatalog5( @Nullable final String inspectionResultCatalog5 )
    {
        rememberChangedField("InspectionResultCatalog5", this.inspectionResultCatalog5);
        this.inspectionResultCatalog5 = inspectionResultCatalog5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @param inspector
     *            Name of Inspector
     */
    public void setInspector( @Nullable final String inspector )
    {
        rememberChangedField("Inspector", this.inspector);
        this.inspector = inspector;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartDate</b>
     * </p>
     *
     * @param inspectionStartDate
     *            Start Date in Local Time Zone of Inspection
     */
    public void setInspectionStartDate( @Nullable final LocalDateTime inspectionStartDate )
    {
        rememberChangedField("InspectionStartDate", this.inspectionStartDate);
        this.inspectionStartDate = inspectionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionStartTime</b>
     * </p>
     *
     * @param inspectionStartTime
     *            Start Time in Local Time Zone of Inspection
     */
    public void setInspectionStartTime( @Nullable final LocalTime inspectionStartTime )
    {
        rememberChangedField("InspectionStartTime", this.inspectionStartTime);
        this.inspectionStartTime = inspectionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndDate</b>
     * </p>
     *
     * @param inspectionEndDate
     *            End Date in Local Time Zone of Inspection
     */
    public void setInspectionEndDate( @Nullable final LocalDateTime inspectionEndDate )
    {
        rememberChangedField("InspectionEndDate", this.inspectionEndDate);
        this.inspectionEndDate = inspectionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionEndTime</b>
     * </p>
     *
     * @param inspectionEndTime
     *            End Time in Local Time Zone of Inspection
     */
    public void setInspectionEndTime( @Nullable final LocalTime inspectionEndTime )
    {
        rememberChangedField("InspectionEndTime", this.inspectionEndTime);
        this.inspectionEndTime = inspectionEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            System Time at Which Data Record Was Created
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of User Who Created the Data Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedTime</b>
     * </p>
     *
     * @param changedTime
     *            System Time at Which Data Record Was Changed
     */
    public void setChangedTime( @Nullable final LocalTime changedTime )
    {
        rememberChangedField("ChangedTime", this.changedTime);
        this.changedTime = changedTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionResultValue";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        result.put("InspectionCharacteristic", getInspectionCharacteristic());
        result.put("InspResultValueInternalID", getInspResultValueInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionCharacteristic", getInspectionCharacteristic());
        values.put("InspResultValueInternalID", getInspResultValueInternalID());
        values.put("InspectionResultAttribute", getInspectionResultAttribute());
        values.put("InspResultItemInternalID", getInspResultItemInternalID());
        values.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        values.put("InspectionResultMeasuredValue", getInspectionResultMeasuredValue());
        values.put("InspResultFrmtdMeasuredValue", getInspResultFrmtdMeasuredValue());
        values.put("InspResultHasMeasuredValue", getInspResultHasMeasuredValue());
        values.put("InspectionResultOriginalValue", getInspectionResultOriginalValue());
        values.put("InspectionNumberOfDefects", getInspectionNumberOfDefects());
        values.put("DefectClass", getDefectClass());
        values.put("InspectionResultText", getInspectionResultText());
        values.put("InspLotSingleUnitNumber", getInspLotSingleUnitNumber());
        values.put("InspectionResultItem", getInspectionResultItem());
        values.put("InspRsltFreeDefinedTestEquip", getInspRsltFreeDefinedTestEquip());
        values.put("InspectionValuationResult", getInspectionValuationResult());
        values.put("CharacteristicAttributeCodeGrp", getCharacteristicAttributeCodeGrp());
        values.put("InspectionResultCodeGroup2", getInspectionResultCodeGroup2());
        values.put("InspectionResultCodeGroup3", getInspectionResultCodeGroup3());
        values.put("InspectionResultCodeGroup4", getInspectionResultCodeGroup4());
        values.put("InspectionResultCodeGroup5", getInspectionResultCodeGroup5());
        values.put("CharacteristicAttributeCode", getCharacteristicAttributeCode());
        values.put("InspectionResultCode2", getInspectionResultCode2());
        values.put("InspectionResultCode3", getInspectionResultCode3());
        values.put("InspectionResultCode4", getInspectionResultCode4());
        values.put("InspectionResultCode5", getInspectionResultCode5());
        values.put("CharacteristicAttributeCatalog", getCharacteristicAttributeCatalog());
        values.put("InspectionResultCatalog2", getInspectionResultCatalog2());
        values.put("InspectionResultCatalog3", getInspectionResultCatalog3());
        values.put("InspectionResultCatalog4", getInspectionResultCatalog4());
        values.put("InspectionResultCatalog5", getInspectionResultCatalog5());
        values.put("Inspector", getInspector());
        values.put("InspectionStartDate", getInspectionStartDate());
        values.put("InspectionStartTime", getInspectionStartTime());
        values.put("InspectionEndDate", getInspectionEndDate());
        values.put("InspectionEndTime", getInspectionEndTime());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ChangedTime", getChangedTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionCharacteristic") ) {
                final Object value = values.remove("InspectionCharacteristic");
                if( (value == null) || (!value.equals(getInspectionCharacteristic())) ) {
                    setInspectionCharacteristic(((String) value));
                }
            }
            if( values.containsKey("InspResultValueInternalID") ) {
                final Object value = values.remove("InspResultValueInternalID");
                if( (value == null) || (!value.equals(getInspResultValueInternalID())) ) {
                    setInspResultValueInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionResultAttribute") ) {
                final Object value = values.remove("InspectionResultAttribute");
                if( (value == null) || (!value.equals(getInspectionResultAttribute())) ) {
                    setInspectionResultAttribute(((String) value));
                }
            }
            if( values.containsKey("InspResultItemInternalID") ) {
                final Object value = values.remove("InspResultItemInternalID");
                if( (value == null) || (!value.equals(getInspResultItemInternalID())) ) {
                    setInspResultItemInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetInternalID") ) {
                final Object value = values.remove("InspectionSubsetInternalID");
                if( (value == null) || (!value.equals(getInspectionSubsetInternalID())) ) {
                    setInspectionSubsetInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionResultMeasuredValue") ) {
                final Object value = values.remove("InspectionResultMeasuredValue");
                if( (value == null) || (!value.equals(getInspectionResultMeasuredValue())) ) {
                    setInspectionResultMeasuredValue(((Double) value));
                }
            }
            if( values.containsKey("InspResultFrmtdMeasuredValue") ) {
                final Object value = values.remove("InspResultFrmtdMeasuredValue");
                if( (value == null) || (!value.equals(getInspResultFrmtdMeasuredValue())) ) {
                    setInspResultFrmtdMeasuredValue(((String) value));
                }
            }
            if( values.containsKey("InspResultHasMeasuredValue") ) {
                final Object value = values.remove("InspResultHasMeasuredValue");
                if( (value == null) || (!value.equals(getInspResultHasMeasuredValue())) ) {
                    setInspResultHasMeasuredValue(((String) value));
                }
            }
            if( values.containsKey("InspectionResultOriginalValue") ) {
                final Object value = values.remove("InspectionResultOriginalValue");
                if( (value == null) || (!value.equals(getInspectionResultOriginalValue())) ) {
                    setInspectionResultOriginalValue(((String) value));
                }
            }
            if( values.containsKey("InspectionNumberOfDefects") ) {
                final Object value = values.remove("InspectionNumberOfDefects");
                if( (value == null) || (!value.equals(getInspectionNumberOfDefects())) ) {
                    setInspectionNumberOfDefects(((Short) value));
                }
            }
            if( values.containsKey("DefectClass") ) {
                final Object value = values.remove("DefectClass");
                if( (value == null) || (!value.equals(getDefectClass())) ) {
                    setDefectClass(((String) value));
                }
            }
            if( values.containsKey("InspectionResultText") ) {
                final Object value = values.remove("InspectionResultText");
                if( (value == null) || (!value.equals(getInspectionResultText())) ) {
                    setInspectionResultText(((String) value));
                }
            }
            if( values.containsKey("InspLotSingleUnitNumber") ) {
                final Object value = values.remove("InspLotSingleUnitNumber");
                if( (value == null) || (!value.equals(getInspLotSingleUnitNumber())) ) {
                    setInspLotSingleUnitNumber(((String) value));
                }
            }
            if( values.containsKey("InspectionResultItem") ) {
                final Object value = values.remove("InspectionResultItem");
                if( (value == null) || (!value.equals(getInspectionResultItem())) ) {
                    setInspectionResultItem(((String) value));
                }
            }
            if( values.containsKey("InspRsltFreeDefinedTestEquip") ) {
                final Object value = values.remove("InspRsltFreeDefinedTestEquip");
                if( (value == null) || (!value.equals(getInspRsltFreeDefinedTestEquip())) ) {
                    setInspRsltFreeDefinedTestEquip(((String) value));
                }
            }
            if( values.containsKey("InspectionValuationResult") ) {
                final Object value = values.remove("InspectionValuationResult");
                if( (value == null) || (!value.equals(getInspectionValuationResult())) ) {
                    setInspectionValuationResult(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCodeGrp") ) {
                final Object value = values.remove("CharacteristicAttributeCodeGrp");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCodeGrp())) ) {
                    setCharacteristicAttributeCodeGrp(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup2") ) {
                final Object value = values.remove("InspectionResultCodeGroup2");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup2())) ) {
                    setInspectionResultCodeGroup2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup3") ) {
                final Object value = values.remove("InspectionResultCodeGroup3");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup3())) ) {
                    setInspectionResultCodeGroup3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup4") ) {
                final Object value = values.remove("InspectionResultCodeGroup4");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup4())) ) {
                    setInspectionResultCodeGroup4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCodeGroup5") ) {
                final Object value = values.remove("InspectionResultCodeGroup5");
                if( (value == null) || (!value.equals(getInspectionResultCodeGroup5())) ) {
                    setInspectionResultCodeGroup5(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCode") ) {
                final Object value = values.remove("CharacteristicAttributeCode");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCode())) ) {
                    setCharacteristicAttributeCode(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode2") ) {
                final Object value = values.remove("InspectionResultCode2");
                if( (value == null) || (!value.equals(getInspectionResultCode2())) ) {
                    setInspectionResultCode2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode3") ) {
                final Object value = values.remove("InspectionResultCode3");
                if( (value == null) || (!value.equals(getInspectionResultCode3())) ) {
                    setInspectionResultCode3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode4") ) {
                final Object value = values.remove("InspectionResultCode4");
                if( (value == null) || (!value.equals(getInspectionResultCode4())) ) {
                    setInspectionResultCode4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCode5") ) {
                final Object value = values.remove("InspectionResultCode5");
                if( (value == null) || (!value.equals(getInspectionResultCode5())) ) {
                    setInspectionResultCode5(((String) value));
                }
            }
            if( values.containsKey("CharacteristicAttributeCatalog") ) {
                final Object value = values.remove("CharacteristicAttributeCatalog");
                if( (value == null) || (!value.equals(getCharacteristicAttributeCatalog())) ) {
                    setCharacteristicAttributeCatalog(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog2") ) {
                final Object value = values.remove("InspectionResultCatalog2");
                if( (value == null) || (!value.equals(getInspectionResultCatalog2())) ) {
                    setInspectionResultCatalog2(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog3") ) {
                final Object value = values.remove("InspectionResultCatalog3");
                if( (value == null) || (!value.equals(getInspectionResultCatalog3())) ) {
                    setInspectionResultCatalog3(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog4") ) {
                final Object value = values.remove("InspectionResultCatalog4");
                if( (value == null) || (!value.equals(getInspectionResultCatalog4())) ) {
                    setInspectionResultCatalog4(((String) value));
                }
            }
            if( values.containsKey("InspectionResultCatalog5") ) {
                final Object value = values.remove("InspectionResultCatalog5");
                if( (value == null) || (!value.equals(getInspectionResultCatalog5())) ) {
                    setInspectionResultCatalog5(((String) value));
                }
            }
            if( values.containsKey("Inspector") ) {
                final Object value = values.remove("Inspector");
                if( (value == null) || (!value.equals(getInspector())) ) {
                    setInspector(((String) value));
                }
            }
            if( values.containsKey("InspectionStartDate") ) {
                final Object value = values.remove("InspectionStartDate");
                if( (value == null) || (!value.equals(getInspectionStartDate())) ) {
                    setInspectionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionStartTime") ) {
                final Object value = values.remove("InspectionStartTime");
                if( (value == null) || (!value.equals(getInspectionStartTime())) ) {
                    setInspectionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionEndDate") ) {
                final Object value = values.remove("InspectionEndDate");
                if( (value == null) || (!value.equals(getInspectionEndDate())) ) {
                    setInspectionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionEndTime") ) {
                final Object value = values.remove("InspectionEndTime");
                if( (value == null) || (!value.equals(getInspectionEndTime())) ) {
                    setInspectionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedTime") ) {
                final Object value = values.remove("ChangedTime");
                if( (value == null) || (!value.equals(getChangedTime())) ) {
                    setChangedTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionResultValueField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionResultValueField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionResultValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionResultValueField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
