/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionSubsetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionSubsetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Points
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionSubsetType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionSubset extends VdmEntity<InspectionSubset>
{

    /**
     * Selector for all available fields of InspectionSubset.
     *
     */
    public final static InspectionSubsetSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Trigger_valuation_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "Trigger_valuation_ac" )
    @JsonProperty( "Trigger_valuation_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Trigger_valuation_ac" )
    private Boolean trigger_valuation_ac;
    /**
     * Use with available fluent helpers to apply the <b>Trigger_valuation_ac</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<Boolean> TRIGGER_VALUATION_AC =
        new InspectionSubsetField<Boolean>("Trigger_valuation_ac");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @return Inspection Lot Number
     */
    @Key
    @SerializedName( "InspectionLot" )
    @JsonProperty( "InspectionLot" )
    @Nullable
    @ODataField( odataName = "InspectionLot" )
    private String inspectionLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLot</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_LOT =
        new InspectionSubsetField<String>("InspectionLot");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @return Current Node Number from Order Counter
     */
    @Key
    @SerializedName( "InspPlanOperationInternalID" )
    @JsonProperty( "InspPlanOperationInternalID" )
    @Nullable
    @ODataField( odataName = "InspPlanOperationInternalID" )
    private String inspPlanOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanOperationInternalID</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_PLAN_OPERATION_INTERNAL_ID =
        new InspectionSubsetField<String>("InspPlanOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @return Sample Number (Based on an Inspection Point)
     */
    @Key
    @SerializedName( "InspectionSubsetInternalID" )
    @JsonProperty( "InspectionSubsetInternalID" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetInternalID" )
    private String inspectionSubsetInternalID;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetInternalID</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_SUBSET_INTERNAL_ID =
        new InspectionSubsetField<String>("InspectionSubsetInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSample</b>
     * </p>
     *
     * @return Material Sample Number
     */
    @SerializedName( "MaterialSample" )
    @JsonProperty( "MaterialSample" )
    @Nullable
    @ODataField( odataName = "MaterialSample" )
    private String materialSample;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSample</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> MATERIAL_SAMPLE =
        new InspectionSubsetField<String>("MaterialSample");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> EQUIPMENT = new InspectionSubsetField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> FUNCTIONAL_LOCATION =
        new InspectionSubsetField<String>("FunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ShopFloorItem</b>
     * </p>
     *
     * @return ID of Serialized Material
     */
    @SerializedName( "ShopFloorItem" )
    @JsonProperty( "ShopFloorItem" )
    @Nullable
    @ODataField( odataName = "ShopFloorItem" )
    private Long shopFloorItem;
    /**
     * Use with available fluent helpers to apply the <b>ShopFloorItem</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<Long> SHOP_FLOOR_ITEM = new InspectionSubsetField<Long>("ShopFloorItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> SELECTED_CODE_SET_PLANT =
        new InspectionSubsetField<String>("SelectedCodeSetPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Selected Set of the Usage Decision
     */
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> SELECTED_CODE_SET =
        new InspectionSubsetField<String>("SelectedCodeSet");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnCodeGroup</b>
     * </p>
     *
     * @return Code Group of the Usage Decision
     */
    @SerializedName( "InspSubsetUsageDcsnCodeGroup" )
    @JsonProperty( "InspSubsetUsageDcsnCodeGroup" )
    @Nullable
    @ODataField( odataName = "InspSubsetUsageDcsnCodeGroup" )
    private String inspSubsetUsageDcsnCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetUsageDcsnCodeGroup</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SUBSET_USAGE_DCSN_CODE_GROUP =
        new InspectionSubsetField<String>("InspSubsetUsageDcsnCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnCode</b>
     * </p>
     *
     * @return Usage Decision Code
     */
    @SerializedName( "InspSubsetUsageDcsnCode" )
    @JsonProperty( "InspSubsetUsageDcsnCode" )
    @Nullable
    @ODataField( odataName = "InspSubsetUsageDcsnCode" )
    private String inspSubsetUsageDcsnCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetUsageDcsnCode</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SUBSET_USAGE_DCSN_CODE =
        new InspectionSubsetField<String>("InspSubsetUsageDcsnCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnValuation</b>
     * </p>
     *
     * @return Code Valuation
     */
    @SerializedName( "InspSubsetUsageDcsnValuation" )
    @JsonProperty( "InspSubsetUsageDcsnValuation" )
    @Nullable
    @ODataField( odataName = "InspSubsetUsageDcsnValuation" )
    private String inspSubsetUsageDcsnValuation;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetUsageDcsnValuation</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SUBSET_USAGE_DCSN_VALUATION =
        new InspectionSubsetField<String>("InspSubsetUsageDcsnValuation");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetTime</b>
     * </p>
     *
     * @return User Field for Time
     */
    @SerializedName( "InspectionSubsetTime" )
    @JsonProperty( "InspectionSubsetTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "InspectionSubsetTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime inspectionSubsetTime;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetTime</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalTime> INSPECTION_SUBSET_TIME =
        new InspectionSubsetField<LocalTime>("InspectionSubsetTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetDate</b>
     * </p>
     *
     * @return User Field for Date
     */
    @SerializedName( "InspectionSubsetDate" )
    @JsonProperty( "InspectionSubsetDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspectionSubsetDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspectionSubsetDate;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetDate</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalDateTime> INSPECTION_SUBSET_DATE =
        new InspectionSubsetField<LocalDateTime>("InspectionSubsetDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetLongNumericKey</b>
     * </p>
     *
     * @return User Field for 10 Digits
     */
    @SerializedName( "InspSubsetLongNumericKey" )
    @JsonProperty( "InspSubsetLongNumericKey" )
    @Nullable
    @ODataField( odataName = "InspSubsetLongNumericKey" )
    private String inspSubsetLongNumericKey;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetLongNumericKey</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SUBSET_LONG_NUMERIC_KEY =
        new InspectionSubsetField<String>("InspSubsetLongNumericKey");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetShortNumericKey</b>
     * </p>
     *
     * @return User Field for 3 Digits
     */
    @SerializedName( "InspSubsetShortNumericKey" )
    @JsonProperty( "InspSubsetShortNumericKey" )
    @Nullable
    @ODataField( odataName = "InspSubsetShortNumericKey" )
    private String inspSubsetShortNumericKey;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetShortNumericKey</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SUBSET_SHORT_NUMERIC_KEY =
        new InspectionSubsetField<String>("InspSubsetShortNumericKey");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetLongCharKey</b>
     * </p>
     *
     * @return User Field for 18 Characters
     */
    @SerializedName( "InspectionSubsetLongCharKey" )
    @JsonProperty( "InspectionSubsetLongCharKey" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetLongCharKey" )
    private String inspectionSubsetLongCharKey;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetLongCharKey</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_SUBSET_LONG_CHAR_KEY =
        new InspectionSubsetField<String>("InspectionSubsetLongCharKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetShortCharKey</b>
     * </p>
     *
     * @return User Field for 10 Characters
     */
    @SerializedName( "InspectionSubsetShortCharKey" )
    @JsonProperty( "InspectionSubsetShortCharKey" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetShortCharKey" )
    private String inspectionSubsetShortCharKey;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetShortCharKey</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_SUBSET_SHORT_CHAR_KEY =
        new InspectionSubsetField<String>("InspectionSubsetShortCharKey");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLot</b>
     * </p>
     *
     * @return Partial Lot Number
     */
    @SerializedName( "InspectionPartialLot" )
    @JsonProperty( "InspectionPartialLot" )
    @Nullable
    @ODataField( odataName = "InspectionPartialLot" )
    private String inspectionPartialLot;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPartialLot</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_PARTIAL_LOT =
        new InspectionSubsetField<String>("InspectionPartialLot");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @return Name of Inspector
     */
    @SerializedName( "Inspector" )
    @JsonProperty( "Inspector" )
    @Nullable
    @ODataField( odataName = "Inspector" )
    private String inspector;
    /**
     * Use with available fluent helpers to apply the <b>Inspector</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTOR = new InspectionSubsetField<String>("Inspector");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetYieldQty</b>
     * </p>
     *
     * @return Inspection Point Yield
     */
    @SerializedName( "InspectionSubsetYieldQty" )
    @JsonProperty( "InspectionSubsetYieldQty" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetYieldQty" )
    private BigDecimal inspectionSubsetYieldQty;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetYieldQty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<BigDecimal> INSPECTION_SUBSET_YIELD_QTY =
        new InspectionSubsetField<BigDecimal>("InspectionSubsetYieldQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetScrapQty</b>
     * </p>
     *
     * @return Scrap for Inspection Point
     */
    @SerializedName( "InspectionSubsetScrapQty" )
    @JsonProperty( "InspectionSubsetScrapQty" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetScrapQty" )
    private BigDecimal inspectionSubsetScrapQty;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetScrapQty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<BigDecimal> INSPECTION_SUBSET_SCRAP_QTY =
        new InspectionSubsetField<BigDecimal>("InspectionSubsetScrapQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetReworkQty</b>
     * </p>
     *
     * @return Rework Quantity for Inspection Point
     */
    @SerializedName( "InspectionSubsetReworkQty" )
    @JsonProperty( "InspectionSubsetReworkQty" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetReworkQty" )
    private BigDecimal inspectionSubsetReworkQty;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetReworkQty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<BigDecimal> INSPECTION_SUBSET_REWORK_QTY =
        new InspectionSubsetField<BigDecimal>("InspectionSubsetReworkQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetQtyUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Inspection Point
     */
    @SerializedName( "InspectionSubsetQtyUnit" )
    @JsonProperty( "InspectionSubsetQtyUnit" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetQtyUnit" )
    private String inspectionSubsetQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetQtyUnit</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_SUBSET_QTY_UNIT =
        new InspectionSubsetField<String>("InspectionSubsetQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstFuncnlLocProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstFuncnlLocProperty" )
    @JsonProperty( "InspSbstFuncnlLocProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstFuncnlLocProperty" )
    private String inspSbstFuncnlLocProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstFuncnlLocProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_FUNCNL_LOC_PROPERTY =
        new InspectionSubsetField<String>("InspSbstFuncnlLocProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstEquipProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstEquipProperty" )
    @JsonProperty( "InspSbstEquipProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstEquipProperty" )
    private String inspSbstEquipProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstEquipProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_EQUIP_PROPERTY =
        new InspectionSubsetField<String>("InspSbstEquipProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstMatlSmplProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstMatlSmplProperty" )
    @JsonProperty( "InspSbstMatlSmplProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstMatlSmplProperty" )
    private String inspSbstMatlSmplProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstMatlSmplProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_MATL_SMPL_PROPERTY =
        new InspectionSubsetField<String>("InspSbstMatlSmplProperty");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetSortKey</b>
     * </p>
     *
     * @return Key Field (Sort Field) for Inspection Point
     */
    @SerializedName( "InspectionSubsetSortKey" )
    @JsonProperty( "InspectionSubsetSortKey" )
    @Nullable
    @ODataField( odataName = "InspectionSubsetSortKey" )
    private String inspectionSubsetSortKey;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSubsetSortKey</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSPECTION_SUBSET_SORT_KEY =
        new InspectionSubsetField<String>("InspectionSubsetSortKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstDateFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstDateFldProperty" )
    @JsonProperty( "InspSbstDateFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstDateFldProperty" )
    private String inspSbstDateFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstDateFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_DATE_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstDateFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstLongNmbrFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstLongNmbrFldProperty" )
    @JsonProperty( "InspSbstLongNmbrFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstLongNmbrFldProperty" )
    private String inspSbstLongNmbrFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstLongNmbrFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_LONG_NMBR_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstLongNmbrFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstShrtNmbrFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstShrtNmbrFldProperty" )
    @JsonProperty( "InspSbstShrtNmbrFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstShrtNmbrFldProperty" )
    private String inspSbstShrtNmbrFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstShrtNmbrFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_SHRT_NMBR_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstShrtNmbrFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstLongTxtFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstLongTxtFldProperty" )
    @JsonProperty( "InspSbstLongTxtFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstLongTxtFldProperty" )
    private String inspSbstLongTxtFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstLongTxtFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_LONG_TXT_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstLongTxtFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstTimeFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstTimeFldProperty" )
    @JsonProperty( "InspSbstTimeFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstTimeFldProperty" )
    private String inspSbstTimeFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstTimeFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_TIME_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstTimeFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstShrtTxtFldProperty</b>
     * </p>
     *
     * @return Field Active
     */
    @SerializedName( "InspSbstShrtTxtFldProperty" )
    @JsonProperty( "InspSbstShrtTxtFldProperty" )
    @Nullable
    @ODataField( odataName = "InspSbstShrtTxtFldProperty" )
    private String inspSbstShrtTxtFldProperty;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstShrtTxtFldProperty</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> INSP_SBST_SHRT_TXT_FLD_PROPERTY =
        new InspectionSubsetField<String>("InspSbstShrtTxtFldProperty");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> CREATED_BY_USER =
        new InspectionSubsetField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalDateTime> CREATION_DATE =
        new InspectionSubsetField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return System Time at Which Data Record Was Created
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalTime> CREATION_TIME =
        new InspectionSubsetField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<String> LAST_CHANGED_BY_USER =
        new InspectionSubsetField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalDateTime> LAST_CHANGE_DATE =
        new InspectionSubsetField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return System Time at Which Data Record Was Changed
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<LocalTime> LAST_CHANGE_TIME =
        new InspectionSubsetField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionSubsetField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionSubsetField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspectionSubset> getType()
    {
        return InspectionSubset.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Trigger_valuation_ac</b>
     * </p>
     *
     * @param trigger_valuation_ac
     *            Dyn. Action Control
     */
    public void setTrigger_valuation_ac( @Nullable final Boolean trigger_valuation_ac )
    {
        rememberChangedField("Trigger_valuation_ac", this.trigger_valuation_ac);
        this.trigger_valuation_ac = trigger_valuation_ac;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLot</b>
     * </p>
     *
     * @param inspectionLot
     *            Inspection Lot Number
     */
    public void setInspectionLot( @Nullable final String inspectionLot )
    {
        rememberChangedField("InspectionLot", this.inspectionLot);
        this.inspectionLot = inspectionLot;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     */
    public void setInspPlanOperationInternalID( @Nullable final String inspPlanOperationInternalID )
    {
        rememberChangedField("InspPlanOperationInternalID", this.inspPlanOperationInternalID);
        this.inspPlanOperationInternalID = inspPlanOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     * </p>
     *
     * @param inspectionSubsetInternalID
     *            Sample Number (Based on an Inspection Point)
     */
    public void setInspectionSubsetInternalID( @Nullable final String inspectionSubsetInternalID )
    {
        rememberChangedField("InspectionSubsetInternalID", this.inspectionSubsetInternalID);
        this.inspectionSubsetInternalID = inspectionSubsetInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSample</b>
     * </p>
     *
     * @param materialSample
     *            Material Sample Number
     */
    public void setMaterialSample( @Nullable final String materialSample )
    {
        rememberChangedField("MaterialSample", this.materialSample);
        this.materialSample = materialSample;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ShopFloorItem</b>
     * </p>
     *
     * @param shopFloorItem
     *            ID of Serialized Material
     */
    public void setShopFloorItem( @Nullable final Long shopFloorItem )
    {
        rememberChangedField("ShopFloorItem", this.shopFloorItem);
        this.shopFloorItem = shopFloorItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Selected Set of the Usage Decision
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnCodeGroup</b>
     * </p>
     *
     * @param inspSubsetUsageDcsnCodeGroup
     *            Code Group of the Usage Decision
     */
    public void setInspSubsetUsageDcsnCodeGroup( @Nullable final String inspSubsetUsageDcsnCodeGroup )
    {
        rememberChangedField("InspSubsetUsageDcsnCodeGroup", this.inspSubsetUsageDcsnCodeGroup);
        this.inspSubsetUsageDcsnCodeGroup = inspSubsetUsageDcsnCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnCode</b>
     * </p>
     *
     * @param inspSubsetUsageDcsnCode
     *            Usage Decision Code
     */
    public void setInspSubsetUsageDcsnCode( @Nullable final String inspSubsetUsageDcsnCode )
    {
        rememberChangedField("InspSubsetUsageDcsnCode", this.inspSubsetUsageDcsnCode);
        this.inspSubsetUsageDcsnCode = inspSubsetUsageDcsnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetUsageDcsnValuation</b>
     * </p>
     *
     * @param inspSubsetUsageDcsnValuation
     *            Code Valuation
     */
    public void setInspSubsetUsageDcsnValuation( @Nullable final String inspSubsetUsageDcsnValuation )
    {
        rememberChangedField("InspSubsetUsageDcsnValuation", this.inspSubsetUsageDcsnValuation);
        this.inspSubsetUsageDcsnValuation = inspSubsetUsageDcsnValuation;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetTime</b>
     * </p>
     *
     * @param inspectionSubsetTime
     *            User Field for Time
     */
    public void setInspectionSubsetTime( @Nullable final LocalTime inspectionSubsetTime )
    {
        rememberChangedField("InspectionSubsetTime", this.inspectionSubsetTime);
        this.inspectionSubsetTime = inspectionSubsetTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetDate</b>
     * </p>
     *
     * @param inspectionSubsetDate
     *            User Field for Date
     */
    public void setInspectionSubsetDate( @Nullable final LocalDateTime inspectionSubsetDate )
    {
        rememberChangedField("InspectionSubsetDate", this.inspectionSubsetDate);
        this.inspectionSubsetDate = inspectionSubsetDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetLongNumericKey</b>
     * </p>
     *
     * @param inspSubsetLongNumericKey
     *            User Field for 10 Digits
     */
    public void setInspSubsetLongNumericKey( @Nullable final String inspSubsetLongNumericKey )
    {
        rememberChangedField("InspSubsetLongNumericKey", this.inspSubsetLongNumericKey);
        this.inspSubsetLongNumericKey = inspSubsetLongNumericKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetShortNumericKey</b>
     * </p>
     *
     * @param inspSubsetShortNumericKey
     *            User Field for 3 Digits
     */
    public void setInspSubsetShortNumericKey( @Nullable final String inspSubsetShortNumericKey )
    {
        rememberChangedField("InspSubsetShortNumericKey", this.inspSubsetShortNumericKey);
        this.inspSubsetShortNumericKey = inspSubsetShortNumericKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetLongCharKey</b>
     * </p>
     *
     * @param inspectionSubsetLongCharKey
     *            User Field for 18 Characters
     */
    public void setInspectionSubsetLongCharKey( @Nullable final String inspectionSubsetLongCharKey )
    {
        rememberChangedField("InspectionSubsetLongCharKey", this.inspectionSubsetLongCharKey);
        this.inspectionSubsetLongCharKey = inspectionSubsetLongCharKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetShortCharKey</b>
     * </p>
     *
     * @param inspectionSubsetShortCharKey
     *            User Field for 10 Characters
     */
    public void setInspectionSubsetShortCharKey( @Nullable final String inspectionSubsetShortCharKey )
    {
        rememberChangedField("InspectionSubsetShortCharKey", this.inspectionSubsetShortCharKey);
        this.inspectionSubsetShortCharKey = inspectionSubsetShortCharKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLot</b>
     * </p>
     *
     * @param inspectionPartialLot
     *            Partial Lot Number
     */
    public void setInspectionPartialLot( @Nullable final String inspectionPartialLot )
    {
        rememberChangedField("InspectionPartialLot", this.inspectionPartialLot);
        this.inspectionPartialLot = inspectionPartialLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Inspector</b>
     * </p>
     *
     * @param inspector
     *            Name of Inspector
     */
    public void setInspector( @Nullable final String inspector )
    {
        rememberChangedField("Inspector", this.inspector);
        this.inspector = inspector;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetYieldQty</b>
     * </p>
     *
     * @param inspectionSubsetYieldQty
     *            Inspection Point Yield
     */
    public void setInspectionSubsetYieldQty( @Nullable final BigDecimal inspectionSubsetYieldQty )
    {
        rememberChangedField("InspectionSubsetYieldQty", this.inspectionSubsetYieldQty);
        this.inspectionSubsetYieldQty = inspectionSubsetYieldQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetScrapQty</b>
     * </p>
     *
     * @param inspectionSubsetScrapQty
     *            Scrap for Inspection Point
     */
    public void setInspectionSubsetScrapQty( @Nullable final BigDecimal inspectionSubsetScrapQty )
    {
        rememberChangedField("InspectionSubsetScrapQty", this.inspectionSubsetScrapQty);
        this.inspectionSubsetScrapQty = inspectionSubsetScrapQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetReworkQty</b>
     * </p>
     *
     * @param inspectionSubsetReworkQty
     *            Rework Quantity for Inspection Point
     */
    public void setInspectionSubsetReworkQty( @Nullable final BigDecimal inspectionSubsetReworkQty )
    {
        rememberChangedField("InspectionSubsetReworkQty", this.inspectionSubsetReworkQty);
        this.inspectionSubsetReworkQty = inspectionSubsetReworkQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetQtyUnit</b>
     * </p>
     *
     * @param inspectionSubsetQtyUnit
     *            Unit of Measure for the Inspection Point
     */
    public void setInspectionSubsetQtyUnit( @Nullable final String inspectionSubsetQtyUnit )
    {
        rememberChangedField("InspectionSubsetQtyUnit", this.inspectionSubsetQtyUnit);
        this.inspectionSubsetQtyUnit = inspectionSubsetQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstFuncnlLocProperty</b>
     * </p>
     *
     * @param inspSbstFuncnlLocProperty
     *            Field Active
     */
    public void setInspSbstFuncnlLocProperty( @Nullable final String inspSbstFuncnlLocProperty )
    {
        rememberChangedField("InspSbstFuncnlLocProperty", this.inspSbstFuncnlLocProperty);
        this.inspSbstFuncnlLocProperty = inspSbstFuncnlLocProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstEquipProperty</b>
     * </p>
     *
     * @param inspSbstEquipProperty
     *            Field Active
     */
    public void setInspSbstEquipProperty( @Nullable final String inspSbstEquipProperty )
    {
        rememberChangedField("InspSbstEquipProperty", this.inspSbstEquipProperty);
        this.inspSbstEquipProperty = inspSbstEquipProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstMatlSmplProperty</b>
     * </p>
     *
     * @param inspSbstMatlSmplProperty
     *            Field Active
     */
    public void setInspSbstMatlSmplProperty( @Nullable final String inspSbstMatlSmplProperty )
    {
        rememberChangedField("InspSbstMatlSmplProperty", this.inspSbstMatlSmplProperty);
        this.inspSbstMatlSmplProperty = inspSbstMatlSmplProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSubsetSortKey</b>
     * </p>
     *
     * @param inspectionSubsetSortKey
     *            Key Field (Sort Field) for Inspection Point
     */
    public void setInspectionSubsetSortKey( @Nullable final String inspectionSubsetSortKey )
    {
        rememberChangedField("InspectionSubsetSortKey", this.inspectionSubsetSortKey);
        this.inspectionSubsetSortKey = inspectionSubsetSortKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstDateFldProperty</b>
     * </p>
     *
     * @param inspSbstDateFldProperty
     *            Field Active
     */
    public void setInspSbstDateFldProperty( @Nullable final String inspSbstDateFldProperty )
    {
        rememberChangedField("InspSbstDateFldProperty", this.inspSbstDateFldProperty);
        this.inspSbstDateFldProperty = inspSbstDateFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstLongNmbrFldProperty</b>
     * </p>
     *
     * @param inspSbstLongNmbrFldProperty
     *            Field Active
     */
    public void setInspSbstLongNmbrFldProperty( @Nullable final String inspSbstLongNmbrFldProperty )
    {
        rememberChangedField("InspSbstLongNmbrFldProperty", this.inspSbstLongNmbrFldProperty);
        this.inspSbstLongNmbrFldProperty = inspSbstLongNmbrFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstShrtNmbrFldProperty</b>
     * </p>
     *
     * @param inspSbstShrtNmbrFldProperty
     *            Field Active
     */
    public void setInspSbstShrtNmbrFldProperty( @Nullable final String inspSbstShrtNmbrFldProperty )
    {
        rememberChangedField("InspSbstShrtNmbrFldProperty", this.inspSbstShrtNmbrFldProperty);
        this.inspSbstShrtNmbrFldProperty = inspSbstShrtNmbrFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstLongTxtFldProperty</b>
     * </p>
     *
     * @param inspSbstLongTxtFldProperty
     *            Field Active
     */
    public void setInspSbstLongTxtFldProperty( @Nullable final String inspSbstLongTxtFldProperty )
    {
        rememberChangedField("InspSbstLongTxtFldProperty", this.inspSbstLongTxtFldProperty);
        this.inspSbstLongTxtFldProperty = inspSbstLongTxtFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstTimeFldProperty</b>
     * </p>
     *
     * @param inspSbstTimeFldProperty
     *            Field Active
     */
    public void setInspSbstTimeFldProperty( @Nullable final String inspSbstTimeFldProperty )
    {
        rememberChangedField("InspSbstTimeFldProperty", this.inspSbstTimeFldProperty);
        this.inspSbstTimeFldProperty = inspSbstTimeFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstShrtTxtFldProperty</b>
     * </p>
     *
     * @param inspSbstShrtTxtFldProperty
     *            Field Active
     */
    public void setInspSbstShrtTxtFldProperty( @Nullable final String inspSbstShrtTxtFldProperty )
    {
        rememberChangedField("InspSbstShrtTxtFldProperty", this.inspSbstShrtTxtFldProperty);
        this.inspSbstShrtTxtFldProperty = inspSbstShrtTxtFldProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            System Time at Which Data Record Was Created
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            System Time at Which Data Record Was Changed
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionSubset";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionLot", getInspectionLot());
        result.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        result.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Trigger_valuation_ac", getTrigger_valuation_ac());
        values.put("InspectionLot", getInspectionLot());
        values.put("InspPlanOperationInternalID", getInspPlanOperationInternalID());
        values.put("InspectionSubsetInternalID", getInspectionSubsetInternalID());
        values.put("MaterialSample", getMaterialSample());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("ShopFloorItem", getShopFloorItem());
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("InspSubsetUsageDcsnCodeGroup", getInspSubsetUsageDcsnCodeGroup());
        values.put("InspSubsetUsageDcsnCode", getInspSubsetUsageDcsnCode());
        values.put("InspSubsetUsageDcsnValuation", getInspSubsetUsageDcsnValuation());
        values.put("InspectionSubsetTime", getInspectionSubsetTime());
        values.put("InspectionSubsetDate", getInspectionSubsetDate());
        values.put("InspSubsetLongNumericKey", getInspSubsetLongNumericKey());
        values.put("InspSubsetShortNumericKey", getInspSubsetShortNumericKey());
        values.put("InspectionSubsetLongCharKey", getInspectionSubsetLongCharKey());
        values.put("InspectionSubsetShortCharKey", getInspectionSubsetShortCharKey());
        values.put("InspectionPartialLot", getInspectionPartialLot());
        values.put("Inspector", getInspector());
        values.put("InspectionSubsetYieldQty", getInspectionSubsetYieldQty());
        values.put("InspectionSubsetScrapQty", getInspectionSubsetScrapQty());
        values.put("InspectionSubsetReworkQty", getInspectionSubsetReworkQty());
        values.put("InspectionSubsetQtyUnit", getInspectionSubsetQtyUnit());
        values.put("InspSbstFuncnlLocProperty", getInspSbstFuncnlLocProperty());
        values.put("InspSbstEquipProperty", getInspSbstEquipProperty());
        values.put("InspSbstMatlSmplProperty", getInspSbstMatlSmplProperty());
        values.put("InspectionSubsetSortKey", getInspectionSubsetSortKey());
        values.put("InspSbstDateFldProperty", getInspSbstDateFldProperty());
        values.put("InspSbstLongNmbrFldProperty", getInspSbstLongNmbrFldProperty());
        values.put("InspSbstShrtNmbrFldProperty", getInspSbstShrtNmbrFldProperty());
        values.put("InspSbstLongTxtFldProperty", getInspSbstLongTxtFldProperty());
        values.put("InspSbstTimeFldProperty", getInspSbstTimeFldProperty());
        values.put("InspSbstShrtTxtFldProperty", getInspSbstShrtTxtFldProperty());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Trigger_valuation_ac") ) {
                final Object value = values.remove("Trigger_valuation_ac");
                if( (value == null) || (!value.equals(getTrigger_valuation_ac())) ) {
                    setTrigger_valuation_ac(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionLot") ) {
                final Object value = values.remove("InspectionLot");
                if( (value == null) || (!value.equals(getInspectionLot())) ) {
                    setInspectionLot(((String) value));
                }
            }
            if( values.containsKey("InspPlanOperationInternalID") ) {
                final Object value = values.remove("InspPlanOperationInternalID");
                if( (value == null) || (!value.equals(getInspPlanOperationInternalID())) ) {
                    setInspPlanOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetInternalID") ) {
                final Object value = values.remove("InspectionSubsetInternalID");
                if( (value == null) || (!value.equals(getInspectionSubsetInternalID())) ) {
                    setInspectionSubsetInternalID(((String) value));
                }
            }
            if( values.containsKey("MaterialSample") ) {
                final Object value = values.remove("MaterialSample");
                if( (value == null) || (!value.equals(getMaterialSample())) ) {
                    setMaterialSample(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("ShopFloorItem") ) {
                final Object value = values.remove("ShopFloorItem");
                if( (value == null) || (!value.equals(getShopFloorItem())) ) {
                    setShopFloorItem(((Long) value));
                }
            }
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("InspSubsetUsageDcsnCodeGroup") ) {
                final Object value = values.remove("InspSubsetUsageDcsnCodeGroup");
                if( (value == null) || (!value.equals(getInspSubsetUsageDcsnCodeGroup())) ) {
                    setInspSubsetUsageDcsnCodeGroup(((String) value));
                }
            }
            if( values.containsKey("InspSubsetUsageDcsnCode") ) {
                final Object value = values.remove("InspSubsetUsageDcsnCode");
                if( (value == null) || (!value.equals(getInspSubsetUsageDcsnCode())) ) {
                    setInspSubsetUsageDcsnCode(((String) value));
                }
            }
            if( values.containsKey("InspSubsetUsageDcsnValuation") ) {
                final Object value = values.remove("InspSubsetUsageDcsnValuation");
                if( (value == null) || (!value.equals(getInspSubsetUsageDcsnValuation())) ) {
                    setInspSubsetUsageDcsnValuation(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetTime") ) {
                final Object value = values.remove("InspectionSubsetTime");
                if( (value == null) || (!value.equals(getInspectionSubsetTime())) ) {
                    setInspectionSubsetTime(((LocalTime) value));
                }
            }
            if( values.containsKey("InspectionSubsetDate") ) {
                final Object value = values.remove("InspectionSubsetDate");
                if( (value == null) || (!value.equals(getInspectionSubsetDate())) ) {
                    setInspectionSubsetDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSubsetLongNumericKey") ) {
                final Object value = values.remove("InspSubsetLongNumericKey");
                if( (value == null) || (!value.equals(getInspSubsetLongNumericKey())) ) {
                    setInspSubsetLongNumericKey(((String) value));
                }
            }
            if( values.containsKey("InspSubsetShortNumericKey") ) {
                final Object value = values.remove("InspSubsetShortNumericKey");
                if( (value == null) || (!value.equals(getInspSubsetShortNumericKey())) ) {
                    setInspSubsetShortNumericKey(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetLongCharKey") ) {
                final Object value = values.remove("InspectionSubsetLongCharKey");
                if( (value == null) || (!value.equals(getInspectionSubsetLongCharKey())) ) {
                    setInspectionSubsetLongCharKey(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetShortCharKey") ) {
                final Object value = values.remove("InspectionSubsetShortCharKey");
                if( (value == null) || (!value.equals(getInspectionSubsetShortCharKey())) ) {
                    setInspectionSubsetShortCharKey(((String) value));
                }
            }
            if( values.containsKey("InspectionPartialLot") ) {
                final Object value = values.remove("InspectionPartialLot");
                if( (value == null) || (!value.equals(getInspectionPartialLot())) ) {
                    setInspectionPartialLot(((String) value));
                }
            }
            if( values.containsKey("Inspector") ) {
                final Object value = values.remove("Inspector");
                if( (value == null) || (!value.equals(getInspector())) ) {
                    setInspector(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetYieldQty") ) {
                final Object value = values.remove("InspectionSubsetYieldQty");
                if( (value == null) || (!value.equals(getInspectionSubsetYieldQty())) ) {
                    setInspectionSubsetYieldQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionSubsetScrapQty") ) {
                final Object value = values.remove("InspectionSubsetScrapQty");
                if( (value == null) || (!value.equals(getInspectionSubsetScrapQty())) ) {
                    setInspectionSubsetScrapQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionSubsetReworkQty") ) {
                final Object value = values.remove("InspectionSubsetReworkQty");
                if( (value == null) || (!value.equals(getInspectionSubsetReworkQty())) ) {
                    setInspectionSubsetReworkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspectionSubsetQtyUnit") ) {
                final Object value = values.remove("InspectionSubsetQtyUnit");
                if( (value == null) || (!value.equals(getInspectionSubsetQtyUnit())) ) {
                    setInspectionSubsetQtyUnit(((String) value));
                }
            }
            if( values.containsKey("InspSbstFuncnlLocProperty") ) {
                final Object value = values.remove("InspSbstFuncnlLocProperty");
                if( (value == null) || (!value.equals(getInspSbstFuncnlLocProperty())) ) {
                    setInspSbstFuncnlLocProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstEquipProperty") ) {
                final Object value = values.remove("InspSbstEquipProperty");
                if( (value == null) || (!value.equals(getInspSbstEquipProperty())) ) {
                    setInspSbstEquipProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstMatlSmplProperty") ) {
                final Object value = values.remove("InspSbstMatlSmplProperty");
                if( (value == null) || (!value.equals(getInspSbstMatlSmplProperty())) ) {
                    setInspSbstMatlSmplProperty(((String) value));
                }
            }
            if( values.containsKey("InspectionSubsetSortKey") ) {
                final Object value = values.remove("InspectionSubsetSortKey");
                if( (value == null) || (!value.equals(getInspectionSubsetSortKey())) ) {
                    setInspectionSubsetSortKey(((String) value));
                }
            }
            if( values.containsKey("InspSbstDateFldProperty") ) {
                final Object value = values.remove("InspSbstDateFldProperty");
                if( (value == null) || (!value.equals(getInspSbstDateFldProperty())) ) {
                    setInspSbstDateFldProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstLongNmbrFldProperty") ) {
                final Object value = values.remove("InspSbstLongNmbrFldProperty");
                if( (value == null) || (!value.equals(getInspSbstLongNmbrFldProperty())) ) {
                    setInspSbstLongNmbrFldProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstShrtNmbrFldProperty") ) {
                final Object value = values.remove("InspSbstShrtNmbrFldProperty");
                if( (value == null) || (!value.equals(getInspSbstShrtNmbrFldProperty())) ) {
                    setInspSbstShrtNmbrFldProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstLongTxtFldProperty") ) {
                final Object value = values.remove("InspSbstLongTxtFldProperty");
                if( (value == null) || (!value.equals(getInspSbstLongTxtFldProperty())) ) {
                    setInspSbstLongTxtFldProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstTimeFldProperty") ) {
                final Object value = values.remove("InspSbstTimeFldProperty");
                if( (value == null) || (!value.equals(getInspSbstTimeFldProperty())) ) {
                    setInspSbstTimeFldProperty(((String) value));
                }
            }
            if( values.containsKey("InspSbstShrtTxtFldProperty") ) {
                final Object value = values.remove("InspSbstShrtTxtFldProperty");
                if( (value == null) || (!value.equals(getInspSbstShrtTxtFldProperty())) ) {
                    setInspSbstShrtTxtFldProperty(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionSubsetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionSubsetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionSubsetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionSubsetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

}
