/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata;

import java.net.URI;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>A_InspectionSubsetTrigger_valuation</b> OData function import.
 *
 */
public class InspectionSubsetTrigger_valuationFluentHelper
    extends
    SingleValuedFluentHelperFunction<InspectionSubsetTrigger_valuationFluentHelper, InspectionSubset, InspectionSubset>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>A_InspectionSubsetTrigger_valuation</b> OData function
     * import with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param inspPlanOperationInternalID
     *            Current Node No.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     *            </p>
     * @param inspectionLot
     *            Inspection Lot
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspectionLot</b>
     *            </p>
     * @param inspectionSubsetInternalID
     *            Sample
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     *            </p>
     */
    public InspectionSubsetTrigger_valuationFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String inspectionLot,
        @Nonnull final String inspPlanOperationInternalID,
        @Nonnull final String inspectionSubsetInternalID )
    {
        super(servicePath);
        values.put("InspectionLot", inspectionLot);
        values.put("InspPlanOperationInternalID", inspPlanOperationInternalID);
        values.put("InspectionSubsetInternalID", inspectionSubsetInternalID);
    }

    @Override
    @Nonnull
    protected Class<InspectionSubset> getEntityClass()
    {
        return InspectionSubset.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "A_InspectionSubsetTrigger_valuation";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public InspectionSubset executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
