/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link QualityInspectionDataServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService QualityInspectionDataService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultQualityInspectionDataServiceBatch
    extends
    BatchFluentHelperBasic<QualityInspectionDataServiceBatch, QualityInspectionDataServiceBatchChangeSet>
    implements
    QualityInspectionDataServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultQualityInspectionDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultQualityInspectionDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultQualityInspectionDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultQualityInspectionDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultQualityInspectionDataServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultQualityInspectionDataServiceBatchChangeSet(this, service);
    }

}
