/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset;

/**
 * Implementation of the {@link QualityInspectionDataServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService QualityInspectionDataService}.
 *
 */
public class DefaultQualityInspectionDataServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<QualityInspectionDataServiceBatch, QualityInspectionDataServiceBatchChangeSet>
    implements
    QualityInspectionDataServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService service;

    @SuppressWarnings( "deprecation" )
    DefaultQualityInspectionDataServiceBatchChangeSet(
        @Nonnull final DefaultQualityInspectionDataServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultQualityInspectionDataServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspectionCharacteristic(
        @Nonnull final InspectionCharacteristic inspectionCharacteristic )
    {
        return addRequestCreate(service::createInspectionCharacteristic, inspectionCharacteristic);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspectionLot( @Nonnull final InspectionLot inspectionLot )
    {
        return addRequestCreate(service::createInspectionLot, inspectionLot);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspectionLot( @Nonnull final InspectionLot inspectionLot )
    {
        return addRequestUpdate(service::updateInspectionLot, inspectionLot);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspectionResult(
        @Nonnull final InspectionResult inspectionResult )
    {
        return addRequestCreate(service::createInspectionResult, inspectionResult);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspectionResult(
        @Nonnull final InspectionResult inspectionResult )
    {
        return addRequestUpdate(service::updateInspectionResult, inspectionResult);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspectionResultValue(
        @Nonnull final InspectionResultValue inspectionResultValue )
    {
        return addRequestCreate(service::createInspectionResultValue, inspectionResultValue);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspectionResultValue(
        @Nonnull final InspectionResultValue inspectionResultValue )
    {
        return addRequestUpdate(service::updateInspectionResultValue, inspectionResultValue);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspectionSubset(
        @Nonnull final InspectionSubset inspectionSubset )
    {
        return addRequestCreate(service::createInspectionSubset, inspectionSubset);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspectionSubset(
        @Nonnull final InspectionSubset inspectionSubset )
    {
        return addRequestUpdate(service::updateInspectionSubset, inspectionSubset);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspLotMatlDocItem(
        @Nonnull final InspLotMatlDocItem inspLotMatlDocItem )
    {
        return addRequestCreate(service::createInspLotMatlDocItem, inspLotMatlDocItem);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspLotUsageDecision(
        @Nonnull final InspLotUsageDecision inspLotUsageDecision )
    {
        return addRequestCreate(service::createInspLotUsageDecision, inspLotUsageDecision);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspLotUsageDecision(
        @Nonnull final InspLotUsageDecision inspLotUsageDecision )
    {
        return addRequestUpdate(service::updateInspLotUsageDecision, inspLotUsageDecision);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet createInspSampleResult(
        @Nonnull final InspSampleResult inspSampleResult )
    {
        return addRequestCreate(service::createInspSampleResult, inspSampleResult);
    }

    @Nonnull
    @Override
    public QualityInspectionDataServiceBatchChangeSet updateInspSampleResult(
        @Nonnull final InspSampleResult inspSampleResult )
    {
        return addRequestUpdate(service::updateInspSampleResult, inspSampleResult);
    }

}
