/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.QualityInspectionDataService
 * QualityInspectionDataService}.
 *
 */
public interface QualityInspectionDataServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<QualityInspectionDataServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<QualityInspectionDataServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     * InspectionCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspectionCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     *            InspectionCharacteristic} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspectionCharacteristic( @Nonnull final InspectionCharacteristic inspectionCharacteristic );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entity and save it to the S/4HANA system.
     *
     * @param inspectionLot
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *            InspectionLot} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet createInspectionLot( @Nonnull final InspectionLot inspectionLot );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entity and save it to the S/4HANA system.
     *
     * @param inspectionLot
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *            InspectionLot} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet updateInspectionLot( @Nonnull final InspectionLot inspectionLot );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entity and save it to the S/4HANA system.
     *
     * @param inspectionResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *            InspectionResult} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspectionResult( @Nonnull final InspectionResult inspectionResult );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entity and save it to the S/4HANA system.
     *
     * @param inspectionResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *            InspectionResult} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        updateInspectionResult( @Nonnull final InspectionResult inspectionResult );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entity and save it to the S/4HANA system.
     *
     * @param inspectionResultValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *            InspectionResultValue} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspectionResultValue( @Nonnull final InspectionResultValue inspectionResultValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entity and save it to the S/4HANA system.
     *
     * @param inspectionResultValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *            InspectionResultValue} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        updateInspectionResultValue( @Nonnull final InspectionResultValue inspectionResultValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entity and save it to the S/4HANA system.
     *
     * @param inspectionSubset
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *            InspectionSubset} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspectionSubset( @Nonnull final InspectionSubset inspectionSubset );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entity and save it to the S/4HANA system.
     *
     * @param inspectionSubset
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *            InspectionSubset} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        updateInspectionSubset( @Nonnull final InspectionSubset inspectionSubset );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     * InspLotMatlDocItem} entity and save it to the S/4HANA system.
     *
     * @param inspLotMatlDocItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     *            InspLotMatlDocItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspLotMatlDocItem( @Nonnull final InspLotMatlDocItem inspLotMatlDocItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entity and save it to the S/4HANA system.
     *
     * @param inspLotUsageDecision
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *            InspLotUsageDecision} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspLotUsageDecision( @Nonnull final InspLotUsageDecision inspLotUsageDecision );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entity and save it to the S/4HANA system.
     *
     * @param inspLotUsageDecision
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *            InspLotUsageDecision} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        updateInspLotUsageDecision( @Nonnull final InspLotUsageDecision inspLotUsageDecision );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entity and save it to the S/4HANA system.
     *
     * @param inspSampleResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *            InspSampleResult} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        createInspSampleResult( @Nonnull final InspSampleResult inspSampleResult );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entity and save it to the S/4HANA system.
     *
     * @param inspSampleResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *            InspSampleResult} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    QualityInspectionDataServiceBatchChangeSet
        updateInspSampleResult( @Nonnull final InspSampleResult inspSampleResult );

}
