/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable.InspectionCharacteristicSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
 * InspectionCharacteristic} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class InspectionCharacteristicLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<InspectionCharacteristicLink<ObjectT>, InspectionCharacteristic, ObjectT>
    implements
    InspectionCharacteristicSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public InspectionCharacteristicLink( final String fieldName )
    {
        super(fieldName);
    }

    private InspectionCharacteristicLink(
        final EntityLink<InspectionCharacteristicLink<ObjectT>, InspectionCharacteristic, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected InspectionCharacteristicLink<ObjectT> translateLinkType(
        final EntityLink<InspectionCharacteristicLink<ObjectT>, InspectionCharacteristic, ObjectT> link )
    {
        return new InspectionCharacteristicLink<ObjectT>(link);
    }

}
