/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr
 * InspLotMatlDocItmSrlNmbr}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotMatlDocItmSrlNmbrField
 * InspLotMatlDocItmSrlNmbrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspLotMatlDocItmSrlNmbrLink
 * InspLotMatlDocItmSrlNmbrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr#INSP_LOT_MATL_DOC_ITEM
 * INSP_LOT_MATL_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr#INSP_LOT_MATL_DOC_ITEM_TYPE
 * INSP_LOT_MATL_DOC_ITEM_TYPE}</li>
 * </ul>
 *
 */
public interface InspLotMatlDocItmSrlNmbrSelectable extends EntitySelectable<InspLotMatlDocItmSrlNmbr>
{

}
