/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
 * InspLotSerialNumber}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotSerialNumberField
 * InspLotSerialNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspLotSerialNumberLink
 * InspLotSerialNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface InspLotSerialNumberSelectable extends EntitySelectable<InspLotSerialNumber>
{

}
