/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
 * InspLotUsageDecision}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspLotUsageDecisionField
 * InspLotUsageDecisionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspLotUsageDecisionLink
 * InspLotUsageDecisionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_LEVEL
 * INSP_LOT_USAGE_DECISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSPECTION_LOT_QUALITY_SCORE
 * INSPECTION_LOT_QUALITY_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_CATALOG
 * INSP_LOT_USAGE_DECISION_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USGE_DCSN_SELECTED_SET
 * INSP_LOT_USGE_DCSN_SELECTED_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_CODE_GROUP
 * INSP_LOT_USAGE_DECISION_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSPECTION_LOT_USAGE_DECISION_CODE
 * INSPECTION_LOT_USAGE_DECISION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USGE_DCSN_DYN_VALUATION
 * INSP_LOT_USGE_DCSN_DYN_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_VALUATION
 * INSP_LOT_USAGE_DECISION_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USGE_DCSN_FOLLOW_UP_ACTION
 * INSP_LOT_USGE_DCSN_FOLLOW_UP_ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSPECTION_LOT_USAGE_DECIDED_BY
 * INSPECTION_LOT_USAGE_DECIDED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSPECTION_LOT_USAGE_DECIDED_ON
 * INSPECTION_LOT_USAGE_DECIDED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_TIME
 * INSP_LOT_USAGE_DECISION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_CHANGED_BY
 * INSP_LOT_USAGE_DECISION_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USAGE_DECISION_CHANGED_ON
 * INSP_LOT_USAGE_DECISION_CHANGED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USGE_DCSN_CHANGED_TIME
 * INSP_LOT_USGE_DCSN_CHANGED_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#INSP_LOT_USGE_DCSN_HAS_LONG_TEXT
 * INSP_LOT_USGE_DCSN_HAS_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspLotUsageDecisionSelectable extends EntitySelectable<InspLotUsageDecision>
{

}
