/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic
 * InspSampleCharacteristic}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspSampleCharacteristicField
 * InspSampleCharacteristicField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspSampleCharacteristicLink
 * InspSampleCharacteristicLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_CHARACTERISTIC
 * INSPECTION_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_SUBSET_INTERNAL_ID
 * INSPECTION_SUBSET_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_CHARACTERISTIC_STATUS
 * INSPECTION_CHARACTERISTIC_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#QUALITY_CONTROL_CHART
 * QUALITY_CONTROL_CHART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_SAMPLE_ACCEPTANCE_NUMBER
 * INSP_SAMPLE_ACCEPTANCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_SAMPLE_REJECTION_NUMBER
 * INSP_SAMPLE_REJECTION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_SAMPLE_VALUATION_RULE
 * INSP_SAMPLE_VALUATION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_SAMPLE_SIZE
 * INSPECTION_SAMPLE_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_LOT_DYN_RULE_STAGE
 * INSP_LOT_DYN_RULE_STAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSPECTION_SEVERITY
 * INSPECTION_SEVERITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#INSP_SUBSET_CHARC_CREATION_DATE
 * INSP_SUBSET_CHARC_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspSampleCharacteristicSelectable extends EntitySelectable<InspSampleCharacteristic>
{

}
