/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult InspSampleResult}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspSampleResultField
 * InspSampleResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspSampleResultLink
 * InspSampleResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_CHARACTERISTIC
 * INSPECTION_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_SUBSET_INTERNAL_ID
 * INSPECTION_SUBSET_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTOR
 * INSPECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_STATUS
 * INSPECTION_RESULT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_ORIGIN
 * INSPECTION_RESULT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_START_DATE
 * INSPECTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_START_TIME
 * INSPECTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_END_DATE
 * INSPECTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_END_TIME
 * INSPECTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_ATTRIBUTE
 * INSPECTION_RESULT_ATTRIBUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_VALUATION_RESULT
 * INSPECTION_VALUATION_RESULT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_FRMTD_MEAN_VALUE
 * INSP_RESULT_FRMTD_MEAN_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_HAS_MEAN_VALUE
 * INSPECTION_RESULT_HAS_MEAN_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_FRMTD_MAXIMUM_VALUE
 * INSP_RESULT_FRMTD_MAXIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_HAS_MAXIMUM_VALUE
 * INSP_RESULT_HAS_MAXIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_FRMTD_MINIMUM_VALUE
 * INSP_RESULT_FRMTD_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_HAS_MINIMUM_VALUE
 * INSP_RESULT_HAS_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_ORIGINAL_VALUE
 * INSPECTION_RESULT_ORIGINAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_VALID_VALUES_NUMBER
 * INSP_RESULT_VALID_VALUES_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_NMBR_OF_RECORDED_RSLTS
 * INSP_RESULT_NMBR_OF_RECORDED_RSLTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_TEXT
 * INSPECTION_RESULT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_HAS_LONG_TEXT
 * INSPECTION_RESULT_HAS_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_FREE_DEFINED_TEST_EQUIP
 * INSP_RSLT_FREE_DEFINED_TEST_EQUIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_BELOW_TOLERANCE_VALS_NMBR
 * INSP_RSLT_BELOW_TOLERANCE_VALS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_ABOVE_TOLERANCE_VALS_NMBR
 * INSP_RSLT_ABOVE_TOLERANCE_VALS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_FRMTD_ABV_TOL_FRACTION
 * INSP_RSLT_FRMTD_ABV_TOL_FRACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_FRMTD_BELOW_TOL_FRACTION
 * INSP_RSLT_FRMTD_BELOW_TOL_FRACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RESULT_FRMTD_VARIANCE
 * INSP_RESULT_FRMTD_VARIANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSP_RSLT_NONCONFORMING_VALS_NMBR
 * INSP_RSLT_NONCONFORMING_VALS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_NUMBER_OF_DEFECTS
 * INSPECTION_NUMBER_OF_DEFECTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CHARACTERISTIC_ATTRIBUTE_CODE_GRP
 * CHARACTERISTIC_ATTRIBUTE_CODE_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE_GROUP2
 * INSPECTION_RESULT_CODE_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE_GROUP3
 * INSPECTION_RESULT_CODE_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE_GROUP4
 * INSPECTION_RESULT_CODE_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE_GROUP5
 * INSPECTION_RESULT_CODE_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CHARACTERISTIC_ATTRIBUTE_CODE
 * CHARACTERISTIC_ATTRIBUTE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE2
 * INSPECTION_RESULT_CODE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE3
 * INSPECTION_RESULT_CODE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE4
 * INSPECTION_RESULT_CODE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CODE5
 * INSPECTION_RESULT_CODE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CHARACTERISTIC_ATTRIBUTE_CATALOG
 * CHARACTERISTIC_ATTRIBUTE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CATALOG2
 * INSPECTION_RESULT_CATALOG2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CATALOG3
 * INSPECTION_RESULT_CATALOG3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CATALOG4
 * INSPECTION_RESULT_CATALOG4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#INSPECTION_RESULT_CATALOG5
 * INSPECTION_RESULT_CATALOG5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult#CHANGED_TIME
 * CHANGED_TIME}</li>
 * </ul>
 *
 */
public interface InspSampleResultSelectable extends EntitySelectable<InspSampleResult>
{

}
