/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
 * InspectionCharacteristic}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionCharacteristicField
 * InspectionCharacteristicField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionCharacteristicLink
 * InspectionCharacteristicLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_CHARACTERISTIC
 * INSPECTION_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SPECIFICATION_TEXT
 * INSPECTION_SPECIFICATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#HAS_INSP_CHARC_PRTL_SMPL
 * HAS_INSP_CHARC_PRTL_SMPL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_IS_QUANTITATIVE
 * INSP_SPEC_IS_QUANTITATIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_IS_MEASURED_VALUE_RQD
 * INSP_SPEC_IS_MEASURED_VALUE_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_IS_SELECTED_SET_REQUIRED
 * INSP_SPEC_IS_SELECTED_SET_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_IS_LONG_TERM_INSPECTION
 * INSP_SPEC_IS_LONG_TERM_INSPECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_RECORDING_TYPE
 * INSP_SPEC_RECORDING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_RESULT_IS_DOCUMENTATION_RQD
 * INSP_RESULT_IS_DOCUMENTATION_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_CHARC_CATEGORY
 * INSP_SPEC_CHARC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_RESULT_CALCULATION
 * INSP_SPEC_RESULT_CALCULATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_CHARC_IS_NOT_PLANNED
 * INSP_CHARC_IS_NOT_PLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_METHOD
 * INSPECTION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_METHOD_PLANT
 * INSPECTION_METHOD_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_METHOD_VERSION
 * INSPECTION_METHOD_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SPECIFICATION_PLANT
 * INSPECTION_SPECIFICATION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SPECIFICATION
 * INSPECTION_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SPECIFICATION_VERSION
 * INSPECTION_SPECIFICATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_CHARACTERISTIC_STATUS
 * INSPECTION_CHARACTERISTIC_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_DECIMAL_PLACES
 * INSP_SPEC_DECIMAL_PLACES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SPECIFICATION_UNIT
 * INSPECTION_SPECIFICATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SAMPLE_VALUATION_RULE
 * INSP_SAMPLE_VALUATION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_CHARACTERISTIC_SAMPLE_SIZE
 * INSP_CHARACTERISTIC_SAMPLE_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_CHARACTERISTIC_SAMPLE_UNIT
 * INSP_CHARACTERISTIC_SAMPLE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_SAMPLE_QUANTITY_FACTOR
 * INSP_SPEC_SAMPLE_QUANTITY_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_TARGET_VALUE
 * INSP_SPEC_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_FRMTD_TARGET_VALUE
 * INSP_SPEC_FRMTD_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_HAS_TARGET_VALUE
 * INSP_SPEC_HAS_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_UPPER_LIMIT
 * INSP_SPEC_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_FRMTD_UPPER_LIMIT
 * INSP_SPEC_FRMTD_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_HAS_UPPER_LIMIT
 * INSP_SPEC_HAS_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_LOWER_LIMIT
 * INSP_SPEC_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_FRMTD_LOWER_LIMIT
 * INSP_SPEC_FRMTD_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_HAS_LOWER_LIMIT
 * INSP_SPEC_HAS_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_IMPORTANCE_CODE
 * INSP_SPEC_IMPORTANCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_LOT_TEST_EQUIP_INTERNAL_ID
 * INSP_LOT_TEST_EQUIP_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTOR_QUALIFICATION
 * INSPECTOR_QUALIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_INFORMATION_FIELD1
 * INSP_SPEC_INFORMATION_FIELD1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_INFORMATION_FIELD2
 * INSP_SPEC_INFORMATION_FIELD2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_INFORMATION_FIELD3
 * INSP_SPEC_INFORMATION_FIELD3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSPECTION_SCOPE
 * INSPECTION_SCOPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_CHARC_QUANTITY
 * INSP_CHARC_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_SPEC_CONTROL_INDICATORS
 * INSP_SPEC_CONTROL_INDICATORS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#CHARACTERISTIC_ATTRIBUTE_CATALOG
 * CHARACTERISTIC_ATTRIBUTE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#UNPLND_CHARC_INSP_SUBSET_INT_ID
 * UNPLND_CHARC_INSP_SUBSET_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_LOT_DYNAMIC_RULE
 * INSP_LOT_DYNAMIC_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#INSP_CHARC_CONFIRMATION_NUMBER
 * INSP_CHARC_CONFIRMATION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#TO_INSP_RESULT_VALUE
 * TO_INSP_RESULT_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic#TO_INSP_SMPL_RESULT
 * TO_INSP_SMPL_RESULT}</li>
 * </ul>
 *
 */
public interface InspectionCharacteristicSelectable extends EntitySelectable<InspectionCharacteristic>
{

}
