/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot InspectionLot}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionLotField
 * InspectionLotField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionLotLink
 * InspectionLotLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_ORIGIN
 * INSPECTION_LOT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_TEXT
 * INSPECTION_LOT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_TYPE
 * INSPECTION_LOT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_QUANTITY
 * INSPECTION_LOT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_ACTUAL_QUANTITY
 * INSPECTION_LOT_ACTUAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_DEFECTIVE_QUANTITY
 * INSPECTION_LOT_DEFECTIVE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_QUANTITY_UNIT
 * INSPECTION_LOT_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_CREATED_ON_LOCAL_DATE
 * INSP_LOT_CREATED_ON_LOCAL_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_SUBSET_FIELD_COMBINATION
 * INSP_SUBSET_FIELD_COMBINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_NMBR_OPEN_LONG_TERM_CHARC
 * INSP_LOT_NMBR_OPEN_LONG_TERM_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#STATUS_OBJECT
 * STATUS_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#STATUS_OBJECT_CATEGORY
 * STATUS_OBJECT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_OBJECT_TEXT
 * INSPECTION_LOT_OBJECT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#STATUS_PROFILE
 * STATUS_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATL_QUALITY_AUTHORIZATION_GROUP
 * MATL_QUALITY_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_HAS_QUANTITY
 * INSPECTION_LOT_HAS_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_CREATED_AUTOMATICALLY
 * INSP_LOT_IS_CREATED_AUTOMATICALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_HAS_PARTIAL_LOTS
 * INSPECTION_LOT_HAS_PARTIAL_LOTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_HAS_APPRAISAL_COSTS
 * INSPECTION_LOT_HAS_APPRAISAL_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_HAS_SUBSETS
 * INSP_LOT_HAS_SUBSETS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_AUTOM_USGE_DCSN_POSSIBLE
 * INSP_LOT_IS_AUTOM_USGE_DCSN_POSSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_HAS_CONFIGN_SPECIFICATION
 * INSP_LOT_HAS_CONFIGN_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#GOODS_RECEIPT_IS_MOVED_TO_BLKD_STOCK
 * GOODS_RECEIPT_IS_MOVED_TO_BLKD_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_DOCUMENTATION_REQUIRED
 * INSP_LOT_IS_DOCUMENTATION_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_TASK_LIST_REQUIRED
 * INSP_LOT_IS_TASK_LIST_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_HAS_MANUAL_SAMPLE_SIZE
 * INSP_LOT_HAS_MANUAL_SAMPLE_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_HAS_MATERIAL_SPEC
 * INSP_LOT_HAS_MATERIAL_SPEC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_APPROVAL
 * INSPECTION_LOT_APPROVAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_DIGITAL_SGNTR_RESULTS_RECG
 * INSP_LOT_DIGITAL_SGNTR_RESULTS_RECG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_DIGITAL_SGNTR_IN_USGE_DCSN
 * INSP_LOT_DIGITAL_SGNTR_IN_USGE_DCSN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_BATCH_REQUIRED
 * INSP_LOT_IS_BATCH_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_USAGE_IN_STABILITY_STUDY
 * INSP_LOT_USAGE_IN_STABILITY_STUDY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_STOCK_POSTING_COMPLETED
 * INSP_LOT_IS_STOCK_POSTING_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_HAS_USAGE_DECISION
 * INSPECTION_LOT_HAS_USAGE_DECISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#NUMBER_OF_SERIAL_NUMBERS
 * NUMBER_OF_SERIAL_NUMBERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_IS_SERIAL_NMBR_POSSIBLE
 * INSP_LOT_IS_SERIAL_NMBR_POSSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_IS_SKIPPED
 * INSPECTION_LOT_IS_SKIPPED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_IS_FULL_INSPECTION
 * INSPECTION_LOT_IS_FULL_INSPECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_DYNAMIC_LEVEL
 * INSPECTION_LOT_DYNAMIC_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SAMPLING_PROCEDURE
 * SAMPLING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_CREATED_ON_LOCAL_TIME
 * INSP_LOT_CREATED_ON_LOCAL_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CREATED_BY
 * INSPECTION_LOT_CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CREATED_ON
 * INSPECTION_LOT_CREATED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CREATED_ON_TIME
 * INSPECTION_LOT_CREATED_ON_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CHANGED_BY
 * INSPECTION_LOT_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CHANGE_DATE
 * INSPECTION_LOT_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CHANGE_TIME
 * INSPECTION_LOT_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_START_DATE
 * INSPECTION_LOT_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_START_TIME
 * INSPECTION_LOT_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_END_DATE
 * INSPECTION_LOT_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_END_TIME
 * INSPECTION_LOT_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_OF_OPERATIONS_TYPE
 * BILL_OF_OPERATIONS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_OF_OPERATIONS_GROUP
 * BILL_OF_OPERATIONS_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_OF_OPERATIONS_USAGE
 * BILL_OF_OPERATIONS_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_OF_OPERATIONS_VARIANT
 * BILL_OF_OPERATIONS_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_OF_OPERATIONS_CHANGE_STATE_ID
 * BILL_OF_OPERATIONS_CHANGE_STATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_SUBSET_TYPE
 * INSPECTION_SUBSET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SMPL_DRAWING_PROCEDURE
 * SMPL_DRAWING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SMPL_DRAWING_PROCEDURE_VERSION
 * SMPL_DRAWING_PROCEDURE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SMPL_DRWG_PROCED_IS_CONF_REQUIRED
 * SMPL_DRWG_PROCED_IS_CONF_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_MATERIAL
 * INSP_LOT_SELECTION_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SEL_MATL_REVISION_LVL
 * INSP_LOT_SEL_MATL_REVISION_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_PLANT
 * INSP_LOT_SELECTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_SUPPLIER
 * INSP_LOT_SELECTION_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_MANUFACTURER
 * INSP_LOT_SELECTION_MANUFACTURER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_CUSTOMER
 * INSP_LOT_SELECTION_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SEL_BILL_OF_OPERATIONS_USGE
 * INSP_LOT_SEL_BILL_OF_OPERATIONS_USGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SELECTION_VALID_FROM_DATE
 * INSP_LOT_SELECTION_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SALES_OPERATIONS_PLANNING_ORDER
 * SALES_OPERATIONS_PLANNING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#IS_BUSINESS_PURPOSE_COMPLETED
 * IS_BUSINESS_PURPOSE_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BATCH_BY_SUPPLIER
 * BATCH_BY_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MANUFACTURER
 * MANUFACTURER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MANUFACTURER_PART_NMBR
 * MANUFACTURER_PART_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_REVISION_LEVEL
 * MATERIAL_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_IS_BATCH_MANAGED
 * MATERIAL_IS_BATCH_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BATCH_STORAGE_LOCATION
 * BATCH_STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_COMP_IS_SPECIAL_STOCK
 * MATERIAL_COMP_IS_SPECIAL_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATL_DOC_LATEST_POSTG_DATE
 * MATL_DOC_LATEST_POSTG_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_PLANT
 * INSPECTION_LOT_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_STORAGE_LOCATION
 * INSPECTION_LOT_STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#DELIVERY_DOCUMENT_ITEM
 * DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#DELIVERY_CATEGORY
 * DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_DELIVERY_CATEGORY
 * INSPECTION_DELIVERY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#ROUTE ROUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BILL_TO_PARTY_COUNTRY
 * BILL_TO_PARTY_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_NMBR_ADDL_RECORDED_CHARC
 * INSP_LOT_NMBR_ADDL_RECORDED_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_NMBR_OPEN_SHORT_TERM_CHARC
 * INSP_LOT_NMBR_OPEN_SHORT_TERM_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CONTAINER
 * INSPECTION_LOT_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_CONTAINER_UNIT
 * INSPECTION_LOT_CONTAINER_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_SAMPLE_QUANTITY
 * INSPECTION_LOT_SAMPLE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_SAMPLE_UNIT
 * INSPECTION_LOT_SAMPLE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_DYNAMIC_RULE
 * INSP_LOT_DYNAMIC_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_DYNAMIC_TRGGR_POINT
 * INSP_LOT_DYNAMIC_TRGGR_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_DYNAMIC_STAGE
 * INSPECTION_DYNAMIC_STAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_SEVERITY
 * INSPECTION_SEVERITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_FREE
 * INSP_LOT_QTY_TO_FREE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_SCRAP
 * INSP_LOT_QTY_TO_SCRAP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_SAMPLE
 * INSP_LOT_QTY_TO_SAMPLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_BLOCKED
 * INSP_LOT_QTY_TO_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_RESERVES
 * INSP_LOT_QTY_TO_RESERVES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_ANOTHER_MATERIAL
 * INSP_LOT_QTY_TO_ANOTHER_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_MATERIAL_POSTED_TO
 * INSP_LOT_MATERIAL_POSTED_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_BATCH_TRANSFERRED_TO
 * INSP_LOT_BATCH_TRANSFERRED_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_RETURNED_TO_SUPPLIER
 * INSP_LOT_QTY_RETURNED_TO_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_SPECIAL_STOCK
 * INSP_LOT_QTY_TO_SPECIAL_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_OTHER_STOCK
 * INSP_LOT_QTY_TO_OTHER_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_TO_BE_POSTED
 * INSP_LOT_QTY_TO_BE_POSTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_SMPL_QTY_FOR_LONG_TERM_CHAR
 * INSP_LOT_SMPL_QTY_FOR_LONG_TERM_CHAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_INSPECTED
 * INSP_LOT_QTY_INSPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_QTY_DESTROYED
 * INSP_LOT_QTY_DESTROYED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_SCRAP_RATIO
 * INSPECTION_LOT_SCRAP_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_USAGE_DECISION_TOOL
 * INSP_LOT_USAGE_DECISION_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_ALLOWED_SCRAP_RATIO
 * INSPECTION_LOT_ALLOWED_SCRAP_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#QUALITY_COST_COLLECTOR
 * QUALITY_COST_COLLECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#CONSUMPTION_POSTING
 * CONSUMPTION_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#ACCOUNT_ASSIGNMENT_CATEGORY
 * ACCOUNT_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PURCHASING_DOCUMENT_ITEM_CATEGORY
 * PURCHASING_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_ACCT_ASSGMT_KEY
 * INSP_LOT_ACCT_ASSGMT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SALES_ORD_STOCK_WBS_ELEMENT
 * SALES_ORD_STOCK_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#NETWORK_ACTIVITY_INTERNAL_ID
 * NETWORK_ACTIVITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INVENTORY_SPCL_STK_SALES_DOCUMENT
 * INVENTORY_SPCL_STK_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INVENTORY_SPCL_STK_SALES_DOC_ITM
 * INVENTORY_SPCL_STK_SALES_DOC_ITM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_COST_COLLECTOR_SALES_ORDER
 * INSP_LOT_COST_COLLECTOR_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_COST_COLLECTOR_SLS_ORD_ITEM
 * INSP_LOT_COST_COLLECTOR_SLS_ORD_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_COST_COLLECTOR_WBS_ELEMENT
 * INSP_LOT_COST_COLLECTOR_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSP_LOT_EXTERNAL_NUMBER
 * INSP_LOT_EXTERNAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#INSPECTION_LOT_PRIORITY_POINTS
 * INSPECTION_LOT_PRIORITY_POINTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MAINTENANCE_PLAN_ITEM_INT_ID
 * MAINTENANCE_PLAN_ITEM_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#MAINTENANCE_STRATEGY
 * MAINTENANCE_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot#TO_INSPECTION_LOT_WITH_STATUS
 * TO_INSPECTION_LOT_WITH_STATUS}</li>
 * </ul>
 *
 */
public interface InspectionLotSelectable extends EntitySelectable<InspectionLot>
{

}
