/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus
 * InspectionLotWithStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionLotWithStatusField
 * InspectionLotWithStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionLotWithStatusLink
 * InspectionLotWithStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSPECTION_LOT_STATUS_CREATED
 * INSPECTION_LOT_STATUS_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSPECTION_LOT_STATUS_RELEASED
 * INSPECTION_LOT_STATUS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSPECTION_LOT_STATUS_SKIP
 * INSPECTION_LOT_STATUS_SKIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STATUS_RSLTS_CONFIRMED
 * INSP_LOT_STATUS_RSLTS_CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STS_DEFECTS_RECORDED
 * INSP_LOT_STS_DEFECTS_RECORDED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STS_SHRT_TRM_INSP_CMPLTD
 * INSP_LOT_STS_SHRT_TRM_INSP_CMPLTD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STATUS_INSP_COMPLETED
 * INSP_LOT_STATUS_INSP_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STATUS_CANCELED
 * INSP_LOT_STATUS_CANCELED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus#INSP_LOT_STATUS_REPAIR
 * INSP_LOT_STATUS_REPAIR}</li>
 * </ul>
 *
 */
public interface InspectionLotWithStatusSelectable extends EntitySelectable<InspectionLotWithStatus>
{

}
