/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
 * InspectionResultValue}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionResultValueField
 * InspectionResultValueField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionResultValueLink
 * InspectionResultValueLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_CHARACTERISTIC
 * INSPECTION_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_RESULT_VALUE_INTERNAL_ID
 * INSP_RESULT_VALUE_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_ATTRIBUTE
 * INSPECTION_RESULT_ATTRIBUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_RESULT_ITEM_INTERNAL_ID
 * INSP_RESULT_ITEM_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_SUBSET_INTERNAL_ID
 * INSPECTION_SUBSET_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_MEASURED_VALUE
 * INSPECTION_RESULT_MEASURED_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_RESULT_FRMTD_MEASURED_VALUE
 * INSP_RESULT_FRMTD_MEASURED_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_RESULT_HAS_MEASURED_VALUE
 * INSP_RESULT_HAS_MEASURED_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_ORIGINAL_VALUE
 * INSPECTION_RESULT_ORIGINAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_NUMBER_OF_DEFECTS
 * INSPECTION_NUMBER_OF_DEFECTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#DEFECT_CLASS
 * DEFECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_TEXT
 * INSPECTION_RESULT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_LOT_SINGLE_UNIT_NUMBER
 * INSP_LOT_SINGLE_UNIT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_ITEM
 * INSPECTION_RESULT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSP_RSLT_FREE_DEFINED_TEST_EQUIP
 * INSP_RSLT_FREE_DEFINED_TEST_EQUIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_VALUATION_RESULT
 * INSPECTION_VALUATION_RESULT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CHARACTERISTIC_ATTRIBUTE_CODE_GRP
 * CHARACTERISTIC_ATTRIBUTE_CODE_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE_GROUP2
 * INSPECTION_RESULT_CODE_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE_GROUP3
 * INSPECTION_RESULT_CODE_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE_GROUP4
 * INSPECTION_RESULT_CODE_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE_GROUP5
 * INSPECTION_RESULT_CODE_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CHARACTERISTIC_ATTRIBUTE_CODE
 * CHARACTERISTIC_ATTRIBUTE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE2
 * INSPECTION_RESULT_CODE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE3
 * INSPECTION_RESULT_CODE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE4
 * INSPECTION_RESULT_CODE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CODE5
 * INSPECTION_RESULT_CODE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CHARACTERISTIC_ATTRIBUTE_CATALOG
 * CHARACTERISTIC_ATTRIBUTE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CATALOG2
 * INSPECTION_RESULT_CATALOG2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CATALOG3
 * INSPECTION_RESULT_CATALOG3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CATALOG4
 * INSPECTION_RESULT_CATALOG4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_RESULT_CATALOG5
 * INSPECTION_RESULT_CATALOG5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTOR
 * INSPECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_START_DATE
 * INSPECTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_START_TIME
 * INSPECTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_END_DATE
 * INSPECTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#INSPECTION_END_TIME
 * INSPECTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CHANGED_TIME
 * CHANGED_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspectionResultValueSelectable extends EntitySelectable<InspectionResultValue>
{

}
