/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset InspectionSubset}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.field.InspectionSubsetField
 * InspectionSubsetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.link.InspectionSubsetLink
 * InspectionSubsetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#TRIGGER_VALUATION_AC
 * TRIGGER_VALUATION_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_PLAN_OPERATION_INTERNAL_ID
 * INSP_PLAN_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_INTERNAL_ID
 * INSPECTION_SUBSET_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#MATERIAL_SAMPLE
 * MATERIAL_SAMPLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#SHOP_FLOOR_ITEM
 * SHOP_FLOOR_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SUBSET_USAGE_DCSN_CODE_GROUP
 * INSP_SUBSET_USAGE_DCSN_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SUBSET_USAGE_DCSN_CODE
 * INSP_SUBSET_USAGE_DCSN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SUBSET_USAGE_DCSN_VALUATION
 * INSP_SUBSET_USAGE_DCSN_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_TIME
 * INSPECTION_SUBSET_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_DATE
 * INSPECTION_SUBSET_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SUBSET_LONG_NUMERIC_KEY
 * INSP_SUBSET_LONG_NUMERIC_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SUBSET_SHORT_NUMERIC_KEY
 * INSP_SUBSET_SHORT_NUMERIC_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_LONG_CHAR_KEY
 * INSPECTION_SUBSET_LONG_CHAR_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_SHORT_CHAR_KEY
 * INSPECTION_SUBSET_SHORT_CHAR_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_PARTIAL_LOT
 * INSPECTION_PARTIAL_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTOR
 * INSPECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_YIELD_QTY
 * INSPECTION_SUBSET_YIELD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_SCRAP_QTY
 * INSPECTION_SUBSET_SCRAP_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_REWORK_QTY
 * INSPECTION_SUBSET_REWORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_QTY_UNIT
 * INSPECTION_SUBSET_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_FUNCNL_LOC_PROPERTY
 * INSP_SBST_FUNCNL_LOC_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_EQUIP_PROPERTY
 * INSP_SBST_EQUIP_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_MATL_SMPL_PROPERTY
 * INSP_SBST_MATL_SMPL_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSPECTION_SUBSET_SORT_KEY
 * INSPECTION_SUBSET_SORT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_DATE_FLD_PROPERTY
 * INSP_SBST_DATE_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_LONG_NMBR_FLD_PROPERTY
 * INSP_SBST_LONG_NMBR_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_SHRT_NMBR_FLD_PROPERTY
 * INSP_SBST_SHRT_NMBR_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_LONG_TXT_FLD_PROPERTY
 * INSP_SBST_LONG_TXT_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_TIME_FLD_PROPERTY
 * INSP_SBST_TIME_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#INSP_SBST_SHRT_TXT_FLD_PROPERTY
 * INSP_SBST_SHRT_TXT_FLD_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspectionSubsetSelectable extends EntitySelectable<InspectionSubset>
{

}
