/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.ProductPlantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.ProductPlantLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.ProductPlantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Plant Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlant extends VdmEntity<ProductPlant>
{

    /**
     * Selector for all available fields of ProductPlant.
     *
     */
    public final static ProductPlantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PRODUCT = new ProductPlantField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PLANT = new ProductPlantField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PURCHASING_GROUP = new ProductPlantField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> COUNTRY_OF_ORIGIN = new ProductPlantField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @return Region of Origin of Material (Non-Preferential Origin)
     */
    @SerializedName( "RegionOfOrigin" )
    @JsonProperty( "RegionOfOrigin" )
    @Nullable
    @ODataField( odataName = "RegionOfOrigin" )
    private String regionOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>RegionOfOrigin</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> REGION_OF_ORIGIN = new ProductPlantField<String>("RegionOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @return Issue Storage Location
     */
    @SerializedName( "ProductionInvtryManagedLoc" )
    @JsonProperty( "ProductionInvtryManagedLoc" )
    @Nullable
    @ODataField( odataName = "ProductionInvtryManagedLoc" )
    private String productionInvtryManagedLoc;
    /**
     * Use with available fluent helpers to apply the <b>ProductionInvtryManagedLoc</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PRODUCTION_INVTRY_MANAGED_LOC =
        new ProductPlantField<String>("ProductionInvtryManagedLoc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfileCode</b>
     * </p>
     *
     * @return Plant-Specific Material Status
     */
    @SerializedName( "ProfileCode" )
    @JsonProperty( "ProfileCode" )
    @Nullable
    @ODataField( odataName = "ProfileCode" )
    private String profileCode;
    /**
     * Use with available fluent helpers to apply the <b>ProfileCode</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PROFILE_CODE = new ProductPlantField<String>("ProfileCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProfileValidityStartDate</b>
     * </p>
     *
     * @return Date from Which the Plant-Specific Material Status Is Valid
     */
    @SerializedName( "ProfileValidityStartDate" )
    @JsonProperty( "ProfileValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProfileValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime profileValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProfileValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductPlantField<LocalDateTime> PROFILE_VALIDITY_START_DATE =
        new ProductPlantField<LocalDateTime>("ProfileValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @return Checking Group for Availability Check
     */
    @SerializedName( "AvailabilityCheckType" )
    @JsonProperty( "AvailabilityCheckType" )
    @Nullable
    @ODataField( odataName = "AvailabilityCheckType" )
    private String availabilityCheckType;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityCheckType</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> AVAILABILITY_CHECK_TYPE =
        new ProductPlantField<String>("AvailabilityCheckType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> FISCAL_YEAR_VARIANT =
        new ProductPlantField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @return Period Indicator
     */
    @SerializedName( "PeriodType" )
    @JsonProperty( "PeriodType" )
    @Nullable
    @ODataField( odataName = "PeriodType" )
    private String periodType;
    /**
     * Use with available fluent helpers to apply the <b>PeriodType</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PERIOD_TYPE = new ProductPlantField<String>("PeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PROFIT_CENTER = new ProductPlantField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>Commodity</b>
     * </p>
     *
     * @return Commodity Code
     */
    @SerializedName( "Commodity" )
    @JsonProperty( "Commodity" )
    @Nullable
    @ODataField( odataName = "Commodity" )
    private String commodity;
    /**
     * Use with available fluent helpers to apply the <b>Commodity</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> COMMODITY = new ProductPlantField<String>("Commodity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> GOODS_RECEIPT_DURATION =
        new ProductPlantField<BigDecimal>("GoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStatusName</b>
     * </p>
     *
     * @return Maintenance status
     */
    @SerializedName( "MaintenanceStatusName" )
    @JsonProperty( "MaintenanceStatusName" )
    @Nullable
    @ODataField( odataName = "MaintenanceStatusName" )
    private String maintenanceStatusName;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStatusName</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> MAINTENANCE_STATUS_NAME =
        new ProductPlantField<String>("MaintenanceStatusName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Flag Material for Deletion at Plant Level
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductPlantField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @return MRP Type
     */
    @SerializedName( "MRPType" )
    @JsonProperty( "MRPType" )
    @Nullable
    @ODataField( odataName = "MRPType" )
    private String mRPType;
    /**
     * Use with available fluent helpers to apply the <b>MRPType</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> MRP_TYPE = new ProductPlantField<String>("MRPType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPResponsible" )
    @JsonProperty( "MRPResponsible" )
    @Nullable
    @ODataField( odataName = "MRPResponsible" )
    private String mRPResponsible;
    /**
     * Use with available fluent helpers to apply the <b>MRPResponsible</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> MRP_RESPONSIBLE = new ProductPlantField<String>("MRPResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> ABC_INDICATOR = new ProductPlantField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductPlantField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductPlantField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @return Fixed lot size
     */
    @SerializedName( "FixedLotSizeQuantity" )
    @JsonProperty( "FixedLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "FixedLotSizeQuantity" )
    private BigDecimal fixedLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> FIXED_LOT_SIZE_QUANTITY =
        new ProductPlantField<BigDecimal>("FixedLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @return Control code for consumption taxes in foreign trade
     */
    @SerializedName( "ConsumptionTaxCtrlCode" )
    @JsonProperty( "ConsumptionTaxCtrlCode" )
    @Nullable
    @ODataField( odataName = "ConsumptionTaxCtrlCode" )
    private String consumptionTaxCtrlCode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionTaxCtrlCode</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> CONSUMPTION_TAX_CTRL_CODE =
        new ProductPlantField<String>("ConsumptionTaxCtrlCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCoProduct</b>
     * </p>
     *
     * @return Co-Product
     */
    @SerializedName( "IsCoProduct" )
    @JsonProperty( "IsCoProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCoProduct" )
    private Boolean isCoProduct;
    /**
     * Use with available fluent helpers to apply the <b>IsCoProduct</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> IS_CO_PRODUCT = new ProductPlantField<Boolean>("IsCoProduct");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsConfigurable</b>
     * </p>
     *
     * @return Configurable Product
     */
    @SerializedName( "ProductIsConfigurable" )
    @JsonProperty( "ProductIsConfigurable" )
    @Nullable
    @ODataField( odataName = "ProductIsConfigurable" )
    private String productIsConfigurable;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsConfigurable</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PRODUCT_IS_CONFIGURABLE =
        new ProductPlantField<String>("ProductIsConfigurable");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StockDeterminationGroup</b>
     * </p>
     *
     * @return Stock determination group
     */
    @SerializedName( "StockDeterminationGroup" )
    @JsonProperty( "StockDeterminationGroup" )
    @Nullable
    @ODataField( odataName = "StockDeterminationGroup" )
    private String stockDeterminationGroup;
    /**
     * Use with available fluent helpers to apply the <b>StockDeterminationGroup</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> STOCK_DETERMINATION_GROUP =
        new ProductPlantField<String>("StockDeterminationGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockInTransferQuantity</b>
     * </p>
     *
     * @return The stockInTransferQuantity contained in this entity.
     */
    @SerializedName( "StockInTransferQuantity" )
    @JsonProperty( "StockInTransferQuantity" )
    @Nullable
    @ODataField( odataName = "StockInTransferQuantity" )
    private BigDecimal stockInTransferQuantity;
    /**
     * Use with available fluent helpers to apply the <b>StockInTransferQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> STOCK_IN_TRANSFER_QUANTITY =
        new ProductPlantField<BigDecimal>("StockInTransferQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockInTransitQuantity</b>
     * </p>
     *
     * @return The stockInTransitQuantity contained in this entity.
     */
    @SerializedName( "StockInTransitQuantity" )
    @JsonProperty( "StockInTransitQuantity" )
    @Nullable
    @ODataField( odataName = "StockInTransitQuantity" )
    private BigDecimal stockInTransitQuantity;
    /**
     * Use with available fluent helpers to apply the <b>StockInTransitQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> STOCK_IN_TRANSIT_QUANTITY =
        new ProductPlantField<BigDecimal>("StockInTransitQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPostToInspectionStock</b>
     * </p>
     *
     * @return Has Post to Inspection Stock
     */
    @SerializedName( "HasPostToInspectionStock" )
    @JsonProperty( "HasPostToInspectionStock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HasPostToInspectionStock" )
    private Boolean hasPostToInspectionStock;
    /**
     * Use with available fluent helpers to apply the <b>HasPostToInspectionStock</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> HAS_POST_TO_INSPECTION_STOCK =
        new ProductPlantField<Boolean>("HasPostToInspectionStock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBatchManagementRequired</b>
     * </p>
     *
     * @return Batch Management Requirement Indicator for Plant
     */
    @SerializedName( "IsBatchManagementRequired" )
    @JsonProperty( "IsBatchManagementRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBatchManagementRequired" )
    private Boolean isBatchManagementRequired;
    /**
     * Use with available fluent helpers to apply the <b>IsBatchManagementRequired</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> IS_BATCH_MANAGEMENT_REQUIRED =
        new ProductPlantField<Boolean>("IsBatchManagementRequired");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @return Serial Number Profile
     */
    @SerializedName( "SerialNumberProfile" )
    @JsonProperty( "SerialNumberProfile" )
    @Nullable
    @ODataField( odataName = "SerialNumberProfile" )
    private String serialNumberProfile;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberProfile</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> SERIAL_NUMBER_PROFILE =
        new ProductPlantField<String>("SerialNumberProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNegativeStockAllowed</b>
     * </p>
     *
     * @return Negative stocks allowed in plant
     */
    @SerializedName( "IsNegativeStockAllowed" )
    @JsonProperty( "IsNegativeStockAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNegativeStockAllowed" )
    private Boolean isNegativeStockAllowed;
    /**
     * Use with available fluent helpers to apply the <b>IsNegativeStockAllowed</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> IS_NEGATIVE_STOCK_ALLOWED =
        new ProductPlantField<Boolean>("IsNegativeStockAllowed");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptBlockedStockQty</b>
     * </p>
     *
     * @return The goodsReceiptBlockedStockQty contained in this entity.
     */
    @SerializedName( "GoodsReceiptBlockedStockQty" )
    @JsonProperty( "GoodsReceiptBlockedStockQty" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptBlockedStockQty" )
    private BigDecimal goodsReceiptBlockedStockQty;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptBlockedStockQty</b> field to query operations.
     *
     */
    public final static ProductPlantField<BigDecimal> GOODS_RECEIPT_BLOCKED_STOCK_QTY =
        new ProductPlantField<BigDecimal>("GoodsReceiptBlockedStockQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasConsignmentCtrl</b>
     * </p>
     *
     * @return Consignment Control
     */
    @SerializedName( "HasConsignmentCtrl" )
    @JsonProperty( "HasConsignmentCtrl" )
    @Nullable
    @ODataField( odataName = "HasConsignmentCtrl" )
    private String hasConsignmentCtrl;
    /**
     * Use with available fluent helpers to apply the <b>HasConsignmentCtrl</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> HAS_CONSIGNMENT_CTRL =
        new ProductPlantField<String>("HasConsignmentCtrl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentPeriod</b>
     * </p>
     *
     * @return The fiscalYearCurrentPeriod contained in this entity.
     */
    @SerializedName( "FiscalYearCurrentPeriod" )
    @JsonProperty( "FiscalYearCurrentPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearCurrentPeriod" )
    private String fiscalYearCurrentPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearCurrentPeriod</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> FISCAL_YEAR_CURRENT_PERIOD =
        new ProductPlantField<String>("FiscalYearCurrentPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalMonthCurrentPeriod</b>
     * </p>
     *
     * @return The fiscalMonthCurrentPeriod contained in this entity.
     */
    @SerializedName( "FiscalMonthCurrentPeriod" )
    @JsonProperty( "FiscalMonthCurrentPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalMonthCurrentPeriod" )
    private String fiscalMonthCurrentPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalMonthCurrentPeriod</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> FISCAL_MONTH_CURRENT_PERIOD =
        new ProductPlantField<String>("FiscalMonthCurrentPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "ProcurementType" )
    @JsonProperty( "ProcurementType" )
    @Nullable
    @ODataField( odataName = "ProcurementType" )
    private String procurementType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementType</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PROCUREMENT_TYPE = new ProductPlantField<String>("ProcurementType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInternalBatchManaged</b>
     * </p>
     *
     * @return Batch management indicator (internal)
     */
    @SerializedName( "IsInternalBatchManaged" )
    @JsonProperty( "IsInternalBatchManaged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsInternalBatchManaged" )
    private Boolean isInternalBatchManaged;
    /**
     * Use with available fluent helpers to apply the <b>IsInternalBatchManaged</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> IS_INTERNAL_BATCH_MANAGED =
        new ProductPlantField<Boolean>("IsInternalBatchManaged");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductCFOPCategory</b>
     * </p>
     *
     * @return Material CFOP category
     */
    @SerializedName( "ProductCFOPCategory" )
    @JsonProperty( "ProductCFOPCategory" )
    @Nullable
    @ODataField( odataName = "ProductCFOPCategory" )
    private String productCFOPCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProductCFOPCategory</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PRODUCT_CFOP_CATEGORY =
        new ProductPlantField<String>("ProductCFOPCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsExciseTaxRelevant</b>
     * </p>
     *
     * @return Excise Tax Relevance Indicator
     */
    @SerializedName( "ProductIsExciseTaxRelevant" )
    @JsonProperty( "ProductIsExciseTaxRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductIsExciseTaxRelevant" )
    private Boolean productIsExciseTaxRelevant;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsExciseTaxRelevant</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> PRODUCT_IS_EXCISE_TAX_RELEVANT =
        new ProductPlantField<Boolean>("ProductIsExciseTaxRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> BASE_UNIT = new ProductPlantField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProduct</b>
     * </p>
     *
     * @return Configurable Material
     */
    @SerializedName( "ConfigurableProduct" )
    @JsonProperty( "ConfigurableProduct" )
    @Nullable
    @ODataField( odataName = "ConfigurableProduct" )
    private String configurableProduct;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurableProduct</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> CONFIGURABLE_PRODUCT =
        new ProductPlantField<String>("ConfigurableProduct");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueUnit</b>
     * </p>
     *
     * @return Ouput Unit of Measure
     */
    @SerializedName( "GoodsIssueUnit" )
    @JsonProperty( "GoodsIssueUnit" )
    @Nullable
    @ODataField( odataName = "GoodsIssueUnit" )
    private String goodsIssueUnit;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueUnit</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> GOODS_ISSUE_UNIT = new ProductPlantField<String>("GoodsIssueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaterialFreightGroup</b>
     * </p>
     *
     * @return Material Freight Group
     */
    @SerializedName( "MaterialFreightGroup" )
    @JsonProperty( "MaterialFreightGroup" )
    @Nullable
    @ODataField( odataName = "MaterialFreightGroup" )
    private String materialFreightGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialFreightGroup</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> MATERIAL_FREIGHT_GROUP =
        new ProductPlantField<String>("MaterialFreightGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginalBatchReferenceMaterial</b>
     * </p>
     *
     * @return Reference Material for Original Batches
     */
    @SerializedName( "OriginalBatchReferenceMaterial" )
    @JsonProperty( "OriginalBatchReferenceMaterial" )
    @Nullable
    @ODataField( odataName = "OriginalBatchReferenceMaterial" )
    private String originalBatchReferenceMaterial;
    /**
     * Use with available fluent helpers to apply the <b>OriginalBatchReferenceMaterial</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> ORIGINAL_BATCH_REFERENCE_MATERIAL =
        new ProductPlantField<String>("OriginalBatchReferenceMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriglBatchManagementIsRequired</b>
     * </p>
     *
     * @return Indicator for Original Batch Management
     */
    @SerializedName( "OriglBatchManagementIsRequired" )
    @JsonProperty( "OriglBatchManagementIsRequired" )
    @Nullable
    @ODataField( odataName = "OriglBatchManagementIsRequired" )
    private String origlBatchManagementIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>OriglBatchManagementIsRequired</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> ORIGL_BATCH_MANAGEMENT_IS_REQUIRED =
        new ProductPlantField<String>("OriglBatchManagementIsRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsCriticalPrt</b>
     * </p>
     *
     * @return Indicator: Critical part
     */
    @SerializedName( "ProductIsCriticalPrt" )
    @JsonProperty( "ProductIsCriticalPrt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductIsCriticalPrt" )
    private Boolean productIsCriticalPrt;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsCriticalPrt</b> field to query operations.
     *
     */
    public final static ProductPlantField<Boolean> PRODUCT_IS_CRITICAL_PRT =
        new ProductPlantField<Boolean>("ProductIsCriticalPrt");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductLogisticsHandlingGroup</b>
     * </p>
     *
     * @return Logistics handling group for workload calculation
     */
    @SerializedName( "ProductLogisticsHandlingGroup" )
    @JsonProperty( "ProductLogisticsHandlingGroup" )
    @Nullable
    @ODataField( odataName = "ProductLogisticsHandlingGroup" )
    private String productLogisticsHandlingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductLogisticsHandlingGroup</b> field to query operations.
     *
     */
    public final static ProductPlantField<String> PRODUCT_LOGISTICS_HANDLING_GROUP =
        new ProductPlantField<String>("ProductLogisticsHandlingGroup");
    /**
     * Navigation property <b>to_StorageLocation</b> for <b>ProductPlant</b> to multiple <b>ProductStorageLocation</b>.
     *
     */
    @SerializedName( "to_StorageLocation" )
    @JsonProperty( "to_StorageLocation" )
    @ODataField( odataName = "to_StorageLocation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductStorageLocation> toStorageLocation;
    /**
     * Use with available fluent helpers to apply the <b>to_StorageLocation</b> navigation property to query operations.
     *
     */
    public final static ProductPlantLink<ProductStorageLocation> TO_STORAGE_LOCATION =
        new ProductPlantLink<ProductStorageLocation>("to_StorageLocation");

    @Nonnull
    @Override
    public Class<ProductPlant> getType()
    {
        return ProductPlant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @param regionOfOrigin
     *            Region of Origin of Material (Non-Preferential Origin)
     */
    public void setRegionOfOrigin( @Nullable final String regionOfOrigin )
    {
        rememberChangedField("RegionOfOrigin", this.regionOfOrigin);
        this.regionOfOrigin = regionOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @param productionInvtryManagedLoc
     *            Issue Storage Location
     */
    public void setProductionInvtryManagedLoc( @Nullable final String productionInvtryManagedLoc )
    {
        rememberChangedField("ProductionInvtryManagedLoc", this.productionInvtryManagedLoc);
        this.productionInvtryManagedLoc = productionInvtryManagedLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfileCode</b>
     * </p>
     *
     * @param profileCode
     *            Plant-Specific Material Status
     */
    public void setProfileCode( @Nullable final String profileCode )
    {
        rememberChangedField("ProfileCode", this.profileCode);
        this.profileCode = profileCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProfileValidityStartDate</b>
     * </p>
     *
     * @param profileValidityStartDate
     *            Date from Which the Plant-Specific Material Status Is Valid
     */
    public void setProfileValidityStartDate( @Nullable final LocalDateTime profileValidityStartDate )
    {
        rememberChangedField("ProfileValidityStartDate", this.profileValidityStartDate);
        this.profileValidityStartDate = profileValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @param availabilityCheckType
     *            Checking Group for Availability Check
     */
    public void setAvailabilityCheckType( @Nullable final String availabilityCheckType )
    {
        rememberChangedField("AvailabilityCheckType", this.availabilityCheckType);
        this.availabilityCheckType = availabilityCheckType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @param periodType
     *            Period Indicator
     */
    public void setPeriodType( @Nullable final String periodType )
    {
        rememberChangedField("PeriodType", this.periodType);
        this.periodType = periodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>Commodity</b>
     * </p>
     *
     * @param commodity
     *            Commodity Code
     */
    public void setCommodity( @Nullable final String commodity )
    {
        rememberChangedField("Commodity", this.commodity);
        this.commodity = commodity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStatusName</b>
     * </p>
     *
     * @param maintenanceStatusName
     *            Maintenance status
     */
    public void setMaintenanceStatusName( @Nullable final String maintenanceStatusName )
    {
        rememberChangedField("MaintenanceStatusName", this.maintenanceStatusName);
        this.maintenanceStatusName = maintenanceStatusName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Flag Material for Deletion at Plant Level
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @param mRPType
     *            MRP Type
     */
    public void setMRPType( @Nullable final String mRPType )
    {
        rememberChangedField("MRPType", this.mRPType);
        this.mRPType = mRPType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @param mRPResponsible
     *            MRP Controller
     */
    public void setMRPResponsible( @Nullable final String mRPResponsible )
    {
        rememberChangedField("MRPResponsible", this.mRPResponsible);
        this.mRPResponsible = mRPResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @param fixedLotSizeQuantity
     *            Fixed lot size
     */
    public void setFixedLotSizeQuantity( @Nullable final BigDecimal fixedLotSizeQuantity )
    {
        rememberChangedField("FixedLotSizeQuantity", this.fixedLotSizeQuantity);
        this.fixedLotSizeQuantity = fixedLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @param consumptionTaxCtrlCode
     *            Control code for consumption taxes in foreign trade
     */
    public void setConsumptionTaxCtrlCode( @Nullable final String consumptionTaxCtrlCode )
    {
        rememberChangedField("ConsumptionTaxCtrlCode", this.consumptionTaxCtrlCode);
        this.consumptionTaxCtrlCode = consumptionTaxCtrlCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCoProduct</b>
     * </p>
     *
     * @param isCoProduct
     *            Co-Product
     */
    public void setIsCoProduct( @Nullable final Boolean isCoProduct )
    {
        rememberChangedField("IsCoProduct", this.isCoProduct);
        this.isCoProduct = isCoProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsConfigurable</b>
     * </p>
     *
     * @param productIsConfigurable
     *            Configurable Product
     */
    public void setProductIsConfigurable( @Nullable final String productIsConfigurable )
    {
        rememberChangedField("ProductIsConfigurable", this.productIsConfigurable);
        this.productIsConfigurable = productIsConfigurable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StockDeterminationGroup</b>
     * </p>
     *
     * @param stockDeterminationGroup
     *            Stock determination group
     */
    public void setStockDeterminationGroup( @Nullable final String stockDeterminationGroup )
    {
        rememberChangedField("StockDeterminationGroup", this.stockDeterminationGroup);
        this.stockDeterminationGroup = stockDeterminationGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockInTransferQuantity</b>
     * </p>
     *
     * @param stockInTransferQuantity
     *            The stockInTransferQuantity to set.
     */
    public void setStockInTransferQuantity( @Nullable final BigDecimal stockInTransferQuantity )
    {
        rememberChangedField("StockInTransferQuantity", this.stockInTransferQuantity);
        this.stockInTransferQuantity = stockInTransferQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockInTransitQuantity</b>
     * </p>
     *
     * @param stockInTransitQuantity
     *            The stockInTransitQuantity to set.
     */
    public void setStockInTransitQuantity( @Nullable final BigDecimal stockInTransitQuantity )
    {
        rememberChangedField("StockInTransitQuantity", this.stockInTransitQuantity);
        this.stockInTransitQuantity = stockInTransitQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPostToInspectionStock</b>
     * </p>
     *
     * @param hasPostToInspectionStock
     *            Has Post to Inspection Stock
     */
    public void setHasPostToInspectionStock( @Nullable final Boolean hasPostToInspectionStock )
    {
        rememberChangedField("HasPostToInspectionStock", this.hasPostToInspectionStock);
        this.hasPostToInspectionStock = hasPostToInspectionStock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBatchManagementRequired</b>
     * </p>
     *
     * @param isBatchManagementRequired
     *            Batch Management Requirement Indicator for Plant
     */
    public void setIsBatchManagementRequired( @Nullable final Boolean isBatchManagementRequired )
    {
        rememberChangedField("IsBatchManagementRequired", this.isBatchManagementRequired);
        this.isBatchManagementRequired = isBatchManagementRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @param serialNumberProfile
     *            Serial Number Profile
     */
    public void setSerialNumberProfile( @Nullable final String serialNumberProfile )
    {
        rememberChangedField("SerialNumberProfile", this.serialNumberProfile);
        this.serialNumberProfile = serialNumberProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNegativeStockAllowed</b>
     * </p>
     *
     * @param isNegativeStockAllowed
     *            Negative stocks allowed in plant
     */
    public void setIsNegativeStockAllowed( @Nullable final Boolean isNegativeStockAllowed )
    {
        rememberChangedField("IsNegativeStockAllowed", this.isNegativeStockAllowed);
        this.isNegativeStockAllowed = isNegativeStockAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptBlockedStockQty</b>
     * </p>
     *
     * @param goodsReceiptBlockedStockQty
     *            The goodsReceiptBlockedStockQty to set.
     */
    public void setGoodsReceiptBlockedStockQty( @Nullable final BigDecimal goodsReceiptBlockedStockQty )
    {
        rememberChangedField("GoodsReceiptBlockedStockQty", this.goodsReceiptBlockedStockQty);
        this.goodsReceiptBlockedStockQty = goodsReceiptBlockedStockQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HasConsignmentCtrl</b>
     * </p>
     *
     * @param hasConsignmentCtrl
     *            Consignment Control
     */
    public void setHasConsignmentCtrl( @Nullable final String hasConsignmentCtrl )
    {
        rememberChangedField("HasConsignmentCtrl", this.hasConsignmentCtrl);
        this.hasConsignmentCtrl = hasConsignmentCtrl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentPeriod</b>
     * </p>
     *
     * @param fiscalYearCurrentPeriod
     *            The fiscalYearCurrentPeriod to set.
     */
    public void setFiscalYearCurrentPeriod( @Nullable final String fiscalYearCurrentPeriod )
    {
        rememberChangedField("FiscalYearCurrentPeriod", this.fiscalYearCurrentPeriod);
        this.fiscalYearCurrentPeriod = fiscalYearCurrentPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalMonthCurrentPeriod</b>
     * </p>
     *
     * @param fiscalMonthCurrentPeriod
     *            The fiscalMonthCurrentPeriod to set.
     */
    public void setFiscalMonthCurrentPeriod( @Nullable final String fiscalMonthCurrentPeriod )
    {
        rememberChangedField("FiscalMonthCurrentPeriod", this.fiscalMonthCurrentPeriod);
        this.fiscalMonthCurrentPeriod = fiscalMonthCurrentPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @param procurementType
     *            Procurement Type
     */
    public void setProcurementType( @Nullable final String procurementType )
    {
        rememberChangedField("ProcurementType", this.procurementType);
        this.procurementType = procurementType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInternalBatchManaged</b>
     * </p>
     *
     * @param isInternalBatchManaged
     *            Batch management indicator (internal)
     */
    public void setIsInternalBatchManaged( @Nullable final Boolean isInternalBatchManaged )
    {
        rememberChangedField("IsInternalBatchManaged", this.isInternalBatchManaged);
        this.isInternalBatchManaged = isInternalBatchManaged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductCFOPCategory</b>
     * </p>
     *
     * @param productCFOPCategory
     *            Material CFOP category
     */
    public void setProductCFOPCategory( @Nullable final String productCFOPCategory )
    {
        rememberChangedField("ProductCFOPCategory", this.productCFOPCategory);
        this.productCFOPCategory = productCFOPCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsExciseTaxRelevant</b>
     * </p>
     *
     * @param productIsExciseTaxRelevant
     *            Excise Tax Relevance Indicator
     */
    public void setProductIsExciseTaxRelevant( @Nullable final Boolean productIsExciseTaxRelevant )
    {
        rememberChangedField("ProductIsExciseTaxRelevant", this.productIsExciseTaxRelevant);
        this.productIsExciseTaxRelevant = productIsExciseTaxRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurableProduct</b>
     * </p>
     *
     * @param configurableProduct
     *            Configurable Material
     */
    public void setConfigurableProduct( @Nullable final String configurableProduct )
    {
        rememberChangedField("ConfigurableProduct", this.configurableProduct);
        this.configurableProduct = configurableProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueUnit</b>
     * </p>
     *
     * @param goodsIssueUnit
     *            Ouput Unit of Measure
     */
    public void setGoodsIssueUnit( @Nullable final String goodsIssueUnit )
    {
        rememberChangedField("GoodsIssueUnit", this.goodsIssueUnit);
        this.goodsIssueUnit = goodsIssueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaterialFreightGroup</b>
     * </p>
     *
     * @param materialFreightGroup
     *            Material Freight Group
     */
    public void setMaterialFreightGroup( @Nullable final String materialFreightGroup )
    {
        rememberChangedField("MaterialFreightGroup", this.materialFreightGroup);
        this.materialFreightGroup = materialFreightGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginalBatchReferenceMaterial</b>
     * </p>
     *
     * @param originalBatchReferenceMaterial
     *            Reference Material for Original Batches
     */
    public void setOriginalBatchReferenceMaterial( @Nullable final String originalBatchReferenceMaterial )
    {
        rememberChangedField("OriginalBatchReferenceMaterial", this.originalBatchReferenceMaterial);
        this.originalBatchReferenceMaterial = originalBatchReferenceMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriglBatchManagementIsRequired</b>
     * </p>
     *
     * @param origlBatchManagementIsRequired
     *            Indicator for Original Batch Management
     */
    public void setOriglBatchManagementIsRequired( @Nullable final String origlBatchManagementIsRequired )
    {
        rememberChangedField("OriglBatchManagementIsRequired", this.origlBatchManagementIsRequired);
        this.origlBatchManagementIsRequired = origlBatchManagementIsRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsCriticalPrt</b>
     * </p>
     *
     * @param productIsCriticalPrt
     *            Indicator: Critical part
     */
    public void setProductIsCriticalPrt( @Nullable final Boolean productIsCriticalPrt )
    {
        rememberChangedField("ProductIsCriticalPrt", this.productIsCriticalPrt);
        this.productIsCriticalPrt = productIsCriticalPrt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductLogisticsHandlingGroup</b>
     * </p>
     *
     * @param productLogisticsHandlingGroup
     *            Logistics handling group for workload calculation
     */
    public void setProductLogisticsHandlingGroup( @Nullable final String productLogisticsHandlingGroup )
    {
        rememberChangedField("ProductLogisticsHandlingGroup", this.productLogisticsHandlingGroup);
        this.productLogisticsHandlingGroup = productLogisticsHandlingGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("RegionOfOrigin", getRegionOfOrigin());
        values.put("ProductionInvtryManagedLoc", getProductionInvtryManagedLoc());
        values.put("ProfileCode", getProfileCode());
        values.put("ProfileValidityStartDate", getProfileValidityStartDate());
        values.put("AvailabilityCheckType", getAvailabilityCheckType());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("PeriodType", getPeriodType());
        values.put("ProfitCenter", getProfitCenter());
        values.put("Commodity", getCommodity());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("MaintenanceStatusName", getMaintenanceStatusName());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("MRPType", getMRPType());
        values.put("MRPResponsible", getMRPResponsible());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("FixedLotSizeQuantity", getFixedLotSizeQuantity());
        values.put("ConsumptionTaxCtrlCode", getConsumptionTaxCtrlCode());
        values.put("IsCoProduct", getIsCoProduct());
        values.put("ProductIsConfigurable", getProductIsConfigurable());
        values.put("StockDeterminationGroup", getStockDeterminationGroup());
        values.put("StockInTransferQuantity", getStockInTransferQuantity());
        values.put("StockInTransitQuantity", getStockInTransitQuantity());
        values.put("HasPostToInspectionStock", getHasPostToInspectionStock());
        values.put("IsBatchManagementRequired", getIsBatchManagementRequired());
        values.put("SerialNumberProfile", getSerialNumberProfile());
        values.put("IsNegativeStockAllowed", getIsNegativeStockAllowed());
        values.put("GoodsReceiptBlockedStockQty", getGoodsReceiptBlockedStockQty());
        values.put("HasConsignmentCtrl", getHasConsignmentCtrl());
        values.put("FiscalYearCurrentPeriod", getFiscalYearCurrentPeriod());
        values.put("FiscalMonthCurrentPeriod", getFiscalMonthCurrentPeriod());
        values.put("ProcurementType", getProcurementType());
        values.put("IsInternalBatchManaged", getIsInternalBatchManaged());
        values.put("ProductCFOPCategory", getProductCFOPCategory());
        values.put("ProductIsExciseTaxRelevant", getProductIsExciseTaxRelevant());
        values.put("BaseUnit", getBaseUnit());
        values.put("ConfigurableProduct", getConfigurableProduct());
        values.put("GoodsIssueUnit", getGoodsIssueUnit());
        values.put("MaterialFreightGroup", getMaterialFreightGroup());
        values.put("OriginalBatchReferenceMaterial", getOriginalBatchReferenceMaterial());
        values.put("OriglBatchManagementIsRequired", getOriglBatchManagementIsRequired());
        values.put("ProductIsCriticalPrt", getProductIsCriticalPrt());
        values.put("ProductLogisticsHandlingGroup", getProductLogisticsHandlingGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("RegionOfOrigin") ) {
                final Object value = values.remove("RegionOfOrigin");
                if( (value == null) || (!value.equals(getRegionOfOrigin())) ) {
                    setRegionOfOrigin(((String) value));
                }
            }
            if( values.containsKey("ProductionInvtryManagedLoc") ) {
                final Object value = values.remove("ProductionInvtryManagedLoc");
                if( (value == null) || (!value.equals(getProductionInvtryManagedLoc())) ) {
                    setProductionInvtryManagedLoc(((String) value));
                }
            }
            if( values.containsKey("ProfileCode") ) {
                final Object value = values.remove("ProfileCode");
                if( (value == null) || (!value.equals(getProfileCode())) ) {
                    setProfileCode(((String) value));
                }
            }
            if( values.containsKey("ProfileValidityStartDate") ) {
                final Object value = values.remove("ProfileValidityStartDate");
                if( (value == null) || (!value.equals(getProfileValidityStartDate())) ) {
                    setProfileValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AvailabilityCheckType") ) {
                final Object value = values.remove("AvailabilityCheckType");
                if( (value == null) || (!value.equals(getAvailabilityCheckType())) ) {
                    setAvailabilityCheckType(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("PeriodType") ) {
                final Object value = values.remove("PeriodType");
                if( (value == null) || (!value.equals(getPeriodType())) ) {
                    setPeriodType(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("Commodity") ) {
                final Object value = values.remove("Commodity");
                if( (value == null) || (!value.equals(getCommodity())) ) {
                    setCommodity(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintenanceStatusName") ) {
                final Object value = values.remove("MaintenanceStatusName");
                if( (value == null) || (!value.equals(getMaintenanceStatusName())) ) {
                    setMaintenanceStatusName(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("MRPType") ) {
                final Object value = values.remove("MRPType");
                if( (value == null) || (!value.equals(getMRPType())) ) {
                    setMRPType(((String) value));
                }
            }
            if( values.containsKey("MRPResponsible") ) {
                final Object value = values.remove("MRPResponsible");
                if( (value == null) || (!value.equals(getMRPResponsible())) ) {
                    setMRPResponsible(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedLotSizeQuantity") ) {
                final Object value = values.remove("FixedLotSizeQuantity");
                if( (value == null) || (!value.equals(getFixedLotSizeQuantity())) ) {
                    setFixedLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConsumptionTaxCtrlCode") ) {
                final Object value = values.remove("ConsumptionTaxCtrlCode");
                if( (value == null) || (!value.equals(getConsumptionTaxCtrlCode())) ) {
                    setConsumptionTaxCtrlCode(((String) value));
                }
            }
            if( values.containsKey("IsCoProduct") ) {
                final Object value = values.remove("IsCoProduct");
                if( (value == null) || (!value.equals(getIsCoProduct())) ) {
                    setIsCoProduct(((Boolean) value));
                }
            }
            if( values.containsKey("ProductIsConfigurable") ) {
                final Object value = values.remove("ProductIsConfigurable");
                if( (value == null) || (!value.equals(getProductIsConfigurable())) ) {
                    setProductIsConfigurable(((String) value));
                }
            }
            if( values.containsKey("StockDeterminationGroup") ) {
                final Object value = values.remove("StockDeterminationGroup");
                if( (value == null) || (!value.equals(getStockDeterminationGroup())) ) {
                    setStockDeterminationGroup(((String) value));
                }
            }
            if( values.containsKey("StockInTransferQuantity") ) {
                final Object value = values.remove("StockInTransferQuantity");
                if( (value == null) || (!value.equals(getStockInTransferQuantity())) ) {
                    setStockInTransferQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("StockInTransitQuantity") ) {
                final Object value = values.remove("StockInTransitQuantity");
                if( (value == null) || (!value.equals(getStockInTransitQuantity())) ) {
                    setStockInTransitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HasPostToInspectionStock") ) {
                final Object value = values.remove("HasPostToInspectionStock");
                if( (value == null) || (!value.equals(getHasPostToInspectionStock())) ) {
                    setHasPostToInspectionStock(((Boolean) value));
                }
            }
            if( values.containsKey("IsBatchManagementRequired") ) {
                final Object value = values.remove("IsBatchManagementRequired");
                if( (value == null) || (!value.equals(getIsBatchManagementRequired())) ) {
                    setIsBatchManagementRequired(((Boolean) value));
                }
            }
            if( values.containsKey("SerialNumberProfile") ) {
                final Object value = values.remove("SerialNumberProfile");
                if( (value == null) || (!value.equals(getSerialNumberProfile())) ) {
                    setSerialNumberProfile(((String) value));
                }
            }
            if( values.containsKey("IsNegativeStockAllowed") ) {
                final Object value = values.remove("IsNegativeStockAllowed");
                if( (value == null) || (!value.equals(getIsNegativeStockAllowed())) ) {
                    setIsNegativeStockAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptBlockedStockQty") ) {
                final Object value = values.remove("GoodsReceiptBlockedStockQty");
                if( (value == null) || (!value.equals(getGoodsReceiptBlockedStockQty())) ) {
                    setGoodsReceiptBlockedStockQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("HasConsignmentCtrl") ) {
                final Object value = values.remove("HasConsignmentCtrl");
                if( (value == null) || (!value.equals(getHasConsignmentCtrl())) ) {
                    setHasConsignmentCtrl(((String) value));
                }
            }
            if( values.containsKey("FiscalYearCurrentPeriod") ) {
                final Object value = values.remove("FiscalYearCurrentPeriod");
                if( (value == null) || (!value.equals(getFiscalYearCurrentPeriod())) ) {
                    setFiscalYearCurrentPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalMonthCurrentPeriod") ) {
                final Object value = values.remove("FiscalMonthCurrentPeriod");
                if( (value == null) || (!value.equals(getFiscalMonthCurrentPeriod())) ) {
                    setFiscalMonthCurrentPeriod(((String) value));
                }
            }
            if( values.containsKey("ProcurementType") ) {
                final Object value = values.remove("ProcurementType");
                if( (value == null) || (!value.equals(getProcurementType())) ) {
                    setProcurementType(((String) value));
                }
            }
            if( values.containsKey("IsInternalBatchManaged") ) {
                final Object value = values.remove("IsInternalBatchManaged");
                if( (value == null) || (!value.equals(getIsInternalBatchManaged())) ) {
                    setIsInternalBatchManaged(((Boolean) value));
                }
            }
            if( values.containsKey("ProductCFOPCategory") ) {
                final Object value = values.remove("ProductCFOPCategory");
                if( (value == null) || (!value.equals(getProductCFOPCategory())) ) {
                    setProductCFOPCategory(((String) value));
                }
            }
            if( values.containsKey("ProductIsExciseTaxRelevant") ) {
                final Object value = values.remove("ProductIsExciseTaxRelevant");
                if( (value == null) || (!value.equals(getProductIsExciseTaxRelevant())) ) {
                    setProductIsExciseTaxRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ConfigurableProduct") ) {
                final Object value = values.remove("ConfigurableProduct");
                if( (value == null) || (!value.equals(getConfigurableProduct())) ) {
                    setConfigurableProduct(((String) value));
                }
            }
            if( values.containsKey("GoodsIssueUnit") ) {
                final Object value = values.remove("GoodsIssueUnit");
                if( (value == null) || (!value.equals(getGoodsIssueUnit())) ) {
                    setGoodsIssueUnit(((String) value));
                }
            }
            if( values.containsKey("MaterialFreightGroup") ) {
                final Object value = values.remove("MaterialFreightGroup");
                if( (value == null) || (!value.equals(getMaterialFreightGroup())) ) {
                    setMaterialFreightGroup(((String) value));
                }
            }
            if( values.containsKey("OriginalBatchReferenceMaterial") ) {
                final Object value = values.remove("OriginalBatchReferenceMaterial");
                if( (value == null) || (!value.equals(getOriginalBatchReferenceMaterial())) ) {
                    setOriginalBatchReferenceMaterial(((String) value));
                }
            }
            if( values.containsKey("OriglBatchManagementIsRequired") ) {
                final Object value = values.remove("OriglBatchManagementIsRequired");
                if( (value == null) || (!value.equals(getOriglBatchManagementIsRequired())) ) {
                    setOriglBatchManagementIsRequired(((String) value));
                }
            }
            if( values.containsKey("ProductIsCriticalPrt") ) {
                final Object value = values.remove("ProductIsCriticalPrt");
                if( (value == null) || (!value.equals(getProductIsCriticalPrt())) ) {
                    setProductIsCriticalPrt(((Boolean) value));
                }
            }
            if( values.containsKey("ProductLogisticsHandlingGroup") ) {
                final Object value = values.remove("ProductLogisticsHandlingGroup");
                if( (value == null) || (!value.equals(getProductLogisticsHandlingGroup())) ) {
                    setProductLogisticsHandlingGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_StorageLocation") ) {
                final Object value = (values).remove("to_StorageLocation");
                if( value instanceof Iterable ) {
                    if( toStorageLocation == null ) {
                        toStorageLocation = Lists.newArrayList();
                    } else {
                        toStorageLocation = Lists.newArrayList(toStorageLocation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductStorageLocation entity;
                        if( toStorageLocation.size() > i ) {
                            entity = toStorageLocation.get(i);
                        } else {
                            entity = new ProductStorageLocation();
                            toStorageLocation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductPlantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toStorageLocation != null ) {
            (values).put("to_StorageLocation", toStorageLocation);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductStorageLocation</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_StorageLocation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductStorageLocation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductStorageLocation> fetchStorageLocation()
    {
        return fetchFieldAsList("to_StorageLocation", ProductStorageLocation.class);
    }

    /**
     * Retrieval of associated <b>ProductStorageLocation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StorageLocation</b>.
     * <p>
     * If the navigation property <b>to_StorageLocation</b> of a queried <b>ProductPlant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductStorageLocation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductStorageLocation> getStorageLocationOrFetch()
    {
        if( toStorageLocation == null ) {
            toStorageLocation = fetchStorageLocation();
        }
        return toStorageLocation;
    }

    /**
     * Retrieval of associated <b>ProductStorageLocation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StorageLocation</b>.
     * <p>
     * If the navigation property for an entity <b>ProductPlant</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StorageLocation</b> is already loaded, the result will
     *         contain the <b>ProductStorageLocation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductStorageLocation>> getStorageLocationIfPresent()
    {
        return Option.of(toStorageLocation);
    }

    /**
     * Overwrites the list of associated <b>ProductStorageLocation</b> entities for the loaded navigation property
     * <b>to_StorageLocation</b>.
     * <p>
     * If the navigation property <b>to_StorageLocation</b> of a queried <b>ProductPlant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductStorageLocation</b> entities.
     */
    public void setStorageLocation( @Nonnull final List<ProductStorageLocation> value )
    {
        if( toStorageLocation == null ) {
            toStorageLocation = Lists.newArrayList();
        }
        toStorageLocation.clear();
        toStorageLocation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductStorageLocation</b> entities. This corresponds to the OData
     * navigation property <b>to_StorageLocation</b>.
     * <p>
     * If the navigation property <b>to_StorageLocation</b> of a queried <b>ProductPlant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductStorageLocation</b> entities.
     */
    public void addStorageLocation( ProductStorageLocation... entity )
    {
        if( toStorageLocation == null ) {
            toStorageLocation = Lists.newArrayList();
        }
        toStorageLocation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductPlant instances.
     *
     */
    public final static class ProductPlantBuilder
    {

        private List<ProductStorageLocation> toStorageLocation = Lists.newArrayList();

        private ProductPlant.ProductPlantBuilder toStorageLocation( final List<ProductStorageLocation> value )
        {
            toStorageLocation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StorageLocation</b> for <b>ProductPlant</b> to multiple
         * <b>ProductStorageLocation</b>.
         *
         * @param value
         *            The ProductStorageLocations to build this ProductPlant with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductPlant.ProductPlantBuilder storageLocation( ProductStorageLocation... value )
        {
            return toStorageLocation(Lists.newArrayList(value));
        }

    }

}
