/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery ProductSalesDelivery}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ProductSalesDeliveryCreateFluentHelper
    extends
    FluentHelperCreate<ProductSalesDeliveryCreateFluentHelper, ProductSalesDelivery>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     *
     */
    private final ProductSalesDelivery entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The ProductSalesDelivery to create.
     */
    public ProductSalesDeliveryCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ProductSalesDelivery entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ProductSalesDelivery getEntity()
    {
        return entity;
    }

}
