/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.RawSubstanceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.RawSubstanceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.RawSubstanceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Raw Substance
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RawSubstanceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RawSubstance extends VdmEntity<RawSubstance>
{

    /**
     * Selector for all available fields of RawSubstance.
     *
     */
    public final static RawSubstanceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "RawSubstanceInternalID" )
    @JsonProperty( "RawSubstanceInternalID" )
    @Nullable
    @ODataField( odataName = "RawSubstanceInternalID" )
    private String rawSubstanceInternalID;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceInternalID</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_INTERNAL_ID =
        new RawSubstanceField<String>("RawSubstanceInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstance</b>
     * </p>
     *
     * @return Specification
     */
    @SerializedName( "RawSubstance" )
    @JsonProperty( "RawSubstance" )
    @Nullable
    @ODataField( odataName = "RawSubstance" )
    private String rawSubstance;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstance</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE = new RawSubstanceField<String>("RawSubstance");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceAuthznGroup</b>
     * </p>
     *
     * @return Description of Authorization Group
     */
    @SerializedName( "RawSubstanceAuthznGroup" )
    @JsonProperty( "RawSubstanceAuthznGroup" )
    @Nullable
    @ODataField( odataName = "RawSubstanceAuthznGroup" )
    private String rawSubstanceAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceAuthznGroup</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_AUTHZN_GROUP =
        new RawSubstanceField<String>("RawSubstanceAuthznGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "RawSubstanceCreationDate" )
    @JsonProperty( "RawSubstanceCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RawSubstanceCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime rawSubstanceCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceCreationDate</b> field to query operations.
     *
     */
    public final static RawSubstanceField<LocalDateTime> RAW_SUBSTANCE_CREATION_DATE =
        new RawSubstanceField<LocalDateTime>("RawSubstanceCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "RawSubstanceCreatedByUser" )
    @JsonProperty( "RawSubstanceCreatedByUser" )
    @Nullable
    @ODataField( odataName = "RawSubstanceCreatedByUser" )
    private String rawSubstanceCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceCreatedByUser</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_CREATED_BY_USER =
        new RawSubstanceField<String>("RawSubstanceCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreatedByUserName</b>
     * </p>
     *
     * @return Specification Header Created By Name
     */
    @SerializedName( "RawSubstanceCreatedByUserName" )
    @JsonProperty( "RawSubstanceCreatedByUserName" )
    @Nullable
    @ODataField( odataName = "RawSubstanceCreatedByUserName" )
    private String rawSubstanceCreatedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceCreatedByUserName</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_CREATED_BY_USER_NAME =
        new RawSubstanceField<String>("RawSubstanceCreatedByUserName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangeDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "RawSubstanceChangeDate" )
    @JsonProperty( "RawSubstanceChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RawSubstanceChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime rawSubstanceChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceChangeDate</b> field to query operations.
     *
     */
    public final static RawSubstanceField<LocalDateTime> RAW_SUBSTANCE_CHANGE_DATE =
        new RawSubstanceField<LocalDateTime>("RawSubstanceChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "RawSubstanceChangedByUser" )
    @JsonProperty( "RawSubstanceChangedByUser" )
    @Nullable
    @ODataField( odataName = "RawSubstanceChangedByUser" )
    private String rawSubstanceChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceChangedByUser</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_CHANGED_BY_USER =
        new RawSubstanceField<String>("RawSubstanceChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangedByUserName</b>
     * </p>
     *
     * @return Specification Changed By Name
     */
    @SerializedName( "RawSubstanceChangedByUserName" )
    @JsonProperty( "RawSubstanceChangedByUserName" )
    @Nullable
    @ODataField( odataName = "RawSubstanceChangedByUserName" )
    private String rawSubstanceChangedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceChangedByUserName</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_CHANGED_BY_USER_NAME =
        new RawSubstanceField<String>("RawSubstanceChangedByUserName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "RawSubstanceType" )
    @JsonProperty( "RawSubstanceType" )
    @Nullable
    @ODataField( odataName = "RawSubstanceType" )
    private String rawSubstanceType;
    /**
     * Use with available fluent helpers to apply the <b>RawSubstanceType</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> RAW_SUBSTANCE_TYPE =
        new RawSubstanceField<String>("RawSubstanceType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationCategory</b>
     * </p>
     *
     * @return Specification Category
     */
    @SerializedName( "SpecificationCategory" )
    @JsonProperty( "SpecificationCategory" )
    @Nullable
    @ODataField( odataName = "SpecificationCategory" )
    private String specificationCategory;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationCategory</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> SPECIFICATION_CATEGORY =
        new RawSubstanceField<String>("SpecificationCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationNote</b>
     * </p>
     *
     * @return Note
     */
    @SerializedName( "SpecificationNote" )
    @JsonProperty( "SpecificationNote" )
    @Nullable
    @ODataField( odataName = "SpecificationNote" )
    private String specificationNote;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationNote</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> SPECIFICATION_NOTE =
        new RawSubstanceField<String>("SpecificationNote");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @return Status Identification
     */
    @SerializedName( "SpecificationHeaderStatus" )
    @JsonProperty( "SpecificationHeaderStatus" )
    @Nullable
    @ODataField( odataName = "SpecificationHeaderStatus" )
    private String specificationHeaderStatus;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHeaderStatus</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> SPECIFICATION_HEADER_STATUS =
        new RawSubstanceField<String>("SpecificationHeaderStatus");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @return Status Scheme
     */
    @SerializedName( "SpecificationHdrStsSchema" )
    @JsonProperty( "SpecificationHdrStsSchema" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchema" )
    private String specificationHdrStsSchema;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchema</b> field to query operations.
     *
     */
    public final static RawSubstanceField<String> SPECIFICATION_HDR_STS_SCHEMA =
        new RawSubstanceField<String>("SpecificationHdrStsSchema");
    /**
     * Navigation property <b>to_RawSubstanceAllergenComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceAllergenComp" )
    @JsonProperty( "to_RawSubstanceAllergenComp" )
    @ODataField( odataName = "to_RawSubstanceAllergenComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceAllergenComp;
    /**
     * Navigation property <b>to_RawSubstanceAuthznGroupText</b> for <b>RawSubstance</b> to multiple
     * <b>SpecAuthorizationGroupText</b>.
     *
     */
    @SerializedName( "to_RawSubstanceAuthznGroupText" )
    @JsonProperty( "to_RawSubstanceAuthznGroupText" )
    @ODataField( odataName = "to_RawSubstanceAuthznGroupText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecAuthorizationGroupText> toRawSubstanceAuthznGroupText;
    /**
     * Navigation property <b>to_RawSubstanceComponentType</b> for <b>RawSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RawSubstanceComponentType" )
    @JsonProperty( "to_RawSubstanceComponentType" )
    @ODataField( odataName = "to_RawSubstanceComponentType" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRawSubstanceComponentType;
    /**
     * Navigation property <b>to_RawSubstanceConversionFactor</b> for <b>RawSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RawSubstanceConversionFactor" )
    @JsonProperty( "to_RawSubstanceConversionFactor" )
    @ODataField( odataName = "to_RawSubstanceConversionFactor" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRawSubstanceConversionFactor;
    /**
     * Navigation property <b>to_RawSubstanceDensity</b> for <b>RawSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RawSubstanceDensity" )
    @JsonProperty( "to_RawSubstanceDensity" )
    @ODataField( odataName = "to_RawSubstanceDensity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRawSubstanceDensity;
    /**
     * Navigation property <b>to_RawSubstanceDietComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceDietComp" )
    @JsonProperty( "to_RawSubstanceDietComp" )
    @ODataField( odataName = "to_RawSubstanceDietComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceDietComp;
    /**
     * Navigation property <b>to_RawSubstanceEstimatedPrice</b> for <b>RawSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RawSubstanceEstimatedPrice" )
    @JsonProperty( "to_RawSubstanceEstimatedPrice" )
    @ODataField( odataName = "to_RawSubstanceEstimatedPrice" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRawSubstanceEstimatedPrice;
    /**
     * Navigation property <b>to_RawSubstanceGMOComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceGMOComp" )
    @JsonProperty( "to_RawSubstanceGMOComp" )
    @ODataField( odataName = "to_RawSubstanceGMOComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceGMOComp;
    /**
     * Navigation property <b>to_RawSubstanceIdentifier</b> for <b>RawSubstance</b> to multiple <b>SpecIdentifier</b>.
     *
     */
    @SerializedName( "to_RawSubstanceIdentifier" )
    @JsonProperty( "to_RawSubstanceIdentifier" )
    @ODataField( odataName = "to_RawSubstanceIdentifier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecIdentifier> toRawSubstanceIdentifier;
    /**
     * Navigation property <b>to_RawSubstanceMatlAssignment</b> for <b>RawSubstance</b> to multiple
     * <b>SpecAssignedMatlForKeyDate</b>.
     *
     */
    @SerializedName( "to_RawSubstanceMatlAssignment" )
    @JsonProperty( "to_RawSubstanceMatlAssignment" )
    @ODataField( odataName = "to_RawSubstanceMatlAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecAssignedMatlForKeyDate> toRawSubstanceMatlAssignment;
    /**
     * Navigation property <b>to_RawSubstanceNextStatus</b> for <b>RawSubstance</b> to multiple
     * <b>SpecStatusNextStatus</b>.
     *
     */
    @SerializedName( "to_RawSubstanceNextStatus" )
    @JsonProperty( "to_RawSubstanceNextStatus" )
    @ODataField( odataName = "to_RawSubstanceNextStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusNextStatus> toRawSubstanceNextStatus;
    /**
     * Navigation property <b>to_RawSubstanceNtrntComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceNtrntComp" )
    @JsonProperty( "to_RawSubstanceNtrntComp" )
    @ODataField( odataName = "to_RawSubstanceNtrntComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceNtrntComp;
    /**
     * Navigation property <b>to_RawSubstanceReligiousComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceReligiousComp" )
    @JsonProperty( "to_RawSubstanceReligiousComp" )
    @ODataField( odataName = "to_RawSubstanceReligiousComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceReligiousComp;
    /**
     * Navigation property <b>to_RawSubstanceSchema</b> for <b>RawSubstance</b> to multiple <b>SpecStatusSchema</b>.
     *
     */
    @SerializedName( "to_RawSubstanceSchema" )
    @JsonProperty( "to_RawSubstanceSchema" )
    @ODataField( odataName = "to_RawSubstanceSchema" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusSchema> toRawSubstanceSchema;
    /**
     * Navigation property <b>to_RawSubstanceStatusAttributes</b> for <b>RawSubstance</b> to multiple
     * <b>SpecStatusAttributes</b>.
     *
     */
    @SerializedName( "to_RawSubstanceStatusAttributes" )
    @JsonProperty( "to_RawSubstanceStatusAttributes" )
    @ODataField( odataName = "to_RawSubstanceStatusAttributes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusAttributes> toRawSubstanceStatusAttributes;
    /**
     * Navigation property <b>to_RawSubstanceStdComp</b> for <b>RawSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RawSubstanceStdComp" )
    @JsonProperty( "to_RawSubstanceStdComp" )
    @ODataField( odataName = "to_RawSubstanceStdComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRawSubstanceStdComp;
    /**
     * Navigation property <b>to_RawSubstanceTotalSolid</b> for <b>RawSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RawSubstanceTotalSolid" )
    @JsonProperty( "to_RawSubstanceTotalSolid" )
    @ODataField( odataName = "to_RawSubstanceTotalSolid" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRawSubstanceTotalSolid;
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceAllergenComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_ALLERGEN_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceAllergenComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceAuthznGroupText</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecAuthorizationGroupText> TO_RAW_SUBSTANCE_AUTHZN_GROUP_TEXT =
        new RawSubstanceLink<SpecAuthorizationGroupText>("to_RawSubstanceAuthznGroupText");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceComponentType</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecCharByValueAssgmtInst> TO_RAW_SUBSTANCE_COMPONENT_TYPE =
        new RawSubstanceLink<SpecCharByValueAssgmtInst>("to_RawSubstanceComponentType");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceConversionFactor</b> navigation property to
     * query operations.
     *
     */
    public final static RawSubstanceLink<SpecCharByValueAssgmtInst> TO_RAW_SUBSTANCE_CONVERSION_FACTOR =
        new RawSubstanceLink<SpecCharByValueAssgmtInst>("to_RawSubstanceConversionFactor");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceDensity</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecCharByValueAssgmtInst> TO_RAW_SUBSTANCE_DENSITY =
        new RawSubstanceLink<SpecCharByValueAssgmtInst>("to_RawSubstanceDensity");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceDietComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_DIET_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceDietComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceEstimatedPrice</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecCharByValueAssgmtInst> TO_RAW_SUBSTANCE_ESTIMATED_PRICE =
        new RawSubstanceLink<SpecCharByValueAssgmtInst>("to_RawSubstanceEstimatedPrice");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceGMOComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_GMO_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceGMOComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceIdentifier</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecIdentifier> TO_RAW_SUBSTANCE_IDENTIFIER =
        new RawSubstanceLink<SpecIdentifier>("to_RawSubstanceIdentifier");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceMatlAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecAssignedMatlForKeyDate> TO_RAW_SUBSTANCE_MATL_ASSIGNMENT =
        new RawSubstanceLink<SpecAssignedMatlForKeyDate>("to_RawSubstanceMatlAssignment");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceNextStatus</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecStatusNextStatus> TO_RAW_SUBSTANCE_NEXT_STATUS =
        new RawSubstanceLink<SpecStatusNextStatus>("to_RawSubstanceNextStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceNtrntComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_NTRNT_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceNtrntComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceReligiousComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_RELIGIOUS_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceReligiousComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceSchema</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecStatusSchema> TO_RAW_SUBSTANCE_SCHEMA =
        new RawSubstanceLink<SpecStatusSchema>("to_RawSubstanceSchema");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceStatusAttributes</b> navigation property to
     * query operations.
     *
     */
    public final static RawSubstanceLink<SpecStatusAttributes> TO_RAW_SUBSTANCE_STATUS_ATTRIBUTES =
        new RawSubstanceLink<SpecStatusAttributes>("to_RawSubstanceStatusAttributes");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceStdComp</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecValAssgmtInstanceWthComp> TO_RAW_SUBSTANCE_STD_COMP =
        new RawSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RawSubstanceStdComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RawSubstanceTotalSolid</b> navigation property to query
     * operations.
     *
     */
    public final static RawSubstanceLink<SpecCharByValueAssgmtInst> TO_RAW_SUBSTANCE_TOTAL_SOLID =
        new RawSubstanceLink<SpecCharByValueAssgmtInst>("to_RawSubstanceTotalSolid");

    @Nonnull
    @Override
    public Class<RawSubstance> getType()
    {
        return RawSubstance.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceInternalID</b>
     * </p>
     *
     * @param rawSubstanceInternalID
     *            Sequential Number of Data Record
     */
    public void setRawSubstanceInternalID( @Nullable final String rawSubstanceInternalID )
    {
        rememberChangedField("RawSubstanceInternalID", this.rawSubstanceInternalID);
        this.rawSubstanceInternalID = rawSubstanceInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstance</b>
     * </p>
     *
     * @param rawSubstance
     *            Specification
     */
    public void setRawSubstance( @Nullable final String rawSubstance )
    {
        rememberChangedField("RawSubstance", this.rawSubstance);
        this.rawSubstance = rawSubstance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceAuthznGroup</b>
     * </p>
     *
     * @param rawSubstanceAuthznGroup
     *            Description of Authorization Group
     */
    public void setRawSubstanceAuthznGroup( @Nullable final String rawSubstanceAuthznGroup )
    {
        rememberChangedField("RawSubstanceAuthznGroup", this.rawSubstanceAuthznGroup);
        this.rawSubstanceAuthznGroup = rawSubstanceAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreationDate</b>
     * </p>
     *
     * @param rawSubstanceCreationDate
     *            Created On
     */
    public void setRawSubstanceCreationDate( @Nullable final LocalDateTime rawSubstanceCreationDate )
    {
        rememberChangedField("RawSubstanceCreationDate", this.rawSubstanceCreationDate);
        this.rawSubstanceCreationDate = rawSubstanceCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreatedByUser</b>
     * </p>
     *
     * @param rawSubstanceCreatedByUser
     *            Created By
     */
    public void setRawSubstanceCreatedByUser( @Nullable final String rawSubstanceCreatedByUser )
    {
        rememberChangedField("RawSubstanceCreatedByUser", this.rawSubstanceCreatedByUser);
        this.rawSubstanceCreatedByUser = rawSubstanceCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceCreatedByUserName</b>
     * </p>
     *
     * @param rawSubstanceCreatedByUserName
     *            Specification Header Created By Name
     */
    public void setRawSubstanceCreatedByUserName( @Nullable final String rawSubstanceCreatedByUserName )
    {
        rememberChangedField("RawSubstanceCreatedByUserName", this.rawSubstanceCreatedByUserName);
        this.rawSubstanceCreatedByUserName = rawSubstanceCreatedByUserName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangeDate</b>
     * </p>
     *
     * @param rawSubstanceChangeDate
     *            Changed On
     */
    public void setRawSubstanceChangeDate( @Nullable final LocalDateTime rawSubstanceChangeDate )
    {
        rememberChangedField("RawSubstanceChangeDate", this.rawSubstanceChangeDate);
        this.rawSubstanceChangeDate = rawSubstanceChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangedByUser</b>
     * </p>
     *
     * @param rawSubstanceChangedByUser
     *            Last Changed By
     */
    public void setRawSubstanceChangedByUser( @Nullable final String rawSubstanceChangedByUser )
    {
        rememberChangedField("RawSubstanceChangedByUser", this.rawSubstanceChangedByUser);
        this.rawSubstanceChangedByUser = rawSubstanceChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceChangedByUserName</b>
     * </p>
     *
     * @param rawSubstanceChangedByUserName
     *            Specification Changed By Name
     */
    public void setRawSubstanceChangedByUserName( @Nullable final String rawSubstanceChangedByUserName )
    {
        rememberChangedField("RawSubstanceChangedByUserName", this.rawSubstanceChangedByUserName);
        this.rawSubstanceChangedByUserName = rawSubstanceChangedByUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RawSubstanceType</b>
     * </p>
     *
     * @param rawSubstanceType
     *            Specification Type
     */
    public void setRawSubstanceType( @Nullable final String rawSubstanceType )
    {
        rememberChangedField("RawSubstanceType", this.rawSubstanceType);
        this.rawSubstanceType = rawSubstanceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationCategory</b>
     * </p>
     *
     * @param specificationCategory
     *            Specification Category
     */
    public void setSpecificationCategory( @Nullable final String specificationCategory )
    {
        rememberChangedField("SpecificationCategory", this.specificationCategory);
        this.specificationCategory = specificationCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationNote</b>
     * </p>
     *
     * @param specificationNote
     *            Note
     */
    public void setSpecificationNote( @Nullable final String specificationNote )
    {
        rememberChangedField("SpecificationNote", this.specificationNote);
        this.specificationNote = specificationNote;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @param specificationHeaderStatus
     *            Status Identification
     */
    public void setSpecificationHeaderStatus( @Nullable final String specificationHeaderStatus )
    {
        rememberChangedField("SpecificationHeaderStatus", this.specificationHeaderStatus);
        this.specificationHeaderStatus = specificationHeaderStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     */
    public void setSpecificationHdrStsSchema( @Nullable final String specificationHdrStsSchema )
    {
        rememberChangedField("SpecificationHdrStsSchema", this.specificationHdrStsSchema);
        this.specificationHdrStsSchema = specificationHdrStsSchema;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RawSubstance";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RawSubstanceInternalID", getRawSubstanceInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RawSubstanceInternalID", getRawSubstanceInternalID());
        values.put("RawSubstance", getRawSubstance());
        values.put("RawSubstanceAuthznGroup", getRawSubstanceAuthznGroup());
        values.put("RawSubstanceCreationDate", getRawSubstanceCreationDate());
        values.put("RawSubstanceCreatedByUser", getRawSubstanceCreatedByUser());
        values.put("RawSubstanceCreatedByUserName", getRawSubstanceCreatedByUserName());
        values.put("RawSubstanceChangeDate", getRawSubstanceChangeDate());
        values.put("RawSubstanceChangedByUser", getRawSubstanceChangedByUser());
        values.put("RawSubstanceChangedByUserName", getRawSubstanceChangedByUserName());
        values.put("RawSubstanceType", getRawSubstanceType());
        values.put("SpecificationCategory", getSpecificationCategory());
        values.put("SpecificationNote", getSpecificationNote());
        values.put("SpecificationHeaderStatus", getSpecificationHeaderStatus());
        values.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RawSubstanceInternalID") ) {
                final Object value = values.remove("RawSubstanceInternalID");
                if( (value == null) || (!value.equals(getRawSubstanceInternalID())) ) {
                    setRawSubstanceInternalID(((String) value));
                }
            }
            if( values.containsKey("RawSubstance") ) {
                final Object value = values.remove("RawSubstance");
                if( (value == null) || (!value.equals(getRawSubstance())) ) {
                    setRawSubstance(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceAuthznGroup") ) {
                final Object value = values.remove("RawSubstanceAuthznGroup");
                if( (value == null) || (!value.equals(getRawSubstanceAuthznGroup())) ) {
                    setRawSubstanceAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceCreationDate") ) {
                final Object value = values.remove("RawSubstanceCreationDate");
                if( (value == null) || (!value.equals(getRawSubstanceCreationDate())) ) {
                    setRawSubstanceCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RawSubstanceCreatedByUser") ) {
                final Object value = values.remove("RawSubstanceCreatedByUser");
                if( (value == null) || (!value.equals(getRawSubstanceCreatedByUser())) ) {
                    setRawSubstanceCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceCreatedByUserName") ) {
                final Object value = values.remove("RawSubstanceCreatedByUserName");
                if( (value == null) || (!value.equals(getRawSubstanceCreatedByUserName())) ) {
                    setRawSubstanceCreatedByUserName(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceChangeDate") ) {
                final Object value = values.remove("RawSubstanceChangeDate");
                if( (value == null) || (!value.equals(getRawSubstanceChangeDate())) ) {
                    setRawSubstanceChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RawSubstanceChangedByUser") ) {
                final Object value = values.remove("RawSubstanceChangedByUser");
                if( (value == null) || (!value.equals(getRawSubstanceChangedByUser())) ) {
                    setRawSubstanceChangedByUser(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceChangedByUserName") ) {
                final Object value = values.remove("RawSubstanceChangedByUserName");
                if( (value == null) || (!value.equals(getRawSubstanceChangedByUserName())) ) {
                    setRawSubstanceChangedByUserName(((String) value));
                }
            }
            if( values.containsKey("RawSubstanceType") ) {
                final Object value = values.remove("RawSubstanceType");
                if( (value == null) || (!value.equals(getRawSubstanceType())) ) {
                    setRawSubstanceType(((String) value));
                }
            }
            if( values.containsKey("SpecificationCategory") ) {
                final Object value = values.remove("SpecificationCategory");
                if( (value == null) || (!value.equals(getSpecificationCategory())) ) {
                    setSpecificationCategory(((String) value));
                }
            }
            if( values.containsKey("SpecificationNote") ) {
                final Object value = values.remove("SpecificationNote");
                if( (value == null) || (!value.equals(getSpecificationNote())) ) {
                    setSpecificationNote(((String) value));
                }
            }
            if( values.containsKey("SpecificationHeaderStatus") ) {
                final Object value = values.remove("SpecificationHeaderStatus");
                if( (value == null) || (!value.equals(getSpecificationHeaderStatus())) ) {
                    setSpecificationHeaderStatus(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsSchema") ) {
                final Object value = values.remove("SpecificationHdrStsSchema");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchema())) ) {
                    setSpecificationHdrStsSchema(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RawSubstanceAllergenComp") ) {
                final Object value = (values).remove("to_RawSubstanceAllergenComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceAllergenComp == null ) {
                        toRawSubstanceAllergenComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceAllergenComp = Lists.newArrayList(toRawSubstanceAllergenComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceAllergenComp.size() > i ) {
                            entity = toRawSubstanceAllergenComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceAllergenComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceAuthznGroupText") ) {
                final Object value = (values).remove("to_RawSubstanceAuthznGroupText");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceAuthznGroupText == null ) {
                        toRawSubstanceAuthznGroupText = Lists.newArrayList();
                    } else {
                        toRawSubstanceAuthznGroupText = Lists.newArrayList(toRawSubstanceAuthznGroupText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecAuthorizationGroupText entity;
                        if( toRawSubstanceAuthznGroupText.size() > i ) {
                            entity = toRawSubstanceAuthznGroupText.get(i);
                        } else {
                            entity = new SpecAuthorizationGroupText();
                            toRawSubstanceAuthznGroupText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceComponentType") ) {
                final Object value = (values).remove("to_RawSubstanceComponentType");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceComponentType == null ) {
                        toRawSubstanceComponentType = Lists.newArrayList();
                    } else {
                        toRawSubstanceComponentType = Lists.newArrayList(toRawSubstanceComponentType);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRawSubstanceComponentType.size() > i ) {
                            entity = toRawSubstanceComponentType.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRawSubstanceComponentType.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceConversionFactor") ) {
                final Object value = (values).remove("to_RawSubstanceConversionFactor");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceConversionFactor == null ) {
                        toRawSubstanceConversionFactor = Lists.newArrayList();
                    } else {
                        toRawSubstanceConversionFactor = Lists.newArrayList(toRawSubstanceConversionFactor);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRawSubstanceConversionFactor.size() > i ) {
                            entity = toRawSubstanceConversionFactor.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRawSubstanceConversionFactor.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceDensity") ) {
                final Object value = (values).remove("to_RawSubstanceDensity");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceDensity == null ) {
                        toRawSubstanceDensity = Lists.newArrayList();
                    } else {
                        toRawSubstanceDensity = Lists.newArrayList(toRawSubstanceDensity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRawSubstanceDensity.size() > i ) {
                            entity = toRawSubstanceDensity.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRawSubstanceDensity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceDietComp") ) {
                final Object value = (values).remove("to_RawSubstanceDietComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceDietComp == null ) {
                        toRawSubstanceDietComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceDietComp = Lists.newArrayList(toRawSubstanceDietComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceDietComp.size() > i ) {
                            entity = toRawSubstanceDietComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceDietComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceEstimatedPrice") ) {
                final Object value = (values).remove("to_RawSubstanceEstimatedPrice");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceEstimatedPrice == null ) {
                        toRawSubstanceEstimatedPrice = Lists.newArrayList();
                    } else {
                        toRawSubstanceEstimatedPrice = Lists.newArrayList(toRawSubstanceEstimatedPrice);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRawSubstanceEstimatedPrice.size() > i ) {
                            entity = toRawSubstanceEstimatedPrice.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRawSubstanceEstimatedPrice.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceGMOComp") ) {
                final Object value = (values).remove("to_RawSubstanceGMOComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceGMOComp == null ) {
                        toRawSubstanceGMOComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceGMOComp = Lists.newArrayList(toRawSubstanceGMOComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceGMOComp.size() > i ) {
                            entity = toRawSubstanceGMOComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceGMOComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceIdentifier") ) {
                final Object value = (values).remove("to_RawSubstanceIdentifier");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceIdentifier == null ) {
                        toRawSubstanceIdentifier = Lists.newArrayList();
                    } else {
                        toRawSubstanceIdentifier = Lists.newArrayList(toRawSubstanceIdentifier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecIdentifier entity;
                        if( toRawSubstanceIdentifier.size() > i ) {
                            entity = toRawSubstanceIdentifier.get(i);
                        } else {
                            entity = new SpecIdentifier();
                            toRawSubstanceIdentifier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceMatlAssignment") ) {
                final Object value = (values).remove("to_RawSubstanceMatlAssignment");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceMatlAssignment == null ) {
                        toRawSubstanceMatlAssignment = Lists.newArrayList();
                    } else {
                        toRawSubstanceMatlAssignment = Lists.newArrayList(toRawSubstanceMatlAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecAssignedMatlForKeyDate entity;
                        if( toRawSubstanceMatlAssignment.size() > i ) {
                            entity = toRawSubstanceMatlAssignment.get(i);
                        } else {
                            entity = new SpecAssignedMatlForKeyDate();
                            toRawSubstanceMatlAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceNextStatus") ) {
                final Object value = (values).remove("to_RawSubstanceNextStatus");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceNextStatus == null ) {
                        toRawSubstanceNextStatus = Lists.newArrayList();
                    } else {
                        toRawSubstanceNextStatus = Lists.newArrayList(toRawSubstanceNextStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusNextStatus entity;
                        if( toRawSubstanceNextStatus.size() > i ) {
                            entity = toRawSubstanceNextStatus.get(i);
                        } else {
                            entity = new SpecStatusNextStatus();
                            toRawSubstanceNextStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceNtrntComp") ) {
                final Object value = (values).remove("to_RawSubstanceNtrntComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceNtrntComp == null ) {
                        toRawSubstanceNtrntComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceNtrntComp = Lists.newArrayList(toRawSubstanceNtrntComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceNtrntComp.size() > i ) {
                            entity = toRawSubstanceNtrntComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceNtrntComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceReligiousComp") ) {
                final Object value = (values).remove("to_RawSubstanceReligiousComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceReligiousComp == null ) {
                        toRawSubstanceReligiousComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceReligiousComp = Lists.newArrayList(toRawSubstanceReligiousComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceReligiousComp.size() > i ) {
                            entity = toRawSubstanceReligiousComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceReligiousComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceSchema") ) {
                final Object value = (values).remove("to_RawSubstanceSchema");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceSchema == null ) {
                        toRawSubstanceSchema = Lists.newArrayList();
                    } else {
                        toRawSubstanceSchema = Lists.newArrayList(toRawSubstanceSchema);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusSchema entity;
                        if( toRawSubstanceSchema.size() > i ) {
                            entity = toRawSubstanceSchema.get(i);
                        } else {
                            entity = new SpecStatusSchema();
                            toRawSubstanceSchema.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceStatusAttributes") ) {
                final Object value = (values).remove("to_RawSubstanceStatusAttributes");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceStatusAttributes == null ) {
                        toRawSubstanceStatusAttributes = Lists.newArrayList();
                    } else {
                        toRawSubstanceStatusAttributes = Lists.newArrayList(toRawSubstanceStatusAttributes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusAttributes entity;
                        if( toRawSubstanceStatusAttributes.size() > i ) {
                            entity = toRawSubstanceStatusAttributes.get(i);
                        } else {
                            entity = new SpecStatusAttributes();
                            toRawSubstanceStatusAttributes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceStdComp") ) {
                final Object value = (values).remove("to_RawSubstanceStdComp");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceStdComp == null ) {
                        toRawSubstanceStdComp = Lists.newArrayList();
                    } else {
                        toRawSubstanceStdComp = Lists.newArrayList(toRawSubstanceStdComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRawSubstanceStdComp.size() > i ) {
                            entity = toRawSubstanceStdComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRawSubstanceStdComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RawSubstanceTotalSolid") ) {
                final Object value = (values).remove("to_RawSubstanceTotalSolid");
                if( value instanceof Iterable ) {
                    if( toRawSubstanceTotalSolid == null ) {
                        toRawSubstanceTotalSolid = Lists.newArrayList();
                    } else {
                        toRawSubstanceTotalSolid = Lists.newArrayList(toRawSubstanceTotalSolid);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRawSubstanceTotalSolid.size() > i ) {
                            entity = toRawSubstanceTotalSolid.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRawSubstanceTotalSolid.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> RawSubstanceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RawSubstanceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RawSubstanceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RawSubstanceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRawSubstanceAllergenComp != null ) {
            (values).put("to_RawSubstanceAllergenComp", toRawSubstanceAllergenComp);
        }
        if( toRawSubstanceAuthznGroupText != null ) {
            (values).put("to_RawSubstanceAuthznGroupText", toRawSubstanceAuthznGroupText);
        }
        if( toRawSubstanceComponentType != null ) {
            (values).put("to_RawSubstanceComponentType", toRawSubstanceComponentType);
        }
        if( toRawSubstanceConversionFactor != null ) {
            (values).put("to_RawSubstanceConversionFactor", toRawSubstanceConversionFactor);
        }
        if( toRawSubstanceDensity != null ) {
            (values).put("to_RawSubstanceDensity", toRawSubstanceDensity);
        }
        if( toRawSubstanceDietComp != null ) {
            (values).put("to_RawSubstanceDietComp", toRawSubstanceDietComp);
        }
        if( toRawSubstanceEstimatedPrice != null ) {
            (values).put("to_RawSubstanceEstimatedPrice", toRawSubstanceEstimatedPrice);
        }
        if( toRawSubstanceGMOComp != null ) {
            (values).put("to_RawSubstanceGMOComp", toRawSubstanceGMOComp);
        }
        if( toRawSubstanceIdentifier != null ) {
            (values).put("to_RawSubstanceIdentifier", toRawSubstanceIdentifier);
        }
        if( toRawSubstanceMatlAssignment != null ) {
            (values).put("to_RawSubstanceMatlAssignment", toRawSubstanceMatlAssignment);
        }
        if( toRawSubstanceNextStatus != null ) {
            (values).put("to_RawSubstanceNextStatus", toRawSubstanceNextStatus);
        }
        if( toRawSubstanceNtrntComp != null ) {
            (values).put("to_RawSubstanceNtrntComp", toRawSubstanceNtrntComp);
        }
        if( toRawSubstanceReligiousComp != null ) {
            (values).put("to_RawSubstanceReligiousComp", toRawSubstanceReligiousComp);
        }
        if( toRawSubstanceSchema != null ) {
            (values).put("to_RawSubstanceSchema", toRawSubstanceSchema);
        }
        if( toRawSubstanceStatusAttributes != null ) {
            (values).put("to_RawSubstanceStatusAttributes", toRawSubstanceStatusAttributes);
        }
        if( toRawSubstanceStdComp != null ) {
            (values).put("to_RawSubstanceStdComp", toRawSubstanceStdComp);
        }
        if( toRawSubstanceTotalSolid != null ) {
            (values).put("to_RawSubstanceTotalSolid", toRawSubstanceTotalSolid);
        }
        return values;
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceAllergenComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceAllergenComp()
    {
        return fetchFieldAsList("to_RawSubstanceAllergenComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAllergenComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceAllergenCompOrFetch()
    {
        if( toRawSubstanceAllergenComp == null ) {
            toRawSubstanceAllergenComp = fetchRawSubstanceAllergenComp();
        }
        return toRawSubstanceAllergenComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceAllergenComp</b> is already loaded, the
     *         result will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceAllergenCompIfPresent()
    {
        return Option.of(toRawSubstanceAllergenComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAllergenComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceAllergenComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceAllergenComp == null ) {
            toRawSubstanceAllergenComp = Lists.newArrayList();
        }
        toRawSubstanceAllergenComp.clear();
        toRawSubstanceAllergenComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAllergenComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceAllergenComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceAllergenComp == null ) {
            toRawSubstanceAllergenComp = Lists.newArrayList();
        }
        toRawSubstanceAllergenComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecAuthorizationGroupText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceAuthznGroupText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecAuthorizationGroupText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAuthorizationGroupText> fetchRawSubstanceAuthznGroupText()
    {
        return fetchFieldAsList("to_RawSubstanceAuthznGroupText", SpecAuthorizationGroupText.class);
    }

    /**
     * Retrieval of associated <b>SpecAuthorizationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAuthznGroupText</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecAuthorizationGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAuthorizationGroupText> getRawSubstanceAuthznGroupTextOrFetch()
    {
        if( toRawSubstanceAuthznGroupText == null ) {
            toRawSubstanceAuthznGroupText = fetchRawSubstanceAuthznGroupText();
        }
        return toRawSubstanceAuthznGroupText;
    }

    /**
     * Retrieval of associated <b>SpecAuthorizationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceAuthznGroupText</b> is already loaded, the
     *         result will contain the <b>SpecAuthorizationGroupText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecAuthorizationGroupText>> getRawSubstanceAuthznGroupTextIfPresent()
    {
        return Option.of(toRawSubstanceAuthznGroupText);
    }

    /**
     * Overwrites the list of associated <b>SpecAuthorizationGroupText</b> entities for the loaded navigation property
     * <b>to_RawSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAuthznGroupText</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecAuthorizationGroupText</b> entities.
     */
    public void setRawSubstanceAuthznGroupText( @Nonnull final List<SpecAuthorizationGroupText> value )
    {
        if( toRawSubstanceAuthznGroupText == null ) {
            toRawSubstanceAuthznGroupText = Lists.newArrayList();
        }
        toRawSubstanceAuthznGroupText.clear();
        toRawSubstanceAuthznGroupText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecAuthorizationGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceAuthznGroupText</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecAuthorizationGroupText</b> entities.
     */
    public void addRawSubstanceAuthznGroupText( SpecAuthorizationGroupText... entity )
    {
        if( toRawSubstanceAuthznGroupText == null ) {
            toRawSubstanceAuthznGroupText = Lists.newArrayList();
        }
        toRawSubstanceAuthznGroupText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RawSubstanceComponentType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRawSubstanceComponentType()
    {
        return fetchFieldAsList("to_RawSubstanceComponentType", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceComponentType</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRawSubstanceComponentTypeOrFetch()
    {
        if( toRawSubstanceComponentType == null ) {
            toRawSubstanceComponentType = fetchRawSubstanceComponentType();
        }
        return toRawSubstanceComponentType;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceComponentType</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceComponentType</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRawSubstanceComponentTypeIfPresent()
    {
        return Option.of(toRawSubstanceComponentType);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RawSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceComponentType</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRawSubstanceComponentType( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRawSubstanceComponentType == null ) {
            toRawSubstanceComponentType = Lists.newArrayList();
        }
        toRawSubstanceComponentType.clear();
        toRawSubstanceComponentType.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceComponentType</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRawSubstanceComponentType( SpecCharByValueAssgmtInst... entity )
    {
        if( toRawSubstanceComponentType == null ) {
            toRawSubstanceComponentType = Lists.newArrayList();
        }
        toRawSubstanceComponentType.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RawSubstanceConversionFactor</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRawSubstanceConversionFactor()
    {
        return fetchFieldAsList("to_RawSubstanceConversionFactor", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceConversionFactor</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRawSubstanceConversionFactorOrFetch()
    {
        if( toRawSubstanceConversionFactor == null ) {
            toRawSubstanceConversionFactor = fetchRawSubstanceConversionFactor();
        }
        return toRawSubstanceConversionFactor;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceConversionFactor</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRawSubstanceConversionFactorIfPresent()
    {
        return Option.of(toRawSubstanceConversionFactor);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RawSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceConversionFactor</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRawSubstanceConversionFactor( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRawSubstanceConversionFactor == null ) {
            toRawSubstanceConversionFactor = Lists.newArrayList();
        }
        toRawSubstanceConversionFactor.clear();
        toRawSubstanceConversionFactor.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceConversionFactor</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRawSubstanceConversionFactor( SpecCharByValueAssgmtInst... entity )
    {
        if( toRawSubstanceConversionFactor == null ) {
            toRawSubstanceConversionFactor = Lists.newArrayList();
        }
        toRawSubstanceConversionFactor.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RawSubstanceDensity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRawSubstanceDensity()
    {
        return fetchFieldAsList("to_RawSubstanceDensity", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDensity</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRawSubstanceDensityOrFetch()
    {
        if( toRawSubstanceDensity == null ) {
            toRawSubstanceDensity = fetchRawSubstanceDensity();
        }
        return toRawSubstanceDensity;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceDensity</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceDensity</b> is already loaded, the result
     *         will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRawSubstanceDensityIfPresent()
    {
        return Option.of(toRawSubstanceDensity);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RawSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDensity</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRawSubstanceDensity( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRawSubstanceDensity == null ) {
            toRawSubstanceDensity = Lists.newArrayList();
        }
        toRawSubstanceDensity.clear();
        toRawSubstanceDensity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDensity</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRawSubstanceDensity( SpecCharByValueAssgmtInst... entity )
    {
        if( toRawSubstanceDensity == null ) {
            toRawSubstanceDensity = Lists.newArrayList();
        }
        toRawSubstanceDensity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceDietComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceDietComp()
    {
        return fetchFieldAsList("to_RawSubstanceDietComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDietComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceDietCompOrFetch()
    {
        if( toRawSubstanceDietComp == null ) {
            toRawSubstanceDietComp = fetchRawSubstanceDietComp();
        }
        return toRawSubstanceDietComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceDietComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceDietComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceDietCompIfPresent()
    {
        return Option.of(toRawSubstanceDietComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDietComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceDietComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceDietComp == null ) {
            toRawSubstanceDietComp = Lists.newArrayList();
        }
        toRawSubstanceDietComp.clear();
        toRawSubstanceDietComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceDietComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceDietComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceDietComp == null ) {
            toRawSubstanceDietComp = Lists.newArrayList();
        }
        toRawSubstanceDietComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RawSubstanceEstimatedPrice</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRawSubstanceEstimatedPrice()
    {
        return fetchFieldAsList("to_RawSubstanceEstimatedPrice", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceEstimatedPrice</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRawSubstanceEstimatedPriceOrFetch()
    {
        if( toRawSubstanceEstimatedPrice == null ) {
            toRawSubstanceEstimatedPrice = fetchRawSubstanceEstimatedPrice();
        }
        return toRawSubstanceEstimatedPrice;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceEstimatedPrice</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRawSubstanceEstimatedPriceIfPresent()
    {
        return Option.of(toRawSubstanceEstimatedPrice);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RawSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceEstimatedPrice</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRawSubstanceEstimatedPrice( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRawSubstanceEstimatedPrice == null ) {
            toRawSubstanceEstimatedPrice = Lists.newArrayList();
        }
        toRawSubstanceEstimatedPrice.clear();
        toRawSubstanceEstimatedPrice.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceEstimatedPrice</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRawSubstanceEstimatedPrice( SpecCharByValueAssgmtInst... entity )
    {
        if( toRawSubstanceEstimatedPrice == null ) {
            toRawSubstanceEstimatedPrice = Lists.newArrayList();
        }
        toRawSubstanceEstimatedPrice.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceGMOComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceGMOComp()
    {
        return fetchFieldAsList("to_RawSubstanceGMOComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceGMOComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceGMOCompOrFetch()
    {
        if( toRawSubstanceGMOComp == null ) {
            toRawSubstanceGMOComp = fetchRawSubstanceGMOComp();
        }
        return toRawSubstanceGMOComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceGMOComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceGMOComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceGMOCompIfPresent()
    {
        return Option.of(toRawSubstanceGMOComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceGMOComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceGMOComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceGMOComp == null ) {
            toRawSubstanceGMOComp = Lists.newArrayList();
        }
        toRawSubstanceGMOComp.clear();
        toRawSubstanceGMOComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceGMOComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceGMOComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceGMOComp == null ) {
            toRawSubstanceGMOComp = Lists.newArrayList();
        }
        toRawSubstanceGMOComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecIdentifier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RawSubstanceIdentifier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecIdentifier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> fetchRawSubstanceIdentifier()
    {
        return fetchFieldAsList("to_RawSubstanceIdentifier", SpecIdentifier.class);
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RawSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceIdentifier</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecIdentifier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> getRawSubstanceIdentifierOrFetch()
    {
        if( toRawSubstanceIdentifier == null ) {
            toRawSubstanceIdentifier = fetchRawSubstanceIdentifier();
        }
        return toRawSubstanceIdentifier;
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RawSubstanceIdentifier</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceIdentifier</b> is already loaded, the result
     *         will contain the <b>SpecIdentifier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecIdentifier>> getRawSubstanceIdentifierIfPresent()
    {
        return Option.of(toRawSubstanceIdentifier);
    }

    /**
     * Overwrites the list of associated <b>SpecIdentifier</b> entities for the loaded navigation property
     * <b>to_RawSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceIdentifier</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecIdentifier</b> entities.
     */
    public void setRawSubstanceIdentifier( @Nonnull final List<SpecIdentifier> value )
    {
        if( toRawSubstanceIdentifier == null ) {
            toRawSubstanceIdentifier = Lists.newArrayList();
        }
        toRawSubstanceIdentifier.clear();
        toRawSubstanceIdentifier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecIdentifier</b> entities. This corresponds to the OData navigation
     * property <b>to_RawSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceIdentifier</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecIdentifier</b> entities.
     */
    public void addRawSubstanceIdentifier( SpecIdentifier... entity )
    {
        if( toRawSubstanceIdentifier == null ) {
            toRawSubstanceIdentifier = Lists.newArrayList();
        }
        toRawSubstanceIdentifier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecAssignedMatlForKeyDate</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceMatlAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecAssignedMatlForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAssignedMatlForKeyDate> fetchRawSubstanceMatlAssignment()
    {
        return fetchFieldAsList("to_RawSubstanceMatlAssignment", SpecAssignedMatlForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>SpecAssignedMatlForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceMatlAssignment</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecAssignedMatlForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAssignedMatlForKeyDate> getRawSubstanceMatlAssignmentOrFetch()
    {
        if( toRawSubstanceMatlAssignment == null ) {
            toRawSubstanceMatlAssignment = fetchRawSubstanceMatlAssignment();
        }
        return toRawSubstanceMatlAssignment;
    }

    /**
     * Retrieval of associated <b>SpecAssignedMatlForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceMatlAssignment</b> is already loaded, the
     *         result will contain the <b>SpecAssignedMatlForKeyDate</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecAssignedMatlForKeyDate>> getRawSubstanceMatlAssignmentIfPresent()
    {
        return Option.of(toRawSubstanceMatlAssignment);
    }

    /**
     * Overwrites the list of associated <b>SpecAssignedMatlForKeyDate</b> entities for the loaded navigation property
     * <b>to_RawSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceMatlAssignment</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecAssignedMatlForKeyDate</b> entities.
     */
    public void setRawSubstanceMatlAssignment( @Nonnull final List<SpecAssignedMatlForKeyDate> value )
    {
        if( toRawSubstanceMatlAssignment == null ) {
            toRawSubstanceMatlAssignment = Lists.newArrayList();
        }
        toRawSubstanceMatlAssignment.clear();
        toRawSubstanceMatlAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecAssignedMatlForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceMatlAssignment</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecAssignedMatlForKeyDate</b> entities.
     */
    public void addRawSubstanceMatlAssignment( SpecAssignedMatlForKeyDate... entity )
    {
        if( toRawSubstanceMatlAssignment == null ) {
            toRawSubstanceMatlAssignment = Lists.newArrayList();
        }
        toRawSubstanceMatlAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusNextStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RawSubstanceNextStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusNextStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusNextStatus> fetchRawSubstanceNextStatus()
    {
        return fetchFieldAsList("to_RawSubstanceNextStatus", SpecStatusNextStatus.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusNextStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNextStatus</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusNextStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusNextStatus> getRawSubstanceNextStatusOrFetch()
    {
        if( toRawSubstanceNextStatus == null ) {
            toRawSubstanceNextStatus = fetchRawSubstanceNextStatus();
        }
        return toRawSubstanceNextStatus;
    }

    /**
     * Retrieval of associated <b>SpecStatusNextStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceNextStatus</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceNextStatus</b> is already loaded, the result
     *         will contain the <b>SpecStatusNextStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusNextStatus>> getRawSubstanceNextStatusIfPresent()
    {
        return Option.of(toRawSubstanceNextStatus);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusNextStatus</b> entities for the loaded navigation property
     * <b>to_RawSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNextStatus</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusNextStatus</b> entities.
     */
    public void setRawSubstanceNextStatus( @Nonnull final List<SpecStatusNextStatus> value )
    {
        if( toRawSubstanceNextStatus == null ) {
            toRawSubstanceNextStatus = Lists.newArrayList();
        }
        toRawSubstanceNextStatus.clear();
        toRawSubstanceNextStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusNextStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNextStatus</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusNextStatus</b> entities.
     */
    public void addRawSubstanceNextStatus( SpecStatusNextStatus... entity )
    {
        if( toRawSubstanceNextStatus == null ) {
            toRawSubstanceNextStatus = Lists.newArrayList();
        }
        toRawSubstanceNextStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceNtrntComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceNtrntComp()
    {
        return fetchFieldAsList("to_RawSubstanceNtrntComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNtrntComp</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceNtrntCompOrFetch()
    {
        if( toRawSubstanceNtrntComp == null ) {
            toRawSubstanceNtrntComp = fetchRawSubstanceNtrntComp();
        }
        return toRawSubstanceNtrntComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceNtrntComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceNtrntCompIfPresent()
    {
        return Option.of(toRawSubstanceNtrntComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNtrntComp</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceNtrntComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceNtrntComp == null ) {
            toRawSubstanceNtrntComp = Lists.newArrayList();
        }
        toRawSubstanceNtrntComp.clear();
        toRawSubstanceNtrntComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceNtrntComp</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceNtrntComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceNtrntComp == null ) {
            toRawSubstanceNtrntComp = Lists.newArrayList();
        }
        toRawSubstanceNtrntComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceReligiousComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceReligiousComp()
    {
        return fetchFieldAsList("to_RawSubstanceReligiousComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceReligiousComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceReligiousCompOrFetch()
    {
        if( toRawSubstanceReligiousComp == null ) {
            toRawSubstanceReligiousComp = fetchRawSubstanceReligiousComp();
        }
        return toRawSubstanceReligiousComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceReligiousComp</b> is already loaded, the
     *         result will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceReligiousCompIfPresent()
    {
        return Option.of(toRawSubstanceReligiousComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceReligiousComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceReligiousComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceReligiousComp == null ) {
            toRawSubstanceReligiousComp = Lists.newArrayList();
        }
        toRawSubstanceReligiousComp.clear();
        toRawSubstanceReligiousComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceReligiousComp</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceReligiousComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceReligiousComp == null ) {
            toRawSubstanceReligiousComp = Lists.newArrayList();
        }
        toRawSubstanceReligiousComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusSchema</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RawSubstanceSchema</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusSchema</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusSchema> fetchRawSubstanceSchema()
    {
        return fetchFieldAsList("to_RawSubstanceSchema", SpecStatusSchema.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusSchema</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RawSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceSchema</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusSchema</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusSchema> getRawSubstanceSchemaOrFetch()
    {
        if( toRawSubstanceSchema == null ) {
            toRawSubstanceSchema = fetchRawSubstanceSchema();
        }
        return toRawSubstanceSchema;
    }

    /**
     * Retrieval of associated <b>SpecStatusSchema</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RawSubstanceSchema</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceSchema</b> is already loaded, the result
     *         will contain the <b>SpecStatusSchema</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusSchema>> getRawSubstanceSchemaIfPresent()
    {
        return Option.of(toRawSubstanceSchema);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusSchema</b> entities for the loaded navigation property
     * <b>to_RawSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceSchema</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusSchema</b> entities.
     */
    public void setRawSubstanceSchema( @Nonnull final List<SpecStatusSchema> value )
    {
        if( toRawSubstanceSchema == null ) {
            toRawSubstanceSchema = Lists.newArrayList();
        }
        toRawSubstanceSchema.clear();
        toRawSubstanceSchema.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusSchema</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceSchema</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusSchema</b> entities.
     */
    public void addRawSubstanceSchema( SpecStatusSchema... entity )
    {
        if( toRawSubstanceSchema == null ) {
            toRawSubstanceSchema = Lists.newArrayList();
        }
        toRawSubstanceSchema.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusAttributes</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RawSubstanceStatusAttributes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusAttributes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> fetchRawSubstanceStatusAttributes()
    {
        return fetchFieldAsList("to_RawSubstanceStatusAttributes", SpecStatusAttributes.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStatusAttributes</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusAttributes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> getRawSubstanceStatusAttributesOrFetch()
    {
        if( toRawSubstanceStatusAttributes == null ) {
            toRawSubstanceStatusAttributes = fetchRawSubstanceStatusAttributes();
        }
        return toRawSubstanceStatusAttributes;
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceStatusAttributes</b> is already loaded, the
     *         result will contain the <b>SpecStatusAttributes</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusAttributes>> getRawSubstanceStatusAttributesIfPresent()
    {
        return Option.of(toRawSubstanceStatusAttributes);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusAttributes</b> entities for the loaded navigation property
     * <b>to_RawSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStatusAttributes</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusAttributes</b> entities.
     */
    public void setRawSubstanceStatusAttributes( @Nonnull final List<SpecStatusAttributes> value )
    {
        if( toRawSubstanceStatusAttributes == null ) {
            toRawSubstanceStatusAttributes = Lists.newArrayList();
        }
        toRawSubstanceStatusAttributes.clear();
        toRawSubstanceStatusAttributes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusAttributes</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStatusAttributes</b> of a queried <b>RawSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusAttributes</b> entities.
     */
    public void addRawSubstanceStatusAttributes( SpecStatusAttributes... entity )
    {
        if( toRawSubstanceStatusAttributes == null ) {
            toRawSubstanceStatusAttributes = Lists.newArrayList();
        }
        toRawSubstanceStatusAttributes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RawSubstanceStdComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRawSubstanceStdComp()
    {
        return fetchFieldAsList("to_RawSubstanceStdComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStdComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRawSubstanceStdCompOrFetch()
    {
        if( toRawSubstanceStdComp == null ) {
            toRawSubstanceStdComp = fetchRawSubstanceStdComp();
        }
        return toRawSubstanceStdComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceStdComp</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceStdComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRawSubstanceStdCompIfPresent()
    {
        return Option.of(toRawSubstanceStdComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RawSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStdComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRawSubstanceStdComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRawSubstanceStdComp == null ) {
            toRawSubstanceStdComp = Lists.newArrayList();
        }
        toRawSubstanceStdComp.clear();
        toRawSubstanceStdComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RawSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceStdComp</b> of a queried <b>RawSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRawSubstanceStdComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRawSubstanceStdComp == null ) {
            toRawSubstanceStdComp = Lists.newArrayList();
        }
        toRawSubstanceStdComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RawSubstanceTotalSolid</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRawSubstanceTotalSolid()
    {
        return fetchFieldAsList("to_RawSubstanceTotalSolid", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceTotalSolid</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRawSubstanceTotalSolidOrFetch()
    {
        if( toRawSubstanceTotalSolid == null ) {
            toRawSubstanceTotalSolid = fetchRawSubstanceTotalSolid();
        }
        return toRawSubstanceTotalSolid;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RawSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property for an entity <b>RawSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RawSubstanceTotalSolid</b> is already loaded, the result
     *         will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRawSubstanceTotalSolidIfPresent()
    {
        return Option.of(toRawSubstanceTotalSolid);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RawSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceTotalSolid</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRawSubstanceTotalSolid( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRawSubstanceTotalSolid == null ) {
            toRawSubstanceTotalSolid = Lists.newArrayList();
        }
        toRawSubstanceTotalSolid.clear();
        toRawSubstanceTotalSolid.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RawSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RawSubstanceTotalSolid</b> of a queried <b>RawSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRawSubstanceTotalSolid( SpecCharByValueAssgmtInst... entity )
    {
        if( toRawSubstanceTotalSolid == null ) {
            toRawSubstanceTotalSolid = Lists.newArrayList();
        }
        toRawSubstanceTotalSolid.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RawSubstance instances.
     *
     */
    public final static class RawSubstanceBuilder
    {

        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceAllergenComp = Lists.newArrayList();
        private List<SpecAuthorizationGroupText> toRawSubstanceAuthznGroupText = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRawSubstanceComponentType = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRawSubstanceConversionFactor = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRawSubstanceDensity = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceDietComp = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRawSubstanceEstimatedPrice = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceGMOComp = Lists.newArrayList();
        private List<SpecIdentifier> toRawSubstanceIdentifier = Lists.newArrayList();
        private List<SpecAssignedMatlForKeyDate> toRawSubstanceMatlAssignment = Lists.newArrayList();
        private List<SpecStatusNextStatus> toRawSubstanceNextStatus = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceNtrntComp = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceReligiousComp = Lists.newArrayList();
        private List<SpecStatusSchema> toRawSubstanceSchema = Lists.newArrayList();
        private List<SpecStatusAttributes> toRawSubstanceStatusAttributes = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRawSubstanceStdComp = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRawSubstanceTotalSolid = Lists.newArrayList();

        private RawSubstance.RawSubstanceBuilder toRawSubstanceAllergenComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceAllergenComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceAllergenComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceAllergenComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceAllergenComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceAuthznGroupText(
            final List<SpecAuthorizationGroupText> value )
        {
            toRawSubstanceAuthznGroupText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceAuthznGroupText</b> for <b>RawSubstance</b> to multiple
         * <b>SpecAuthorizationGroupText</b>.
         *
         * @param value
         *            The SpecAuthorizationGroupTexts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceAuthznGroupText( SpecAuthorizationGroupText... value )
        {
            return toRawSubstanceAuthznGroupText(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceComponentType(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRawSubstanceComponentType.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceComponentType</b> for <b>RawSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceComponentType( SpecCharByValueAssgmtInst... value )
        {
            return toRawSubstanceComponentType(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceConversionFactor(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRawSubstanceConversionFactor.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceConversionFactor</b> for <b>RawSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceConversionFactor( SpecCharByValueAssgmtInst... value )
        {
            return toRawSubstanceConversionFactor(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceDensity( final List<SpecCharByValueAssgmtInst> value )
        {
            toRawSubstanceDensity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceDensity</b> for <b>RawSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceDensity( SpecCharByValueAssgmtInst... value )
        {
            return toRawSubstanceDensity(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceDietComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceDietComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceDietComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceDietComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceDietComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceEstimatedPrice(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRawSubstanceEstimatedPrice.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceEstimatedPrice</b> for <b>RawSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceEstimatedPrice( SpecCharByValueAssgmtInst... value )
        {
            return toRawSubstanceEstimatedPrice(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceGMOComp( final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceGMOComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceGMOComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceGMOComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceGMOComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceIdentifier( final List<SpecIdentifier> value )
        {
            toRawSubstanceIdentifier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceIdentifier</b> for <b>RawSubstance</b> to multiple
         * <b>SpecIdentifier</b>.
         *
         * @param value
         *            The SpecIdentifiers to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceIdentifier( SpecIdentifier... value )
        {
            return toRawSubstanceIdentifier(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceMatlAssignment(
            final List<SpecAssignedMatlForKeyDate> value )
        {
            toRawSubstanceMatlAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceMatlAssignment</b> for <b>RawSubstance</b> to multiple
         * <b>SpecAssignedMatlForKeyDate</b>.
         *
         * @param value
         *            The SpecAssignedMatlForKeyDates to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceMatlAssignment( SpecAssignedMatlForKeyDate... value )
        {
            return toRawSubstanceMatlAssignment(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceNextStatus( final List<SpecStatusNextStatus> value )
        {
            toRawSubstanceNextStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceNextStatus</b> for <b>RawSubstance</b> to multiple
         * <b>SpecStatusNextStatus</b>.
         *
         * @param value
         *            The SpecStatusNextStatuss to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceNextStatus( SpecStatusNextStatus... value )
        {
            return toRawSubstanceNextStatus(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceNtrntComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceNtrntComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceNtrntComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceNtrntComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceNtrntComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceReligiousComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceReligiousComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceReligiousComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceReligiousComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceReligiousComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceSchema( final List<SpecStatusSchema> value )
        {
            toRawSubstanceSchema.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceSchema</b> for <b>RawSubstance</b> to multiple <b>SpecStatusSchema</b>.
         *
         * @param value
         *            The SpecStatusSchemas to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceSchema( SpecStatusSchema... value )
        {
            return toRawSubstanceSchema(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceStatusAttributes(
            final List<SpecStatusAttributes> value )
        {
            toRawSubstanceStatusAttributes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceStatusAttributes</b> for <b>RawSubstance</b> to multiple
         * <b>SpecStatusAttributes</b>.
         *
         * @param value
         *            The SpecStatusAttributess to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceStatusAttributes( SpecStatusAttributes... value )
        {
            return toRawSubstanceStatusAttributes(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceStdComp( final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRawSubstanceStdComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceStdComp</b> for <b>RawSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceStdComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRawSubstanceStdComp(Lists.newArrayList(value));
        }

        private RawSubstance.RawSubstanceBuilder toRawSubstanceTotalSolid( final List<SpecCharByValueAssgmtInst> value )
        {
            toRawSubstanceTotalSolid.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RawSubstanceTotalSolid</b> for <b>RawSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RawSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RawSubstance.RawSubstanceBuilder rawSubstanceTotalSolid( SpecCharByValueAssgmtInst... value )
        {
            return toRawSubstanceTotalSolid(Lists.newArrayList(value));
        }

    }

}
