/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecAssignedMatlForKeyDateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate
 * SpecAssignedMatlForKeyDate} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SpecAssignedMatlForKeyDateByKeyFluentHelper
    extends
    FluentHelperByKey<SpecAssignedMatlForKeyDateByKeyFluentHelper, SpecAssignedMatlForKeyDate, SpecAssignedMatlForKeyDateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecAssignedMatlForKeyDate}
     * @param specMaterialAssgmtInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specMaterialAssgmtChangeState
     *            Sequential Number of the Change State
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecAssignedMatlForKeyDate}
     */
    public SpecAssignedMatlForKeyDateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specMaterialAssgmtInternalID,
        final String specMaterialAssgmtChangeState )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecMaterialAssgmtInternalID", specMaterialAssgmtInternalID);
        this.key.put("SpecMaterialAssgmtChangeState", specMaterialAssgmtChangeState);
    }

    @Override
    @Nonnull
    protected Class<SpecAssignedMatlForKeyDate> getEntityClass()
    {
        return SpecAssignedMatlForKeyDate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
