/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecIdentifierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecIdentifierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Specification Identifier
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecIdentifierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecIdentifier extends VdmEntity<SpecIdentifier>
{

    /**
     * Selector for all available fields of SpecIdentifier.
     *
     */
    public final static SpecIdentifierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "SpecIdfgDescInternalID" )
    @JsonProperty( "SpecIdfgDescInternalID" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescInternalID" )
    private String specIdfgDescInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescInternalID</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_INTERNAL_ID =
        new SpecIdentifierField<String>("SpecIdfgDescInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescChangeState</b>
     * </p>
     *
     * @return Sequential Number of the Change State
     */
    @Key
    @SerializedName( "SpecIdfgDescChangeState" )
    @JsonProperty( "SpecIdfgDescChangeState" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescChangeState" )
    private String specIdfgDescChangeState;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescChangeState</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_CHANGE_STATE =
        new SpecIdentifierField<String>("SpecIdfgDescChangeState");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecificationInternalID" )
    @JsonProperty( "SpecificationInternalID" )
    @Nullable
    @ODataField( odataName = "SpecificationInternalID" )
    private String specificationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationInternalID</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPECIFICATION_INTERNAL_ID =
        new SpecIdentifierField<String>("SpecificationInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "SpecIdfgDescIsDeleted" )
    @JsonProperty( "SpecIdfgDescIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecIdfgDescIsDeleted" )
    private Boolean specIdfgDescIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescIsDeleted</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<Boolean> SPEC_IDFG_DESC_IS_DELETED =
        new SpecIdentifierField<Boolean>("SpecIdfgDescIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "SpecIdfgDescCreatedByUser" )
    @JsonProperty( "SpecIdfgDescCreatedByUser" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescCreatedByUser" )
    private String specIdfgDescCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescCreatedByUser</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_CREATED_BY_USER =
        new SpecIdentifierField<String>("SpecIdfgDescCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "SpecIdfgDescCreationDate" )
    @JsonProperty( "SpecIdfgDescCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecIdfgDescCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specIdfgDescCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescCreationDate</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<LocalDateTime> SPEC_IDFG_DESC_CREATION_DATE =
        new SpecIdentifierField<LocalDateTime>("SpecIdfgDescCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "SpecIdfgDescLastChangedByUser" )
    @JsonProperty( "SpecIdfgDescLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescLastChangedByUser" )
    private String specIdfgDescLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescLastChangedByUser</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_LAST_CHANGED_BY_USER =
        new SpecIdentifierField<String>("SpecIdfgDescLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "SpecIdfgDescLastChangeDate" )
    @JsonProperty( "SpecIdfgDescLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecIdfgDescLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specIdfgDescLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescLastChangeDate</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<LocalDateTime> SPEC_IDFG_DESC_LAST_CHANGE_DATE =
        new SpecIdentifierField<LocalDateTime>("SpecIdfgDescLastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescSortSequence</b>
     * </p>
     *
     * @return Sort Order
     */
    @SerializedName( "SpecIdfgDescSortSequence" )
    @JsonProperty( "SpecIdfgDescSortSequence" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescSortSequence" )
    private String specIdfgDescSortSequence;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescSortSequence</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_SORT_SEQUENCE =
        new SpecIdentifierField<String>("SpecIdfgDescSortSequence");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCategory</b>
     * </p>
     *
     * @return Identification Category
     */
    @SerializedName( "SpecIdfgDescCategory" )
    @JsonProperty( "SpecIdfgDescCategory" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescCategory" )
    private String specIdfgDescCategory;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescCategory</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_CATEGORY =
        new SpecIdentifierField<String>("SpecIdfgDescCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescType</b>
     * </p>
     *
     * @return Identification Type
     */
    @SerializedName( "SpecIdfgDescType" )
    @JsonProperty( "SpecIdfgDescType" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescType" )
    private String specIdfgDescType;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescType</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_TYPE =
        new SpecIdentifierField<String>("SpecIdfgDescType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLanguage</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "SpecIdfgDescLanguage" )
    @JsonProperty( "SpecIdfgDescLanguage" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescLanguage" )
    private String specIdfgDescLanguage;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescLanguage</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_LANGUAGE =
        new SpecIdentifierField<String>("SpecIdfgDescLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescText</b>
     * </p>
     *
     * @return Identifier
     */
    @SerializedName( "SpecIdfgDescText" )
    @JsonProperty( "SpecIdfgDescText" )
    @Nullable
    @ODataField( odataName = "SpecIdfgDescText" )
    private String specIdfgDescText;
    /**
     * Use with available fluent helpers to apply the <b>SpecIdfgDescText</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPEC_IDFG_DESC_TEXT =
        new SpecIdentifierField<String>("SpecIdfgDescText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "SpecificationAuthznGroup" )
    @JsonProperty( "SpecificationAuthznGroup" )
    @Nullable
    @ODataField( odataName = "SpecificationAuthznGroup" )
    private String specificationAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationAuthznGroup</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPECIFICATION_AUTHZN_GROUP =
        new SpecIdentifierField<String>("SpecificationAuthznGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static SpecIdentifierField<String> SPECIFICATION_TYPE =
        new SpecIdentifierField<String>("SpecificationType");

    @Nonnull
    @Override
    public Class<SpecIdentifier> getType()
    {
        return SpecIdentifier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescInternalID</b>
     * </p>
     *
     * @param specIdfgDescInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecIdfgDescInternalID( @Nullable final String specIdfgDescInternalID )
    {
        rememberChangedField("SpecIdfgDescInternalID", this.specIdfgDescInternalID);
        this.specIdfgDescInternalID = specIdfgDescInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescChangeState</b>
     * </p>
     *
     * @param specIdfgDescChangeState
     *            Sequential Number of the Change State
     */
    public void setSpecIdfgDescChangeState( @Nullable final String specIdfgDescChangeState )
    {
        rememberChangedField("SpecIdfgDescChangeState", this.specIdfgDescChangeState);
        this.specIdfgDescChangeState = specIdfgDescChangeState;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @param specificationInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecificationInternalID( @Nullable final String specificationInternalID )
    {
        rememberChangedField("SpecificationInternalID", this.specificationInternalID);
        this.specificationInternalID = specificationInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescIsDeleted</b>
     * </p>
     *
     * @param specIdfgDescIsDeleted
     *            Deletion Indicator
     */
    public void setSpecIdfgDescIsDeleted( @Nullable final Boolean specIdfgDescIsDeleted )
    {
        rememberChangedField("SpecIdfgDescIsDeleted", this.specIdfgDescIsDeleted);
        this.specIdfgDescIsDeleted = specIdfgDescIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCreatedByUser</b>
     * </p>
     *
     * @param specIdfgDescCreatedByUser
     *            Created By
     */
    public void setSpecIdfgDescCreatedByUser( @Nullable final String specIdfgDescCreatedByUser )
    {
        rememberChangedField("SpecIdfgDescCreatedByUser", this.specIdfgDescCreatedByUser);
        this.specIdfgDescCreatedByUser = specIdfgDescCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCreationDate</b>
     * </p>
     *
     * @param specIdfgDescCreationDate
     *            Created On
     */
    public void setSpecIdfgDescCreationDate( @Nullable final LocalDateTime specIdfgDescCreationDate )
    {
        rememberChangedField("SpecIdfgDescCreationDate", this.specIdfgDescCreationDate);
        this.specIdfgDescCreationDate = specIdfgDescCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLastChangedByUser</b>
     * </p>
     *
     * @param specIdfgDescLastChangedByUser
     *            Last Changed By
     */
    public void setSpecIdfgDescLastChangedByUser( @Nullable final String specIdfgDescLastChangedByUser )
    {
        rememberChangedField("SpecIdfgDescLastChangedByUser", this.specIdfgDescLastChangedByUser);
        this.specIdfgDescLastChangedByUser = specIdfgDescLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLastChangeDate</b>
     * </p>
     *
     * @param specIdfgDescLastChangeDate
     *            Last Changed On
     */
    public void setSpecIdfgDescLastChangeDate( @Nullable final LocalDateTime specIdfgDescLastChangeDate )
    {
        rememberChangedField("SpecIdfgDescLastChangeDate", this.specIdfgDescLastChangeDate);
        this.specIdfgDescLastChangeDate = specIdfgDescLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescSortSequence</b>
     * </p>
     *
     * @param specIdfgDescSortSequence
     *            Sort Order
     */
    public void setSpecIdfgDescSortSequence( @Nullable final String specIdfgDescSortSequence )
    {
        rememberChangedField("SpecIdfgDescSortSequence", this.specIdfgDescSortSequence);
        this.specIdfgDescSortSequence = specIdfgDescSortSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescCategory</b>
     * </p>
     *
     * @param specIdfgDescCategory
     *            Identification Category
     */
    public void setSpecIdfgDescCategory( @Nullable final String specIdfgDescCategory )
    {
        rememberChangedField("SpecIdfgDescCategory", this.specIdfgDescCategory);
        this.specIdfgDescCategory = specIdfgDescCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescType</b>
     * </p>
     *
     * @param specIdfgDescType
     *            Identification Type
     */
    public void setSpecIdfgDescType( @Nullable final String specIdfgDescType )
    {
        rememberChangedField("SpecIdfgDescType", this.specIdfgDescType);
        this.specIdfgDescType = specIdfgDescType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescLanguage</b>
     * </p>
     *
     * @param specIdfgDescLanguage
     *            Language
     */
    public void setSpecIdfgDescLanguage( @Nullable final String specIdfgDescLanguage )
    {
        rememberChangedField("SpecIdfgDescLanguage", this.specIdfgDescLanguage);
        this.specIdfgDescLanguage = specIdfgDescLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>SpecIdfgDescText</b>
     * </p>
     *
     * @param specIdfgDescText
     *            Identifier
     */
    public void setSpecIdfgDescText( @Nullable final String specIdfgDescText )
    {
        rememberChangedField("SpecIdfgDescText", this.specIdfgDescText);
        this.specIdfgDescText = specIdfgDescText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     */
    public void setSpecificationAuthznGroup( @Nullable final String specificationAuthznGroup )
    {
        rememberChangedField("SpecificationAuthznGroup", this.specificationAuthznGroup);
        this.specificationAuthznGroup = specificationAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Specification Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecIdentifier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecIdfgDescInternalID", getSpecIdfgDescInternalID());
        result.put("SpecIdfgDescChangeState", getSpecIdfgDescChangeState());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecIdfgDescInternalID", getSpecIdfgDescInternalID());
        values.put("SpecIdfgDescChangeState", getSpecIdfgDescChangeState());
        values.put("SpecificationInternalID", getSpecificationInternalID());
        values.put("SpecIdfgDescIsDeleted", getSpecIdfgDescIsDeleted());
        values.put("SpecIdfgDescCreatedByUser", getSpecIdfgDescCreatedByUser());
        values.put("SpecIdfgDescCreationDate", getSpecIdfgDescCreationDate());
        values.put("SpecIdfgDescLastChangedByUser", getSpecIdfgDescLastChangedByUser());
        values.put("SpecIdfgDescLastChangeDate", getSpecIdfgDescLastChangeDate());
        values.put("SpecIdfgDescSortSequence", getSpecIdfgDescSortSequence());
        values.put("SpecIdfgDescCategory", getSpecIdfgDescCategory());
        values.put("SpecIdfgDescType", getSpecIdfgDescType());
        values.put("SpecIdfgDescLanguage", getSpecIdfgDescLanguage());
        values.put("SpecIdfgDescText", getSpecIdfgDescText());
        values.put("SpecificationAuthznGroup", getSpecificationAuthznGroup());
        values.put("SpecificationType", getSpecificationType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecIdfgDescInternalID") ) {
                final Object value = values.remove("SpecIdfgDescInternalID");
                if( (value == null) || (!value.equals(getSpecIdfgDescInternalID())) ) {
                    setSpecIdfgDescInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescChangeState") ) {
                final Object value = values.remove("SpecIdfgDescChangeState");
                if( (value == null) || (!value.equals(getSpecIdfgDescChangeState())) ) {
                    setSpecIdfgDescChangeState(((String) value));
                }
            }
            if( values.containsKey("SpecificationInternalID") ) {
                final Object value = values.remove("SpecificationInternalID");
                if( (value == null) || (!value.equals(getSpecificationInternalID())) ) {
                    setSpecificationInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescIsDeleted") ) {
                final Object value = values.remove("SpecIdfgDescIsDeleted");
                if( (value == null) || (!value.equals(getSpecIdfgDescIsDeleted())) ) {
                    setSpecIdfgDescIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("SpecIdfgDescCreatedByUser") ) {
                final Object value = values.remove("SpecIdfgDescCreatedByUser");
                if( (value == null) || (!value.equals(getSpecIdfgDescCreatedByUser())) ) {
                    setSpecIdfgDescCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescCreationDate") ) {
                final Object value = values.remove("SpecIdfgDescCreationDate");
                if( (value == null) || (!value.equals(getSpecIdfgDescCreationDate())) ) {
                    setSpecIdfgDescCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecIdfgDescLastChangedByUser") ) {
                final Object value = values.remove("SpecIdfgDescLastChangedByUser");
                if( (value == null) || (!value.equals(getSpecIdfgDescLastChangedByUser())) ) {
                    setSpecIdfgDescLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescLastChangeDate") ) {
                final Object value = values.remove("SpecIdfgDescLastChangeDate");
                if( (value == null) || (!value.equals(getSpecIdfgDescLastChangeDate())) ) {
                    setSpecIdfgDescLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecIdfgDescSortSequence") ) {
                final Object value = values.remove("SpecIdfgDescSortSequence");
                if( (value == null) || (!value.equals(getSpecIdfgDescSortSequence())) ) {
                    setSpecIdfgDescSortSequence(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescCategory") ) {
                final Object value = values.remove("SpecIdfgDescCategory");
                if( (value == null) || (!value.equals(getSpecIdfgDescCategory())) ) {
                    setSpecIdfgDescCategory(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescType") ) {
                final Object value = values.remove("SpecIdfgDescType");
                if( (value == null) || (!value.equals(getSpecIdfgDescType())) ) {
                    setSpecIdfgDescType(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescLanguage") ) {
                final Object value = values.remove("SpecIdfgDescLanguage");
                if( (value == null) || (!value.equals(getSpecIdfgDescLanguage())) ) {
                    setSpecIdfgDescLanguage(((String) value));
                }
            }
            if( values.containsKey("SpecIdfgDescText") ) {
                final Object value = values.remove("SpecIdfgDescText");
                if( (value == null) || (!value.equals(getSpecIdfgDescText())) ) {
                    setSpecIdfgDescText(((String) value));
                }
            }
            if( values.containsKey("SpecificationAuthznGroup") ) {
                final Object value = values.remove("SpecificationAuthznGroup");
                if( (value == null) || (!value.equals(getSpecificationAuthznGroup())) ) {
                    setSpecificationAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SpecIdentifierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecIdentifierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecIdentifierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecIdentifierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

}
