/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecStatusAttributesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecStatusAttributesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Specification Status Attributes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecStatusAttributesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecStatusAttributes extends VdmEntity<SpecStatusAttributes>
{

    /**
     * Selector for all available fields of SpecStatusAttributes.
     *
     */
    public final static SpecStatusAttributesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @return Status Identification
     */
    @Key
    @SerializedName( "SpecificationHeaderStatus" )
    @JsonProperty( "SpecificationHeaderStatus" )
    @Nullable
    @ODataField( odataName = "SpecificationHeaderStatus" )
    private String specificationHeaderStatus;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHeaderStatus</b> field to query operations.
     *
     */
    public final static SpecStatusAttributesField<String> SPECIFICATION_HEADER_STATUS =
        new SpecStatusAttributesField<String>("SpecificationHeaderStatus");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsAttribute</b>
     * </p>
     *
     * @return Attribute per Object Type
     */
    @Key
    @SerializedName( "SpecificationHdrStsAttribute" )
    @JsonProperty( "SpecificationHdrStsAttribute" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsAttribute" )
    private String specificationHdrStsAttribute;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsAttribute</b> field to query operations.
     *
     */
    public final static SpecStatusAttributesField<String> SPECIFICATION_HDR_STS_ATTRIBUTE =
        new SpecStatusAttributesField<String>("SpecificationHdrStsAttribute");

    @Nonnull
    @Override
    public Class<SpecStatusAttributes> getType()
    {
        return SpecStatusAttributes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @param specificationHeaderStatus
     *            Status Identification
     */
    public void setSpecificationHeaderStatus( @Nullable final String specificationHeaderStatus )
    {
        rememberChangedField("SpecificationHeaderStatus", this.specificationHeaderStatus);
        this.specificationHeaderStatus = specificationHeaderStatus;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsAttribute</b>
     * </p>
     *
     * @param specificationHdrStsAttribute
     *            Attribute per Object Type
     */
    public void setSpecificationHdrStsAttribute( @Nullable final String specificationHdrStsAttribute )
    {
        rememberChangedField("SpecificationHdrStsAttribute", this.specificationHdrStsAttribute);
        this.specificationHdrStsAttribute = specificationHdrStsAttribute;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecStatusAttributes";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecificationHeaderStatus", getSpecificationHeaderStatus());
        result.put("SpecificationHdrStsAttribute", getSpecificationHdrStsAttribute());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecificationHeaderStatus", getSpecificationHeaderStatus());
        values.put("SpecificationHdrStsAttribute", getSpecificationHdrStsAttribute());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecificationHeaderStatus") ) {
                final Object value = values.remove("SpecificationHeaderStatus");
                if( (value == null) || (!value.equals(getSpecificationHeaderStatus())) ) {
                    setSpecificationHeaderStatus(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsAttribute") ) {
                final Object value = values.remove("SpecificationHdrStsAttribute");
                if( (value == null) || (!value.equals(getSpecificationHdrStsAttribute())) ) {
                    setSpecificationHdrStsAttribute(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SpecStatusAttributesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecStatusAttributesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecStatusAttributesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecStatusAttributesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

}
