/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecStatusSchemaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecStatusSchemaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Specification Status Schema
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecStatusSchemaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecStatusSchema extends VdmEntity<SpecStatusSchema>
{

    /**
     * Selector for all available fields of SpecStatusSchema.
     *
     */
    public final static SpecStatusSchemaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Subordinate Object Type
     */
    @Key
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static SpecStatusSchemaField<String> SPECIFICATION_TYPE =
        new SpecStatusSchemaField<String>("SpecificationType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @return Status Scheme
     */
    @Key
    @SerializedName( "SpecificationHdrStsSchema" )
    @JsonProperty( "SpecificationHdrStsSchema" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchema" )
    private String specificationHdrStsSchema;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchema</b> field to query operations.
     *
     */
    public final static SpecStatusSchemaField<String> SPECIFICATION_HDR_STS_SCHEMA =
        new SpecStatusSchemaField<String>("SpecificationHdrStsSchema");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsDfltSchema</b>
     * </p>
     *
     * @return Default Status Scheme
     */
    @SerializedName( "SpecificationHdrStsDfltSchema" )
    @JsonProperty( "SpecificationHdrStsDfltSchema" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecificationHdrStsDfltSchema" )
    private Boolean specificationHdrStsDfltSchema;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsDfltSchema</b> field to query operations.
     *
     */
    public final static SpecStatusSchemaField<Boolean> SPECIFICATION_HDR_STS_DFLT_SCHEMA =
        new SpecStatusSchemaField<Boolean>("SpecificationHdrStsDfltSchema");

    @Nonnull
    @Override
    public Class<SpecStatusSchema> getType()
    {
        return SpecStatusSchema.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Subordinate Object Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     */
    public void setSpecificationHdrStsSchema( @Nullable final String specificationHdrStsSchema )
    {
        rememberChangedField("SpecificationHdrStsSchema", this.specificationHdrStsSchema);
        this.specificationHdrStsSchema = specificationHdrStsSchema;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsDfltSchema</b>
     * </p>
     *
     * @param specificationHdrStsDfltSchema
     *            Default Status Scheme
     */
    public void setSpecificationHdrStsDfltSchema( @Nullable final Boolean specificationHdrStsDfltSchema )
    {
        rememberChangedField("SpecificationHdrStsDfltSchema", this.specificationHdrStsDfltSchema);
        this.specificationHdrStsDfltSchema = specificationHdrStsDfltSchema;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecStatusSchema";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecificationType", getSpecificationType());
        result.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecificationType", getSpecificationType());
        values.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        values.put("SpecificationHdrStsDfltSchema", getSpecificationHdrStsDfltSchema());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsSchema") ) {
                final Object value = values.remove("SpecificationHdrStsSchema");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchema())) ) {
                    setSpecificationHdrStsSchema(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsDfltSchema") ) {
                final Object value = values.remove("SpecificationHdrStsDfltSchema");
                if( (value == null) || (!value.equals(getSpecificationHdrStsDfltSchema())) ) {
                    setSpecificationHdrStsDfltSchema(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SpecStatusSchemaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecStatusSchemaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecStatusSchemaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecStatusSchemaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

}
