/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecStatusSchemaSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema SpecStatusSchema} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SpecStatusSchemaByKeyFluentHelper
    extends
    FluentHelperByKey<SpecStatusSchemaByKeyFluentHelper, SpecStatusSchema, SpecStatusSchemaSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema SpecStatusSchema} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecStatusSchema}
     * @param specificationHdrStsSchema
     *            Status Scheme
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecStatusSchema}
     * @param specificationType
     *            Subordinate Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public SpecStatusSchemaByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specificationType,
        final String specificationHdrStsSchema )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecificationType", specificationType);
        this.key.put("SpecificationHdrStsSchema", specificationHdrStsSchema);
    }

    @Override
    @Nonnull
    protected Class<SpecStatusSchema> getEntityClass()
    {
        return SpecStatusSchema.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
