/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.SpecValAssgmtInstanceWthCompSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp
 * SpecValAssgmtInstanceWthComp} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SpecValAssgmtInstanceWthCompByKeyFluentHelper
    extends
    FluentHelperByKey<SpecValAssgmtInstanceWthCompByKeyFluentHelper, SpecValAssgmtInstanceWthComp, SpecValAssgmtInstanceWthCompSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp
     * SpecValAssgmtInstanceWthComp} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecValAssgmtInstanceWthComp}
     * @param specValAssgmtType
     *            Value Assignment Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param specificationRating
     *            Rating
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecValAssgmtInstanceWthComp}
     * @param componentSpecificationIntID
     *            Reference to Specification Header of a Component
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationValidityArea
     *            Validity Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param specificationInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public SpecValAssgmtInstanceWthCompByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specificationInternalID,
        final String specValAssgmtType,
        final String specificationRating,
        final String specificationValidityArea,
        final String componentSpecificationIntID )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecificationInternalID", specificationInternalID);
        this.key.put("SpecValAssgmtType", specValAssgmtType);
        this.key.put("SpecificationRating", specificationRating);
        this.key.put("SpecificationValidityArea", specificationValidityArea);
        this.key.put("ComponentSpecificationIntID", componentSpecificationIntID);
    }

    @Override
    @Nonnull
    protected Class<SpecValAssgmtInstanceWthComp> getEntityClass()
    {
        return SpecValAssgmtInstanceWthComp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
